/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.EmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.FKArcComparator;
import oracle.dbtools.crest.model.design.compare.FKComparator;
import oracle.dbtools.crest.model.design.compare.IndexComparator;
import oracle.dbtools.crest.model.design.compare.NoteComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableConstraintComparator;
import oracle.dbtools.crest.model.design.compare.TableViewComparator;
import oracle.dbtools.crest.model.design.compare.ValidTimeDimensionComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.ArcComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.AttributeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.AttributeSelection;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDColumnSelection;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDFilteredSelection;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDIndexComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDModelComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDTableComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CollectionTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.DesignHandler;
import oracle.dbtools.crest.model.design.compare.cwddesign.DistinctTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.EntityComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.EntityViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.InheritanceRelationComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.KeyComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.LogicalSubViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.MethodComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.RelationComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.RelationalSubViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.StructuredTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.TypeElementComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.TypeElementSelection;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.compare.CompareMapping;
import oracle.dbtools.crest.util.compare.CompareMappingObject;

public class CompareCWDDesigns
extends ModelIdObjectSelection {
    public static final String NEW_ENTITY = Messages.getString("CompareCWDDesigns.NewEntity");
    public static final String NEW_ATTRIBUTE = Messages.getString("CompareCWDDesigns.NewAttribute");
    public static final String NEW_DISTINCT_TYPE = Messages.getString("CompareCWDDesigns.NewDistinctType");
    public static final String NEW_STRUCTURED_TYPE = Messages.getString("CompareCWDDesigns.NewStructuredType");
    public static final String NEW_METHOD = Messages.getString("CompareCWDDesigns.NewMethod");
    public static final String NEW_COLLECTION_TYPE = Messages.getString("CompareCWDDesigns.NewCollectionType");
    public static final String NEW_SUBVIEW = Messages.getString("CompareCWDDesigns.NewSubview");
    private PropertiesComparator propertiesComparator;
    private CompareCWDDesigns correspondentNode;
    private JComponent dependentComponent;
    private boolean editable = true;
    private Map comparatorsMap = new TreeMap();
    private List deletedMappings = new ArrayList();
    private DesignHandler designHandler;
    private Map objectsMap;
    private CompareCWDDesigns rightRoot;
    private String rname;
    private List attributesWithChangedDataType = new ArrayList();
    private List columnsWithChangedDataType = new ArrayList();
    private List pkInd = new ArrayList();
    private List fkInd = new ArrayList();
    private List indexes = new ArrayList();
    private boolean updateDependent = true;

    public CompareCWDDesigns(String name) {
        super(name);
    }

    public CompareCWDDesigns(ModelIDObject object) {
        super(object);
    }

    public CompareCWDDesigns(DesignHandler designHandler) {
        super(designHandler.getSourceName());
        this.objectsMap = new TreeMap();
        this.designHandler = designHandler;
        this.rightRoot = new CompareCWDDesigns(designHandler.getTargetName());
        this.setCorrespondentNode(this.rightRoot);
        this.rightRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.rightRoot);
        this.initSourceDesign();
    }

    public void setStatus(int status) {
        if (status == STATE_MODIFIED) {
            if (this.status != STATE_NEW && this.status != STATE_DELETED) {
                this.status = status;
            }
        } else {
            this.status = status;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public CompareCWDDesigns getCorrespondentNode() {
        return this.correspondentNode;
    }

    public void setCorrespondentNode(CompareCWDDesigns correspondentNode) {
        this.correspondentNode = correspondentNode;
    }

    @Override
    public ModelIdObjectSelection getCorrespondentObjectSelection() {
        return this.getCorrespondentNode();
    }

    public PropertiesComparator getPropertiesComparator() {
        return this.propertiesComparator;
    }

    public void setPropertiesComparator(PropertiesComparator propertiesComparator) {
        this.propertiesComparator = propertiesComparator;
    }

    private void setEmptyComparator(CompareCWDDesigns node) {
        node.setPropertiesComparator(new EmptyPropertiesComparator(null, null));
    }

    private List getNotesForDPVandDisplays(DesignPartView masterDPV) {
        ArrayList<Note> list = new ArrayList<Note>();
        DesignPart dp = masterDPV.getDesignPart();
        NoteSet notes = dp.getNoteSet();
        if (notes != null) {
            DesignPartView mdpv = masterDPV;
            if (!mdpv.isMasterDPV()) {
                mdpv = mdpv.getMasterDPV();
            }
            ArrayList<DesignPartView> dlist = new ArrayList<DesignPartView>();
            dlist.add(mdpv);
            dlist.addAll(mdpv.getSubordinateViews());
            Iterator it = notes.iterator();
            block0: while (it.hasNext()) {
                Note note = (Note)it.next();
                for (int i = 0; i < dlist.size(); ++i) {
                    DesignPartView tdpv = (DesignPartView)dlist.get(i);
                    if (note.getAllViews(tdpv).size() <= 0) continue;
                    list.add(note);
                    continue block0;
                }
            }
        }
        return list;
    }

    private void addNotes(DesignPartView sMasterDPV, CWDFilteredSelection sLogicalModel, DesignPartView tMasterDPV, CWDFilteredSelection tLogicalModel) {
        List slist = this.getNotesForDPVandDisplays(sMasterDPV);
        ArrayList tlist = tMasterDPV != null ? this.getNotesForDPVandDisplays(tMasterDPV) : new ArrayList();
        CWDFilteredSelection sNotes = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Notes"));
        CWDFilteredSelection tNotes = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Notes"));
        sNotes.setCorrespondentNode(tNotes);
        tNotes.setCorrespondentNode(sNotes);
        this.setEmptyComparator(sNotes);
        this.setEmptyComparator(tNotes);
        sLogicalModel.addChild(sNotes);
        tLogicalModel.addChild(tNotes);
        tNotes.setSelected(false);
        for (Note sourceNote : slist) {
            NoteComparator comp;
            CompareCWDDesigns sourceNotesel = new CompareCWDDesigns(sourceNote);
            CompareCWDDesigns targetNotesel = null;
            Note targetNote = (Note)this.getCorrespondingObject(tlist, (DesignObject)sourceNote);
            if (targetNote != null) {
                targetNotesel = new CompareCWDDesigns(targetNote);
                comp = new NoteComparator(sourceNote, targetNote);
                sourceNotesel.setPropertiesComparator(comp);
                targetNotesel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sourceNotesel.setSelected(comp.isModified());
                this.objectsMap.put(sourceNote.getObjectID(), targetNote);
            } else {
                targetNotesel = new CompareCWDDesigns(NEW_NOTE);
                sourceNotesel.setStatus(STATE_NEW);
                targetNotesel.setStatus(STATE_NEW);
                targetNotesel.setElementDescriptor(Note.class);
                comp = new NoteComparator(sourceNote, targetNote);
                sourceNotesel.setPropertiesComparator(comp);
                targetNotesel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sourceNotesel.setSelected(true);
            }
            targetNotesel.setCorrespondentNode(sourceNotesel);
            sourceNotesel.setCorrespondentNode(targetNotesel);
            sNotes.addChild(sourceNotesel);
            tNotes.addChild(targetNotesel);
        }
    }

    private void initSourceDesign() {
        Relation relation;
        this.initDataTypesModel();
        LogicalDesign sLogDesign = this.designHandler.getSourceLogicalDesign();
        LogicalDesign tLogDesign = this.designHandler.getTargetLogicalDesign();
        CWDFilteredSelection sLogicalModel = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.LogicalModel"));
        CWDFilteredSelection tLogicalModel = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.LogicalModel"));
        sLogicalModel.object = sLogDesign;
        sLogicalModel.setCorrespondentNode(tLogicalModel);
        tLogicalModel.setCorrespondentNode(sLogicalModel);
        CWDModelComparator compLogModel = new CWDModelComparator(sLogDesign, tLogDesign);
        sLogicalModel.setPropertiesComparator(compLogModel);
        tLogicalModel.setPropertiesComparator(compLogModel);
        this.comparatorsMap.put(compLogModel.getID(), compLogModel);
        this.addChild(sLogicalModel);
        this.rightRoot.addChild(tLogicalModel);
        tLogicalModel.setSelected(false);
        CWDFilteredSelection sEntities = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Entities"));
        CWDFilteredSelection tEntities = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Entities"));
        sEntities.setCorrespondentNode(tEntities);
        tEntities.setCorrespondentNode(sEntities);
        this.setEmptyComparator(sEntities);
        this.setEmptyComparator(tEntities);
        sLogicalModel.addChild(sEntities);
        tLogicalModel.addChild(tEntities);
        tEntities.setSelected(false);
        CWDFilteredSelection sRelations = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Relations"));
        CWDFilteredSelection tRelations = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Relations"));
        sRelations.setCorrespondentNode(tRelations);
        tRelations.setCorrespondentNode(sRelations);
        this.setEmptyComparator(sRelations);
        this.setEmptyComparator(tRelations);
        sLogicalModel.addChild(sRelations);
        tLogicalModel.addChild(tRelations);
        tRelations.setSelected(false);
        CWDFilteredSelection sInheritances = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Inheritances"));
        CWDFilteredSelection tInheritances = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Inheritances"));
        sInheritances.setCorrespondentNode(tInheritances);
        tInheritances.setCorrespondentNode(sInheritances);
        this.setEmptyComparator(sInheritances);
        this.setEmptyComparator(tInheritances);
        sLogicalModel.addChild(sInheritances);
        tLogicalModel.addChild(tInheritances);
        tInheritances.setSelected(false);
        CWDFilteredSelection sEntityView = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Views"));
        CWDFilteredSelection tEntityView = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Views"));
        sEntityView.setCorrespondentNode(tEntityView);
        tEntityView.setCorrespondentNode(sEntityView);
        this.setEmptyComparator(sEntityView);
        this.setEmptyComparator(tEntityView);
        sLogicalModel.addChild(sEntityView);
        tLogicalModel.addChild(tEntityView);
        tEntityView.setSelected(false);
        this.addNotes(sLogDesign.getMainView(), sLogicalModel, tLogDesign.getMainView(), tLogicalModel);
        CWDFilteredSelection sLogicalSubview = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Subviews"));
        CWDFilteredSelection tLogicalSubview = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Subviews"));
        sLogicalSubview.setCorrespondentNode(tLogicalSubview);
        tLogicalSubview.setCorrespondentNode(sLogicalSubview);
        this.setEmptyComparator(sLogicalSubview);
        this.setEmptyComparator(tLogicalSubview);
        sLogicalModel.addChild(sLogicalSubview);
        tLogicalModel.addChild(tLogicalSubview);
        tLogicalSubview.setSelected(false);
        Iterator it = this.designHandler.getSourceLogicalDesign().getEntitySet().iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            this.addEntity(entity, sEntities, tEntities);
        }
        this.addDeletedEntities(sEntities, tEntities);
        it = this.designHandler.getSourceLogicalDesign().getRelationSet().iterator();
        while (it.hasNext()) {
            relation = (Relation)it.next();
            this.addRelation(relation, sRelations, tRelations);
        }
        this.addDeletedRelationss(sRelations, tRelations);
        it = this.designHandler.getSourceLogicalDesign().getInheritanceRelationSet().iterator();
        while (it.hasNext()) {
            relation = (InheritanceRelation)it.next();
            this.addInheritanceRelation((InheritanceRelation)relation, sInheritances, tInheritances);
        }
        this.addDeletedInheritanceRelationss(sInheritances, tInheritances);
        it = this.designHandler.getSourceLogicalDesign().getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView view = (EntityView)it.next();
            this.addEntityView(view, sEntityView, tEntityView);
        }
        this.addDeletedEntityViews(sEntityView, tEntityView);
        it = this.designHandler.getSourceLogicalDesign().getLogicalDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpv = (DesignPartViewPlaceHolder)it.next();
            this.addLogicalSubview(dpv, sLogicalSubview, tLogicalSubview);
        }
        this.addDeletedLogicalSubviews(sLogicalSubview, tLogicalSubview);
        CWDFilteredSelection sRelModels = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.RelationalModels"));
        CWDFilteredSelection tRelModels = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.RelationalModels"));
        sRelModels.setCorrespondentNode(tRelModels);
        tRelModels.setCorrespondentNode(sRelModels);
        this.setEmptyComparator(sRelModels);
        this.setEmptyComparator(tRelModels);
        this.addChild(sRelModels);
        this.rightRoot.addChild(tRelModels);
        for (String sourceDesID : this.designHandler.getSourceRelationalModels()) {
            String targetDesID = this.designHandler.getTargetRelationalModelID(sourceDesID);
            RelationalDesign sourceDes = (RelationalDesign)this.designHandler.getSourceDesign().getRelationalDesigns().getById(sourceDesID);
            RelationalDesign targetDes = (RelationalDesign)this.designHandler.getTargetDesign().getRelationalDesigns().getById(targetDesID);
            if (sourceDes == null || targetDes == null) continue;
            CWDFilteredSelection sRelModel = new CWDFilteredSelection(sourceDes);
            CWDFilteredSelection tRelModel = new CWDFilteredSelection(targetDes);
            sRelModel.setCorrespondentNode(tRelModel);
            tRelModel.setCorrespondentNode(sRelModel);
            CWDModelComparator compRelModel = new CWDModelComparator(sourceDes, targetDes);
            sRelModel.setPropertiesComparator(compRelModel);
            tRelModel.setPropertiesComparator(compRelModel);
            this.comparatorsMap.put(compRelModel.getID(), compRelModel);
            sRelModels.addChild(sRelModel);
            tRelModels.addChild(tRelModel);
            CWDFilteredSelection allsTabsel = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Tables"));
            CWDFilteredSelection alltTabsel = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Tables"));
            allsTabsel.setCorrespondentNode(alltTabsel);
            alltTabsel.setCorrespondentNode(allsTabsel);
            this.setEmptyComparator(alltTabsel);
            this.setEmptyComparator(allsTabsel);
            alltTabsel.setSelected(false);
            sRelModel.addChild(allsTabsel);
            tRelModel.addChild(alltTabsel);
            CWDFilteredSelection allsTabViewSel = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Views"));
            CWDFilteredSelection alltTabViewSel = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Views"));
            allsTabViewSel.setCorrespondentNode(alltTabViewSel);
            alltTabViewSel.setCorrespondentNode(allsTabViewSel);
            this.setEmptyComparator(alltTabViewSel);
            this.setEmptyComparator(allsTabViewSel);
            alltTabViewSel.setSelected(false);
            sRelModel.addChild(allsTabViewSel);
            tRelModel.addChild(alltTabViewSel);
            this.addNotes(sourceDes.getMainView(), sRelModel, targetDes.getMainView(), tRelModel);
            CWDFilteredSelection sRelSubview = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Subviews"));
            CWDFilteredSelection tRelSubview = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.Subviews"));
            sRelSubview.setCorrespondentNode(tRelSubview);
            tRelSubview.setCorrespondentNode(sRelSubview);
            this.setEmptyComparator(sRelSubview);
            this.setEmptyComparator(tRelSubview);
            tRelSubview.setSelected(false);
            sRelModel.addChild(sRelSubview);
            tRelModel.addChild(tRelSubview);
            Iterator iter = sourceDes.getStorageDesign() instanceof StorageDesignOracle ? this.getTables((StorageDesignOracle)sourceDes.getStorageDesign()).iterator() : sourceDes.getTableSet().iterator();
            while (iter.hasNext()) {
                Table sourceTable = (Table)iter.next();
                this.addTable(sourceTable, allsTabsel, alltTabsel, sourceDes, targetDes);
            }
            this.addDeletedTables(allsTabsel, alltTabsel, targetDes);
            iter = sourceDes.getTableViewSet().iterator();
            while (iter.hasNext()) {
                TableView sourceTableView = (TableView)iter.next();
                this.addTableView(sourceTableView, allsTabViewSel, alltTabViewSel, sourceDes, targetDes);
            }
            this.addDeletedTableViews(allsTabViewSel, alltTabViewSel, targetDes);
            iter = sourceDes.getPhysicalDesignSubviews().iterator();
            while (iter.hasNext()) {
                DesignPartViewPlaceHolder dpv = (DesignPartViewPlaceHolder)iter.next();
                this.addRelationalSubView(dpv, sRelSubview, tRelSubview);
            }
            this.addDeletedRelationalSubViews(sRelSubview, tRelSubview);
        }
    }

    private void initDataTypesModel() {
        CWDFilteredSelection sDTModel = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.DataTypesModel"));
        CWDFilteredSelection tDTModel = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.DataTypesModel"));
        sDTModel.setCorrespondentNode(tDTModel);
        tDTModel.setCorrespondentNode(sDTModel);
        sDTModel.object = this.designHandler.getSourceDataTypesDesign();
        this.setEmptyComparator(sDTModel);
        this.setEmptyComparator(tDTModel);
        this.addChild(sDTModel);
        this.rightRoot.addChild(tDTModel);
        CWDFilteredSelection sDistType = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.DistinctTypes"));
        CWDFilteredSelection tDistType = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.DistinctTypes"));
        sDistType.setCorrespondentNode(tDistType);
        tDistType.setCorrespondentNode(sDistType);
        this.setEmptyComparator(sDistType);
        this.setEmptyComparator(tDistType);
        sDTModel.addChild(sDistType);
        tDTModel.addChild(tDistType);
        tDistType.setSelected(false);
        CWDFilteredSelection sStrType = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.StructureTypes"));
        CWDFilteredSelection tStrType = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.StructureTypes"));
        sStrType.setCorrespondentNode(tStrType);
        tStrType.setCorrespondentNode(sStrType);
        this.setEmptyComparator(sStrType);
        this.setEmptyComparator(tStrType);
        sDTModel.addChild(sStrType);
        tDTModel.addChild(tStrType);
        tStrType.setSelected(false);
        CWDFilteredSelection sCollType = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.CollectionTypes"));
        CWDFilteredSelection tCollType = new CWDFilteredSelection(Messages.getString("CompareCWDDesigns.CollectionTypes"));
        sCollType.setCorrespondentNode(tCollType);
        tCollType.setCorrespondentNode(sCollType);
        this.setEmptyComparator(sCollType);
        this.setEmptyComparator(tCollType);
        sDTModel.addChild(sCollType);
        tDTModel.addChild(tCollType);
        tCollType.setSelected(false);
        Iterator it = this.designHandler.getSourceDataTypesDesign().getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType distType = (DistinctType)it.next();
            this.addDistinctType(distType, sDistType, tDistType);
        }
        this.addDeletedDistinctTypes(sDistType, tDistType);
        it = this.designHandler.getSourceDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType strType = (StructuredType)it.next();
            if (strType.getName().equalsIgnoreCase("SDO_GEOMETRY")) continue;
            this.addStructuredType(strType, sStrType, tStrType);
        }
        this.addDeletedStructuredTypes(sStrType, tStrType);
        it = this.designHandler.getSourceDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType collType = (CollectionType)it.next();
            this.addCollectionType(collType, sCollType, tCollType);
        }
        this.addDeletedCollectionTypes(sCollType, tCollType);
    }

    private void addTableView(TableView sourceTableView, CompareCWDDesigns allsTabViewSel, CompareCWDDesigns alltTabViewSel, RelationalDesign sourceDes, RelationalDesign targetDes) {
        CompareCWDDesigns sourceTabViewSel = new CompareCWDDesigns(sourceTableView);
        TableViewProxy sViewProxy = (TableViewProxy)sourceDes.getStorageDesign().getTableViewProxySet().getProxy(sourceTableView.getObjectID());
        TableView targetTableView = (TableView)this.getCorrespondingObject(targetDes.getTableViewSet(), (DesignObject)sourceTableView);
        CompareCWDDesigns targetTabViewSel = null;
        if (targetTableView != null) {
            targetTabViewSel = new CompareCWDDesigns(targetTableView);
            TableViewProxy tViewProxy = (TableViewProxy)targetDes.getStorageDesign().getTableViewProxySet().getProxy(targetTableView.getObjectID());
            TableViewComparator comp = new TableViewComparator(sourceTableView, targetTableView, sViewProxy, tViewProxy);
            sourceTabViewSel.setPropertiesComparator(comp);
            targetTabViewSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceTabViewSel.setSelected(comp.isModified());
            this.objectsMap.put(sourceTableView.getObjectID(), targetTableView);
        } else {
            sourceTabViewSel.setSelected(true);
            targetTabViewSel = new CompareCWDDesigns(NEW_VIEW);
            TableViewComparator comp = new TableViewComparator(sourceTableView, targetTableView, sViewProxy, null);
            sourceTabViewSel.setPropertiesComparator(comp);
            targetTabViewSel.setPropertiesComparator(comp);
            targetTabViewSel.setElementDescriptor(TableView.class);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceTableView.getObjectID(), null);
            sourceTabViewSel.setStatus(STATE_NEW);
            targetTabViewSel.setStatus(STATE_NEW);
        }
        targetTabViewSel.setCorrespondentNode(sourceTabViewSel);
        sourceTabViewSel.setCorrespondentNode(targetTabViewSel);
        allsTabViewSel.addChild(sourceTabViewSel);
        alltTabViewSel.addChild(targetTabViewSel);
    }

    private void addDeletedTables(CompareCWDDesigns allsTabsel, CompareCWDDesigns alltTabsel, RelationalDesign targetDes) {
        Iterator it = targetDes.getStorageDesign() instanceof StorageDesignOracle ? this.getTables((StorageDesignOracle)targetDes.getStorageDesign()).iterator() : targetDes.getTableSet().iterator();
        while (it.hasNext()) {
            Table targetTable = (Table)it.next();
            if (this.objectsMap.containsValue(targetTable)) continue;
            CompareCWDDesigns targetTabsel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(targetTabsel);
            targetTabsel.setSelected(false);
            CompareCWDDesigns sourceTabsel = new CompareCWDDesigns(targetTable);
            targetTabsel.setElementDescriptor(Table.class);
            TableProxy tTableProxy = (TableProxy)targetDes.getStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
            TableComparator comp = new TableComparator(null, targetTable, null, tTableProxy);
            this.comparatorsMap.put(comp.getID(), comp);
            targetTabsel.setPropertiesComparator(comp);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setCorrespondentNode(targetTabsel);
            targetTabsel.setCorrespondentNode(sourceTabsel);
            allsTabsel.addChild(targetTabsel);
            alltTabsel.addChild(sourceTabsel);
        }
    }

    private List getTables(StorageDesignOracle storageDesign) {
        ArrayList<DesignObject> list = new ArrayList<DesignObject>();
        Iterator it = storageDesign.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyOracle proxy = (TableProxyOracle)it.next();
            list.add(proxy.getObject());
        }
        return list;
    }

    private void addTable(Table sourceTable, CompareCWDDesigns allsTabsel, CompareCWDDesigns alltTablesel, RelationalDesign sourceDes, RelationalDesign targetDes) {
        CompareCWDDesigns sourceTabsel = new CompareCWDDesigns(sourceTable);
        CompareCWDDesigns targetTabsel = null;
        TableProxy sTableProxy = (TableProxy)sourceDes.getStorageDesign().getTableProxySet().getProxy(sourceTable.getObjectID());
        Table targetTable = (Table)this.getCorrespondingObject(targetDes.getTableSet(), (DesignObject)sourceTable);
        if (targetTable != null) {
            targetTabsel = new CompareCWDDesigns(targetTable);
            TableProxy tTableProxy = (TableProxy)targetDes.getStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
            CWDTableComparator comp = new CWDTableComparator(sourceTable, targetTable, sTableProxy, tTableProxy);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceTabsel.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sourceTabsel);
            this.objectsMap.put(sourceTable.getObjectID(), targetTable);
        } else {
            targetTabsel = new CompareCWDDesigns(NEW_TABLE);
            sourceTabsel.setStatus(STATE_NEW);
            targetTabsel.setStatus(STATE_NEW);
            targetTabsel.setElementDescriptor(Table.class);
            this.objectsMap.put(sourceTable.getObjectID(), null);
            CWDTableComparator comp = new CWDTableComparator(sourceTable, targetTable, sTableProxy, null);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceTabsel.setSelected(true);
        }
        targetTabsel.setCorrespondentNode(sourceTabsel);
        sourceTabsel.setCorrespondentNode(targetTabsel);
        this.addTableDetails(sourceTable, sourceTabsel, targetTable, targetTabsel, sourceDes, targetDes);
        allsTabsel.addChild(sourceTabsel);
        alltTablesel.addChild(targetTabsel);
        if (sourceTabsel.isModified() || sourceTabsel.hasChildsWithChangeStatus()) {
            sourceTabsel.setSelectedNoPropagateSelection(true);
        }
    }

    private void addTableDetails(Table sourceTable, CompareCWDDesigns sourceTabsel, Table targetTable, CompareCWDDesigns targetTabSel, RelationalDesign sourceDes, RelationalDesign targetDes) {
        CompareCWDDesigns sourceColumnSel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Columns"));
        CompareCWDDesigns targetColumnSel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Columns"));
        sourceColumnSel.setCorrespondentNode(targetColumnSel);
        targetColumnSel.setCorrespondentNode(sourceColumnSel);
        this.setEmptyComparator(sourceColumnSel);
        this.setEmptyComparator(targetColumnSel);
        targetColumnSel.setSelected(false);
        for (Column sourceColumn : sourceTable.getElementsCollection()) {
            this.addColumn(sourceColumn, targetTable, sourceColumnSel, targetColumnSel, sourceDes, targetDes);
        }
        if (targetTable != null) {
            this.addDeletedColumns(sourceTable, sourceColumnSel, targetTable, targetColumnSel);
            List targetNestedElements = targetTable.getNestedElements();
            if (targetNestedElements.size() > 0) {
                for (ContainedObject sourceNestedColumn : sourceTable.getNestedElements()) {
                    ContainedObject targetNestedColumn = this.getCorrespondingNestedColumn(targetNestedElements, sourceNestedColumn);
                    if (targetNestedColumn == null) continue;
                    this.objectsMap.put(sourceNestedColumn.getObjectID(), targetNestedColumn);
                }
            }
        }
        sourceTabsel.addChild(sourceColumnSel);
        targetTabSel.addChild(targetColumnSel);
        ((CWDTableComparator)sourceTabsel.getPropertiesComparator()).presetColumnsOrder();
        this.initIndexes(sourceTable);
        CompareCWDDesigns allsPlainsel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Indexes"));
        CompareCWDDesigns alltPlainSel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Indexes"));
        allsPlainsel.setCorrespondentNode(alltPlainSel);
        alltPlainSel.setCorrespondentNode(allsPlainsel);
        this.setEmptyComparator(allsPlainsel);
        this.setEmptyComparator(alltPlainSel);
        alltPlainSel.setSelected(false);
        for (Index sourceIndex : this.indexes) {
            this.addIndex(sourceIndex, targetTable, allsPlainsel, alltPlainSel);
        }
        if (targetTable != null) {
            this.addDeletedIndexes(targetTable, allsPlainsel, alltPlainSel, false);
        }
        sourceTabsel.addChild(allsPlainsel);
        targetTabSel.addChild(alltPlainSel);
        CompareCWDDesigns allsIndsel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.PKAndUKConstraints"));
        CompareCWDDesigns alltIndSel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.PKAndUKConstraints"));
        allsIndsel.setCorrespondentNode(alltIndSel);
        alltIndSel.setCorrespondentNode(allsIndsel);
        this.setEmptyComparator(allsIndsel);
        this.setEmptyComparator(alltIndSel);
        alltIndSel.setSelected(false);
        for (Index sourceIndex : this.pkInd) {
            this.addIndex(sourceIndex, targetTable, allsIndsel, alltIndSel);
        }
        if (targetTable != null) {
            this.addDeletedIndexes(targetTable, allsIndsel, alltIndSel, true);
        }
        sourceTabsel.addChild(allsIndsel);
        targetTabSel.addChild(alltIndSel);
        CompareCWDDesigns allsFKsel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.ForeignKeys"));
        CompareCWDDesigns alltFKSel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.ForeignKeys"));
        allsFKsel.setCorrespondentNode(alltFKSel);
        alltFKSel.setCorrespondentNode(allsFKsel);
        this.setEmptyComparator(allsFKsel);
        this.setEmptyComparator(alltFKSel);
        alltFKSel.setSelected(false);
        List<FKIndexAssociation> sourcefkIndexes = Arrays.asList(sourceTable.getFKAssociations());
        for (FKIndexAssociation sourcefk : sourcefkIndexes) {
            this.addFK(sourcefk, allsFKsel, alltFKSel, targetDes);
        }
        if (targetTable != null) {
            this.addDeletedFKAssociation(targetTable, allsFKsel, alltFKSel);
        }
        sourceTabsel.addChild(allsFKsel);
        targetTabSel.addChild(alltFKSel);
        String tableCheckConstraintsText = Messages.getString("CompareCWDDesigns.TableCheckConstraints");
        CompareCWDDesigns sourceCheckSel = new CompareCWDDesigns(tableCheckConstraintsText);
        CompareCWDDesigns targetCheckSel = new CompareCWDDesigns(tableCheckConstraintsText);
        sourceCheckSel.setCorrespondentNode(targetCheckSel);
        targetCheckSel.setCorrespondentNode(sourceCheckSel);
        this.setEmptyComparator(sourceCheckSel);
        this.setEmptyComparator(targetCheckSel);
        targetCheckSel.setSelected(false);
        for (TableLevelConstraint sourceTlc : sourceTable.getCheckConstraints()) {
            this.addCheckConstraint(sourceTlc, targetTable, sourceCheckSel, targetCheckSel);
        }
        if (targetTable != null) {
            this.addDeletedCheckConstraints(targetTable, sourceCheckSel, targetCheckSel);
        }
        sourceTabsel.addChild(sourceCheckSel);
        targetTabSel.addChild(targetCheckSel);
        String validTimeDimensionsText = Messages.getString("CompareModelToModel.ValidTimeDimensions");
        CompareCWDDesigns sourceTimeDimSel = new CompareCWDDesigns(validTimeDimensionsText);
        CompareCWDDesigns targetTimeDimSel = new CompareCWDDesigns(validTimeDimensionsText);
        sourceTimeDimSel.setCorrespondentNode(targetTimeDimSel);
        targetTimeDimSel.setCorrespondentNode(sourceTimeDimSel);
        this.setEmptyComparator(sourceTimeDimSel);
        this.setEmptyComparator(targetTimeDimSel);
        targetTimeDimSel.setSelected(false);
        for (ValidTimeDimension sourceTimeDim : sourceTable.getValidTimeDimensions()) {
            this.addTimeDimension(sourceTimeDim, targetTable, sourceTimeDimSel, targetTimeDimSel);
        }
        if (targetTable != null) {
            this.addDeletedTimeDimensions(targetTable, sourceTimeDimSel, targetTimeDimSel);
        }
        sourceTabsel.addChild(sourceTimeDimSel);
        targetTabSel.addChild(targetTimeDimSel);
        this.addFKArcs(sourceTable, sourceTabsel, targetTable, targetTabSel);
    }

    private void addDeletedTableViews(CompareCWDDesigns allsTabViewSel, CompareCWDDesigns alltTabViewSel, RelationalDesign targetDes) {
        Iterator it = targetDes.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView targetTableView = (TableView)it.next();
            if (this.objectsMap.containsValue(targetTableView)) continue;
            CompareCWDDesigns tTabViewSel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(tTabViewSel);
            tTabViewSel.setSelected(false);
            CompareCWDDesigns sTabViewSel = new CompareCWDDesigns(targetTableView);
            tTabViewSel.setElementDescriptor(TableView.class);
            TableViewProxy tViewProxy = (TableViewProxy)targetDes.getStorageDesign().getProxy(targetTableView.getObjectID());
            TableViewComparator comp = new TableViewComparator(null, targetTableView, null, tViewProxy);
            this.comparatorsMap.put(comp.getID(), comp);
            tTabViewSel.setPropertiesComparator(comp);
            sTabViewSel.setPropertiesComparator(comp);
            tTabViewSel.setStatus(STATE_DELETED);
            sTabViewSel.setStatus(STATE_DELETED);
            sTabViewSel.setCorrespondentNode(tTabViewSel);
            tTabViewSel.setCorrespondentNode(sTabViewSel);
            allsTabViewSel.addChild(tTabViewSel);
            alltTabViewSel.addChild(sTabViewSel);
        }
    }

    private void addDeletedFKAssociation(Table targetTable, CompareCWDDesigns allsFKsel, CompareCWDDesigns alltFKeSel) {
        for (FKIndexAssociation targetfk : Arrays.asList(targetTable.getFKAssociations())) {
            if (this.objectsMap.containsValue(targetfk)) continue;
            String tfkname = targetfk.getName() + " (" + targetfk.getContainerWithKeyObject().getName() + " : " + targetfk.getRemoteTable().getName() + " )";
            CompareCWDDesigns sfksel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(sfksel);
            sfksel.setSelected(false);
            CompareCWDDesigns tfksel = new CompareCWDDesigns(targetfk);
            tfksel.setElementDescriptor(FKIndexAssociation.class);
            sfksel.setElementDescriptor(FKIndexAssociation.class);
            this.setEmptyComparator(sfksel);
            FKComparator comp = new FKComparator(null, targetfk, false, false, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            tfksel.setPropertiesComparator(comp);
            tfksel.setName(tfkname);
            sfksel.setStatus(STATE_DELETED);
            tfksel.setStatus(STATE_DELETED);
            tfksel.setCorrespondentNode(sfksel);
            sfksel.setCorrespondentNode(tfksel);
            allsFKsel.addChild(sfksel);
            alltFKeSel.addChild(tfksel);
        }
    }

    public DesignObject getCorrespondingObject(DesignObjectSet set, DesignObject object, boolean getByLongName) {
        DesignObject obj;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            obj = (DesignObject)it.next();
            if (obj.getImportedId() != null && obj.getImportedId().equals(object.getObjectID())) {
                return obj;
            }
            if (!obj.getObjectID().equals(object.getObjectID())) continue;
            return obj;
        }
        if (getByLongName) {
            if ((object instanceof Index || object instanceof FKIndexAssociation) && (obj = set.getByVeryLongdName(object.getVeryLongName())) != null) {
                return obj;
            }
            return set.getByLongName(object.getLongName());
        }
        return set.getByName(object.getName());
    }

    private void addFK(FKIndexAssociation sourcefk, CompareCWDDesigns allsFKsel, CompareCWDDesigns alltFKSel, RelationalDesign targetDes) {
        CompareCWDDesigns sfksel = new CompareCWDDesigns(sourcefk);
        String sfkname = sourcefk.getName() + " (" + sourcefk.getContainerWithKeyObject().getName() + " : " + sourcefk.getRemoteTable().getName() + " )";
        sfksel.setName(sfkname);
        sfksel.setSelected(true);
        FKIndexAssociation targetfk = (FKIndexAssociation)this.getCorrespondingObject(targetDes.getFKIndexAssociationSet(), sourcefk, true);
        CompareCWDDesigns tfksel = null;
        if (targetfk != null) {
            tfksel = new CompareCWDDesigns(targetfk);
            Table tTable = targetfk.getRemoteTable();
            if (tTable != null) {
                KeyObject pk = (KeyObject)this.getCorrespondingObject(tTable.getKeySet(), (DesignObject)sourcefk.getKeyObject());
                if (pk == null) {
                    sfksel.setSelected(true);
                    tfksel = new CompareCWDDesigns(NEW_RELATION);
                    sfksel.setStatus(STATE_NEW);
                    tfksel.setStatus(STATE_NEW);
                    tfksel.setElementDescriptor(FKIndexAssociation.class);
                    FKComparator comp = new FKComparator(sourcefk, null, false, false, this.objectsMap);
                    sfksel.setPropertiesComparator(comp);
                    tfksel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                    this.objectsMap.put(sourcefk.getObjectID(), null);
                } else {
                    Column[] targetColumns;
                    Column[] sourceColumns;
                    boolean matchingColumns;
                    boolean matchingRemoteKey = false;
                    KeyObject targetPK = targetfk.getKeyObject();
                    if (targetPK != null && targetPK.getObjectID().equals(pk.getObjectID())) {
                        matchingRemoteKey = true;
                    }
                    boolean bl = matchingColumns = (sourceColumns = sourcefk.getColumns()).length == (targetColumns = targetfk.getColumns()).length;
                    if (matchingColumns) {
                        for (int i = 0; i < sourceColumns.length; ++i) {
                            Column mappedTargetCol = (Column)this.objectsMap.get(sourceColumns[i].getObjectID());
                            if (mappedTargetCol != null && mappedTargetCol.getObjectID().equals(targetColumns[i].getObjectID())) continue;
                            matchingColumns = false;
                            break;
                        }
                    }
                    FKComparator comp = new FKComparator(sourcefk, targetfk, matchingRemoteKey, matchingColumns, this.objectsMap);
                    sfksel.setPropertiesComparator(comp);
                    tfksel.setPropertiesComparator(comp);
                    tfksel.setSelected(comp.isModified());
                    sfksel.setSelected(comp.isModified());
                    Table tab1 = (Table)targetfk.getContainerWithKeyObject();
                    Table tab2 = targetfk.getRemoteTable();
                    if (tab1 != null && tab2 != null) {
                        String rname = targetfk.getName() + " (" + tab1.getName() + " : " + tab2.getName() + ")";
                        tfksel.setName(rname);
                    }
                    this.comparatorsMap.put(comp.getID(), comp);
                    sfksel.setSelected(comp.isModified());
                    this.objectsMap.put(sourcefk.getObjectID(), targetfk);
                }
            }
        } else {
            sfksel.setSelected(true);
            tfksel = new CompareCWDDesigns(NEW_RELATION);
            sfksel.setStatus(STATE_NEW);
            tfksel.setStatus(STATE_NEW);
            tfksel.setElementDescriptor(FKIndexAssociation.class);
            FKComparator comp = new FKComparator(sourcefk, null, false, false, this.objectsMap);
            sfksel.setPropertiesComparator(comp);
            tfksel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourcefk.getObjectID(), null);
        }
        tfksel.setCorrespondentNode(sfksel);
        sfksel.setCorrespondentNode(tfksel);
        allsFKsel.addChild(sfksel);
        alltFKSel.addChild(tfksel);
    }

    private void addDeletedIndexes(Table targetTable, CompareCWDDesigns allsIndsel, CompareCWDDesigns alltIndsel, boolean isPKorUK) {
        Iterator it = targetTable.getKeySet().iterator();
        while (it.hasNext()) {
            boolean isdeleted;
            Index targetIndex = (Index)it.next();
            boolean bl = isdeleted = isPKorUK == (targetIndex.isPK() || targetIndex.isUnique());
            if (targetIndex.isFK() || !isdeleted || this.objectsMap.containsValue(targetIndex)) continue;
            CompareCWDDesigns sIndsel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(sIndsel);
            sIndsel.setSelected(false);
            CompareCWDDesigns tIndsel = new CompareCWDDesigns(targetIndex);
            sIndsel.setElementDescriptor(Index.class);
            IndexComparator comp = new IndexComparator(null, targetIndex, this.objectsMap, isPKorUK, null, null);
            this.comparatorsMap.put(comp.getID(), comp);
            tIndsel.setPropertiesComparator(comp);
            sIndsel.setPropertiesComparator(comp);
            sIndsel.setStatus(STATE_DELETED);
            tIndsel.setStatus(STATE_DELETED);
            tIndsel.setCorrespondentNode(sIndsel);
            sIndsel.setCorrespondentNode(tIndsel);
            allsIndsel.addChild(sIndsel);
            alltIndsel.addChild(tIndsel);
        }
    }

    private void addIndex(Index sourceIndex, Table targetTable, CompareCWDDesigns allsIndsel, CompareCWDDesigns alltIndSel) {
        CWDIndexComparator comp;
        CompareCWDDesigns sIndsel = new CompareCWDDesigns(sourceIndex);
        sIndsel.setSelected(true);
        CompareCWDDesigns tIndsel = null;
        Index targetIndex = null;
        if (targetTable != null) {
            targetIndex = (Index)this.getCorrespondingObject(targetTable.getKeySet(), (DesignObject)sourceIndex);
            if (targetIndex == null) {
                targetIndex = this.checkForEqualStructure(sourceIndex, targetTable, allsIndsel);
            }
            if (targetIndex != null) {
                tIndsel = new CompareCWDDesigns(targetIndex);
                comp = new CWDIndexComparator(sourceIndex, targetIndex, this.objectsMap);
                sIndsel.setPropertiesComparator(comp);
                tIndsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sIndsel.setSelected(comp.isModified());
                sIndsel.setEditable(comp.isModified());
                comp.setLeftSelectionObject(sIndsel);
                this.objectsMap.put(sourceIndex.getObjectID(), targetIndex);
            }
        }
        if (targetIndex == null) {
            sIndsel.setSelected(true);
            tIndsel = new CompareCWDDesigns(NEW_INDEX);
            tIndsel.setStatus(STATE_NEW);
            sIndsel.setStatus(STATE_NEW);
            tIndsel.setElementDescriptor(Index.class);
            comp = new CWDIndexComparator(sourceIndex, targetIndex, this.objectsMap);
            sIndsel.setPropertiesComparator(comp);
            tIndsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceIndex.getObjectID(), null);
        }
        sIndsel.setCorrespondentNode(tIndsel);
        tIndsel.setCorrespondentNode(sIndsel);
        alltIndSel.addChild(tIndsel);
        allsIndsel.addChild(sIndsel);
    }

    private Index checkForEqualStructure(Index sourceIndex, Table targetTable, CompareCWDDesigns allsIndsel) {
        block4: {
            Table sourceTable;
            block5: {
                block3: {
                    sourceTable = (Table)sourceIndex.getContainerObject();
                    if (!sourceIndex.isPK()) break block3;
                    Index targetIndex = (Index)targetTable.getPK();
                    if (targetIndex != null && this.checkIndexes(sourceIndex, targetIndex)) {
                        return targetIndex;
                    }
                    break block4;
                }
                if (!sourceIndex.isUnique()) break block5;
                Iterator it = targetTable.getUKeys().iterator();
                while (it.hasNext()) {
                    Index targetIndex = (Index)it.next();
                    if (!this.checkIndexes(sourceIndex, targetIndex) || sourceTable.getUKeys().getByName(targetIndex.getName()) != null) continue;
                    return targetIndex;
                }
                break block4;
            }
            if (sourceIndex.isFK()) break block4;
            Iterator it = targetTable.getIndexes().iterator();
            while (it.hasNext()) {
                Index targetIndex = (Index)((ContainerObjectPlaceHolder)it.next()).getObject();
                if (!this.checkIndexes(sourceIndex, targetIndex) || sourceTable.getIndexes().getByName(targetIndex.getName()) != null) continue;
                return targetIndex;
            }
        }
        return null;
    }

    private boolean checkIndexes(Index sourceIndex, Index targetIndex) {
        ContainedObject[] targetColumns;
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        if (sourceColumns.length != (targetColumns = targetIndex.getElements()).length) {
            return false;
        }
        for (int i = 0; i < sourceColumns.length; ++i) {
            Column scol = (Column)sourceColumns[i];
            Column tcol = (Column)this.objectsMap.get(scol.getObjectID());
            if (tcol == null) {
                return false;
            }
            if (tcol.getName().equals(((Column)targetColumns[i]).getName())) continue;
            return false;
        }
        return true;
    }

    private void initIndexes(Table r_table) {
        this.clearIndexList();
        Iterator it = r_table.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (key.isPK() || key.isUnique()) {
                this.pkInd.add(key);
                continue;
            }
            if (key.isFK()) continue;
            this.indexes.add(key);
        }
    }

    private void clearIndexList() {
        this.pkInd.clear();
        this.fkInd.clear();
        this.indexes.clear();
    }

    private void addDeletedCheckConstraints(Table targetTable, CompareCWDDesigns sourceCheckSel, CompareCWDDesigns targetCheckSel) {
        for (TableLevelConstraint targetTlc : targetTable.getCheckConstraints()) {
            if (this.objectsMap.containsValue(targetTlc)) continue;
            CompareCWDDesigns sCheckSel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(sCheckSel);
            sCheckSel.setSelected(false);
            sCheckSel.setElementDescriptor(TableLevelConstraint.class);
            CompareCWDDesigns tCheckSel = new CompareCWDDesigns(targetTlc);
            tCheckSel.setElementDescriptor(TableLevelConstraint.class);
            TableConstraintComparator comp = new TableConstraintComparator(null, targetTlc);
            this.comparatorsMap.put(comp.getID(), comp);
            tCheckSel.setPropertiesComparator(comp);
            sCheckSel.setPropertiesComparator(comp);
            sCheckSel.setStatus(STATE_DELETED);
            tCheckSel.setStatus(STATE_DELETED);
            tCheckSel.setCorrespondentNode(sCheckSel);
            sCheckSel.setCorrespondentNode(tCheckSel);
            sourceCheckSel.addChild(sCheckSel);
            targetCheckSel.addChild(tCheckSel);
        }
    }

    private void addCheckConstraint(TableLevelConstraint sourceConstraint, Table targetTable, CompareCWDDesigns sourceTlcSel, CompareCWDDesigns targetTlcSel) {
        TableConstraintComparator comp;
        CompareCWDDesigns sTlcSel = new CompareCWDDesigns(sourceConstraint);
        ModelIdObjectSelection tTlcSel = null;
        TableLevelConstraint targetConstraint = null;
        if (targetTable != null && (targetConstraint = (TableLevelConstraint)this.getCorrespondingObject(targetTable.getCheckConstraints(), (DesignObject)sourceConstraint)) != null) {
            tTlcSel = new CompareCWDDesigns(targetConstraint);
            comp = new TableConstraintComparator(sourceConstraint, targetConstraint);
            sTlcSel.setPropertiesComparator(comp);
            ((CompareCWDDesigns)tTlcSel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sTlcSel.setSelected(comp.isModified());
            sTlcSel.setEditable(comp.isModified());
            this.objectsMap.put(sourceConstraint.getObjectID(), targetConstraint);
        }
        if (targetConstraint == null) {
            sTlcSel.setSelected(true);
            tTlcSel = new CompareCWDDesigns(NEW_CONSTRAINT);
            ((CompareCWDDesigns)tTlcSel).setStatus(STATE_NEW);
            sTlcSel.setStatus(STATE_NEW);
            comp = new TableConstraintComparator(sourceConstraint, targetConstraint);
            sTlcSel.setPropertiesComparator(comp);
            ((CompareCWDDesigns)tTlcSel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceConstraint.getObjectID(), null);
        }
        tTlcSel.setElementDescriptor(TableLevelConstraint.class);
        sTlcSel.setCorrespondentNode((CompareCWDDesigns)tTlcSel);
        ((CompareCWDDesigns)tTlcSel).setCorrespondentNode(sTlcSel);
        sourceTlcSel.addChild(sTlcSel);
        targetTlcSel.addChild(tTlcSel);
    }

    private void addDeletedTimeDimensions(Table targetTable, CompareCWDDesigns sourceTimeDimSel, CompareCWDDesigns targetTimeDimSel) {
        for (ValidTimeDimension targetTimeDim : targetTable.getValidTimeDimensions()) {
            if (this.objectsMap.containsValue(targetTimeDim)) continue;
            CompareCWDDesigns sTimeDimSel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(sTimeDimSel);
            sTimeDimSel.setSelected(false);
            sTimeDimSel.setElementDescriptor(ValidTimeDimension.class);
            CompareCWDDesigns tTimeDimSel = new CompareCWDDesigns(targetTimeDim);
            tTimeDimSel.setElementDescriptor(ValidTimeDimension.class);
            ValidTimeDimensionComparator comp = new ValidTimeDimensionComparator(null, targetTimeDim);
            this.comparatorsMap.put(comp.getID(), comp);
            tTimeDimSel.setPropertiesComparator(comp);
            sTimeDimSel.setPropertiesComparator(comp);
            sTimeDimSel.setStatus(STATE_DELETED);
            tTimeDimSel.setStatus(STATE_DELETED);
            tTimeDimSel.setCorrespondentNode(sTimeDimSel);
            sTimeDimSel.setCorrespondentNode(tTimeDimSel);
            sourceTimeDimSel.addChild(sTimeDimSel);
            targetTimeDimSel.addChild(tTimeDimSel);
        }
    }

    private void addTimeDimension(ValidTimeDimension sourceTimeDim, Table targetTable, CompareCWDDesigns sourceTimeDimSel, CompareCWDDesigns targetTimeDimSel) {
        ValidTimeDimensionComparator comp;
        CompareCWDDesigns sTimeDimSel = new CompareCWDDesigns(sourceTimeDim);
        ModelIdObjectSelection tTimeDimSel = null;
        ValidTimeDimension targetTimeDim = null;
        if (targetTable != null && (targetTimeDim = (ValidTimeDimension)this.getCorrespondingObject(targetTable.getValidTimeDimensions(), (DesignObject)sourceTimeDim)) != null) {
            tTimeDimSel = new CompareCWDDesigns(targetTimeDim);
            comp = new ValidTimeDimensionComparator(sourceTimeDim, targetTimeDim);
            sTimeDimSel.setPropertiesComparator(comp);
            ((CompareCWDDesigns)tTimeDimSel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sTimeDimSel.setSelected(comp.isModified());
            sTimeDimSel.setEditable(comp.isModified());
            this.objectsMap.put(sourceTimeDim.getObjectID(), targetTimeDim);
        }
        if (targetTimeDim == null) {
            sTimeDimSel.setSelected(true);
            tTimeDimSel = new CompareCWDDesigns(NEW_VALID_TIME);
            ((CompareCWDDesigns)tTimeDimSel).setStatus(STATE_NEW);
            sTimeDimSel.setStatus(STATE_NEW);
            comp = new ValidTimeDimensionComparator(sourceTimeDim, targetTimeDim);
            sTimeDimSel.setPropertiesComparator(comp);
            ((CompareCWDDesigns)tTimeDimSel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceTimeDim.getObjectID(), null);
        }
        tTimeDimSel.setElementDescriptor(ValidTimeDimension.class);
        sTimeDimSel.setCorrespondentNode((CompareCWDDesigns)tTimeDimSel);
        ((CompareCWDDesigns)tTimeDimSel).setCorrespondentNode(sTimeDimSel);
        sourceTimeDimSel.addChild(sTimeDimSel);
        targetTimeDimSel.addChild(tTimeDimSel);
    }

    private void addDeletedColumns(Table sourceTable, CompareCWDDesigns sourceColumnSel, Table targetTable, CompareCWDDesigns targetColumnSel) {
        for (Column targetColumn : targetTable.getElementsCollection()) {
            if (this.objectsMap.containsValue(targetColumn)) continue;
            CompareCWDDesigns sColsel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(sColsel);
            sColsel.setSelected(false);
            sColsel.setElementDescriptor(Column.class);
            CompareCWDDesigns tColSel = new CompareCWDDesigns(targetColumn);
            tColSel.setElementDescriptor(Column.class);
            ColumnComparator comp = new ColumnComparator(null, targetColumn, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            tColSel.setPropertiesComparator(comp);
            sColsel.setPropertiesComparator(comp);
            sColsel.setStatus(STATE_DELETED);
            tColSel.setStatus(STATE_DELETED);
            tColSel.setCorrespondentNode(sColsel);
            sColsel.setCorrespondentNode(tColSel);
            sourceColumnSel.addChild(sColsel);
            targetColumnSel.addChild(tColSel);
        }
    }

    private void addColumn(Column sourceColumn, Table targetTable, CompareCWDDesigns sourceColumnSel, CompareCWDDesigns targetColumnSel, RelationalDesign sourceDes, RelationalDesign targetDes) {
        CWDColumnSelection sColsel = new CWDColumnSelection(sourceColumn);
        ModelIdObjectSelection tColsel = null;
        ColumnProxy sourceColumnProxy = (ColumnProxy)sourceDes.getStorageDesign().getColumnProxySet().getProxy(sourceColumn.getObjectID());
        Column targetColumn = null;
        if (targetTable != null && (targetColumn = (Column)this.getCorrespondingObject(targetTable.getElements(), (DesignObject)sourceColumn)) != null) {
            tColsel = new CompareCWDDesigns(targetColumn);
            ColumnProxy targetColumnProxy = (ColumnProxy)targetDes.getStorageDesign().getColumnProxySet().getProxy(targetColumn.getObjectID());
            ColumnComparator comp = new ColumnComparator(sourceColumn, targetColumn, sourceColumnProxy, targetColumnProxy, this.objectsMap);
            sColsel.setPropertiesComparator(comp);
            ((CompareCWDDesigns)tColsel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            ((CompareCWDDesigns)sColsel).setSelected(comp.isModified());
            sColsel.setEditable(comp.isModified());
            this.objectsMap.put(sourceColumn.getObjectID(), targetColumn);
        }
        if (targetColumn == null) {
            ((CompareCWDDesigns)sColsel).setSelected(true);
            tColsel = new CompareCWDDesigns(NEW_COLUMN);
            ((CompareCWDDesigns)tColsel).setStatus(STATE_NEW);
            sColsel.setStatus(STATE_NEW);
            ColumnComparator comp = new ColumnComparator(sourceColumn, targetColumn, sourceColumnProxy, null, this.objectsMap);
            sColsel.setPropertiesComparator(comp);
            ((CompareCWDDesigns)tColsel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceColumn.getObjectID(), null);
        }
        tColsel.setElementDescriptor(Column.class);
        sColsel.setCorrespondentNode((CompareCWDDesigns)tColsel);
        ((CompareCWDDesigns)tColsel).setCorrespondentNode(sColsel);
        sourceColumnSel.addChild(sColsel);
        targetColumnSel.addChild(tColsel);
        if (((ColumnComparator)((CompareCWDDesigns)tColsel).getPropertiesComparator()).isDataTypeChanged()) {
            this.columnsWithChangedDataType.add(tColsel);
        }
    }

    private ContainedObject getCorrespondingNestedColumn(List targetNestedElements, ContainedObject sourceColumn) {
        TypeElement targetStructAtt;
        ContainedObject targetParentColumn;
        ContainedObject sourceParentColumn = sourceColumn.getParentObject();
        if (sourceParentColumn != null && (targetParentColumn = (ContainedObject)this.objectsMap.get(sourceParentColumn.getObjectID())) != null && (targetStructAtt = (TypeElement)this.objectsMap.get(sourceColumn.getStructAttributeID())) != null) {
            String targetStructAttID = targetStructAtt.getObjectID();
            String targetParentColumnID = targetParentColumn.getObjectID();
            for (ContainedObject targetCol : targetNestedElements) {
                ContainedObject parentCol;
                if (!targetCol.getStructAttributeID().equals(targetStructAttID) || (parentCol = targetCol.getParentObject()) == null || !parentCol.getObjectID().equals(targetParentColumnID)) continue;
                return targetCol;
            }
        }
        return null;
    }

    private void addRelationalSubView(DesignPartViewPlaceHolder sourceSubView, CompareCWDDesigns sRelSubViews, CompareCWDDesigns tRelSubViews) {
        CWDFilteredSelection sSubView = new CWDFilteredSelection(sourceSubView);
        CWDFilteredSelection tSubView = null;
        DesignPartView tDPV = this.getCorrespondingObject(this.designHandler.getTargetDesign().getRelationalDesign().getPhysicalDesignSubviews(), sourceSubView.getDesignPartView());
        if (tDPV != null) {
            DesignPartViewPlaceHolder targetSubView = (DesignPartViewPlaceHolder)tDPV.getPlaceHolder();
            tSubView = new CWDFilteredSelection(targetSubView);
            RelationalSubViewComparator comp = new RelationalSubViewComparator(sourceSubView, targetSubView);
            sSubView.setPropertiesComparator(comp);
            tSubView.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sSubView.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sSubView);
            this.objectsMap.put(sourceSubView.getDesignPartView().getDPVId(), tDPV);
        } else {
            tSubView = new CWDFilteredSelection(NEW_SUBVIEW);
            sSubView.setStatus(STATE_NEW);
            tSubView.setStatus(STATE_NEW);
            tSubView.setElementDescriptor(DesignPartViewPlaceHolder.class);
            this.objectsMap.put(sourceSubView.getDesignPartView().getDPVId(), null);
            RelationalSubViewComparator comp = new RelationalSubViewComparator(sourceSubView, null);
            sSubView.setPropertiesComparator(comp);
            tSubView.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sSubView.setSelected(true);
        }
        tSubView.setCorrespondentNode(sSubView);
        sSubView.setCorrespondentNode(tSubView);
        sRelSubViews.addChild(sSubView);
        tRelSubViews.addChild(tSubView);
        this.addNotes(sourceSubView.getDesignPartView(), sSubView, tDPV, tSubView);
    }

    private void addDeletedRelationalSubViews(CompareCWDDesigns sSubViews, CompareCWDDesigns tSubViews) {
        Iterator it = this.designHandler.getTargetDesign().getRelationalDesign().getPhysicalDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder targetSubView = (DesignPartViewPlaceHolder)it.next();
            if (this.objectsMap.containsValue(targetSubView.getDesignPartView())) continue;
            CompareCWDDesigns tSubView = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(tSubView);
            tSubView.setSelected(false);
            CompareCWDDesigns sSubView = new CompareCWDDesigns(targetSubView);
            sSubView.setElementDescriptor(DesignPartViewPlaceHolder.class);
            RelationalSubViewComparator comp = new RelationalSubViewComparator(null, targetSubView);
            this.comparatorsMap.put(comp.getID(), comp);
            tSubView.setPropertiesComparator(comp);
            sSubView.setPropertiesComparator(comp);
            tSubView.setStatus(STATE_DELETED);
            sSubView.setStatus(STATE_DELETED);
            sSubView.setCorrespondentNode(tSubView);
            tSubView.setCorrespondentNode(sSubView);
            sSubViews.addChild(tSubView);
            tSubViews.addChild(sSubView);
        }
    }

    private void addDeletedEntities(CompareCWDDesigns allsTabsel, CompareCWDDesigns alltTabsel) {
        Iterator it = this.designHandler.getTargetLogicalDesign().getEntitySet().iterator();
        while (it.hasNext()) {
            Entity targetEntity = (Entity)it.next();
            if (this.objectsMap.containsValue(targetEntity)) continue;
            CompareCWDDesigns targetTabsel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(targetTabsel);
            targetTabsel.setSelected(false);
            CompareCWDDesigns sourceTabsel = new CompareCWDDesigns(targetEntity);
            targetTabsel.setElementDescriptor(Entity.class);
            EntityComparator comp = new EntityComparator(null, targetEntity);
            this.comparatorsMap.put(comp.getID(), comp);
            targetTabsel.setPropertiesComparator(comp);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setCorrespondentNode(targetTabsel);
            targetTabsel.setCorrespondentNode(sourceTabsel);
            allsTabsel.addChild(targetTabsel);
            alltTabsel.addChild(sourceTabsel);
        }
    }

    private void addDeletedEntityViews(CompareCWDDesigns allsTabsel, CompareCWDDesigns alltTabsel) {
        Iterator it = this.designHandler.getTargetLogicalDesign().getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView targetEntityView = (EntityView)it.next();
            if (this.objectsMap.containsValue(targetEntityView)) continue;
            CompareCWDDesigns targetTabsel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(targetTabsel);
            targetTabsel.setSelected(false);
            CompareCWDDesigns sourceTabsel = new CompareCWDDesigns(targetEntityView);
            targetTabsel.setElementDescriptor(EntityView.class);
            EntityViewComparator comp = new EntityViewComparator(null, targetEntityView);
            this.comparatorsMap.put(comp.getID(), comp);
            targetTabsel.setPropertiesComparator(comp);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setCorrespondentNode(targetTabsel);
            targetTabsel.setCorrespondentNode(sourceTabsel);
            allsTabsel.addChild(targetTabsel);
            alltTabsel.addChild(sourceTabsel);
        }
    }

    private void addDeletedRelationss(CompareCWDDesigns allsTabsel, CompareCWDDesigns alltTabsel) {
        Iterator it = this.designHandler.getTargetLogicalDesign().getRelationSet().iterator();
        while (it.hasNext()) {
            Relation targetRelation = (Relation)it.next();
            if (this.objectsMap.containsValue(targetRelation)) continue;
            CompareCWDDesigns targetTabsel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(targetTabsel);
            targetTabsel.setSelected(false);
            CompareCWDDesigns sourceTabsel = new CompareCWDDesigns(targetRelation);
            targetTabsel.setElementDescriptor(Relation.class);
            RelationComparator comp = new RelationComparator(null, targetRelation, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            targetTabsel.setPropertiesComparator(comp);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setCorrespondentNode(targetTabsel);
            targetTabsel.setCorrespondentNode(sourceTabsel);
            allsTabsel.addChild(targetTabsel);
            alltTabsel.addChild(sourceTabsel);
        }
    }

    private void addDeletedInheritanceRelationss(CompareCWDDesigns allsTabsel, CompareCWDDesigns alltTabsel) {
        Iterator it = this.designHandler.getTargetLogicalDesign().getInheritanceRelationSet().iterator();
        while (it.hasNext()) {
            InheritanceRelation targetRelation = (InheritanceRelation)it.next();
            if (this.objectsMap.containsValue(targetRelation)) continue;
            CompareCWDDesigns targetTabsel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(targetTabsel);
            targetTabsel.setSelected(false);
            CompareCWDDesigns sourceTabsel = new CompareCWDDesigns(targetRelation);
            targetTabsel.setElementDescriptor(InheritanceRelation.class);
            RelationComparator comp = new RelationComparator(null, targetRelation, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            targetTabsel.setPropertiesComparator(comp);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setCorrespondentNode(targetTabsel);
            targetTabsel.setCorrespondentNode(sourceTabsel);
            allsTabsel.addChild(targetTabsel);
            alltTabsel.addChild(sourceTabsel);
        }
    }

    public DesignObject getCorrespondingObject(DesignObjectSet targetSet, DesignObject sourceObject) {
        Iterator it = targetSet.iterator();
        while (it.hasNext()) {
            DesignObject obj = (DesignObject)it.next();
            if (!(sourceObject.getObjectID().equals(obj.getObjectID()) || obj.getImportedId() != null && obj.getImportedId().equals(sourceObject.getObjectID()) || sourceObject.getImportedId() != null && sourceObject.getImportedId().equals(obj.getObjectID())) && (obj.getImportedId() == null || sourceObject.getImportedId() == null || !sourceObject.getImportedId().equals(obj.getImportedId()))) continue;
            return obj;
        }
        return targetSet.getByName(sourceObject.getName());
    }

    public DesignObject getCorrespondingObject(List targetList, DesignObject sourceObject) {
        for (DesignObject obj : targetList) {
            if (!(sourceObject.getObjectID().equals(obj.getObjectID()) || obj.getImportedId() != null && obj.getImportedId().equals(sourceObject.getObjectID()) || sourceObject.getImportedId() != null && sourceObject.getImportedId().equals(obj.getObjectID())) && (obj.getImportedId() == null || sourceObject.getImportedId() == null || !sourceObject.getImportedId().equals(obj.getImportedId()))) continue;
            return obj;
        }
        return null;
    }

    private Method getCorrespondingObject(List targetList, Method sourceObject) {
        for (Method obj : targetList) {
            if (!(sourceObject.getObjectID().equals(obj.getObjectID()) || obj.getImportedId() != null && obj.getImportedId().equals(sourceObject.getObjectID()) || sourceObject.getImportedId() != null && sourceObject.getImportedId().equals(obj.getObjectID())) && (obj.getImportedId() == null || sourceObject.getImportedId() == null || !sourceObject.getImportedId().equals(obj.getImportedId()))) continue;
            return obj;
        }
        String name = sourceObject.getName();
        for (Method obj : targetList) {
            if (!obj.getName().equals(name) || this.objectsMap.containsValue(obj)) continue;
            return obj;
        }
        return null;
    }

    public DesignPartView getCorrespondingObject(SubViewObjectSet set, DesignPartView sourceDPV) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder holder = (DesignPartViewPlaceHolder)it.next();
            DesignPartView targetDPV = holder.getDesignPartView();
            if (!(targetDPV.getImportedId() != null && targetDPV.getImportedId().equals(sourceDPV.getDPVId()) || sourceDPV.getImportedId() != null && sourceDPV.getImportedId().equals(targetDPV.getDPVId()) || sourceDPV.getDPVId().equals(targetDPV.getDPVId())) && (targetDPV.getImportedId() == null || sourceDPV.getImportedId() == null || !sourceDPV.getImportedId().equals(targetDPV.getImportedId()))) continue;
            return targetDPV;
        }
        return set.getSubViewByName(sourceDPV.getName());
    }

    private void addEntity(Entity source, CompareCWDDesigns allSources, CompareCWDDesigns allTargets) {
        CompareCWDDesigns sourceSel = new CompareCWDDesigns(source);
        CompareCWDDesigns targetSel = null;
        Entity target = (Entity)this.getCorrespondingObject(this.designHandler.getTargetLogicalDesign().getEntitySet(), (DesignObject)source);
        if (target != null) {
            targetSel = new CompareCWDDesigns(target);
            EntityComparator comp = new EntityComparator(source, target);
            sourceSel.setPropertiesComparator(comp);
            targetSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSel.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sourceSel);
            this.objectsMap.put(source.getObjectID(), target);
        } else {
            targetSel = new CompareCWDDesigns(NEW_ENTITY);
            sourceSel.setStatus(STATE_NEW);
            targetSel.setStatus(STATE_NEW);
            targetSel.setElementDescriptor(Entity.class);
            this.objectsMap.put(source.getObjectID(), null);
            EntityComparator comp = new EntityComparator(source, target);
            sourceSel.setPropertiesComparator(comp);
            targetSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSel.setSelected(true);
        }
        targetSel.setCorrespondentNode(sourceSel);
        sourceSel.setCorrespondentNode(targetSel);
        this.addEntityDetails(source, sourceSel, target, targetSel);
        allSources.addChild(sourceSel);
        allTargets.addChild(targetSel);
    }

    private void addEntityView(EntityView sourceView, CompareCWDDesigns allsViewSel, CompareCWDDesigns alltViewSel) {
        CompareCWDDesigns sourceViewSel = new CompareCWDDesigns(sourceView);
        EntityView targetView = (EntityView)this.getCorrespondingObject(this.designHandler.getTargetLogicalDesign().getEntityViewSet(), (DesignObject)sourceView);
        CompareCWDDesigns targetViewSel = null;
        if (targetView != null) {
            targetViewSel = new CompareCWDDesigns(targetView);
            EntityViewComparator comp = new EntityViewComparator(sourceView, targetView);
            sourceViewSel.setPropertiesComparator(comp);
            targetViewSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceViewSel.setSelected(comp.isModified());
            this.objectsMap.put(sourceView.getObjectID(), targetView);
        } else {
            sourceViewSel.setSelected(true);
            targetViewSel = new CompareCWDDesigns(NEW_VIEW);
            EntityViewComparator comp = new EntityViewComparator(sourceView, null);
            sourceViewSel.setPropertiesComparator(comp);
            targetViewSel.setPropertiesComparator(comp);
            targetViewSel.setElementDescriptor(EntityView.class);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceView.getObjectID(), null);
            sourceViewSel.setStatus(STATE_NEW);
            targetViewSel.setStatus(STATE_NEW);
        }
        targetViewSel.setCorrespondentNode(sourceViewSel);
        sourceViewSel.setCorrespondentNode(targetViewSel);
        allsViewSel.addChild(sourceViewSel);
        alltViewSel.addChild(targetViewSel);
    }

    private void addRelation(Relation source, CompareCWDDesigns allSources, CompareCWDDesigns allTargets) {
        RelationComparator comp;
        CompareCWDDesigns sourceSel = new CompareCWDDesigns(source);
        CompareCWDDesigns targetSel = null;
        Relation target = (Relation)this.getCorrespondingObject(this.designHandler.getTargetLogicalDesign().getRelationSet(), (DesignObject)source);
        if (target != null) {
            targetSel = new CompareCWDDesigns(target);
            comp = new RelationComparator(source, target, this.objectsMap);
            sourceSel.setPropertiesComparator(comp);
            targetSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSel.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sourceSel);
            this.objectsMap.put(source.getObjectID(), target);
        } else {
            targetSel = new CompareCWDDesigns(NEW_RELATION);
            sourceSel.setStatus(STATE_NEW);
            targetSel.setStatus(STATE_NEW);
            targetSel.setElementDescriptor(Relation.class);
            this.objectsMap.put(source.getObjectID(), null);
            comp = new RelationComparator(source, target, this.objectsMap);
            sourceSel.setPropertiesComparator(comp);
            targetSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSel.setSelected(true);
        }
        if (source.hasAttributes()) {
            CompareCWDDesigns sourceAttributesSel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Attributes"));
            CompareCWDDesigns targetAttributesSel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Attributes"));
            sourceAttributesSel.setCorrespondentNode(targetAttributesSel);
            targetAttributesSel.setCorrespondentNode(sourceAttributesSel);
            this.setEmptyComparator(sourceAttributesSel);
            this.setEmptyComparator(targetAttributesSel);
            targetAttributesSel.setSelected(false);
            Entity relEntity = null;
            if (target != null) {
                relEntity = target.getOwnedEntity();
            }
            for (Attribute sourceAttribute : source.getAttributesCollection()) {
                this.addAttribute(sourceAttribute, relEntity, sourceAttributesSel, targetAttributesSel);
            }
            sourceSel.addChild(sourceAttributesSel);
            targetSel.addChild(targetAttributesSel);
        }
        targetSel.setCorrespondentNode(sourceSel);
        sourceSel.setCorrespondentNode(targetSel);
        allSources.addChild(sourceSel);
        allTargets.addChild(targetSel);
    }

    private void addInheritanceRelation(InheritanceRelation source, CompareCWDDesigns allSources, CompareCWDDesigns allTargets) {
        CompareCWDDesigns sourceSel = new CompareCWDDesigns(source);
        CompareCWDDesigns targetSel = null;
        InheritanceRelation target = (InheritanceRelation)this.getCorrespondingObject(this.designHandler.getTargetLogicalDesign().getInheritanceRelationSet(), (DesignObject)source);
        if (target != null) {
            targetSel = new CompareCWDDesigns(target);
            InheritanceRelationComparator comp = new InheritanceRelationComparator(source, target);
            sourceSel.setPropertiesComparator(comp);
            targetSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSel.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sourceSel);
            this.objectsMap.put(source.getObjectID(), target);
        } else {
            targetSel = new CompareCWDDesigns(NEW_INHERITANCE);
            sourceSel.setStatus(STATE_NEW);
            targetSel.setStatus(STATE_NEW);
            targetSel.setElementDescriptor(InheritanceRelation.class);
            this.objectsMap.put(source.getObjectID(), null);
            InheritanceRelationComparator comp = new InheritanceRelationComparator(source, target);
            sourceSel.setPropertiesComparator(comp);
            targetSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSel.setSelected(true);
        }
        targetSel.setCorrespondentNode(sourceSel);
        sourceSel.setCorrespondentNode(targetSel);
        allSources.addChild(sourceSel);
        allTargets.addChild(targetSel);
    }

    private void addEntityDetails(Entity source, CompareCWDDesigns sourceSel, Entity target, CompareCWDDesigns targetSel) {
        CompareCWDDesigns sourceAttributesSel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Attributes"));
        CompareCWDDesigns targetAttributesSel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Attributes"));
        sourceAttributesSel.setCorrespondentNode(targetAttributesSel);
        targetAttributesSel.setCorrespondentNode(sourceAttributesSel);
        this.setEmptyComparator(sourceAttributesSel);
        this.setEmptyComparator(targetAttributesSel);
        targetAttributesSel.setSelected(false);
        for (Attribute sourceAttribute : source.getElementsCollection()) {
            this.addAttribute(sourceAttribute, target, sourceAttributesSel, targetAttributesSel);
        }
        if (target != null) {
            this.addDeletedAttributes(source, sourceAttributesSel, target, targetAttributesSel);
            List targetNestedElements = target.getNestedElements();
            if (targetNestedElements.size() > 0) {
                for (ContainedObject sourceNestedAtt : source.getNestedElements()) {
                    ContainedObject targetNestedAtt = this.getCorrespondingNestedColumn(targetNestedElements, sourceNestedAtt);
                    if (targetNestedAtt == null) continue;
                    this.objectsMap.put(sourceNestedAtt.getObjectID(), targetNestedAtt);
                }
            }
        }
        sourceSel.addChild(sourceAttributesSel);
        targetSel.addChild(targetAttributesSel);
        ((EntityComparator)sourceSel.getPropertiesComparator()).presetAttributesOrder();
        CompareCWDDesigns allsIndsel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.CandidateKeys"));
        CompareCWDDesigns alltIndSel = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.CandidateKeys"));
        allsIndsel.setCorrespondentNode(alltIndSel);
        alltIndSel.setCorrespondentNode(allsIndsel);
        this.setEmptyComparator(allsIndsel);
        this.setEmptyComparator(alltIndSel);
        alltIndSel.setSelected(false);
        KeyObject[] keys = source.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            CandidateKey key = (CandidateKey)keys[i];
            this.addKey(key, target, allsIndsel, alltIndSel);
        }
        if (target != null) {
            this.addDeletedKeys(target, allsIndsel, alltIndSel);
        }
        sourceSel.addChild(allsIndsel);
        targetSel.addChild(alltIndSel);
        this.addArcs(source, sourceSel, target, targetSel);
    }

    private void addKey(CandidateKey sourceKey, Entity target, CompareCWDDesigns allsIndsel, CompareCWDDesigns alltIndSel) {
        KeyComparator comp;
        CompareCWDDesigns sIndsel = new CompareCWDDesigns(sourceKey);
        sIndsel.setSelected(true);
        CompareCWDDesigns tIndsel = null;
        CandidateKey targetKey = null;
        if (target != null) {
            targetKey = (CandidateKey)this.getCorrespondingObject(target.getKeySet(), (DesignObject)sourceKey);
            if (targetKey == null) {
                targetKey = this.checkForEqualStructure(sourceKey, target, allsIndsel);
            }
            if (targetKey != null) {
                tIndsel = new CompareCWDDesigns(targetKey);
                comp = new KeyComparator(sourceKey, targetKey);
                sIndsel.setPropertiesComparator(comp);
                tIndsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sIndsel.setSelected(comp.isModified());
                sIndsel.setEditable(comp.isModified());
                comp.setLeftSelectionObject(sIndsel);
                this.objectsMap.put(sourceKey.getObjectID(), targetKey);
            }
        }
        if (targetKey == null) {
            sIndsel.setSelected(true);
            tIndsel = new CompareCWDDesigns(NEW_KEY);
            tIndsel.setStatus(STATE_NEW);
            sIndsel.setStatus(STATE_NEW);
            tIndsel.setElementDescriptor(CandidateKey.class);
            comp = new KeyComparator(sourceKey, targetKey);
            sIndsel.setPropertiesComparator(comp);
            tIndsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceKey.getObjectID(), null);
        }
        sIndsel.setCorrespondentNode(tIndsel);
        tIndsel.setCorrespondentNode(sIndsel);
        alltIndSel.addChild(tIndsel);
        allsIndsel.addChild(sIndsel);
    }

    private void addDeletedKeys(Entity target, CompareCWDDesigns allsIndsel, CompareCWDDesigns alltIndsel) {
        Iterator it = target.getKeySet().iterator();
        while (it.hasNext()) {
            CandidateKey targetKey = (CandidateKey)it.next();
            if (targetKey.isFK() || this.objectsMap.containsValue(targetKey)) continue;
            CompareCWDDesigns sIndsel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(sIndsel);
            sIndsel.setSelected(false);
            CompareCWDDesigns tIndsel = new CompareCWDDesigns(targetKey);
            sIndsel.setElementDescriptor(CandidateKey.class);
            KeyComparator comp = new KeyComparator(null, targetKey);
            this.comparatorsMap.put(comp.getID(), comp);
            tIndsel.setPropertiesComparator(comp);
            sIndsel.setPropertiesComparator(comp);
            sIndsel.setStatus(STATE_DELETED);
            tIndsel.setStatus(STATE_DELETED);
            tIndsel.setCorrespondentNode(sIndsel);
            sIndsel.setCorrespondentNode(tIndsel);
            allsIndsel.addChild(sIndsel);
            alltIndsel.addChild(tIndsel);
        }
    }

    private CandidateKey checkForEqualStructure(CandidateKey sourceKey, Entity target, CompareCWDDesigns allsIndsel) {
        Entity sourceEntity = (Entity)sourceKey.getContainerObject();
        if (sourceKey.isPK()) {
            CandidateKey targetKey = (CandidateKey)target.getPK();
            if (targetKey != null && this.checkKeys(sourceKey, targetKey)) {
                return targetKey;
            }
        } else if (sourceKey.isUnique()) {
            Iterator it = target.getKeySet().iterator();
            while (it.hasNext()) {
                CandidateKey targetKey = (CandidateKey)it.next();
                if (!targetKey.isUnique() || !this.checkKeys(sourceKey, targetKey) || sourceEntity.getKeySet().getByName(targetKey.getName()) != null) continue;
                return targetKey;
            }
        }
        return null;
    }

    private boolean checkKeys(CandidateKey sourceIndex, CandidateKey targetIndex) {
        ContainedObject[] targetColumns;
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        if (sourceColumns.length != (targetColumns = targetIndex.getElements()).length) {
            return false;
        }
        for (int i = 0; i < sourceColumns.length; ++i) {
            Attribute scol = (Attribute)sourceColumns[i];
            Attribute tcol = (Attribute)this.objectsMap.get(scol.getObjectID());
            if (tcol == null) {
                return false;
            }
            if (tcol.getName().equals(((Attribute)targetColumns[i]).getName())) continue;
            return false;
        }
        return true;
    }

    private void addAttribute(Attribute sourceAttribute, Entity target, CompareCWDDesigns sourceAttributeSel, CompareCWDDesigns targetAttributeSel) {
        AttributeComparator comp;
        AttributeSelection sAttributeSel = new AttributeSelection(sourceAttribute);
        ModelIdObjectSelection tAttributeSel = null;
        Attribute targetAttribute = null;
        if (target != null && (targetAttribute = (Attribute)this.getCorrespondingObject(target.getElements(), (DesignObject)sourceAttribute)) != null) {
            tAttributeSel = new CompareCWDDesigns(targetAttribute);
            comp = new AttributeComparator(sourceAttribute, targetAttribute, this.objectsMap);
            sAttributeSel.setPropertiesComparator(comp);
            ((CompareCWDDesigns)tAttributeSel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            ((CompareCWDDesigns)sAttributeSel).setSelected(comp.isModified());
            sAttributeSel.setEditable(comp.isModified());
            this.objectsMap.put(sourceAttribute.getObjectID(), targetAttribute);
        }
        if (targetAttribute == null) {
            ((CompareCWDDesigns)sAttributeSel).setSelected(true);
            tAttributeSel = new CompareCWDDesigns(NEW_ATTRIBUTE);
            ((CompareCWDDesigns)tAttributeSel).setStatus(STATE_NEW);
            sAttributeSel.setStatus(STATE_NEW);
            comp = new AttributeComparator(sourceAttribute, null);
            sAttributeSel.setPropertiesComparator(comp);
            ((CompareCWDDesigns)tAttributeSel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceAttribute.getObjectID(), null);
        }
        tAttributeSel.setElementDescriptor(Attribute.class);
        sAttributeSel.setCorrespondentNode((CompareCWDDesigns)tAttributeSel);
        ((CompareCWDDesigns)tAttributeSel).setCorrespondentNode(sAttributeSel);
        sourceAttributeSel.addChild(sAttributeSel);
        targetAttributeSel.addChild(tAttributeSel);
        if (((AttributeComparator)((CompareCWDDesigns)tAttributeSel).getPropertiesComparator()).isDataTypeChanged()) {
            this.attributesWithChangedDataType.add(tAttributeSel);
        }
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    public Map getObjectsMap() {
        return this.objectsMap;
    }

    public CompareCWDDesigns getRightRoot() {
        return this.rightRoot;
    }

    public CompareCWDDesigns getRoot() {
        return this;
    }

    @Override
    public boolean isModified() {
        if (this.propertiesComparator != null) {
            return this.propertiesComparator.isModified();
        }
        return false;
    }

    public boolean hasChildsWithChangeStatus() {
        for (CompareCWDDesigns selob : this.childs) {
            if (!selob.isModified() && this.status == STATE_UNCHANGED) continue;
            return true;
        }
        for (CompareCWDDesigns selob : this.childs) {
            if (!selob.hasChildsWithChangeStatus()) continue;
            return true;
        }
        return false;
    }

    public void resetModifiedStatus() {
        for (CompareCWDDesigns selob : this.childs) {
            selob.resetModifiedStatus();
            if (selob.getStatus() == STATE_UNCHANGED) continue;
            this.setStatus(STATE_MODIFIED);
        }
        if (this.isModified() || this.hasChildsWithChangeStatus()) {
            this.setStatus(STATE_MODIFIED);
        }
    }

    public JComponent getDependentComponent() {
        return this.dependentComponent;
    }

    public void setDependentComponent(JComponent dependentComponent) {
        this.dependentComponent = dependentComponent;
    }

    @Override
    public void setSelected(boolean selected) {
        boolean old = this.selected;
        super.setSelected(selected);
        if (old != selected && this.updateDependent && this.dependentComponent != null) {
            this.dependentComponent.updateUI();
        }
    }

    public void setSelected(boolean selected, boolean updateDependent) {
        boolean old = this.updateDependent;
        this.updateDependent = updateDependent;
        this.setSelected(selected);
        this.updateDependent = old;
    }

    private DesignObject getCorrespondingObject(ContainedObject[] elements, DesignObject object) {
        for (int i = 0; i < elements.length; ++i) {
            ContainedObject obj = elements[i];
            if (obj.getImportedId() != null && obj.getImportedId().equals(object.getObjectID())) {
                return obj;
            }
            if (obj.getObjectID().equals(object.getObjectID())) {
                return obj;
            }
            if (((DesignObject)obj).getName().equals(object.getName())) {
                return obj;
            }
            if (!(obj instanceof Attribute) || !(object instanceof Attribute)) continue;
            Attribute targetAttribute = (Attribute)obj;
            Attribute sourceAttribute = (Attribute)object;
            if (targetAttribute.getIndex() != ((Attribute)object).getIndex() || !targetAttribute.getDataType().toString().equals(sourceAttribute.getDataType().toString()) || sourceAttribute.getContainer().getElementByName(targetAttribute.getName()) != null) continue;
            return targetAttribute;
        }
        CompareMapping compareMapping = this.designHandler.getSourceDesign().getDesignLevelSettings().getCompareMapping();
        if (compareMapping.getCompareMap().containsKey(object.getName())) {
            Entity targetEntity;
            Attribute sourceAttribute = (Attribute)object;
            Entity sourceEntity = (Entity)sourceAttribute.getContainer();
            CompareMappingObject compObject = compareMapping.getCompareMap().get(object.getName());
            if (compObject != null && compObject.isSelected() && sourceEntity.getName().equals(compObject.getSourceParentName()) && (targetEntity = (Entity)this.designHandler.getTargetLogicalDesign().getEntitySet().getByName(compObject.getTargetParentName())) != null) {
                Attribute targetAttribute = (Attribute)targetEntity.getElementByName(compObject.getTargetObjectName());
                return targetAttribute;
            }
        }
        return null;
    }

    public void applySelectionTo() {
        if (this.getObject() != null) {
            this.getObject().setShouldMerge(this.isSelected());
        }
        int count = this.getNumberOfChildren();
        for (int i = 0; i < count; ++i) {
            CompareCWDDesigns child = (CompareCWDDesigns)this.getChild(i);
            child.applySelectionTo();
        }
    }

    private void addDeletedAttributes(Entity source, CompareCWDDesigns sourceAttributeSel, Entity target, CompareCWDDesigns targetAttributeSel) {
        for (Attribute targetAttribute : target.getElementsCollection()) {
            if (this.objectsMap.containsValue(targetAttribute)) continue;
            CompareCWDDesigns sColsel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(sColsel);
            sColsel.setSelected(false);
            sColsel.setElementDescriptor(Attribute.class);
            CompareCWDDesigns tColSel = new CompareCWDDesigns(targetAttribute);
            tColSel.setElementDescriptor(Attribute.class);
            AttributeComparator comp = new AttributeComparator(null, targetAttribute);
            this.comparatorsMap.put(comp.getID(), comp);
            tColSel.setPropertiesComparator(comp);
            sColsel.setPropertiesComparator(comp);
            sColsel.setStatus(STATE_DELETED);
            tColSel.setStatus(STATE_DELETED);
            tColSel.setCorrespondentNode(sColsel);
            sColsel.setCorrespondentNode(tColSel);
            sourceAttributeSel.addChild(sColsel);
            targetAttributeSel.addChild(tColSel);
        }
    }

    @Override
    public String getName() {
        ModelIDObject object = this.getObject();
        if (object != null) {
            if (this.rname != null) {
                return this.rname;
            }
            if (object instanceof KeyObject && ((KeyObject)object).isPK()) {
                return "(PK) " + object.getName();
            }
            return object.getName();
        }
        if (this.rname != null) {
            return this.rname;
        }
        return super.getName();
    }

    @Override
    public boolean setName(String name) {
        this.rname = name;
        super.setName(name);
        return true;
    }

    public List getDeletedMappings() {
        return this.deletedMappings;
    }

    private void addLogicalSubview(DesignPartViewPlaceHolder sourceSubView, CompareCWDDesigns sSubView, CompareCWDDesigns tSubView) {
        CWDFilteredSelection sView = new CWDFilteredSelection(sourceSubView);
        CWDFilteredSelection tView = null;
        DesignPartView targetDPV = this.getCorrespondingObject(this.designHandler.getTargetLogicalDesign().getLogicalDesignSubviews(), sourceSubView.getDesignPartView());
        if (targetDPV != null) {
            DesignPartViewPlaceHolder targetSubView = (DesignPartViewPlaceHolder)targetDPV.getPlaceHolder();
            tView = new CWDFilteredSelection(targetSubView);
            LogicalSubViewComparator comp = new LogicalSubViewComparator(sourceSubView, targetSubView);
            sView.setPropertiesComparator(comp);
            tView.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sView.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sView);
            this.objectsMap.put(sourceSubView.getDesignPartView().getDPVId(), targetDPV);
        } else {
            tView = new CWDFilteredSelection(NEW_SUBVIEW);
            sView.setStatus(STATE_NEW);
            tView.setStatus(STATE_NEW);
            tView.setElementDescriptor(DesignPartViewPlaceHolder.class);
            this.objectsMap.put(sourceSubView.getDesignPartView().getDPVId(), null);
            LogicalSubViewComparator comp = new LogicalSubViewComparator(sourceSubView, null);
            sView.setPropertiesComparator(comp);
            tView.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sView.setSelected(true);
        }
        tView.setCorrespondentNode(sView);
        sView.setCorrespondentNode(tView);
        sSubView.addChild(sView);
        tSubView.addChild(tView);
        this.addNotes(sourceSubView.getDesignPartView(), sView, targetDPV, tView);
    }

    private void addDeletedLogicalSubviews(CompareCWDDesigns sSubViews, CompareCWDDesigns tSubViews) {
        Iterator it = this.designHandler.getTargetLogicalDesign().getLogicalDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder targetSubView = (DesignPartViewPlaceHolder)it.next();
            if (this.objectsMap.containsValue(targetSubView.getDesignPartView())) continue;
            CompareCWDDesigns tSubView = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(tSubView);
            tSubView.setSelected(false);
            CompareCWDDesigns sSubView = new CompareCWDDesigns(targetSubView);
            sSubView.setElementDescriptor(DesignPartViewPlaceHolder.class);
            LogicalSubViewComparator comp = new LogicalSubViewComparator(null, targetSubView);
            this.comparatorsMap.put(comp.getID(), comp);
            tSubView.setPropertiesComparator(comp);
            sSubView.setPropertiesComparator(comp);
            tSubView.setStatus(STATE_DELETED);
            sSubView.setStatus(STATE_DELETED);
            sSubView.setCorrespondentNode(tSubView);
            tSubView.setCorrespondentNode(sSubView);
            sSubViews.addChild(tSubView);
            tSubViews.addChild(sSubView);
        }
    }

    private void addDistinctType(DistinctType sourceType, CompareCWDDesigns allSDistTypes, CompareCWDDesigns allTDistTypes) {
        CompareCWDDesigns sDistType = new CompareCWDDesigns(sourceType);
        CompareCWDDesigns tDistType = null;
        DistinctType targetType = (DistinctType)this.getCorrespondingObject(this.designHandler.getTargetDataTypesDesign().getDistinctTypeSet(), (DesignObject)sourceType);
        if (targetType != null) {
            tDistType = new CompareCWDDesigns(targetType);
            DistinctTypeComparator comp = new DistinctTypeComparator(sourceType, targetType);
            sDistType.setPropertiesComparator(comp);
            tDistType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sDistType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sDistType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tDistType = new CompareCWDDesigns(NEW_DISTINCT_TYPE);
            sDistType.setStatus(STATE_NEW);
            tDistType.setStatus(STATE_NEW);
            tDistType.setElementDescriptor(DistinctType.class);
            this.objectsMap.put(sourceType.getObjectID(), null);
            DistinctTypeComparator comp = new DistinctTypeComparator(sourceType, targetType);
            sDistType.setPropertiesComparator(comp);
            tDistType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sDistType.setSelected(true);
        }
        tDistType.setCorrespondentNode(sDistType);
        sDistType.setCorrespondentNode(tDistType);
        allSDistTypes.addChild(sDistType);
        allTDistTypes.addChild(tDistType);
    }

    private void addDeletedDistinctTypes(CompareCWDDesigns allSDistTypes, CompareCWDDesigns allTDistTypes) {
        Iterator it = this.designHandler.getTargetDataTypesDesign().getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType targetType = (DistinctType)it.next();
            if (this.objectsMap.containsValue(targetType)) continue;
            CompareCWDDesigns selTargetType = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(selTargetType);
            selTargetType.setSelected(false);
            CompareCWDDesigns selSourceType = new CompareCWDDesigns(targetType);
            selTargetType.setElementDescriptor(DistinctType.class);
            DistinctTypeComparator comp = new DistinctTypeComparator(null, targetType);
            this.comparatorsMap.put(comp.getID(), comp);
            selTargetType.setPropertiesComparator(comp);
            selSourceType.setPropertiesComparator(comp);
            selTargetType.setStatus(STATE_DELETED);
            selSourceType.setStatus(STATE_DELETED);
            selSourceType.setCorrespondentNode(selTargetType);
            selTargetType.setCorrespondentNode(selSourceType);
            allSDistTypes.addChild(selTargetType);
            allTDistTypes.addChild(selSourceType);
        }
    }

    private void addStructuredType(StructuredType sourceType, CompareCWDDesigns allSourceStrTypes, CompareCWDDesigns allTargetStrTypes) {
        CompareCWDDesigns sStrType = new CompareCWDDesigns(sourceType);
        CompareCWDDesigns tStrType = null;
        StructuredType targetType = (StructuredType)this.getCorrespondingObject(this.designHandler.getTargetDataTypesDesign().getStructuredTypeSet(), (DesignObject)sourceType);
        if (targetType != null) {
            tStrType = new CompareCWDDesigns(targetType);
            StructuredTypeComparator comp = new StructuredTypeComparator(sourceType, targetType);
            sStrType.setPropertiesComparator(comp);
            tStrType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sStrType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sStrType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tStrType = new CompareCWDDesigns(NEW_STRUCTURED_TYPE);
            sStrType.setStatus(STATE_NEW);
            tStrType.setStatus(STATE_NEW);
            tStrType.setElementDescriptor(StructuredType.class);
            this.objectsMap.put(sourceType.getObjectID(), null);
            StructuredTypeComparator comp = new StructuredTypeComparator(sourceType, targetType);
            sStrType.setPropertiesComparator(comp);
            tStrType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sStrType.setSelected(true);
        }
        tStrType.setCorrespondentNode(sStrType);
        sStrType.setCorrespondentNode(tStrType);
        this.addStructuredTypeDetails(sourceType, sStrType, targetType, tStrType);
        allSourceStrTypes.addChild(sStrType);
        allTargetStrTypes.addChild(tStrType);
    }

    private void addDeletedStructuredTypes(CompareCWDDesigns allsStrTypes, CompareCWDDesigns alltStrTypes) {
        Iterator it = this.designHandler.getTargetDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType targetType = (StructuredType)it.next();
            if (targetType.getName().equalsIgnoreCase("SDO_GEOMETRY") || this.objectsMap.containsValue(targetType)) continue;
            CompareCWDDesigns tStrType = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(tStrType);
            tStrType.setSelected(false);
            CompareCWDDesigns sStrType = new CompareCWDDesigns(targetType);
            tStrType.setElementDescriptor(StructuredType.class);
            StructuredTypeComparator comp = new StructuredTypeComparator(null, targetType);
            this.comparatorsMap.put(comp.getID(), comp);
            tStrType.setPropertiesComparator(comp);
            sStrType.setPropertiesComparator(comp);
            tStrType.setStatus(STATE_DELETED);
            sStrType.setStatus(STATE_DELETED);
            sStrType.setCorrespondentNode(tStrType);
            tStrType.setCorrespondentNode(sStrType);
            allsStrTypes.addChild(tStrType);
            alltStrTypes.addChild(sStrType);
        }
    }

    private void addStructuredTypeDetails(StructuredType sourceType, CompareCWDDesigns sTypeDesign, StructuredType targetType, CompareCWDDesigns tTypeDesign) {
        CompareCWDDesigns sTypeElems = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Attributes"));
        CompareCWDDesigns tTypeElems = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Attributes"));
        sTypeElems.setCorrespondentNode(tTypeElems);
        tTypeElems.setCorrespondentNode(sTypeElems);
        this.setEmptyComparator(sTypeElems);
        this.setEmptyComparator(tTypeElems);
        tTypeElems.setSelected(false);
        TypeElement[] elems = sourceType.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElement sourceAttribute = elems[i];
            this.addTypeElement(sourceAttribute, targetType, sTypeElems, tTypeElems);
        }
        if (targetType != null) {
            this.addDeletedTypeElements(sTypeElems, targetType, tTypeElems);
        }
        sTypeDesign.addChild(sTypeElems);
        tTypeDesign.addChild(tTypeElems);
        ((StructuredTypeComparator)sTypeDesign.getPropertiesComparator()).presetTypeElemsOrder();
        CompareCWDDesigns sourceMethods = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Methods"));
        CompareCWDDesigns targetMethods = new CompareCWDDesigns(Messages.getString("CompareCWDDesigns.Methods"));
        sourceMethods.setCorrespondentNode(targetMethods);
        targetMethods.setCorrespondentNode(sourceMethods);
        this.setEmptyComparator(sourceMethods);
        this.setEmptyComparator(targetMethods);
        targetMethods.setSelected(false);
        Method[] methods = sourceType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            this.addMethod(method, targetType, sourceMethods, targetMethods);
        }
        if (targetType != null) {
            this.addDeletedMethods(sourceMethods, targetType, targetMethods);
        }
        sTypeDesign.addChild(sourceMethods);
        tTypeDesign.addChild(targetMethods);
    }

    private void addTypeElement(TypeElement sourceElem, StructuredType targetType, CompareCWDDesigns sTypeElement, CompareCWDDesigns tTypeElement) {
        TypeElementComparator comp;
        TypeElementSelection sElemType = new TypeElementSelection(sourceElem);
        ModelIdObjectSelection tElemType = null;
        TypeElement targetElem = null;
        if (targetType != null && (targetElem = (TypeElement)this.getCorrespondingObject(targetType.getTypeElementSet(), sourceElem, true)) != null) {
            tElemType = new CompareCWDDesigns(targetElem);
            comp = new TypeElementComparator(sourceElem, targetElem);
            sElemType.setPropertiesComparator(comp);
            ((CompareCWDDesigns)tElemType).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            ((CompareCWDDesigns)sElemType).setSelected(comp.isModified());
            sElemType.setEditable(comp.isModified());
            this.objectsMap.put(sourceElem.getObjectID(), targetElem);
        }
        if (targetElem == null) {
            ((CompareCWDDesigns)sElemType).setSelected(true);
            tElemType = new CompareCWDDesigns(NEW_ATTRIBUTE);
            ((CompareCWDDesigns)tElemType).setStatus(STATE_NEW);
            sElemType.setStatus(STATE_NEW);
            comp = new TypeElementComparator(sourceElem, null);
            sElemType.setPropertiesComparator(comp);
            ((CompareCWDDesigns)tElemType).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceElem.getObjectID(), null);
        }
        tElemType.setElementDescriptor(TypeElement.class);
        sElemType.setCorrespondentNode((CompareCWDDesigns)tElemType);
        ((CompareCWDDesigns)tElemType).setCorrespondentNode(sElemType);
        sTypeElement.addChild(sElemType);
        tTypeElement.addChild(tElemType);
    }

    private void addDeletedTypeElements(CompareCWDDesigns sElemSelected, StructuredType targetType, CompareCWDDesigns tElemSelected) {
        TypeElement[] elems = targetType.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElement targetElem = elems[i];
            if (this.objectsMap.containsValue(targetElem)) continue;
            CompareCWDDesigns sElemSel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(sElemSel);
            sElemSel.setSelected(false);
            sElemSel.setElementDescriptor(TypeElement.class);
            CompareCWDDesigns tElemSel = new CompareCWDDesigns(targetElem);
            tElemSel.setElementDescriptor(TypeElement.class);
            TypeElementComparator comp = new TypeElementComparator(null, targetElem);
            this.comparatorsMap.put(comp.getID(), comp);
            tElemSel.setPropertiesComparator(comp);
            sElemSel.setPropertiesComparator(comp);
            sElemSel.setStatus(STATE_DELETED);
            tElemSel.setStatus(STATE_DELETED);
            tElemSel.setCorrespondentNode(sElemSel);
            sElemSel.setCorrespondentNode(tElemSel);
            sElemSelected.addChild(sElemSel);
            tElemSelected.addChild(tElemSel);
        }
    }

    private void addMethod(Method sourceMethod, StructuredType targetType, CompareCWDDesigns sMethodType, CompareCWDDesigns tMethodType) {
        MethodComparator comp;
        CompareCWDDesigns sMethodTab = new CompareCWDDesigns(sourceMethod);
        CompareCWDDesigns tMethodTab = null;
        Method targetMethod = null;
        if (targetType != null && (targetMethod = this.getCorrespondingObject(targetType.getMethodsList(), sourceMethod)) != null) {
            tMethodTab = new CompareCWDDesigns(targetMethod);
            comp = new MethodComparator(sourceMethod, targetMethod);
            sMethodTab.setPropertiesComparator(comp);
            tMethodTab.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sMethodTab.setSelected(comp.isModified());
            sMethodTab.setEditable(comp.isModified());
            comp.setLeftSelectionObject(sMethodTab);
            this.objectsMap.put(sourceMethod.getObjectID(), targetMethod);
        }
        if (targetMethod == null) {
            sMethodTab.setSelected(true);
            tMethodTab = new CompareCWDDesigns(NEW_METHOD);
            tMethodTab.setStatus(STATE_NEW);
            sMethodTab.setStatus(STATE_NEW);
            tMethodTab.setElementDescriptor(Method.class);
            comp = new MethodComparator(sourceMethod, targetMethod);
            sMethodTab.setPropertiesComparator(comp);
            tMethodTab.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceMethod.getObjectID(), null);
        }
        sMethodTab.setCorrespondentNode(tMethodTab);
        tMethodTab.setCorrespondentNode(sMethodTab);
        sMethodType.addChild(sMethodTab);
        tMethodType.addChild(tMethodTab);
    }

    private void addDeletedMethods(CompareCWDDesigns sMethodSelected, StructuredType targetType, CompareCWDDesigns tMethodSelected) {
        Method[] methods = targetType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method targetMethod = methods[i];
            if (this.objectsMap.containsValue(targetMethod)) continue;
            CompareCWDDesigns sMethodSel = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(sMethodSel);
            sMethodSel.setSelected(false);
            sMethodSel.setElementDescriptor(Method.class);
            CompareCWDDesigns tMethodSel = new CompareCWDDesigns(targetMethod);
            tMethodSel.setElementDescriptor(Method.class);
            MethodComparator comp = new MethodComparator(null, targetMethod);
            this.comparatorsMap.put(comp.getID(), comp);
            tMethodSel.setPropertiesComparator(comp);
            sMethodSel.setPropertiesComparator(comp);
            sMethodSel.setStatus(STATE_DELETED);
            tMethodSel.setStatus(STATE_DELETED);
            tMethodSel.setCorrespondentNode(sMethodSel);
            sMethodSel.setCorrespondentNode(tMethodSel);
            sMethodSelected.addChild(sMethodSel);
            tMethodSelected.addChild(tMethodSel);
        }
    }

    private void addCollectionType(CollectionType sourceType, CompareCWDDesigns selSourceCollType, CompareCWDDesigns selTargetCollType) {
        CompareCWDDesigns sCollType = new CompareCWDDesigns(sourceType);
        CompareCWDDesigns tCollType = null;
        CollectionType targetType = (CollectionType)this.getCorrespondingObject(this.designHandler.getTargetDataTypesDesign().getCollectionTypeSet(), (DesignObject)sourceType);
        if (targetType != null) {
            tCollType = new CompareCWDDesigns(targetType);
            CollectionTypeComparator comp = new CollectionTypeComparator(sourceType, targetType);
            sCollType.setPropertiesComparator(comp);
            tCollType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sCollType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sCollType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tCollType = new CompareCWDDesigns(NEW_COLLECTION_TYPE);
            sCollType.setStatus(STATE_NEW);
            tCollType.setStatus(STATE_NEW);
            tCollType.setElementDescriptor(CollectionType.class);
            this.objectsMap.put(sourceType.getObjectID(), null);
            CollectionTypeComparator comp = new CollectionTypeComparator(sourceType, targetType);
            sCollType.setPropertiesComparator(comp);
            tCollType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sCollType.setSelected(true);
        }
        tCollType.setCorrespondentNode(sCollType);
        sCollType.setCorrespondentNode(tCollType);
        selSourceCollType.addChild(sCollType);
        selTargetCollType.addChild(tCollType);
    }

    private void addDeletedCollectionTypes(CompareCWDDesigns sCollTypes, CompareCWDDesigns tCollTypes) {
        Iterator it = this.designHandler.getTargetDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType targetType = (CollectionType)it.next();
            if (this.objectsMap.containsValue(targetType)) continue;
            CompareCWDDesigns tCollType = new CompareCWDDesigns(TO_DROP);
            this.deletedMappings.add(tCollType);
            tCollType.setSelected(false);
            CompareCWDDesigns sCollType = new CompareCWDDesigns(targetType);
            tCollType.setElementDescriptor(CollectionType.class);
            CollectionTypeComparator comp = new CollectionTypeComparator(null, targetType);
            this.comparatorsMap.put(comp.getID(), comp);
            tCollType.setPropertiesComparator(comp);
            sCollType.setPropertiesComparator(comp);
            tCollType.setStatus(STATE_DELETED);
            sCollType.setStatus(STATE_DELETED);
            sCollType.setCorrespondentNode(tCollType);
            tCollType.setCorrespondentNode(sCollType);
            sCollTypes.addChild(tCollType);
            tCollTypes.addChild(sCollType);
        }
    }

    private void addFKArcs(Table sTable, CompareCWDDesigns sParentNode, Table tTable, CompareCWDDesigns tParentNode) {
        List slist = sTable.getArcs();
        ArrayList tlist = tTable != null ? tTable.getArcs() : new ArrayList();
        if (slist.size() == 0) {
            return;
        }
        CWDFilteredSelection sArcs = new CWDFilteredSelection(Messages.getString("LogicalDesign.Arcs"));
        CWDFilteredSelection tArcs = new CWDFilteredSelection(Messages.getString("LogicalDesign.Arcs"));
        sArcs.setCorrespondentNode(tArcs);
        tArcs.setCorrespondentNode(sArcs);
        this.setEmptyComparator(sArcs);
        this.setEmptyComparator(tArcs);
        sParentNode.addChild(sArcs);
        tParentNode.addChild(tArcs);
        tArcs.setSelected(false);
        for (FKArc source : slist) {
            FKArcComparator comp;
            CompareCWDDesigns sourceArcsel = new CompareCWDDesigns(source);
            CompareCWDDesigns targetArcsel = null;
            FKArc target = (FKArc)this.getCorrespondingObject(tlist, (DesignObject)source);
            if (target != null) {
                targetArcsel = new CompareCWDDesigns(target);
                comp = new FKArcComparator(source, target, this.objectsMap);
                sourceArcsel.setPropertiesComparator(comp);
                targetArcsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sourceArcsel.setSelected(comp.isModified());
                this.objectsMap.put(source.getObjectID(), target);
            } else {
                targetArcsel = new CompareCWDDesigns(NEW_NOTE);
                sourceArcsel.setStatus(STATE_NEW);
                targetArcsel.setStatus(STATE_NEW);
                targetArcsel.setElementDescriptor(FKArc.class);
                comp = new FKArcComparator(source, target, this.objectsMap);
                sourceArcsel.setPropertiesComparator(comp);
                targetArcsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sourceArcsel.setSelected(true);
            }
            targetArcsel.setCorrespondentNode(sourceArcsel);
            sourceArcsel.setCorrespondentNode(targetArcsel);
            sArcs.addChild(sourceArcsel);
            tArcs.addChild(targetArcsel);
        }
    }

    private void addArcs(Entity sEntity, CompareCWDDesigns sParentNode, Entity tEntity, CompareCWDDesigns tParentNode) {
        List slist = sEntity.getArcs();
        ArrayList tlist = tEntity != null ? tEntity.getArcs() : new ArrayList();
        if (slist.size() == 0) {
            return;
        }
        CWDFilteredSelection sArcs = new CWDFilteredSelection(Messages.getString("LogicalDesign.Arcs"));
        CWDFilteredSelection tArcs = new CWDFilteredSelection(Messages.getString("LogicalDesign.Arcs"));
        sArcs.setCorrespondentNode(tArcs);
        tArcs.setCorrespondentNode(sArcs);
        this.setEmptyComparator(sArcs);
        this.setEmptyComparator(tArcs);
        sParentNode.addChild(sArcs);
        tParentNode.addChild(tArcs);
        tArcs.setSelected(false);
        for (Arc source : slist) {
            ArcComparator comp;
            CompareCWDDesigns sourceArcsel = new CompareCWDDesigns(source);
            CompareCWDDesigns targetArcsel = null;
            Arc target = (Arc)this.getCorrespondingObject(tlist, (DesignObject)source);
            if (target != null) {
                targetArcsel = new CompareCWDDesigns(target);
                comp = new ArcComparator(source, target, this.objectsMap);
                sourceArcsel.setPropertiesComparator(comp);
                targetArcsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sourceArcsel.setSelected(comp.isModified());
                this.objectsMap.put(source.getObjectID(), target);
            } else {
                targetArcsel = new CompareCWDDesigns(NEW_NOTE);
                sourceArcsel.setStatus(STATE_NEW);
                targetArcsel.setStatus(STATE_NEW);
                targetArcsel.setElementDescriptor(Arc.class);
                comp = new ArcComparator(source, target, this.objectsMap);
                sourceArcsel.setPropertiesComparator(comp);
                targetArcsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sourceArcsel.setSelected(true);
            }
            targetArcsel.setCorrespondentNode(sourceArcsel);
            sourceArcsel.setCorrespondentNode(targetArcsel);
            sArcs.addChild(sourceArcsel);
            tArcs.addChild(targetArcsel);
        }
    }
}

