/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.EntityView;

public class EntityViewComparator
extends PropertiesComparator {
    private EntityView source;
    private EntityView target;
    protected static List propertiesFilterList = new ArrayList();

    EntityViewComparator(EntityView source, EntityView target) {
        super(source, target);
        this.source = source;
        this.target = target;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromViewToView();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(STRUCTURED_TYPE);
        if (this.source != null && this.source.getBasedOnStructuredType() != null) {
            ph.setLeftValue(this.source.getBasedOnStructuredType().getName());
        } else {
            ph.setLeftValue("");
        }
        if (this.target != null && this.target.getBasedOnStructuredType() != null) {
            ph.setRightValue(this.target.getBasedOnStructuredType().getName());
        } else {
            ph.setRightValue("");
        }
        if (this.isExcludedFromComparison(STRUCTURED_TYPE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && this.source.getBasedOnStructuredType() != this.target.getBasedOnStructuredType()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(WHERE_PROPERTY);
        ph.setLeftValue(this.source != null ? this.source.getWhere() : "");
        ph.setRightValue(this.target != null ? this.target.getWhere() : "");
        if (this.isExcludedFromComparison(WHERE_PROPERTY)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !this.source.getWhere().equals(this.target.getWhere())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(HAVING_PROPERTY);
        ph.setLeftValue(this.source != null ? this.source.getHaving() : "");
        ph.setRightValue(this.target != null ? this.target.getHaving() : "");
        if (this.isExcludedFromComparison(HAVING_PROPERTY)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !this.source.getHaving().equals(this.target.getHaving())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(USER_DEFINED_DQL);
        ph.setLeftValue(this.source != null ? this.source.getUserDefinedSQL() : "");
        ph.setRightValue(this.target != null ? this.target.getUserDefinedSQL() : "");
        if (this.isExcludedFromComparison(USER_DEFINED_DQL)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !this.source.getUserDefinedSQL().equals(this.target.getUserDefinedSQL())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    private void copyPropertiesFromViewToView() {
        if (this.source != null && this.target != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(STRUCTURED_TYPE)) {
                    this.target.setBasedOnStructuredType(this.source.getBasedOnStructuredType());
                    continue;
                }
                if (ph.getName().equals(WHERE_PROPERTY)) {
                    this.target.setWhere(this.source.getWhere());
                    continue;
                }
                if (ph.getName().equals(HAVING_PROPERTY)) {
                    this.target.setHaving(this.source.getHaving());
                    continue;
                }
                if (!ph.getName().equals(USER_DEFINED_DQL)) continue;
                this.target.setUserDefinedSQL(this.source.getUserDefinedSQL());
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.source != null ? MessageFormat.format(Messages.getString("EntityViewComparator.SourceView"), this.source.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.target != null ? MessageFormat.format(Messages.getString("EntityViewComparator.TargetView"), this.target.getName()) : "";
    }
}

