/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.EmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.FKComparator;
import oracle.dbtools.crest.model.design.compare.IndexComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.DesignHandler;
import oracle.dbtools.crest.model.design.compare.ddl.DDLCollectionTypeComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLColumnSelection;
import oracle.dbtools.crest.model.design.compare.ddl.DDLDistinctTypeComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLFilteredSelection;
import oracle.dbtools.crest.model.design.compare.ddl.DDLIndexComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLMethodComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLStructuredTypeComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLTableComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLTypeElementComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLTypeElementSelection;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.util.compare.CompareMapping;
import oracle.dbtools.crest.util.compare.CompareMappingObject;

public class CompareRelationalModels
extends ModelIdObjectSelection {
    private static final String NEW_ATTRIBUTE = Messages.getString("CompareRelationalModels.NewAttribute");
    private static final String NEW_DISTINCT_TYPE = Messages.getString("CompareRelationalModels.NewDistinctType");
    private static final String NEW_STRUCTURE_TYPE = Messages.getString("CompareRelationalModels.NewStructureType");
    private static final String NEW_METHOD = Messages.getString("CompareRelationalModels.NewMethod");
    private static final String NEW_COLLECTION_TYPE = Messages.getString("CompareRelationalModels.NewCollectionType");
    private PropertiesComparator propertiesComparator;
    private CompareRelationalModels correspondentNode;
    private JComponent dependentComponent;
    private boolean editable = true;
    private Map comparatorsMap = new TreeMap();
    private List deletedMappings = new ArrayList();
    private DesignHandler designHandler;
    private Map objectsMap;
    private CompareRelationalModels rightRoot;
    private List columnsWithChangedDataType = new ArrayList();
    private List pkInd = new ArrayList();
    private List fkInd = new ArrayList();
    private List indexes = new ArrayList();
    private boolean updateDependent = true;

    public CompareRelationalModels(String name) {
        super(name);
    }

    public CompareRelationalModels(ModelIDObject object) {
        super(object);
    }

    public CompareRelationalModels(DesignHandler designHandler) {
        super(designHandler.getSourceName());
        this.objectsMap = new TreeMap();
        this.designHandler = designHandler;
        this.rightRoot = new CompareRelationalModels(designHandler.getTargetName());
        this.setCorrespondentNode(this.rightRoot);
        this.rightRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.rightRoot);
        this.initSourceDesign();
    }

    public void setStatus(int status) {
        if (status == STATE_MODIFIED) {
            if (this.status != STATE_NEW && this.status != STATE_DELETED) {
                this.status = status;
            }
        } else {
            this.status = status;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public CompareRelationalModels getCorrespondentNode() {
        return this.correspondentNode;
    }

    @Override
    public ModelIdObjectSelection getCorrespondentObjectSelection() {
        return this.getCorrespondentNode();
    }

    public void setCorrespondentNode(CompareRelationalModels correspondentNode) {
        this.correspondentNode = correspondentNode;
    }

    public PropertiesComparator getPropertiesComparator() {
        return this.propertiesComparator;
    }

    public void setPropertiesComparator(PropertiesComparator propertiesComparator) {
        this.propertiesComparator = propertiesComparator;
    }

    private void setEmptyComparator(CompareRelationalModels node) {
        node.setPropertiesComparator(new EmptyPropertiesComparator(null, null));
    }

    private void initSourceDesign() {
        DDLFilteredSelection sourceRelModels = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.RelationalModels"));
        DDLFilteredSelection targetRelModels = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.RelationalModels"));
        sourceRelModels.setCorrespondentNode(targetRelModels);
        targetRelModels.setCorrespondentNode(sourceRelModels);
        this.setEmptyComparator(sourceRelModels);
        this.setEmptyComparator(targetRelModels);
        this.addChild(sourceRelModels);
        this.rightRoot.addChild(targetRelModels);
        for (String sourceDesID : this.designHandler.getSourceRelationalModels()) {
            String targetDesID = this.designHandler.getTargetRelationalModelID(sourceDesID);
            RelationalDesign sourceDes = (RelationalDesign)this.designHandler.getSourceDesign().getRelationalDesigns().getById(sourceDesID);
            RelationalDesign targetDes = (RelationalDesign)this.designHandler.getTargetDesign().getRelationalDesigns().getById(targetDesID);
            if (sourceDes == null || targetDes == null) continue;
            this.constructRelationalModels(sourceRelModels, targetRelModels, sourceDes, targetDes);
        }
        for (RelationalDesign sourceDes : this.designHandler.getNewRelationals()) {
            RelationalDesign targetDes = (RelationalDesign)this.designHandler.getTargetDesign().getRelationalDesigns().getByName(sourceDes.getName());
            if (targetDes == null) continue;
            this.constructRelationalModels(sourceRelModels, targetRelModels, sourceDes, targetDes);
        }
        DDLFilteredSelection sDTModel = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.DataTypesModel"));
        DDLFilteredSelection tDTModel = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.DataTypesModel"));
        sDTModel.setCorrespondentNode(tDTModel);
        tDTModel.setCorrespondentNode(sDTModel);
        this.setEmptyComparator(sDTModel);
        this.setEmptyComparator(tDTModel);
        this.addChild(sDTModel);
        this.rightRoot.addChild(tDTModel);
        DDLFilteredSelection sDistType = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.DistinctTypes"));
        DDLFilteredSelection tDistType = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.DistinctTypes"));
        sDistType.setCorrespondentNode(tDistType);
        tDistType.setCorrespondentNode(sDistType);
        this.setEmptyComparator(sDistType);
        this.setEmptyComparator(tDistType);
        sDTModel.addChild(sDistType);
        tDTModel.addChild(tDistType);
        tDistType.setSelected(false);
        DDLFilteredSelection sStrType = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.StructureTypes"));
        DDLFilteredSelection tStrType = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.StructureTypes"));
        sStrType.setCorrespondentNode(tStrType);
        tStrType.setCorrespondentNode(sStrType);
        this.setEmptyComparator(sStrType);
        this.setEmptyComparator(tStrType);
        sDTModel.addChild(sStrType);
        tDTModel.addChild(tStrType);
        tStrType.setSelected(false);
        DDLFilteredSelection sCollType = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.CollectionTypes"));
        DDLFilteredSelection tCollType = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.CollectionTypes"));
        sCollType.setCorrespondentNode(tCollType);
        tCollType.setCorrespondentNode(sCollType);
        this.setEmptyComparator(sCollType);
        this.setEmptyComparator(tCollType);
        sDTModel.addChild(sCollType);
        tDTModel.addChild(tCollType);
        tCollType.setSelected(false);
        Iterator it = this.designHandler.getSourceDataTypesDesign().getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType distType = (DistinctType)it.next();
            this.addDistinctType(distType, sDistType, tDistType);
        }
        this.addDeletedDistinctTypes(sDistType, tDistType);
        it = this.designHandler.getSourceDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType strType = (StructuredType)it.next();
            if (strType.getName().equalsIgnoreCase("SDO_GEOMETRY") || strType.getName().equalsIgnoreCase("XMLTYPE")) continue;
            this.addStructuredType(strType, sStrType, tStrType);
        }
        this.addDeletedStructuredTypes(sStrType, tStrType);
        it = this.designHandler.getSourceDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType collType = (CollectionType)it.next();
            this.addCollectionType(collType, sCollType, tCollType);
        }
        this.addDeletedCollectionTypes(sCollType, tCollType);
    }

    private void constructRelationalModels(DDLFilteredSelection sSelection, DDLFilteredSelection tSelection, RelationalDesign sourceDesign, RelationalDesign targetDesign) {
        DDLFilteredSelection sourceRelModel = new DDLFilteredSelection(sourceDesign.getName());
        DDLFilteredSelection targetRelModel = new DDLFilteredSelection(targetDesign.getName());
        sourceRelModel.setCorrespondentNode(targetRelModel);
        targetRelModel.setCorrespondentNode(sourceRelModel);
        this.setEmptyComparator(sourceRelModel);
        this.setEmptyComparator(targetRelModel);
        sSelection.addChild(sourceRelModel);
        tSelection.addChild(targetRelModel);
        DDLFilteredSelection allSourceTables = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.Tables"));
        DDLFilteredSelection allTargetTables = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.Tables"));
        allSourceTables.setCorrespondentNode(allTargetTables);
        allTargetTables.setCorrespondentNode(allSourceTables);
        this.setEmptyComparator(allTargetTables);
        this.setEmptyComparator(allSourceTables);
        allTargetTables.setSelected(false);
        sourceRelModel.addChild(allSourceTables);
        targetRelModel.addChild(allTargetTables);
        DDLFilteredSelection allSourceTabView = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.Views"));
        DDLFilteredSelection allTargetTabView = new DDLFilteredSelection(Messages.getString("CompareRelationalModels.Views"));
        allSourceTabView.setCorrespondentNode(allTargetTabView);
        allTargetTabView.setCorrespondentNode(allSourceTabView);
        this.setEmptyComparator(allTargetTabView);
        this.setEmptyComparator(allSourceTabView);
        allTargetTabView.setSelected(false);
        sourceRelModel.addChild(allSourceTabView);
        targetRelModel.addChild(allTargetTabView);
        Iterator iter = sourceDesign.getStorageDesign() instanceof StorageDesignOracle ? this.getTables((StorageDesignOracle)sourceDesign.getStorageDesign()).iterator() : sourceDesign.getTableSet().iterator();
        while (iter.hasNext()) {
            Table sourceTable = (Table)iter.next();
            this.addTable(sourceTable, allSourceTables, allTargetTables, sourceDesign, targetDesign);
        }
        this.addDeletedTables(allSourceTables, allTargetTables, targetDesign);
        iter = sourceDesign.getTableViewSet().iterator();
        while (iter.hasNext()) {
            TableView sourceTableView = (TableView)iter.next();
            this.addTableView(sourceTableView, allSourceTabView, allTargetTabView, sourceDesign, targetDesign);
        }
        this.addDeletedTableViews(allSourceTabView, allTargetTabView, targetDesign);
    }

    private void addTableView(TableView sourceTableView, CompareRelationalModels allSourceTableView, CompareRelationalModels allTargetTableView, RelationalDesign sourceDesign, RelationalDesign targetDesign) {
        CompareRelationalModels sTableView = new CompareRelationalModels(sourceTableView);
        TableViewProxy sViewProxy = (TableViewProxy)sourceDesign.getStorageDesign().getTableViewProxySet().getProxy(sourceTableView.getObjectID());
        TableView targetTableView = (TableView)this.getCorrespondingObject(targetDesign.getTableViewSet(), (DesignObject)sourceTableView);
        CompareRelationalModels tTableView = null;
        if (targetTableView != null) {
            tTableView = new CompareRelationalModels(targetTableView);
            TableViewProxy tViewProxy = (TableViewProxy)targetDesign.getStorageDesign().getTableViewProxySet().getProxy(targetTableView.getObjectID());
            TableViewComparator comp = new TableViewComparator(sourceTableView, targetTableView, sViewProxy, tViewProxy);
            sTableView.setPropertiesComparator(comp);
            tTableView.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sTableView.setSelected(comp.isModified());
            this.objectsMap.put(sourceTableView.getObjectID(), targetTableView);
        } else {
            sTableView.setSelected(true);
            tTableView = new CompareRelationalModels(NEW_VIEW);
            TableViewComparator comp = new TableViewComparator(sourceTableView, targetTableView, sViewProxy, null);
            sTableView.setPropertiesComparator(comp);
            tTableView.setPropertiesComparator(comp);
            tTableView.setElementDescriptor(TableView.class);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceTableView.getObjectID(), null);
            sTableView.setStatus(STATE_NEW);
            tTableView.setStatus(STATE_NEW);
        }
        tTableView.setCorrespondentNode(sTableView);
        sTableView.setCorrespondentNode(tTableView);
        allSourceTableView.addChild(sTableView);
        allTargetTableView.addChild(tTableView);
    }

    private void addDeletedTables(CompareRelationalModels allSourceTables, CompareRelationalModels allTargetTables, RelationalDesign targetDesign) {
        Iterator it = targetDesign.getStorageDesign() instanceof StorageDesignOracle ? this.getTables((StorageDesignOracle)targetDesign.getStorageDesign()).iterator() : targetDesign.getTableSet().iterator();
        while (it.hasNext()) {
            Table targetTable = (Table)it.next();
            if (this.objectsMap.containsValue(targetTable)) continue;
            CompareRelationalModels tTableSel = new CompareRelationalModels(TO_DROP);
            this.deletedMappings.add(tTableSel);
            tTableSel.setSelected(false);
            CompareRelationalModels sTableSel = new CompareRelationalModels(targetTable);
            tTableSel.setElementDescriptor(Table.class);
            TableProxy tTableProxy = (TableProxy)targetDesign.getStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
            DDLTableComparator comp = new DDLTableComparator(null, targetTable, null, tTableProxy);
            this.comparatorsMap.put(comp.getID(), comp);
            tTableSel.setPropertiesComparator(comp);
            sTableSel.setPropertiesComparator(comp);
            tTableSel.setStatus(STATE_DELETED);
            sTableSel.setStatus(STATE_DELETED);
            sTableSel.setCorrespondentNode(tTableSel);
            tTableSel.setCorrespondentNode(sTableSel);
            allSourceTables.addChild(tTableSel);
            allTargetTables.addChild(sTableSel);
        }
    }

    private List getTables(StorageDesignOracle storageDesign) {
        ArrayList<DesignObject> list = new ArrayList<DesignObject>();
        Iterator it = storageDesign.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyOracle proxy = (TableProxyOracle)it.next();
            list.add(proxy.getObject());
        }
        return list;
    }

    private void addTable(Table sourceTable, CompareRelationalModels allSourceTables, CompareRelationalModels allTargetTables, RelationalDesign sourceDesign, RelationalDesign targetDesign) {
        CompareRelationalModels sTableSel = new CompareRelationalModels(sourceTable);
        CompareRelationalModels tTableSel = null;
        TableProxy sTableProxy = (TableProxy)sourceDesign.getStorageDesign().getTableProxySet().getProxy(sourceTable.getObjectID());
        Table targetTable = (Table)this.getCorrespondingObject(targetDesign.getTableSet(), (DesignObject)sourceTable);
        if (targetTable != null) {
            tTableSel = new CompareRelationalModels(targetTable);
            TableProxy tTableProxy = (TableProxy)targetDesign.getStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
            DDLTableComparator comp = new DDLTableComparator(sourceTable, targetTable, sTableProxy, tTableProxy);
            sTableSel.setPropertiesComparator(comp);
            tTableSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sTableSel.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sTableSel);
            this.objectsMap.put(sourceTable.getObjectID(), targetTable);
        } else {
            tTableSel = new CompareRelationalModels(NEW_TABLE);
            sTableSel.setStatus(STATE_NEW);
            tTableSel.setStatus(STATE_NEW);
            tTableSel.setElementDescriptor(Table.class);
            this.objectsMap.put(sourceTable.getObjectID(), null);
            DDLTableComparator comp = new DDLTableComparator(sourceTable, targetTable, sTableProxy, null);
            sTableSel.setPropertiesComparator(comp);
            tTableSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sTableSel.setSelected(true);
        }
        tTableSel.setCorrespondentNode(sTableSel);
        sTableSel.setCorrespondentNode(tTableSel);
        this.addTableDetails(sourceTable, sTableSel, targetTable, tTableSel, sourceDesign, targetDesign);
        allSourceTables.addChild(sTableSel);
        allTargetTables.addChild(tTableSel);
    }

    private void addTableDetails(Table sourceTable, CompareRelationalModels sourceTables, Table targetTable, CompareRelationalModels targetTables, RelationalDesign sourceDesign, RelationalDesign targetDesign) {
        CompareRelationalModels sColumnSel = new CompareRelationalModels(Messages.getString("CompareRelationalModels.Columns"));
        CompareRelationalModels tColumnSel = new CompareRelationalModels(Messages.getString("CompareRelationalModels.Columns"));
        sColumnSel.setCorrespondentNode(tColumnSel);
        tColumnSel.setCorrespondentNode(sColumnSel);
        this.setEmptyComparator(sColumnSel);
        this.setEmptyComparator(tColumnSel);
        tColumnSel.setSelected(false);
        for (Column sourceColumn : sourceTable.getElementsCollection()) {
            this.addColumn(sourceColumn, targetTable, sColumnSel, tColumnSel, sourceDesign, targetDesign);
        }
        if (targetTable != null) {
            this.addDeletedColumns(sColumnSel, targetTable, tColumnSel);
            List targetNestedElements = targetTable.getNestedElements();
            if (targetNestedElements.size() > 0) {
                for (ContainedObject sourceNestedColumn : sourceTable.getNestedElements()) {
                    ContainedObject targetNestedColumn = this.getCorrespondingNestedColumn(targetNestedElements, sourceNestedColumn);
                    if (targetNestedColumn == null) continue;
                    this.objectsMap.put(sourceNestedColumn.getObjectID(), targetNestedColumn);
                }
            }
        }
        sourceTables.addChild(sColumnSel);
        targetTables.addChild(tColumnSel);
        ((DDLTableComparator)sourceTables.getPropertiesComparator()).presetColumnsOrder();
        this.initIndexes(sourceTable);
        CompareRelationalModels allSourcePlainSel = new CompareRelationalModels(Messages.getString("CompareRelationalModels.Indexes"));
        CompareRelationalModels allTargetPlainSel = new CompareRelationalModels(Messages.getString("CompareRelationalModels.Indexes"));
        allSourcePlainSel.setCorrespondentNode(allTargetPlainSel);
        allTargetPlainSel.setCorrespondentNode(allSourcePlainSel);
        this.setEmptyComparator(allSourcePlainSel);
        this.setEmptyComparator(allTargetPlainSel);
        allTargetPlainSel.setSelected(false);
        for (Index sourceIndex : this.indexes) {
            this.addIndex(sourceIndex, targetTable, allSourcePlainSel, allTargetPlainSel);
        }
        if (targetTable != null) {
            this.addDeletedIndexes(targetTable, allSourcePlainSel, allTargetPlainSel, false);
        }
        sourceTables.addChild(allSourcePlainSel);
        targetTables.addChild(allTargetPlainSel);
        CompareRelationalModels allSourceIndSel = new CompareRelationalModels(Messages.getString("CompareRelationalModels.PKAndUKConstraints"));
        CompareRelationalModels allTargetIndSel = new CompareRelationalModels(Messages.getString("CompareRelationalModels.PKAndUKConstraints"));
        allSourceIndSel.setCorrespondentNode(allTargetIndSel);
        allTargetIndSel.setCorrespondentNode(allSourceIndSel);
        this.setEmptyComparator(allSourceIndSel);
        this.setEmptyComparator(allTargetIndSel);
        allTargetIndSel.setSelected(false);
        for (Index sourceIndex : this.pkInd) {
            this.addIndex(sourceIndex, targetTable, allSourceIndSel, allTargetIndSel);
        }
        if (targetTable != null) {
            this.addDeletedIndexes(targetTable, allSourceIndSel, allTargetIndSel, true);
        }
        sourceTables.addChild(allSourceIndSel);
        targetTables.addChild(allTargetIndSel);
        CompareRelationalModels allSourceFKsel = new CompareRelationalModels(Messages.getString("CompareRelationalModels.ForeignKeys"));
        CompareRelationalModels allTargetFKsel = new CompareRelationalModels(Messages.getString("CompareRelationalModels.ForeignKeys"));
        allSourceFKsel.setCorrespondentNode(allTargetFKsel);
        allTargetFKsel.setCorrespondentNode(allSourceFKsel);
        this.setEmptyComparator(allSourceFKsel);
        this.setEmptyComparator(allTargetFKsel);
        allTargetFKsel.setSelected(false);
        List<FKIndexAssociation> sourcefkIndexes = Arrays.asList(sourceTable.getFKAssociations());
        for (FKIndexAssociation sourcefk : sourcefkIndexes) {
            this.addFK(sourcefk, allSourceFKsel, allTargetFKsel, targetDesign);
        }
        if (targetTable != null) {
            this.addDeletedFKAssociation(targetTable, allSourceFKsel, allTargetFKsel);
        }
        sourceTables.addChild(allSourceFKsel);
        targetTables.addChild(allTargetFKsel);
    }

    private void addDeletedTableViews(CompareRelationalModels allSourceTableViews, CompareRelationalModels allTargetTableViews, RelationalDesign targetDesign) {
        Iterator it = targetDesign.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView targetTableView = (TableView)it.next();
            if (this.objectsMap.containsValue(targetTableView)) continue;
            CompareRelationalModels tTableView = new CompareRelationalModels(TO_DROP);
            this.deletedMappings.add(tTableView);
            tTableView.setSelected(false);
            CompareRelationalModels sTableView = new CompareRelationalModels(targetTableView);
            tTableView.setElementDescriptor(TableView.class);
            TableViewProxy tViewProxy = (TableViewProxy)targetDesign.getStorageDesign().getProxy(targetTableView.getObjectID());
            TableViewComparator comp = new TableViewComparator(null, targetTableView, null, tViewProxy);
            this.comparatorsMap.put(comp.getID(), comp);
            tTableView.setPropertiesComparator(comp);
            sTableView.setPropertiesComparator(comp);
            tTableView.setStatus(STATE_DELETED);
            sTableView.setStatus(STATE_DELETED);
            sTableView.setCorrespondentNode(tTableView);
            tTableView.setCorrespondentNode(sTableView);
            allSourceTableViews.addChild(tTableView);
            allTargetTableViews.addChild(sTableView);
        }
    }

    private void addDeletedFKAssociation(Table targetTable, CompareRelationalModels allSourceFKsel, CompareRelationalModels allTargetFKsel) {
        for (FKIndexAssociation targetfk : Arrays.asList(targetTable.getFKAssociations())) {
            if (this.objectsMap.containsValue(targetfk)) continue;
            String tfkname = targetfk.getName() + " (" + targetfk.getContainerWithKeyObject().getName() + " : " + targetfk.getRemoteTable().getName() + " )";
            CompareRelationalModels sfksel = new CompareRelationalModels(TO_DROP);
            this.deletedMappings.add(sfksel);
            sfksel.setSelected(false);
            CompareRelationalModels tfksel = new CompareRelationalModels(targetfk);
            tfksel.setElementDescriptor(FKIndexAssociation.class);
            sfksel.setElementDescriptor(FKIndexAssociation.class);
            this.setEmptyComparator(sfksel);
            FKComparator comp = new FKComparator(null, targetfk, false, false, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            tfksel.setPropertiesComparator(comp);
            tfksel.setName(tfkname);
            sfksel.setStatus(STATE_DELETED);
            tfksel.setStatus(STATE_DELETED);
            tfksel.setCorrespondentNode(sfksel);
            sfksel.setCorrespondentNode(tfksel);
            allSourceFKsel.addChild(sfksel);
            allTargetFKsel.addChild(tfksel);
        }
    }

    public DesignObject getCorrespondingObject(DesignObjectSet set, DesignObject object, boolean getByLongName) {
        return set.getByName(object.getName());
    }

    private void addFK(FKIndexAssociation sourcefk, CompareRelationalModels allSourceFKsel, CompareRelationalModels allTargetFKsel, RelationalDesign targetDesign) {
        CompareRelationalModels sfksel = new CompareRelationalModels(sourcefk);
        String sfkname = sourcefk.getName() + " (" + sourcefk.getContainerWithKeyObject().getName() + " : " + sourcefk.getRemoteTable().getName() + " )";
        sfksel.setName(sfkname);
        sfksel.setSelected(true);
        FKIndexAssociation targetfk = (FKIndexAssociation)this.getCorrespondingObject(targetDesign.getFKIndexAssociationSet(), sourcefk, true);
        CompareRelationalModels tfksel = null;
        if (targetfk != null) {
            tfksel = new CompareRelationalModels(targetfk);
            Table tTable = targetfk.getRemoteTable();
            if (tTable != null) {
                KeyObject pk = (KeyObject)this.getCorrespondingObject(tTable.getKeySet(), (DesignObject)sourcefk.getKeyObject());
                if (pk == null) {
                    sfksel.setSelected(true);
                    tfksel = new CompareRelationalModels(NEW_RELATION);
                    sfksel.setStatus(STATE_NEW);
                    tfksel.setStatus(STATE_NEW);
                    tfksel.setElementDescriptor(FKIndexAssociation.class);
                    FKComparator comp = new FKComparator(sourcefk, null, false, false, this.objectsMap);
                    sfksel.setPropertiesComparator(comp);
                    tfksel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                    this.objectsMap.put(sourcefk.getObjectID(), null);
                } else {
                    Column[] targetColumns;
                    Column[] sourceColumns;
                    boolean matchingColumns;
                    boolean matchingRemoteKey = false;
                    KeyObject targetPK = targetfk.getKeyObject();
                    if (targetPK != null && targetPK.getObjectID().equals(pk.getObjectID())) {
                        matchingRemoteKey = true;
                    }
                    boolean bl = matchingColumns = (sourceColumns = sourcefk.getColumns()).length == (targetColumns = targetfk.getColumns()).length;
                    if (matchingColumns) {
                        for (int i = 0; i < sourceColumns.length; ++i) {
                            Column mappedTargetCol = (Column)this.objectsMap.get(sourceColumns[i].getObjectID());
                            if (mappedTargetCol != null && mappedTargetCol.getObjectID().equals(targetColumns[i].getObjectID())) continue;
                            matchingColumns = false;
                            break;
                        }
                    }
                    FKComparator comp = new FKComparator(sourcefk, targetfk, matchingRemoteKey, matchingColumns, this.objectsMap);
                    sfksel.setPropertiesComparator(comp);
                    tfksel.setPropertiesComparator(comp);
                    tfksel.setSelected(comp.isModified());
                    sfksel.setSelected(comp.isModified());
                    Table tab1 = (Table)targetfk.getContainerWithKeyObject();
                    Table tab2 = targetfk.getRemoteTable();
                    if (tab1 != null && tab2 != null) {
                        String rname = targetfk.getName() + " (" + tab1.getName() + " : " + tab2.getName() + ")";
                        tfksel.setName(rname);
                    }
                    this.comparatorsMap.put(comp.getID(), comp);
                    sfksel.setSelected(comp.isModified());
                    this.objectsMap.put(sourcefk.getObjectID(), targetfk);
                }
            }
        } else {
            sfksel.setSelected(true);
            tfksel = new CompareRelationalModels(NEW_RELATION);
            sfksel.setStatus(STATE_NEW);
            tfksel.setStatus(STATE_NEW);
            tfksel.setElementDescriptor(FKIndexAssociation.class);
            FKComparator comp = new FKComparator(sourcefk, null, false, false, this.objectsMap);
            sfksel.setPropertiesComparator(comp);
            tfksel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourcefk.getObjectID(), null);
        }
        tfksel.setCorrespondentNode(sfksel);
        sfksel.setCorrespondentNode(tfksel);
        allSourceFKsel.addChild(sfksel);
        allTargetFKsel.addChild(tfksel);
    }

    private void addDeletedIndexes(Table targetTable, CompareRelationalModels allSourceIndexes, CompareRelationalModels allTargetIndexes, boolean isPKorUK) {
        Iterator it = targetTable.getKeySet().iterator();
        while (it.hasNext()) {
            boolean isdeleted;
            Index targetIndex = (Index)it.next();
            boolean bl = isdeleted = isPKorUK == (targetIndex.isPK() || targetIndex.isUnique());
            if (targetIndex.isFK() || !isdeleted || this.objectsMap.containsValue(targetIndex)) continue;
            CompareRelationalModels sIndSel = new CompareRelationalModels(TO_DROP);
            this.deletedMappings.add(sIndSel);
            sIndSel.setSelected(false);
            CompareRelationalModels tIndSel = new CompareRelationalModels(targetIndex);
            sIndSel.setElementDescriptor(Index.class);
            IndexComparator comp = new IndexComparator(null, targetIndex, this.objectsMap, isPKorUK, null, null);
            this.comparatorsMap.put(comp.getID(), comp);
            tIndSel.setPropertiesComparator(comp);
            sIndSel.setPropertiesComparator(comp);
            sIndSel.setStatus(STATE_DELETED);
            tIndSel.setStatus(STATE_DELETED);
            tIndSel.setCorrespondentNode(sIndSel);
            sIndSel.setCorrespondentNode(tIndSel);
            allSourceIndexes.addChild(sIndSel);
            allTargetIndexes.addChild(tIndSel);
        }
    }

    private void addIndex(Index sourceIndex, Table targetTable, CompareRelationalModels allSourceIndexes, CompareRelationalModels allTargetIndexes) {
        DDLIndexComparator comp;
        CompareRelationalModels sIndSel = new CompareRelationalModels(sourceIndex);
        sIndSel.setSelected(true);
        CompareRelationalModels tIndSel = null;
        Index targetIndex = null;
        if (targetTable != null) {
            targetIndex = (Index)this.getCorrespondingObject(targetTable.getKeySet(), (DesignObject)sourceIndex);
            if (targetIndex == null) {
                targetIndex = this.checkForEqualStructure(sourceIndex, targetTable, allSourceIndexes);
            }
            if (targetIndex != null) {
                tIndSel = new CompareRelationalModels(targetIndex);
                comp = new DDLIndexComparator(sourceIndex, targetIndex, this.objectsMap);
                sIndSel.setPropertiesComparator(comp);
                tIndSel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sIndSel.setSelected(comp.isModified());
                sIndSel.setEditable(comp.isModified());
                comp.setLeftSelectionObject(sIndSel);
                this.objectsMap.put(sourceIndex.getObjectID(), targetIndex);
            }
        }
        if (targetIndex == null) {
            sIndSel.setSelected(true);
            tIndSel = new CompareRelationalModels(NEW_INDEX);
            tIndSel.setStatus(STATE_NEW);
            sIndSel.setStatus(STATE_NEW);
            tIndSel.setElementDescriptor(Index.class);
            comp = new DDLIndexComparator(sourceIndex, targetIndex, this.objectsMap);
            sIndSel.setPropertiesComparator(comp);
            tIndSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceIndex.getObjectID(), null);
        }
        sIndSel.setCorrespondentNode(tIndSel);
        tIndSel.setCorrespondentNode(sIndSel);
        allTargetIndexes.addChild(tIndSel);
        allSourceIndexes.addChild(sIndSel);
    }

    private Index checkForEqualStructure(Index sourceIndex, Table targetTable, CompareRelationalModels allsIndsel) {
        block4: {
            Table sourceTable;
            block5: {
                block3: {
                    sourceTable = (Table)sourceIndex.getContainerObject();
                    if (!sourceIndex.isPK()) break block3;
                    Index targetIndex = (Index)targetTable.getPK();
                    if (targetIndex != null && this.checkIndexes(sourceIndex, targetIndex)) {
                        return targetIndex;
                    }
                    break block4;
                }
                if (!sourceIndex.isUnique()) break block5;
                Iterator it = targetTable.getUKeys().iterator();
                while (it.hasNext()) {
                    Index targetIndex = (Index)it.next();
                    if (!this.checkIndexes(sourceIndex, targetIndex) || sourceTable.getUKeys().getByName(targetIndex.getName()) != null) continue;
                    return targetIndex;
                }
                break block4;
            }
            if (sourceIndex.isFK()) break block4;
            Iterator it = targetTable.getIndexes().iterator();
            while (it.hasNext()) {
                Index targetIndex = (Index)((ContainerObjectPlaceHolder)it.next()).getObject();
                if (!this.checkIndexes(sourceIndex, targetIndex) || sourceTable.getIndexes().getByName(targetIndex.getName()) != null) continue;
                return targetIndex;
            }
        }
        return null;
    }

    private boolean checkIndexes(Index sourceIndex, Index targetIndex) {
        ContainedObject[] targetColumns;
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        if (sourceColumns.length != (targetColumns = targetIndex.getElements()).length) {
            return false;
        }
        for (int i = 0; i < sourceColumns.length; ++i) {
            Column scol = (Column)sourceColumns[i];
            Column tcol = (Column)this.objectsMap.get(scol.getObjectID());
            if (tcol == null) {
                return false;
            }
            if (tcol.getName().equals(((Column)targetColumns[i]).getName())) continue;
            return false;
        }
        return true;
    }

    private void initIndexes(Table r_table) {
        this.clearIndexList();
        Iterator it = r_table.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (key.isPK() || key.isUnique()) {
                this.pkInd.add(key);
                continue;
            }
            if (key.isFK()) continue;
            this.indexes.add(key);
        }
    }

    private void clearIndexList() {
        this.pkInd.clear();
        this.fkInd.clear();
        this.indexes.clear();
    }

    private void addDeletedColumns(CompareRelationalModels sourceColumnSel, Table targetTable, CompareRelationalModels targetColumnSel) {
        for (Column targetColumn : targetTable.getElementsCollection()) {
            if (this.objectsMap.containsValue(targetColumn)) continue;
            CompareRelationalModels sColumnSel = new CompareRelationalModels(TO_DROP);
            this.deletedMappings.add(sColumnSel);
            sColumnSel.setSelected(false);
            sColumnSel.setElementDescriptor(Column.class);
            CompareRelationalModels tColumnSel = new CompareRelationalModels(targetColumn);
            tColumnSel.setElementDescriptor(Column.class);
            ColumnComparator comp = new ColumnComparator(null, targetColumn, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            tColumnSel.setPropertiesComparator(comp);
            sColumnSel.setPropertiesComparator(comp);
            sColumnSel.setStatus(STATE_DELETED);
            tColumnSel.setStatus(STATE_DELETED);
            tColumnSel.setCorrespondentNode(sColumnSel);
            sColumnSel.setCorrespondentNode(tColumnSel);
            sourceColumnSel.addChild(sColumnSel);
            targetColumnSel.addChild(tColumnSel);
        }
    }

    private void addColumn(Column sourceColumn, Table targetTable, CompareRelationalModels sourceColumnSel, CompareRelationalModels targetColumnSel, RelationalDesign sourceDesign, RelationalDesign targetDesign) {
        DDLColumnSelection sColumnSel = new DDLColumnSelection(sourceColumn);
        ModelIdObjectSelection tColumnSel = null;
        ColumnProxy sourceColumnProxy = (ColumnProxy)sourceDesign.getStorageDesign().getColumnProxySet().getProxy(sourceColumn.getObjectID());
        Column targetColumn = null;
        if (targetTable != null && (targetColumn = (Column)this.getCorrespondingObject(targetTable.getElements(), (DesignObject)sourceColumn)) != null) {
            tColumnSel = new CompareRelationalModels(targetColumn);
            ColumnProxy targetColumnProxy = (ColumnProxy)targetDesign.getStorageDesign().getColumnProxySet().getProxy(targetColumn.getObjectID());
            ColumnComparator comp = new ColumnComparator(sourceColumn, targetColumn, sourceColumnProxy, targetColumnProxy, this.objectsMap);
            sColumnSel.setPropertiesComparator(comp);
            ((CompareRelationalModels)tColumnSel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            ((CompareRelationalModels)sColumnSel).setSelected(comp.isModified());
            sColumnSel.setEditable(comp.isModified());
            this.objectsMap.put(sourceColumn.getObjectID(), targetColumn);
        }
        if (targetColumn == null) {
            ((CompareRelationalModels)sColumnSel).setSelected(true);
            tColumnSel = new CompareRelationalModels(NEW_COLUMN);
            ((CompareRelationalModels)tColumnSel).setStatus(STATE_NEW);
            sColumnSel.setStatus(STATE_NEW);
            ColumnComparator comp = new ColumnComparator(sourceColumn, targetColumn, sourceColumnProxy, null, this.objectsMap);
            sColumnSel.setPropertiesComparator(comp);
            ((CompareRelationalModels)tColumnSel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceColumn.getObjectID(), null);
        }
        tColumnSel.setElementDescriptor(Column.class);
        sColumnSel.setCorrespondentNode((CompareRelationalModels)tColumnSel);
        ((CompareRelationalModels)tColumnSel).setCorrespondentNode(sColumnSel);
        sourceColumnSel.addChild(sColumnSel);
        targetColumnSel.addChild(tColumnSel);
        if (((ColumnComparator)((CompareRelationalModels)tColumnSel).getPropertiesComparator()).isDataTypeChanged()) {
            this.columnsWithChangedDataType.add(tColumnSel);
        }
    }

    private ContainedObject getCorrespondingNestedColumn(List targetNestedElements, ContainedObject sourceColumn) {
        TypeElement targetStructAtt;
        ContainedObject targetParentColumn;
        ContainedObject sourceParentColumn = sourceColumn.getParentObject();
        if (sourceParentColumn != null && (targetParentColumn = (ContainedObject)this.objectsMap.get(sourceParentColumn.getObjectID())) != null && (targetStructAtt = (TypeElement)this.objectsMap.get(sourceColumn.getStructAttributeID())) != null) {
            String targetStructAttID = targetStructAtt.getObjectID();
            String targetParentColumnID = targetParentColumn.getObjectID();
            for (ContainedObject targetCol : targetNestedElements) {
                ContainedObject parentCol;
                if (!targetCol.getStructAttributeID().equals(targetStructAttID) || (parentCol = targetCol.getParentObject()) == null || !parentCol.getObjectID().equals(targetParentColumnID)) continue;
                return targetCol;
            }
        }
        return null;
    }

    private void addDistinctType(DistinctType sourceType, CompareRelationalModels allSDistTypes, CompareRelationalModels allTDistTypes) {
        CompareRelationalModels sDistType = new CompareRelationalModels(sourceType);
        CompareRelationalModels tDistType = null;
        DistinctType targetType = (DistinctType)this.getCorrespondingObject(this.designHandler.getTargetDataTypesDesign().getDistinctTypeSet(), (DesignObject)sourceType);
        if (targetType != null) {
            tDistType = new CompareRelationalModels(targetType);
            DDLDistinctTypeComparator comp = new DDLDistinctTypeComparator(sourceType, targetType);
            sDistType.setPropertiesComparator(comp);
            tDistType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sDistType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sDistType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tDistType = new CompareRelationalModels(NEW_DISTINCT_TYPE);
            sDistType.setStatus(STATE_NEW);
            tDistType.setStatus(STATE_NEW);
            tDistType.setElementDescriptor(DistinctType.class);
            this.objectsMap.put(sourceType.getObjectID(), null);
            DDLDistinctTypeComparator comp = new DDLDistinctTypeComparator(sourceType, targetType);
            sDistType.setPropertiesComparator(comp);
            tDistType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sDistType.setSelected(true);
        }
        tDistType.setCorrespondentNode(sDistType);
        sDistType.setCorrespondentNode(tDistType);
        allSDistTypes.addChild(sDistType);
        allTDistTypes.addChild(tDistType);
    }

    private void addDeletedDistinctTypes(CompareRelationalModels allSDistTypes, CompareRelationalModels allTDistTypes) {
        Iterator it = this.designHandler.getTargetDataTypesDesign().getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType targetType = (DistinctType)it.next();
            if (this.objectsMap.containsValue(targetType)) continue;
            CompareRelationalModels selTargetType = new CompareRelationalModels(TO_DROP);
            this.deletedMappings.add(selTargetType);
            selTargetType.setSelected(false);
            CompareRelationalModels selSourceType = new CompareRelationalModels(targetType);
            selTargetType.setElementDescriptor(DistinctType.class);
            DDLDistinctTypeComparator comp = new DDLDistinctTypeComparator(null, targetType);
            this.comparatorsMap.put(comp.getID(), comp);
            selTargetType.setPropertiesComparator(comp);
            selSourceType.setPropertiesComparator(comp);
            selTargetType.setStatus(STATE_DELETED);
            selSourceType.setStatus(STATE_DELETED);
            selSourceType.setCorrespondentNode(selTargetType);
            selTargetType.setCorrespondentNode(selSourceType);
            allSDistTypes.addChild(selTargetType);
            allTDistTypes.addChild(selSourceType);
        }
    }

    private void addStructuredType(StructuredType sourceType, CompareRelationalModels allSourceStrTypes, CompareRelationalModels allTargetStrTypes) {
        CompareRelationalModels sStrType = new CompareRelationalModels(sourceType);
        CompareRelationalModels tStrType = null;
        StructuredType targetType = (StructuredType)this.getCorrespondingObject(this.designHandler.getTargetDataTypesDesign().getStructuredTypeSet(), (DesignObject)sourceType);
        if (targetType != null) {
            tStrType = new CompareRelationalModels(targetType);
            DDLStructuredTypeComparator comp = new DDLStructuredTypeComparator(sourceType, targetType);
            sStrType.setPropertiesComparator(comp);
            tStrType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sStrType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sStrType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tStrType = new CompareRelationalModels(NEW_STRUCTURE_TYPE);
            sStrType.setStatus(STATE_NEW);
            tStrType.setStatus(STATE_NEW);
            tStrType.setElementDescriptor(StructuredType.class);
            this.objectsMap.put(sourceType.getObjectID(), null);
            DDLStructuredTypeComparator comp = new DDLStructuredTypeComparator(sourceType, targetType);
            sStrType.setPropertiesComparator(comp);
            tStrType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sStrType.setSelected(true);
        }
        tStrType.setCorrespondentNode(sStrType);
        sStrType.setCorrespondentNode(tStrType);
        this.addStructuredTypeDetails(sourceType, sStrType, targetType, tStrType);
        allSourceStrTypes.addChild(sStrType);
        allTargetStrTypes.addChild(tStrType);
    }

    private void addDeletedStructuredTypes(CompareRelationalModels allsStrTypes, CompareRelationalModels alltStrTypes) {
        Iterator it = this.designHandler.getTargetDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType targetType = (StructuredType)it.next();
            if (targetType.getName().equalsIgnoreCase("SDO_GEOMETRY") || targetType.getName().equalsIgnoreCase("XMLTYPE") || this.objectsMap.containsValue(targetType)) continue;
            CompareRelationalModels tStrType = new CompareRelationalModels(TO_DROP);
            this.deletedMappings.add(tStrType);
            tStrType.setSelected(false);
            CompareRelationalModels sStrType = new CompareRelationalModels(targetType);
            tStrType.setElementDescriptor(StructuredType.class);
            DDLStructuredTypeComparator comp = new DDLStructuredTypeComparator(null, targetType);
            this.comparatorsMap.put(comp.getID(), comp);
            tStrType.setPropertiesComparator(comp);
            sStrType.setPropertiesComparator(comp);
            tStrType.setStatus(STATE_DELETED);
            sStrType.setStatus(STATE_DELETED);
            sStrType.setCorrespondentNode(tStrType);
            tStrType.setCorrespondentNode(sStrType);
            allsStrTypes.addChild(tStrType);
            alltStrTypes.addChild(sStrType);
        }
    }

    private void addStructuredTypeDetails(StructuredType sourceType, CompareRelationalModels sTypeDesign, StructuredType targetType, CompareRelationalModels tTypeDesign) {
        CompareRelationalModels sTypeElems = new CompareRelationalModels(Messages.getString("CompareRelationalModels.Attributes"));
        CompareRelationalModels tTypeElems = new CompareRelationalModels(Messages.getString("CompareRelationalModels.Attributes"));
        sTypeElems.setCorrespondentNode(tTypeElems);
        tTypeElems.setCorrespondentNode(sTypeElems);
        this.setEmptyComparator(sTypeElems);
        this.setEmptyComparator(tTypeElems);
        tTypeElems.setSelected(false);
        TypeElement[] elems = sourceType.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElement sourceAttribute = elems[i];
            this.addTypeElement(sourceAttribute, targetType, sTypeElems, tTypeElems);
        }
        if (targetType != null) {
            this.addDeletedTypeElements(sTypeElems, targetType, tTypeElems);
        }
        sTypeDesign.addChild(sTypeElems);
        tTypeDesign.addChild(tTypeElems);
        ((DDLStructuredTypeComparator)sTypeDesign.getPropertiesComparator()).presetTypeElemsOrder();
        CompareRelationalModels sourceMethods = new CompareRelationalModels(Messages.getString("CompareRelationalModels.Methods"));
        CompareRelationalModels targetMethods = new CompareRelationalModels(Messages.getString("CompareRelationalModels.Methods"));
        sourceMethods.setCorrespondentNode(targetMethods);
        targetMethods.setCorrespondentNode(sourceMethods);
        this.setEmptyComparator(sourceMethods);
        this.setEmptyComparator(targetMethods);
        targetMethods.setSelected(false);
        Method[] methods = sourceType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            this.addMethod(method, targetType, sourceMethods, targetMethods);
        }
        if (targetType != null) {
            this.addDeletedMethods(sourceMethods, targetType, targetMethods);
        }
        sTypeDesign.addChild(sourceMethods);
        tTypeDesign.addChild(targetMethods);
    }

    private void addTypeElement(TypeElement sourceElem, StructuredType targetType, CompareRelationalModels sTypeElement, CompareRelationalModels tTypeElement) {
        DDLTypeElementComparator comp;
        DDLTypeElementSelection sElemType = new DDLTypeElementSelection(sourceElem);
        ModelIdObjectSelection tElemType = null;
        TypeElement targetElem = null;
        if (targetType != null && (targetElem = (TypeElement)this.getCorrespondingObject(targetType.getTypeElementSet(), (DesignObject)sourceElem)) != null) {
            tElemType = new CompareRelationalModels(targetElem);
            comp = new DDLTypeElementComparator(sourceElem, targetElem);
            sElemType.setPropertiesComparator(comp);
            ((CompareRelationalModels)tElemType).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            ((CompareRelationalModels)sElemType).setSelected(comp.isModified());
            sElemType.setEditable(comp.isModified());
            this.objectsMap.put(sourceElem.getObjectID(), targetElem);
        }
        if (targetElem == null) {
            ((CompareRelationalModels)sElemType).setSelected(true);
            tElemType = new CompareRelationalModels(NEW_ATTRIBUTE);
            ((CompareRelationalModels)tElemType).setStatus(STATE_NEW);
            sElemType.setStatus(STATE_NEW);
            comp = new DDLTypeElementComparator(sourceElem, null);
            sElemType.setPropertiesComparator(comp);
            ((CompareRelationalModels)tElemType).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceElem.getObjectID(), null);
        }
        tElemType.setElementDescriptor(TypeElement.class);
        sElemType.setCorrespondentNode((CompareRelationalModels)tElemType);
        ((CompareRelationalModels)tElemType).setCorrespondentNode(sElemType);
        sTypeElement.addChild(sElemType);
        tTypeElement.addChild(tElemType);
    }

    private void addDeletedTypeElements(CompareRelationalModels sElemSelected, StructuredType targetType, CompareRelationalModels tElemSelected) {
        TypeElement[] elems = targetType.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElement targetElem = elems[i];
            if (this.objectsMap.containsValue(targetElem)) continue;
            CompareRelationalModels sElemSel = new CompareRelationalModels(TO_DROP);
            this.deletedMappings.add(sElemSel);
            sElemSel.setSelected(false);
            sElemSel.setElementDescriptor(TypeElement.class);
            CompareRelationalModels tElemSel = new CompareRelationalModels(targetElem);
            tElemSel.setElementDescriptor(TypeElement.class);
            DDLTypeElementComparator comp = new DDLTypeElementComparator(null, targetElem);
            this.comparatorsMap.put(comp.getID(), comp);
            tElemSel.setPropertiesComparator(comp);
            sElemSel.setPropertiesComparator(comp);
            sElemSel.setStatus(STATE_DELETED);
            tElemSel.setStatus(STATE_DELETED);
            tElemSel.setCorrespondentNode(sElemSel);
            sElemSel.setCorrespondentNode(tElemSel);
            sElemSelected.addChild(sElemSel);
            tElemSelected.addChild(tElemSel);
        }
    }

    private void addMethod(Method sourceMethod, StructuredType targetType, CompareRelationalModels sMethodType, CompareRelationalModels tMethodType) {
        DDLMethodComparator comp;
        CompareRelationalModels sMethodTab = new CompareRelationalModels(sourceMethod);
        CompareRelationalModels tMethodTab = null;
        Method targetMethod = null;
        if (targetType != null && (targetMethod = this.getCorrespondingObject(targetType.getMethodsList(), sourceMethod)) != null) {
            tMethodTab = new CompareRelationalModels(targetMethod);
            comp = new DDLMethodComparator(sourceMethod, targetMethod);
            sMethodTab.setPropertiesComparator(comp);
            tMethodTab.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sMethodTab.setSelected(comp.isModified());
            sMethodTab.setEditable(comp.isModified());
            comp.setLeftSelectionObject(sMethodTab);
            this.objectsMap.put(sourceMethod.getObjectID(), targetMethod);
        }
        if (targetMethod == null) {
            sMethodTab.setSelected(true);
            tMethodTab = new CompareRelationalModels(NEW_METHOD);
            tMethodTab.setStatus(STATE_NEW);
            sMethodTab.setStatus(STATE_NEW);
            tMethodTab.setElementDescriptor(Method.class);
            comp = new DDLMethodComparator(sourceMethod, targetMethod);
            sMethodTab.setPropertiesComparator(comp);
            tMethodTab.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceMethod.getObjectID(), null);
        }
        sMethodTab.setCorrespondentNode(tMethodTab);
        tMethodTab.setCorrespondentNode(sMethodTab);
        sMethodType.addChild(sMethodTab);
        tMethodType.addChild(tMethodTab);
    }

    private void addDeletedMethods(CompareRelationalModels sMethodSelected, StructuredType targetType, CompareRelationalModels tMethodSelected) {
        Method[] methods = targetType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method targetMethod = methods[i];
            if (this.objectsMap.containsValue(targetMethod)) continue;
            CompareRelationalModels sMethodSel = new CompareRelationalModels(TO_DROP);
            this.deletedMappings.add(sMethodSel);
            sMethodSel.setSelected(false);
            sMethodSel.setElementDescriptor(Method.class);
            CompareRelationalModels tMethodSel = new CompareRelationalModels(targetMethod);
            tMethodSel.setElementDescriptor(Method.class);
            DDLMethodComparator comp = new DDLMethodComparator(null, targetMethod);
            this.comparatorsMap.put(comp.getID(), comp);
            tMethodSel.setPropertiesComparator(comp);
            sMethodSel.setPropertiesComparator(comp);
            sMethodSel.setStatus(STATE_DELETED);
            tMethodSel.setStatus(STATE_DELETED);
            tMethodSel.setCorrespondentNode(sMethodSel);
            sMethodSel.setCorrespondentNode(tMethodSel);
            sMethodSelected.addChild(sMethodSel);
            tMethodSelected.addChild(tMethodSel);
        }
    }

    private void addCollectionType(CollectionType sourceType, CompareRelationalModels selSourceCollType, CompareRelationalModels selTargetCollType) {
        CompareRelationalModels sCollType = new CompareRelationalModels(sourceType);
        CompareRelationalModels tCollType = null;
        CollectionType targetType = (CollectionType)this.getCorrespondingObject(this.designHandler.getTargetDataTypesDesign().getCollectionTypeSet(), (DesignObject)sourceType);
        if (targetType != null) {
            tCollType = new CompareRelationalModels(targetType);
            DDLCollectionTypeComparator comp = new DDLCollectionTypeComparator(sourceType, targetType);
            sCollType.setPropertiesComparator(comp);
            tCollType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sCollType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sCollType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tCollType = new CompareRelationalModels(NEW_COLLECTION_TYPE);
            sCollType.setStatus(STATE_NEW);
            tCollType.setStatus(STATE_NEW);
            tCollType.setElementDescriptor(CollectionType.class);
            this.objectsMap.put(sourceType.getObjectID(), null);
            DDLCollectionTypeComparator comp = new DDLCollectionTypeComparator(sourceType, targetType);
            sCollType.setPropertiesComparator(comp);
            tCollType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sCollType.setSelected(true);
        }
        tCollType.setCorrespondentNode(sCollType);
        sCollType.setCorrespondentNode(tCollType);
        selSourceCollType.addChild(sCollType);
        selTargetCollType.addChild(tCollType);
    }

    private void addDeletedCollectionTypes(CompareRelationalModels sCollTypes, CompareRelationalModels tCollTypes) {
        Iterator it = this.designHandler.getTargetDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType targetType = (CollectionType)it.next();
            if (this.objectsMap.containsValue(targetType)) continue;
            CompareRelationalModels tCollType = new CompareRelationalModels(TO_DROP);
            this.deletedMappings.add(tCollType);
            tCollType.setSelected(false);
            CompareRelationalModels sCollType = new CompareRelationalModels(targetType);
            tCollType.setElementDescriptor(CollectionType.class);
            DDLCollectionTypeComparator comp = new DDLCollectionTypeComparator(null, targetType);
            this.comparatorsMap.put(comp.getID(), comp);
            tCollType.setPropertiesComparator(comp);
            sCollType.setPropertiesComparator(comp);
            tCollType.setStatus(STATE_DELETED);
            sCollType.setStatus(STATE_DELETED);
            sCollType.setCorrespondentNode(tCollType);
            tCollType.setCorrespondentNode(sCollType);
            sCollTypes.addChild(tCollType);
            tCollTypes.addChild(sCollType);
        }
    }

    public DesignObject getCorrespondingObject(DesignObjectSet set, DesignObject objects) {
        return set.getByName(objects.getName());
    }

    private DesignObject getCorrespondingObject(ContainedObject[] elements, DesignObject object) {
        CompareMapping compareMapping = this.designHandler.getSourceDesign().getDesignLevelSettings().getCompareMapping();
        for (int i = 0; i < elements.length; ++i) {
            ContainedObject obj = elements[i];
            if (obj.getImportedId() != null && obj.getImportedId().equals(object.getObjectID())) {
                return obj;
            }
            if (((DesignObject)obj).getName().equals(object.getName())) {
                return obj;
            }
            if (!(obj instanceof Attribute) || !(object instanceof Attribute)) continue;
            Attribute targetAttribute = (Attribute)obj;
            Attribute sourceAttribute = (Attribute)object;
            if (targetAttribute.getIndex() != ((Attribute)object).getIndex() || !targetAttribute.getDataType().toString().equals(sourceAttribute.getDataType().toString()) || sourceAttribute.getContainer().getElementByName(targetAttribute.getName()) != null) continue;
            return targetAttribute;
        }
        if (compareMapping.getCompareMap().containsKey(object.getName())) {
            Entity targetEntity;
            Attribute sourceAttribute = (Attribute)object;
            Entity sourceEntity = (Entity)sourceAttribute.getContainer();
            CompareMappingObject compObject = compareMapping.getCompareMap().get(object.getName());
            if (compObject != null && compObject.isSelected() && sourceEntity.getName().equals(compObject.getSourceParentName()) && (targetEntity = (Entity)this.designHandler.getTargetLogicalDesign().getEntitySet().getByName(compObject.getTargetParentName())) != null) {
                Attribute targetAttribute = (Attribute)targetEntity.getElementByName(compObject.getTargetObjectName());
                return targetAttribute;
            }
        }
        return null;
    }

    private Method getCorrespondingObject(List targetList, Method sourceObject) {
        String name = sourceObject.getName();
        for (Method obj : targetList) {
            if (!obj.getName().equals(name) || this.objectsMap.containsValue(obj)) continue;
            return obj;
        }
        return null;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    public Map getObjectsMap() {
        return this.objectsMap;
    }

    public CompareRelationalModels getRightRoot() {
        return this.rightRoot;
    }

    public CompareRelationalModels getRoot() {
        return this;
    }

    @Override
    public boolean isModified() {
        if (this.propertiesComparator != null) {
            return this.propertiesComparator.isModified();
        }
        return false;
    }

    public boolean hasChildsWithChangeStatus() {
        for (CompareRelationalModels selectedObj : this.childs) {
            if (!selectedObj.isModified() && this.status == STATE_UNCHANGED) continue;
            return true;
        }
        for (CompareRelationalModels selectedObj : this.childs) {
            if (!selectedObj.hasChildsWithChangeStatus()) continue;
            return true;
        }
        return false;
    }

    public void resetModifiedStatus() {
        for (CompareRelationalModels selectedObj : this.childs) {
            selectedObj.resetModifiedStatus();
            if (selectedObj.getStatus() == STATE_UNCHANGED) continue;
            this.setStatus(STATE_MODIFIED);
        }
        if (this.isModified() || this.hasChildsWithChangeStatus()) {
            this.setStatus(STATE_MODIFIED);
        }
    }

    @Override
    public void setSelected(boolean selected) {
        boolean old = this.selected;
        super.setSelected(selected);
        if (old != selected && this.updateDependent && this.dependentComponent != null) {
            this.dependentComponent.updateUI();
        }
    }

    public void applySelectionTo() {
        if (this.getObject() != null) {
            this.getObject().setShouldMerge(this.isSelected());
        }
        int count = this.getNumberOfChildren();
        for (int i = 0; i < count; ++i) {
            CompareRelationalModels child = (CompareRelationalModels)this.getChild(i);
            child.applySelectionTo();
        }
    }

    public List getDeletedMappings() {
        return this.deletedMappings;
    }
}

