/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.CompareRelationalModels;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public class DDLStructuredTypeComparator
extends PropertiesComparator {
    private StructuredType sourceType;
    private StructuredType targetType;
    private CompareRelationalModels selectionObject;
    private StorageDesign storageDesign;
    protected static List propertiesFilterList = new ArrayList();

    public DDLStructuredTypeComparator(StructuredType source, StructuredType target) {
        super(source, target);
        this.sourceType = source;
        this.targetType = target;
        Design design = source.getDesign();
        this.storageDesign = design.getStorageDesign(source.getSelectedRDBMSSite());
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromStrTypeToStrType();
    }

    private void copyPropertiesFromStrTypeToStrType() {
        if (this.sourceType != null && this.targetType != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
            }
        }
    }

    public void presetTypeElemsOrder() {
        EngPropertyHolder ph = this.getPropertyHolderByName(STRUCTURED_TYPE);
        if (ph != null) {
            if (this.getLeftSelectionObject() != null) {
                ph.setRightValue(this.targetType != null ? this.getElementsToString(this.targetType) : "");
                CompareRelationalModels[] nodes = this.getTypeElemNodes(this.getSelectionObject());
                ph.setLeftValue(this.sourceType != null ? this.getElementsToString(nodes) : "");
                if (!this.equalElementsOrderNew(this.sourceType, this.targetType)) {
                    ph.setSelected(true);
                    ph.setModified(true);
                } else {
                    ph.setSelected(false);
                    ph.setModified(false);
                }
            } else {
                ph.setLeftValue(this.sourceType != null ? this.getElementsToString(this.sourceType) : "");
                ph.setRightValue(this.targetType != null ? this.getElementsToString(this.targetType) : "");
                if (!this.equalElementsOrderNew(this.sourceType, this.targetType)) {
                    ph.setSelected(true);
                    ph.setModified(true);
                }
            }
        }
    }

    private boolean isBeforeUnchangedElement(int index, CompareRelationalModels[] elements) {
        for (int i = index + 1; i < elements.length; ++i) {
            if (elements[i].getStatus() != ModelIdObjectSelection.STATE_UNCHANGED) continue;
            return true;
        }
        return false;
    }

    private boolean equalElementsOrderNew(StructuredType sourseType, StructuredType targetType) {
        if (this.getLeftSelectionObject() != null) {
            CompareRelationalModels[] elemNodes = this.getTypeElemNodes(this.getSelectionObject());
            for (int i = 0; i < elemNodes.length; ++i) {
                CompareRelationalModels eNode = elemNodes[i];
                if (eNode.getStatus() == ModelIdObjectSelection.STATE_NEW && this.isBeforeUnchangedElement(i, elemNodes)) {
                    return false;
                }
                if (eNode.getStatus() != ModelIdObjectSelection.STATE_UNCHANGED && eNode.getStatus() != ModelIdObjectSelection.STATE_MODIFIED) continue;
            }
            return true;
        }
        return this.equalElementsOrder(sourseType, targetType);
    }

    private boolean equalElementsOrder(StructuredType sourseEntity, StructuredType targetEntity) {
        if (sourseEntity == null || targetEntity == null) {
            return true;
        }
        TypeElement[] sourseElems = sourseEntity.getElements();
        TypeElement[] targetElems = targetEntity.getElements();
        for (int i = 0; i < sourseElems.length; ++i) {
            if (i > targetElems.length - 1) {
                return true;
            }
            TypeElement sAttr = sourseElems[i];
            TypeElement tAttr = targetElems[i];
            if (tAttr.getImportedId() != null && sAttr.getObjectID().equals(tAttr.getImportedId()) || tAttr.getName().equals(sAttr.getName()) || tAttr.getDataType().toString().equals(sAttr.getDataType().toString())) continue;
            return false;
        }
        return true;
    }

    private CompareRelationalModels[] getTypeElemNodes(CompareRelationalModels elemNode) {
        ArrayList<CompareRelationalModels> list = new ArrayList<CompareRelationalModels>();
        CompareRelationalModels types = (CompareRelationalModels)elemNode.getChild(0);
        int nod_number = types.getNumberOfChildren();
        for (int i = 0; i < nod_number; ++i) {
            CompareRelationalModels eNode = (CompareRelationalModels)types.getChild(i);
            if (eNode.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!eNode.isSelected() || eNode.getStatus() != ModelIdObjectSelection.STATE_NEW) && eNode.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            list.add(eNode);
        }
        return list.toArray(new CompareRelationalModels[0]);
    }

    private String getElementsToString(StructuredType strType) {
        StringBuffer sb = new StringBuffer();
        Iterator<TypeElement> it = Arrays.asList(strType.getElements()).iterator();
        boolean first = true;
        while (it.hasNext()) {
            TypeElement typeElem = it.next();
            if (first) {
                sb.append(this.storageDesign.getFormatedName(typeElem.getName()));
                first = false;
                continue;
            }
            sb.append("; ").append(this.storageDesign.getFormatedName(typeElem.getName()));
        }
        return sb.toString();
    }

    private String getElementsToString(CompareRelationalModels[] nodes) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < nodes.length; ++i) {
            TypeElement typeElem = (TypeElement)nodes[i].getObject();
            if (first) {
                sb.append(this.storageDesign.getFormatedName(typeElem.getName()));
                first = false;
                continue;
            }
            sb.append("; ").append(this.storageDesign.getFormatedName(typeElem.getName()));
        }
        return sb.toString();
    }

    public CompareRelationalModels getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareRelationalModels selectionObject) {
        this.selectionObject = selectionObject;
    }

    @Override
    public String getLeftName() {
        if (this.sourceType != null && !this.sourceType.getName().equalsIgnoreCase("SDO_GEOMETRY") && !this.sourceType.getName().equalsIgnoreCase("XMLTYPE")) {
            return MessageFormat.format(Messages.getString("DDLStructuredTypeComparator.SourceStructureType"), this.sourceType.getName());
        }
        return "";
    }

    @Override
    public String getRightName() {
        return this.targetType != null ? MessageFormat.format(Messages.getString("DDLStructuredTypeComparator.TargetStructureType"), this.targetType.getName()) : "";
    }
}

