/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;

public abstract class AbstractCSSBOraclev9i
extends AbstractCSSBOracle {
    private DesignObject sType;
    protected StorageDesignOracle storageDesign;

    protected void appendRowDependency(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(tableProxy.getRowDependency())) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "ROWDEPENDENCIES");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOROWDEPENDENCIES");
        }
    }

    protected void appendXMLTypeColumnProps(StringBuffer buffer, ColumnProxyOraclev9i columnProxy, boolean prettyPrint) {
        Column column = columnProxy.getColumn();
        if (column.isReference() && column.getUse() == 3) {
            return;
        }
        AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "XMLTYPE");
        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "COLUMN");
        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "STORE AS");
        if (columnProxy.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "OBJECT RELATIONAL");
        } else {
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "CLOB");
            String lobSegmentName = columnProxy.getLobSegmentName();
            if (lobSegmentName != null && lobSegmentName.length() > 0) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegmentName));
            }
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (columnProxy.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getTablespace()));
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "STORAGE");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (columnProxy.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, columnProxy.getSCInitialExtent());
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (columnProxy.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, columnProxy.getSCNextExtent());
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, columnProxy.getSCPctIncrease());
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, columnProxy.getSCMinExtents());
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, columnProxy.getSCMaxExtents());
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, columnProxy.getSCFreeLists());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && columnProxy.getSCFreelistGroups() > 1) {
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "FREELIST");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, columnProxy.getSCFreelistGroups());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "BUFFER_POOL");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, columnProxy.getSCBufferPool());
                    props = true;
                }
                if (props) {
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ')');
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
            if (columnProxy.getChunk() > 0) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "CHUNK");
                this.appendStringWithSpace(buffer, columnProxy.getChunk());
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            if (columnProxy.getOldVersions().equalsIgnoreCase("RETENTION")) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "RETENTION");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "PCTVERSION");
                this.appendStringWithSpace(buffer, columnProxy.getPCTVersion());
            }
            if (columnProxy.getFreepools() > 0 && columnProxy.getSCFreelistGroups() <= 1) {
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "FREEPOOLS");
                this.appendStringWithSpace(buffer, columnProxy.getFreepools());
            }
            this.appendStorageInRow(buffer, columnProxy.getTableProxy(), columnProxy.getStorageInRow(), prettyPrint);
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, columnProxy.getCache());
            if (!"CACHE".equalsIgnoreCase(columnProxy.getCache()) && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(columnProxy.getLogging())) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(columnProxy.getLogging())) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ')');
        }
        this.appendXMLSchemaSpec(buffer, columnProxy.getXmlSchemaUrl(), columnProxy.getXmlSchemaElement(), prettyPrint);
    }

    protected void appendStorageInRow(StringBuffer buffer, TableProxyOracle tableProxy, String enableDisable, boolean prettyPrint) {
        if ("ENABLE".equalsIgnoreCase(enableDisable)) {
            if (!"INDEX".equals(tableProxy.getOrganization())) {
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "ENABLE");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "STORAGE IN ROW");
            }
        } else {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DISABLE");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "STORAGE IN ROW");
        }
    }

    protected void appendXMLSchemaSpec(StringBuffer buffer, String xmlSchemaUrl, String xmlSchemaElement, boolean prettyPrint) {
        if (xmlSchemaElement != null && xmlSchemaElement.length() > 0) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (xmlSchemaUrl != null && xmlSchemaUrl.length() > 0) {
                buffer.append("XMLSCHEMA").append(' ').append('\"').append(xmlSchemaUrl).append('\"');
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            buffer.append("ELEMENT").append(' ').append('\"').append(xmlSchemaElement).append('\"').append(' ');
        }
    }

    protected void appendVarrayColumnProp(StringBuffer buffer, ColumnProxyOraclev9i columnProxy, boolean prettyPrint) {
        if (this.hasVarrayClause(columnProxy)) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "VARRAY");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, false);
            if (!columnProxy.getLobSegname().equals("")) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "STORE AS");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "LOB");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getLobSegname()));
            }
        }
    }

    protected void appendObjectTypeColProperties(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (table.isBST() && tableProxy != null) {
            boolean first = true;
            Column[] cols = (Column[])table.getElements();
            for (int i = 0; i < cols.length; ++i) {
                Column column = cols[i];
                ColumnProxyOraclev9i columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxy(column.getObjectID());
                if (!this.shouldGenerateObjectPropDefinition(column, columnProxy)) continue;
                if (first) {
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOraclev9i.appendString(buffer, ' ');
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                this.appendColumnOptions(buffer, column, columnProxy, prettyPrint);
                this.appendInlineRefConstraint(buffer, column, columnProxy, prettyPrint);
                CSSBCreateTableOraclev10g.appendColumnConstraints(buffer, column, columnProxy, prettyPrint);
            }
            boolean nestedColNotNullChecksRequired = false;
            for (Column nestedColumn : table.getNestedElements()) {
                if (!nestedColumn.isMandatory()) continue;
                nestedColNotNullChecksRequired = true;
            }
            if (nestedColNotNullChecksRequired) {
                if (first) {
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
                }
                first = this.appendNestedColumnNotNullChecks(buffer, table, tableProxy, prettyPrint, first);
            }
            boolean TableChecksRequired = false;
            Iterator it = tableProxy.getTableCheckConstraints().iterator();
            while (it.hasNext()) {
                TableCheckConstraintOracle constraint = (TableCheckConstraintOracle)it.next();
                if (!constraint.getTableConstraint().isGenerateInDDL()) continue;
                String rule = constraint.getTableConstraint().getRule();
                String cname = constraint.getName().toUpperCase();
                if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                    cname = "";
                }
                if (!"".equals(cname) || "".equals(rule)) continue;
                TableChecksRequired = true;
            }
            if (TableChecksRequired) {
                if (first) {
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
                }
                first = this.appendTableConstraintsDefinition(buffer, tableProxy, prettyPrint, first);
            }
            if (table.getOidPKColumns().size() > 0) {
                if (first) {
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                this.appendPK_ObjectType(buffer, table, tableProxy, prettyPrint);
            }
            if (!first) {
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private boolean shouldGenerateObjectPropDefinition(Column column, ColumnProxyOracle columnProxy) {
        if (column.isOid()) {
            return false;
        }
        if (!column.getNullsAllowed()) {
            return true;
        }
        String defaultValue = columnProxy.getDefaultValue();
        if (defaultValue != null && !"".equalsIgnoreCase(defaultValue)) {
            return true;
        }
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxy.getWithRowId())) {
            return true;
        }
        return SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxy);
    }

    private void appendPK_ObjectType(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        KeyObject pk = table.getPK();
        if (pk != null) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)tableProxy.getStorageDesign();
            ModelIDObject keyObject = storageDesign.getPKProxySet().getProxy(pk.getObjectID());
            if (keyObject == null) {
                keyObject = pk;
            }
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(pk));
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "PRIMARY KEY");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
            boolean first = true;
            for (Column column : table.getOidPKColumns()) {
                ColumnProxyOracle columnProxy = (ColumnProxyOracle)tableProxy.getColumnProxy(column.getObjectID());
                if (first) {
                    first = false;
                } else {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ',');
                }
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(columnProxy));
            }
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendInlineRefConstraint(StringBuffer buffer, Column column, ColumnProxyOraclev9i columnProxy, boolean prettyPrint) {
        this.appendWithRowid(buffer, column, columnProxy, prettyPrint);
    }

    private void appendWithRowid(StringBuffer buffer, Column column, ColumnProxyOraclev9i columnProxy, boolean prettyPrint) {
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxy.getWithRowId())) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "WITH");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "ROWID");
        }
    }

    protected void appendColumnOptions(StringBuffer buffer, Column column, ColumnProxyOraclev9i columnProxy, boolean prettyPrint) {
        this.appendWithDefaultDefinition(buffer, columnProxy);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            AbstractCSSBOraclev9i.appendString(buffer, ' ');
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NULL");
        }
    }

    protected void appendWithDefaultDefinition(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        boolean isSDOpen = columnProxy.getStorageDesign().isOpen();
        String defaultValue = "";
        Column column = columnProxy.getColumn();
        defaultValue = !isSDOpen ? column.getDefaultValue() : columnProxy.getDefaultValue();
        if (defaultValue != null && !"".equalsIgnoreCase(defaultValue)) {
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
            String dt = column.getDatatypeString("Oracle9i");
            String df = this.addQuotesToDefault(dt, defaultValue);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, df);
        }
    }

    protected boolean appendTableConstraintsDefinition(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint, boolean first) {
        if (tableProxy != null) {
            Iterator it = tableProxy.getTableCheckConstraints().iterator();
            while (it.hasNext()) {
                TableCheckConstraintOracle constraint = (TableCheckConstraintOracle)it.next();
                TableLevelConstraint tlc = constraint.getTableConstraint();
                if (!tlc.shouldBeMerge() || !tlc.isGenerateInDDL()) continue;
                String rule = constraint.getTableConstraint().getRule();
                String cname = constraint.getName().toUpperCase();
                if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                    cname = "";
                }
                if (!"".equals(cname) || "".equals(rule)) continue;
                if (first) {
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOraclev9i.appendString(buffer, ' ');
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "CHECK");
                AbstractCSSBOraclev9i.appendString(buffer, '(');
                AbstractCSSBOraclev9i.appendString(buffer, rule);
                AbstractCSSBOraclev9i.appendString(buffer, ')');
                this.appendTableConstraintState(buffer, constraint, prettyPrint);
            }
        }
        return first;
    }

    protected void appendTableConstraintState(StringBuffer buffer, TableCheckConstraintOracle constraint, boolean prettyPrint) {
        if (!"NO".equalsIgnoreCase(constraint.getDeferrable())) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(constraint.getInitially())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOT");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if ("YES".equalsIgnoreCase(constraint.getEnable())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "ENABLE");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(constraint.getValidate())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if ("NO".equalsIgnoreCase(constraint.getEnable())) {
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(constraint.getValidate())) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if ("NO".equalsIgnoreCase(constraint.getValidate())) {
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (constraint.getExceptionsTable() != null) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "EXCEPTIONS");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "INTO");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(constraint.getExceptionsTable()));
        }
    }

    protected void appendNotNullDefinition(StringBuffer buffer, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        String nncName = null;
        if (!columnProxy.getAppView().getSettings().notNullShortFormGeneration()) {
            String string = nncName = columnProxy.isNotNullConstraintNameChanged() ? columnProxy.getNncName() : columnProxy.getColumn().getNotNullConstraintName();
        }
        if (!"NO".equalsIgnoreCase(columnProxy.getNncDeferrable()) || !"YES".equalsIgnoreCase(columnProxy.getNncEnable()) || !"YES".equalsIgnoreCase(columnProxy.getNncValidate()) || nncName != null && !"".equals(nncName)) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendString(buffer, ' ');
            if (nncName != null && !"".equals(nncName)) {
                nncName = this.storageDesign.getFormatedName(nncName);
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, nncName);
            }
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOT NULL");
            this.appendNotNullConstraintState(buffer, columnProxy);
        } else {
            AbstractCSSBOraclev9i.appendString(buffer, ' ');
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOT NULL");
        }
    }

    protected boolean appendNestedColumnNotNullChecks(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint, boolean first) {
        for (Column nestedColumn : table.getNestedElements()) {
            String nncName;
            ColumnProxyOraclev9i columnProxy;
            if (!nestedColumn.isMandatory() || (columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxy(nestedColumn.getObjectID())) == null) continue;
            if (first) {
                first = false;
            } else {
                this.appendComma(buffer);
            }
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendString(buffer, ' ');
            String string = nncName = columnProxy.isNotNullConstraintNameChanged() ? columnProxy.getNncName() : nestedColumn.getNotNullConstraintName();
            if (nncName != null && !"".equals(nncName)) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(nncName));
            }
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "CHECK");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "IS");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOT NULL");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ')');
            this.appendNotNullConstraintState(buffer, columnProxy);
        }
        return first;
    }

    private void appendNotNullConstraintState(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        if (!"NO".equalsIgnoreCase(columnProxy.getNncDeferrable())) {
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(columnProxy.getNncInitially())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOT");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "ENABLE");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
    }

    protected void appendNestedTableColumnProp(StringBuffer buffer, ColumnProxyOraclev9i columnProxy, boolean prettyPrint) {
        if (!columnProxy.getNtStorageTable().equals("")) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NESTED");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "TABLE");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, false);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "STORE AS");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, columnProxy.getNtStorageTable());
            if (!columnProxy.getAdditionalNTS().equals("")) {
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, columnProxy.getAdditionalNTS());
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ')');
            }
            if (!columnProxy.getNtReturn().equals("")) {
                AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "RETURN");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "AS");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, columnProxy.getNtReturn());
            }
        }
    }

    protected void appendSubstitutableColumnClause(StringBuffer buffer, ColumnProxyOraclev9i columnProxy, boolean prettyPrint, boolean columnClause) {
        Column column = columnProxy.getColumn();
        Table table = (Table)column.getContainerWithKeyObject();
        if (table.isBST() && !table.isSubstitutable()) {
            return;
        }
        if (!column.isReference()) {
            if (column.isAllowSubtypeSubstitution()) {
                if (columnClause && (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1 || columnProxy.getSubtitutable().equals("ONLY FOR TYPE"))) {
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "COLUMN");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "IS");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "OF");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "TYPE");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "ONLY");
                    if (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1) {
                        StructuredType st = (StructuredType)column.getPermittedSubTypes().get(0);
                        StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                        if (stp != null) {
                            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(stp));
                        } else {
                            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(st));
                        }
                    } else {
                        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, columnProxy.getElementType());
                    }
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ')');
                } else if (columnProxy.getSubtitutable().equals("YES") || columnProxy.getSubtitutable().equals("NO")) {
                    if (columnClause) {
                        AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "COLUMN");
                        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    }
                    if (columnProxy.getSubtitutable().equals("NO")) {
                        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOT");
                    }
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "AT");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "ALL");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "LEVELS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if (columnClause) {
                        AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "COLUMN");
                        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    }
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "AT");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "ALL");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "LEVELS");
                }
            } else {
                if (columnClause) {
                    AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "COLUMN");
                    AbstractCSSBOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                }
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NOT");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "AT");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "ALL");
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "LEVELS");
            }
        }
    }

    private boolean hasVarrayClause(ColumnProxyOraclev9i columnProxy) {
        return !columnProxy.getSubtitutable().equals("") || !columnProxy.getLobSegname().equals("");
    }

    protected void appendRegisterSpatialTable(StringBuffer oldbuffer, Table table, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        AbstractCSSBOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "INSERT");
        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "INTO");
        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "USER_SDO_GEOM_METADATA");
        advancedComment = buffer.toString();
        this.appendSpatialColumnDefinition(buffer, table, spObjects, prettyPrint);
        this.appendFunctionDefinition(buffer, table, spObjects, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    private void appendFunctionDefinition(StringBuffer buffer, Table table, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        if (spObjects.isFunction()) {
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendString(buffer, "VALUES");
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev9i.appendString(buffer, '\'');
            AbstractCSSBOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(table));
            AbstractCSSBOraclev9i.appendString(buffer, '\'');
            AbstractCSSBOraclev9i.appendString(buffer, ',');
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev9i.appendString(buffer, '\'');
            AbstractCSSBOraclev9i.appendString(buffer, spObjects.getFuncExpression());
            AbstractCSSBOraclev9i.appendString(buffer, '\'');
            AbstractCSSBOraclev9i.appendString(buffer, ',');
            AbstractCSSBOraclev9i.appendSpace(buffer);
            this.appendTableDimensional(buffer, spObjects, prettyPrint);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (spObjects.getSystemID() == null || spObjects.getSystemID().trim().equals("")) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NULL");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, spObjects.getSystemID());
            }
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendString(buffer, ')');
        }
    }

    private void appendSpatialColumnDefinition(StringBuffer buffer, Table table, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        if (spObjects.getSpatialColumn() != null) {
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "TABLE_NAME");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "COLUMN_NAME");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "DIMINFO");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "SRID");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ')');
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "VALUES");
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev9i.appendString(buffer, '\'');
            AbstractCSSBOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(table));
            AbstractCSSBOraclev9i.appendString(buffer, '\'');
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev9i.appendString(buffer, '\'');
            Datatype colType = spObjects.getSpatialColumn().getDataType();
            String columnName = this.storageDesign.getFormatedName(spObjects.getSpatialColumn());
            if (colType instanceof StructuredType) {
                if (this.sType == null) {
                    this.sType = table.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
                }
                StructuredType st = (StructuredType)colType;
                for (TypeElement te : st.getAllElements()) {
                    if (te.getType() != this.sType) continue;
                    columnName = columnName.concat(".").concat(this.storageDesign.getFormatedName(te));
                    break;
                }
            }
            AbstractCSSBOraclev9i.appendString(buffer, columnName);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '\'');
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ',');
            this.appendTableDimensional(buffer, spObjects, prettyPrint);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (spObjects.getSystemID() == null || spObjects.getSystemID().trim().equals("")) {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "NULL");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(buffer, spObjects.getSystemID());
            }
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTableDimensional(StringBuffer buffer, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "MDSYS.SDO_DIM_ARRAY");
        AbstractCSSBOraclev9i.appendStringWithSpace(buffer, '(');
        Iterator it = spObjects.getTableDimensions().iterator();
        while (it.hasNext()) {
            SpatialColumnDefObject.TableDimension td = (SpatialColumnDefObject.TableDimension)it.next();
            AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 3);
            AbstractCSSBOraclev9i.appendStringWithSpace(buffer, "MDSYS.SDO_DIM_ELEMENT");
            AbstractCSSBOraclev9i.appendString(buffer, '(');
            AbstractCSSBOraclev9i.appendString(buffer, '\'');
            AbstractCSSBOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(td.getName()));
            AbstractCSSBOraclev9i.appendString(buffer, '\'');
            AbstractCSSBOraclev9i.appendString(buffer, ',');
            AbstractCSSBOraclev9i.appendString(buffer, td.getLowBoundary());
            AbstractCSSBOraclev9i.appendString(buffer, ',');
            AbstractCSSBOraclev9i.appendString(buffer, td.getUpperBoundary());
            AbstractCSSBOraclev9i.appendString(buffer, ',');
            AbstractCSSBOraclev9i.appendString(buffer, td.getTolerance());
            AbstractCSSBOraclev9i.appendString(buffer, ')');
            if (!it.hasNext()) continue;
            AbstractCSSBOraclev9i.appendString(buffer, ',');
        }
        AbstractCSSBOraclev9i.appendNewLine(buffer, prettyPrint, 2);
        AbstractCSSBOraclev9i.appendString(buffer, ')');
    }
}

