/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.AbstractCSSBOraclev9i;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterColumnOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class CSSBAlterColumn
extends AbstractCSSBOraclev9i {
    private Column sourceColumn;
    private Table sourceTable;
    private SSBAutoIncrementColumnOracle ssbAutoIncCol = null;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection obj = (CompareObjectSelection)object;
        CompareObjectSelection tobj = obj.getCorrespondentNode();
        this.sourceColumn = (Column)obj.getObject();
        this.sourceTable = (Table)this.sourceColumn.getContainer();
        if (this.sourceTable != null) {
            Design design = this.sourceTable.getDesign();
            RDBMSSite site = this.sourceTable.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(site, this.sourceTable);
            if (obj.canBeCreate()) {
                this.appendAddColumn(oldbuffer, obj, prettyPrint);
            } else {
                this.appendModifyColumn(oldbuffer, obj, tobj, prettyPrint);
            }
        }
    }

    private void appendModifyColumn(StringBuffer oldbuffer, CompareObjectSelection obj, CompareObjectSelection tobj, boolean prettyPrint) {
        TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(this.sourceTable.getObjectID());
        Map propMap = this.getPropertiesMap(obj);
        if (tableProxy != null && !propMap.isEmpty() && CSSBAlterColumnOraclev10g.isNotSkipColumnFromObjectTable(tableProxy, propMap)) {
            String tableName = this.getTableName(obj);
            Table table = (Table)tableProxy.getObject();
            StringBuffer buffer = new StringBuffer();
            ColumnProxyOraclev9i columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxy(this.sourceColumn.getObjectID());
            Column scolumn = columnProxy.getColumn();
            Column targetColumn = (Column)tobj.getObject();
            if (propMap.containsKey(PropertiesComparator.NAME) && !table.isBST()) {
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                this.appendRenameColumn(oldbuffer, obj, tobj, prettyPrint);
            }
            if (propMap.containsKey(PropertiesComparator.COMMENT_IN_RDBMS) && columnProxy.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOnColumn(oldbuffer, tableName, obj, columnProxy, prettyPrint);
            }
            if (propMap.containsKey(PropertiesComparator.DATA_TYPE) && !table.isBST() || propMap.containsKey(PropertiesComparator.MANDATORY) || propMap.containsKey(PropertiesComparator.NNC_NAME) || propMap.containsKey(PropertiesComparator.DEFAULT_VALUE)) {
                String addvancedComment;
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                if (propMap.get(PropertiesComparator.NNC_NAME) != null && !propMap.containsKey(PropertiesComparator.MANDATORY) && scolumn.isMandatory() && targetColumn.isMandatory()) {
                    String nnc = targetColumn.getNotNullConstraintName();
                    if (nnc != null && !"".equals(nnc)) {
                        CSSBAlterColumn.appendStringWithSpace(buffer, "ALTER");
                        CSSBAlterColumn.appendStringWithSpace(buffer, "TABLE");
                        CSSBAlterColumn.appendStringWithSpace(buffer, tableName);
                        addvancedComment = buffer.toString() + "DROP" + ' ' + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(nnc);
                        CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 1);
                        CSSBAlterColumn.appendStringWithSpace(buffer, "DROP");
                        CSSBAlterColumn.appendStringWithSpace(buffer, "CONSTRAINT");
                        CSSBAlterColumn.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(nnc));
                        this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                        CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 0);
                        this.appendLineFinisher(buffer, prettyPrint);
                        CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                        CDDLFileMaker.incrementAlterTable();
                    } else if (!targetColumn.isPKElement()) {
                        CSSBAlterColumn.appendStringWithSpace(buffer, "ALTER");
                        CSSBAlterColumn.appendStringWithSpace(buffer, "TABLE");
                        CSSBAlterColumn.appendStringWithSpace(buffer, tableName);
                        addvancedComment = buffer.toString() + "MODIFY" + ' ' + this.storageDesign.getFormatedName(columnProxy);
                        CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 1);
                        CSSBAlterColumn.appendStringWithSpace(buffer, "MODIFY");
                        CSSBAlterColumn.appendStringWithSpace(buffer, '(');
                        CSSBAlterColumn.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                        CSSBAlterColumn.appendStringWithSpace(buffer, "NULL");
                        CSSBAlterColumn.appendStringWithSpace(buffer, ')');
                        this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                        CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 0);
                        this.appendLineFinisher(buffer, prettyPrint);
                        CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                        CDDLFileMaker.incrementAlterTable();
                    }
                }
                CSSBAlterColumn.appendStringWithSpace(buffer, "ALTER");
                CSSBAlterColumn.appendStringWithSpace(buffer, "TABLE");
                CSSBAlterColumn.appendStringWithSpace(buffer, tableName);
                addvancedComment = buffer.toString() + "MODIFY" + ' ' + this.storageDesign.getFormatedName(columnProxy);
                CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterColumn.appendStringWithSpace(buffer, "MODIFY");
                CSSBAlterColumn.appendStringWithSpace(buffer, '(');
                CSSBAlterColumn.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                if (propMap.get(PropertiesComparator.DATA_TYPE) != null && !table.isBST()) {
                    this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.DATA_TYPE));
                }
                if (propMap.get(PropertiesComparator.DEFAULT_VALUE) != null) {
                    this.appendWithDefaultDefinition(buffer, columnProxy);
                }
                if (propMap.get(PropertiesComparator.MANDATORY) != null) {
                    if (!scolumn.getNullsAllowed()) {
                        this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
                    } else {
                        this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.MANDATORY));
                    }
                } else if (propMap.get(PropertiesComparator.NNC_NAME) != null) {
                    if (scolumn.isMandatory()) {
                        this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
                    } else {
                        this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.MANDATORY));
                    }
                }
                CSSBAlterColumn.appendStringWithSpace(buffer, ')');
                this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                CDDLFileMaker.incrementAlterTable();
            }
            this.appendColumnConstraint(oldbuffer, this.sourceColumn, targetColumn, tableName, columnProxy, obj, prettyPrint);
        }
    }

    private void appendCommentOnColumn(StringBuffer oldbuffer, String formattedTableName, CompareObjectSelection columnObj, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        String commentOn = columnProxy.isCommentInRDBMSChanged() ? columnProxy.getCommentInRDBMS() : columnObj.getChoosedPropertyValue(PropertiesComparator.COMMENT_IN_RDBMS);
        if (commentOn.trim().length() > 0) {
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 0);
            CSSBAlterColumn.appendStringWithSpace(buffer, "COMMENT ON");
            CSSBAlterColumn.appendStringWithSpace(buffer, "COLUMN");
            CSSBAlterColumn.appendStringWithSpace(buffer, formattedTableName + '.' + CSSBAlterColumn.getFormattedSelectedName(columnObj, this.storageDesign));
            String advancedComment = buffer.toString();
            CSSBAlterColumn.appendStringWithSpace(buffer, "IS");
            CSSBAlterColumn.appendString(buffer, '\'');
            CSSBAlterColumn.appendString(buffer, this.replaceSingleQuote(commentOn));
            CSSBAlterColumn.appendString(buffer, '\'');
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendColumnConstraint(StringBuffer oldbuffer, Column sourceColumn, Column targetColumn, String tableName, ColumnProxyOracle columnProxy, CompareObjectSelection obj, boolean prettyPrint) {
        boolean add = CSSBCreateRenameTableOraclev10g.isApplyColumnConstraint(obj);
        if (add && sourceColumn.isGenerateConstraintInDDL()) {
            if (!"".equals(targetColumn.getConstraintName())) {
                String constr = this.storageDesign.getFormatedName(targetColumn.getConstraintName());
                StringBuffer buffer = new StringBuffer();
                CSSBAlterColumn.appendStringWithSpace(buffer, "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constr);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                CSSBAlterColumn.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementAlterTable();
            }
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumn.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumn.appendStringWithSpace(buffer, "TABLE");
            CSSBAlterColumn.appendStringWithSpace(buffer, tableName);
            CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumn.appendStringWithSpace(buffer, "ADD ");
            int len = buffer.length();
            CSSBCreateRenameTableOraclev10g.appendColumnConstraints(buffer, sourceColumn, columnProxy, prettyPrint, obj);
            if (len < buffer.length()) {
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                CSSBAlterColumn.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    private Map getPropertiesMap(CompareObjectSelection obj) {
        TreeMap<String, String> propMap = new TreeMap<String, String>();
        for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
            if (!ph.isSelected()) continue;
            if (ph.getName().equals(PropertiesComparator.NAME)) {
                propMap.put(PropertiesComparator.NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.DATA_TYPE)) {
                propMap.put(PropertiesComparator.DATA_TYPE, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.MANDATORY)) {
                if (!Boolean.parseBoolean(ph.getLeftValue())) {
                    propMap.put(PropertiesComparator.MANDATORY, "NULL");
                    continue;
                }
                propMap.put(PropertiesComparator.MANDATORY, "NOT NULL");
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.NNC_NAME)) {
                propMap.put(PropertiesComparator.NNC_NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.DEFAULT_VALUE)) {
                String def = ph.getLeftValue();
                if ("".equals(def.trim())) {
                    propMap.put(PropertiesComparator.DEFAULT_VALUE, "NULL");
                    continue;
                }
                propMap.put(PropertiesComparator.DEFAULT_VALUE, def);
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.COMMENT_IN_RDBMS)) {
                propMap.put(PropertiesComparator.COMMENT_IN_RDBMS, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                propMap.put(EngPropertiesComparator.CHECK_CONSTRAINT_NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.CHECK_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.RANGE_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.RANGE_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (!ph.getName().equals(EngPropertiesComparator.LOV_CONSTRAINT)) continue;
            propMap.put(EngPropertiesComparator.LOV_CONSTRAINT, ph.getLeftValue());
        }
        return propMap;
    }

    private void appendRenameColumn(StringBuffer oldbuffer, CompareObjectSelection sobj, CompareObjectSelection tobj, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBAlterColumn.appendStringWithSpace(buffer, "ALTER");
        CSSBAlterColumn.appendStringWithSpace(buffer, "TABLE");
        CSSBAlterColumn.appendStringWithSpace(buffer, this.getTableName(sobj));
        CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterColumn.appendStringWithSpace(buffer, "RENAME");
        CSSBAlterColumn.appendStringWithSpace(buffer, "COLUMN");
        CSSBAlterColumn.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tobj.getObject()));
        CSSBAlterColumn.appendStringWithSpace(buffer, "TO");
        CSSBAlterColumn.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sobj.getObject()));
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBAlterColumn.appendNewLine(oldbuffer, prettyPrint, 0);
        CDDLFileMaker.incrementAlterTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAddColumn(StringBuffer oldbuffer, CompareObjectSelection object, boolean prettyPrint) {
        Column column = (Column)object.getObject();
        Table table = (Table)column.getContainer();
        TableProxyOraclev9i tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null) {
            RelationalObjectProxy proxy;
            ColumnProxyOraclev9i columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxy(column.getObjectID());
            StringBuffer buffer = new StringBuffer();
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            CSSBAlterColumn.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumn.appendStringWithSpace(buffer, "TABLE");
            String formattedTableName = this.getTableName(object);
            CSSBAlterColumn.appendStringWithSpace(buffer, formattedTableName);
            CSSBAlterColumn.appendStringWithSpace(buffer, "ADD");
            String advancedComment = buffer.toString() + this.storageDesign.getFormatedName(columnProxy);
            CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumn.appendStringWithSpace(buffer, '(');
            CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumn.appendSpace(buffer);
            CSSBAlterColumn.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            String datatypeString = "";
            Datatype datatype = column.getDataType();
            if ((datatype instanceof StructuredType || datatype instanceof CollectionType) && (proxy = this.storageDesign.getProxy(datatype)) != null) {
                datatypeString = this.storageDesign.getFormatedLongNameDDL(proxy);
                if (column.isReference() && datatype instanceof StructuredType) {
                    datatypeString = "REF " + datatypeString;
                }
            }
            if (datatypeString.equals("")) {
                datatypeString = column.getDatatypeString(this.storageDesign.getRDBMSType().getName());
                if ((datatypeString.equals("CHAR") || datatypeString.equals("NCHAR")) && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    datatypeString = datatypeString + " (1)";
                } else if (datatypeString.equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    datatypeString = datatypeString + " (4000)";
                }
            }
            CSSBAlterColumn.appendStringWithSpace(buffer, datatypeString);
            if (tableProxy != null) {
                this.appendColumnOptions(buffer, column, columnProxy, prettyPrint);
                this.appendInlineRefConstraint(buffer, column, columnProxy, prettyPrint);
                CSSBCreateTableOraclev10g.appendColumnConstraints(buffer, column, columnProxy, true, prettyPrint);
            }
            CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumn.appendStringWithSpace(buffer, ')');
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(buffer, columnProxy, prettyPrint);
            } else if (datatype instanceof CollectionType) {
                CollectionType cdatatype = (CollectionType)datatype;
                if (cdatatype.isArrayType()) {
                    this.appendVarrayColumnProp(buffer, columnProxy, prettyPrint);
                } else {
                    this.appendNestedTableColumnProp(buffer, columnProxy, prettyPrint);
                }
            } else if (datatype instanceof StructuredType) {
                this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, true);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            CSSBAlterColumn.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
            if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOnColumn(oldbuffer, formattedTableName, object, columnProxy, prettyPrint);
            }
            if (column.isAutoIncrementColumn()) {
                DDLAdvancedGenerator oldg = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    if (this.ssbAutoIncCol == null) {
                        this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
                    }
                    this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(oldbuffer, column, prettyPrint);
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator(oldg);
                }
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Column;
    }

    public String getTableName(CompareObjectSelection column) {
        CompareObjectSelection table = column.getTableNode();
        if (table != null) {
            return this.getFormattedTableName(table, this.storageDesign);
        }
        return "";
    }
}

