/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBCreateBitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBTriggerOraclev9i;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.AbstractCSSBOraclev9i;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxySetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class CSSBCreateTable
extends AbstractCSSBOraclev9i {
    private CSSBIndex cssbIndex = new CSSBIndex();
    private PKProxyOraclev9i pk = null;
    private CompareObjectSelection tableObj;
    private SSBCreateBitmapJoinIndexOraclev9i ssbBJIndex = null;
    private SSBAutoIncrementColumnOracle ssbAutoIncCol = null;
    private SSBTriggerOraclev9i ssbTriggers = null;

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).canBeCreate() && ((CompareObjectSelection)object).getObject() instanceof Table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Table table = null;
        TableProxyOraclev9i tableProxy = null;
        this.tableObj = (CompareObjectSelection)object;
        if (object == null) {
            return;
        }
        if (!(this.tableObj.getObject() instanceof Table)) {
            return;
        }
        table = (Table)this.tableObj.getObject();
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
        tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (table.getTypeSubstitution() == null) {
            if (tableProxy != null && tableProxy.isCommentChanged()) {
                this.appendComment(oldbuffer, tableProxy);
            } else {
                this.appendComment(oldbuffer, table);
            }
            if (tableProxy != null && tableProxy.getName().length() > tableProxy.getMaxNameLength()) {
                CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateTable.appendStringWithSpace(oldbuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementErrors();
            }
            if (tableProxy != null && tableProxy.getSnapshot() == null) {
                this.appendBeforeCreateScript(oldbuffer, prettyPrint, table);
                CSSBCreateTable.appendStringWithSpace(buffer, "CREATE");
                if ("YES".equalsIgnoreCase(tableProxy.getTemporary())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "GLOBAL");
                    CSSBCreateTable.appendStringWithSpace(buffer, "TEMPORARY");
                    CSSBCreateTable.appendStringWithSpace(buffer, "TABLE");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                    advancedComment = buffer.toString();
                    this.appendElementList(buffer, table, tableProxy, prettyPrint);
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, "ON");
                    CSSBCreateTable.appendStringWithSpace(buffer, "COMMIT");
                    if ("YES".equalsIgnoreCase(tableProxy.getTempPreserveRows())) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "PRESERVE ROWS");
                    } else {
                        CSSBCreateTable.appendStringWithSpace(buffer, "DELETE ROWS");
                    }
                    this.appendOid(buffer, table, null, prettyPrint);
                    if ("YES".equalsIgnoreCase(tableProxy.getCache())) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, "CACHE");
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, "NOCACHE");
                    }
                } else {
                    CSSBCreateTable.appendStringWithSpace(buffer, "TABLE");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                    advancedComment = buffer.toString();
                    this.appendElementList(buffer, table, tableProxy, prettyPrint);
                    this.appendOid(buffer, table, tableProxy, prettyPrint);
                    this.appendCluster(buffer, tableProxy, prettyPrint);
                    this.appendColumnProperties(buffer, table, tableProxy, prettyPrint);
                    this.appendPartitionList(buffer, tableProxy, prettyPrint);
                    if (tableProxy.getCluster() == null && !"INDEX".equals(tableProxy.getOrganization())) {
                        if ("YES".equalsIgnoreCase(tableProxy.getCache())) {
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTable.appendStringWithSpace(buffer, "CACHE");
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTable.appendStringWithSpace(buffer, "NOCACHE");
                        }
                    }
                    if ("YES".equalsIgnoreCase(tableProxy.getMonitoring())) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, "MONITORING");
                    }
                    if ("YES".equalsIgnoreCase(tableProxy.getParallel())) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, "PARALLEL");
                        if (!"".equals(tableProxy.getDegree())) {
                            CSSBCreateTable.appendStringWithSpace(buffer, tableProxy.getDegree());
                        }
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, "NOPARALLEL");
                    }
                }
                this.appendRowDependency(buffer, tableProxy, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementCreateTable();
                this.appendAfterCreateScript(oldbuffer, prettyPrint, table);
            }
            this.appendTableLevelCheckConstraints(oldbuffer, tableProxy, prettyPrint);
            if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendTableCommentOn(oldbuffer, this.tableObj, tableProxy, this.storageDesign, prettyPrint);
            }
            if (tableProxy != null) {
                this.appendIndexes(oldbuffer, tableProxy, this.tableObj, prettyPrint);
                DDLAdvancedGenerator oldg = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    this.appendBitmapJoinIndexes(oldbuffer, tableProxy, prettyPrint);
                    this.appendAutoIncTriggers(oldbuffer, tableProxy, prettyPrint);
                    this.appendTriggers(oldbuffer, tableProxy, prettyPrint);
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator(oldg);
                }
                this.appendPermissions(oldbuffer, tableProxy, prettyPrint);
            }
            CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
            if (table.isSpatialTable()) {
                for (SpatialColumnDefObject spObjects : table.getSpatialDefinitions()) {
                    if (spObjects.getSpatialColumn() == null && !spObjects.isFunction()) continue;
                    this.appendRegisterSpatialTable(oldbuffer, table, spObjects, prettyPrint);
                }
            }
        } else {
            CSSBCreateTable.appendStringWithSpace(oldbuffer, "-- table " + table.getName() + ": is a part of type substitution hierarchy");
            CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
        }
    }

    private void appendColumnProperties(StringBuffer buffer, Table table, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        Column[] cols = (Column[])table.getElements();
        for (int i = 0; i < cols.length; ++i) {
            Column column = cols[i];
            if (!column.shouldBeMerge() && !this.isRenamed()) continue;
            ColumnProxyOraclev9i columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxy(column.getObjectID());
            Datatype datatype = columnProxy.getDataType();
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (datatype instanceof CollectionType) {
                CollectionType cdatatype = (CollectionType)datatype;
                if (cdatatype.isArrayType()) {
                    this.appendVarrayColumnProp(buffer, columnProxy, prettyPrint);
                    continue;
                }
                this.appendNestedTableColumnProp(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (!(datatype instanceof StructuredType)) continue;
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, true);
        }
    }

    private void appendOid(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (table.isRoot()) {
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "OBJECT");
                CSSBCreateTable.appendStringWithSpace(buffer, "IDENTIFIER");
                CSSBCreateTable.appendStringWithSpace(buffer, "IS");
                CSSBCreateTable.appendStringWithSpace(buffer, "PRIMARY KEY");
            }
            if (!(tableProxy == null || tableProxy.getOidIndexSegment() == null && "".equalsIgnoreCase(tableProxy.getOidIndexName()))) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "OIDINDEX");
                if (!"".equalsIgnoreCase(tableProxy.getOidIndexName())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getOidIndexName()));
                }
                if (tableProxy.getOidIndexSegment() != null) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, '(');
                    this.appendSegment(buffer, (SegmentOraclev9i)tableProxy.getOidIndexSegment(), false, prettyPrint, null, "");
                    CSSBCreateTable.appendStringWithSpace(buffer, ')');
                }
            }
        }
    }

    private void appendElementList(StringBuffer buffer, Table table, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        RelationalObjectProxy columnProxy = null;
        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
        if (table.getBasedOnStructuredType() != null) {
            StructuredTypeProxyOracle typeProxy;
            StructuredType type;
            ModelIDObject typeOrProxy = type = table.getBasedOnStructuredType();
            CSSBCreateTable.appendStringWithSpace(buffer, "OF");
            if (tableProxy != null && (typeProxy = (StructuredTypeProxyOracle)tableProxy.getStorageDesign().getProxy(type)) != null) {
                if (typeProxy.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    CSSBCreateTable.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
                    CSSBCreateTable.appendString(buffer, '.');
                }
                typeOrProxy = typeProxy;
            }
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeOrProxy));
            String typeName = ((ModelObject)typeOrProxy).getName();
            if (typeName.equalsIgnoreCase("XMLTYPE")) {
                this.appendObjectTypeColProperties(buffer, table, tableProxy, prettyPrint);
                if (tableProxy != null) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, "XMLTYPE");
                    CSSBCreateTable.appendStringWithSpace(buffer, "STORE AS");
                    if (tableProxy.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "OBJECT RELATIONAL");
                    } else {
                        CSSBCreateTable.appendStringWithSpace(buffer, "CLOB");
                        String lobSegmentName = tableProxy.getLobSegmentName();
                        if (lobSegmentName != null && lobSegmentName.length() > 0) {
                            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegmentName));
                        }
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, '(');
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                        if (tableProxy.getXmlTypeTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                            CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getXmlTypeTableSpace()));
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (tableProxy.getChunk() > 0) {
                            CSSBCreateTable.appendStringWithSpace(buffer, "CHUNK");
                            this.appendStringWithSpace(buffer, tableProxy.getChunk());
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (tableProxy.getOldVersions().equalsIgnoreCase("RETENTION")) {
                            CSSBCreateTable.appendStringWithSpace(buffer, "RETENTION");
                        } else {
                            CSSBCreateTable.appendStringWithSpace(buffer, "PCTVERSION");
                            this.appendStringWithSpace(buffer, tableProxy.getPCTVersion());
                        }
                        if (tableProxy.getFreepools() > 0) {
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateTable.appendStringWithSpace(buffer, "FREEPOOLS");
                            this.appendStringWithSpace(buffer, tableProxy.getFreepools());
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateTable.appendStringWithSpace(buffer, "FREEPOOLS");
                            CSSBCreateTable.appendStringWithSpace(buffer, "1");
                        }
                        this.appendStorageInRow(buffer, tableProxy, tableProxy.getStorageInRow(), prettyPrint);
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTable.appendStringWithSpace(buffer, tableProxy.getXmlTypeCache());
                        if (!"CACHE".equalsIgnoreCase(tableProxy.getXmlTypeCache()) && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                            if ("YES".equalsIgnoreCase(tableProxy.getXmlTypeLogging())) {
                                CSSBCreateTable.appendStringWithSpace(buffer, "LOGGING");
                            } else if ("NO".equalsIgnoreCase(tableProxy.getXmlTypeLogging())) {
                                CSSBCreateTable.appendStringWithSpace(buffer, "NOLOGGING");
                            }
                        }
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, ')');
                    }
                    this.appendXMLSchemaSpec(buffer, tableProxy.getXmlSchemaUrl(), tableProxy.getXmlSchemaElement(), prettyPrint);
                }
            } else {
                if (!table.isSubstitutable()) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, "NOT");
                    CSSBCreateTable.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    CSSBCreateTable.appendStringWithSpace(buffer, "AT");
                    CSSBCreateTable.appendStringWithSpace(buffer, "ALL");
                    CSSBCreateTable.appendStringWithSpace(buffer, "LEVELS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    CSSBCreateTable.appendStringWithSpace(buffer, "AT");
                    CSSBCreateTable.appendStringWithSpace(buffer, "ALL");
                    CSSBCreateTable.appendStringWithSpace(buffer, "LEVELS");
                }
                this.appendObjectTypeColProperties(buffer, table, tableProxy, prettyPrint);
            }
        } else if (columns.length < 1 || this.hasNoMergeColumns(table.getElements())) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "-- No Columns");
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
        } else {
            boolean first = true;
            for (int i = 0; i < columns.length; ++i) {
                RelationalObjectProxy proxy;
                column = columns[i];
                if (!column.shouldBeMerge() && !this.isRenamed() || column.isOid()) continue;
                if (first) {
                    CSSBCreateTable.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateTable.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                if (tableProxy != null) {
                    columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxy(column.getObjectID());
                }
                if (columnProxy.getName().length() > ((ColumnProxyOracle)columnProxy).getMaxNameLength()) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    CSSBCreateTable.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + ((ColumnProxyOracle)columnProxy).getMaxNameLength() + ")");
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    CDDLFileMaker.incrementErrors();
                }
                if (columnProxy.isCommentChanged() && !"".equalsIgnoreCase(columnProxy.getComment())) {
                    this.appendComment(buffer, columnProxy);
                } else if (!"".equalsIgnoreCase(columnProxy.getObject().getComment())) {
                    this.appendComment(buffer, columnProxy.getObject());
                }
                CSSBCreateTable.appendString(buffer, ' ');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                String datatypeString = "";
                Datatype type = column.getDataType();
                if ((type instanceof StructuredType || type instanceof CollectionType) && (proxy = this.storageDesign.getProxy(type)) != null) {
                    datatypeString = this.storageDesign.getFormatedLongNameDDL(proxy);
                    if (column.isReference() && type instanceof StructuredType) {
                        datatypeString = "REF " + datatypeString;
                    }
                }
                if (datatypeString.equals("")) {
                    datatypeString = column.getDatatypeString("Oracle9i");
                    if ((datatypeString.equals("CHAR") || datatypeString.equals("NCHAR")) && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        datatypeString = datatypeString + " (1)";
                    } else if (datatypeString.equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        datatypeString = datatypeString + " (4000)";
                    }
                }
                CSSBCreateTable.appendStringWithSpace(buffer, datatypeString);
                if (datatypeString.equalsIgnoreCase("unknown")) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    CSSBCreateTable.appendStringWithSpace(buffer, "--  ERROR: Datatype UNKNOWN is not allowed");
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 5);
                    CDDLFileMaker.incrementErrors();
                }
                if (tableProxy == null) continue;
                this.appendColumnOptions(buffer, column, (ColumnProxyOraclev9i)columnProxy, prettyPrint);
                this.appendInlineRefConstraint(buffer, column, (ColumnProxyOraclev9i)columnProxy, prettyPrint);
                CSSBCreateTableOraclev10g.appendColumnConstraints(buffer, column, (ColumnProxyOracle)columnProxy, prettyPrint);
            }
            this.appendNestedColumnNotNullChecks(buffer, table, tableProxy, prettyPrint, false);
            if ("INDEX".equalsIgnoreCase(tableProxy.getOrganization())) {
                this.appendPKDefinitionConstraint(buffer, tableProxy, prettyPrint);
            }
            this.appendTableConstraintsDefinition(buffer, tableProxy, prettyPrint, false);
            this.appendSupplementalLoggings(buffer, tableProxy, prettyPrint);
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        }
    }

    private boolean hasNoMergeColumns(ContainedObject[] objects) {
        if (this.isRenamed()) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < objects.length; ++i) {
            Column col = (Column)objects[i];
            if (col.shouldBeMerge()) continue;
            ++count;
        }
        return objects.length == count;
    }

    private PKProxyOraclev9i getPKProxy(TableProxyOraclev9i tableProxy) {
        PKProxySetOraclev9i proxySet = (PKProxySetOraclev9i)((StorageDesignOraclev9i)tableProxy.getStorageDesign()).getPKProxySet();
        if (proxySet != null) {
            Iterator it = proxySet.iterator();
            while (it.hasNext()) {
                PKProxyOraclev9i pkProxy = (PKProxyOraclev9i)it.next();
                if (pkProxy.getTableProxy() != tableProxy) continue;
                return pkProxy;
            }
        }
        return null;
    }

    private void appendPKDefinitionConstraint(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        if (tableProxy != null) {
            this.pk = this.getPKProxy(tableProxy);
            if (this.pk != null) {
                CSSBCreateTable.appendStringWithSpace(buffer, ',');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendString(buffer, ' ');
                CSSBCreateTable.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(this.pk));
                CSSBCreateTable.appendStringWithSpace(buffer, "PRIMARY KEY");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                StringBuffer columnList = this.getColumnsForRestore(this.tableObj, (Index)this.pk.getObject(), prettyPrint, false);
                this.appendStringWithSpace(buffer, columnList);
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                if (!("NO".equalsIgnoreCase(this.pk.getUsingIndex()) || "INDEX".equalsIgnoreCase(tableProxy.getOrganization()) && "BY INDEX NAME".equalsIgnoreCase(this.pk.getUsingIndex()) && this.pk.getExistingIndex() != null)) {
                    this.appendUsingIndex(buffer, this.pk, prettyPrint);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if ("YES".equalsIgnoreCase(this.pk.getEnable())) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "ENABLE");
                    } else {
                        CSSBCreateTable.appendStringWithSpace(buffer, "DISABLE");
                    }
                    if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "VALIDATE");
                    } else {
                        CSSBCreateTable.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                } else {
                    if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "DISABLE");
                        if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                            CSSBCreateTable.appendStringWithSpace(buffer, "VALIDATE");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                }
            }
        }
    }

    private void appendSupplementalLoggings(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        if (tableProxy != null && !"".equalsIgnoreCase(tableProxy.getSuplementalLogGroupName())) {
            this.appendComma(buffer);
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "SUPPLEMENTAL");
            CSSBCreateTable.appendStringWithSpace(buffer, "LOG");
            CSSBCreateTable.appendStringWithSpace(buffer, "GROUP");
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getSuplementalLogGroupName()));
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getSuplementalLogColumns()));
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
            if (tableProxy.getSuplementalLogConditions().equalsIgnoreCase("ALWAYS")) {
                CSSBCreateTable.appendStringWithSpace(buffer, "ALWAYS");
            }
        }
    }

    private void appendUsingIndex(StringBuffer buffer, PKProxyOraclev9i pkProxy, boolean prettyPrint) {
        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateTable.appendStringWithSpace(buffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(pkProxy.getUsingIndex()) && pkProxy.getExistingIndex() != null) {
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pkProxy.getExistingIndex()));
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pkProxy.getUsingIndex())) {
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            CSSBCreateTable.appendStringWithSpace(buffer, pkProxy.getCreateIndexStatement());
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        } else {
            TableProxyOracle tableProxy = (TableProxyOracle)pkProxy.getTableProxy();
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL PARTITIONED".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "LOCAL");
                } else if ("GLOBAL PARTITIONED".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    this.appendGlobalIndex(buffer, pkProxy, prettyPrint);
                }
                if (pkProxy.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev9i)pkProxy.getIndexSegment(), false, prettyPrint, pkProxy.getTableSpace(), pkProxy.getLogging());
                } else {
                    if (pkProxy.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkProxy.getTableSpace()));
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBCreateTable.appendStringWithSpace(buffer, "LOGGING");
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBCreateTable.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (pkProxy.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBCreateTable.appendStringWithSpace(buffer, "NOSORT");
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            } else if (pkProxy.getIndexSort().equalsIgnoreCase("REVERSE")) {
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "SORT");
                }
                CSSBCreateTable.appendStringWithSpace(buffer, "REVERSE");
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTable.appendStringWithSpace(buffer, "SORT");
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            }
            if (pkProxy.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBCreateTable.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer buffer, UniqueOraclev9i unique, boolean prettyPrint) {
        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateTable.appendStringWithSpace(buffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(unique.getUsingIndex()) && unique.getExistingIndex() != null) {
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExistingIndex()));
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(unique.getUsingIndex())) {
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            CSSBCreateTable.appendStringWithSpace(buffer, unique.getCreateIndexStatement());
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        } else {
            TableProxyOracle tableProxy = (TableProxyOracle)unique.getTableProxy();
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL PARTITIONED".equalsIgnoreCase(unique.getUsingIndex())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "LOCAL");
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL PARTITIONED")) {
                    this.appendUniqueGlobalIndex(buffer, unique, prettyPrint);
                }
                if (unique.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev9i)unique.getIndexSegment(), false, prettyPrint, unique.getTableSpace(), unique.getLogging());
                } else {
                    if (unique.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique.getTableSpace()));
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(unique.getLogging())) {
                            CSSBCreateTable.appendStringWithSpace(buffer, "LOGGING");
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(unique.getLogging())) {
                            CSSBCreateTable.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (unique.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBCreateTable.appendStringWithSpace(buffer, "NOSORT");
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            } else if (unique.getIndexSort().equalsIgnoreCase("REVERSE")) {
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "SORT");
                }
                CSSBCreateTable.appendStringWithSpace(buffer, "REVERSE");
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTable.appendStringWithSpace(buffer, "SORT");
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            }
            if (unique.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBCreateTable.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer buffer, UniqueOraclev9i unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateTable.appendStringWithSpace(buffer, "BY");
            CSSBCreateTable.appendStringWithSpace(buffer, "RANGE");
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, (IndexGlobalPartitionsListOraclev9i)unique.getUsingIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalIndex(StringBuffer buffer, PKProxyOraclev9i pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateTable.appendStringWithSpace(buffer, "BY");
            CSSBCreateTable.appendStringWithSpace(buffer, "RANGE");
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, (IndexGlobalPartitionsListOraclev9i)pkProxy.getIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalPartitions(StringBuffer buffer, IndexGlobalPartitionsListOraclev9i globalPartitionList, boolean prettyPrint) {
        IndexGlobalPartitionSetOraclev9i globalPartitionSet = (IndexGlobalPartitionSetOraclev9i)((StorageDesignOraclev9i)globalPartitionList.getStorageDesign()).getIndexGlobalPartitionSet();
        Object[] globalPartitionsList = globalPartitionSet.toArray();
        Arrays.sort(globalPartitionsList, new GlobalPossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < globalPartitionsList.length; ++i) {
            sortedList.add(globalPartitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            IndexGlobalPartitionOraclev9i globalPartition = (IndexGlobalPartitionOraclev9i)setIt.next();
            if (globalPartition.getIndexGlobalPartList() == null || !globalPartition.getIndexGlobalPartList().toString().equalsIgnoreCase(globalPartitionList.toString())) continue;
            if (first) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBCreateTable.appendStringWithSpace(buffer, ',');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
            if (!globalPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition));
            }
            CSSBCreateTable.appendStringWithSpace(buffer, "VALUES LESS THAN");
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            CSSBCreateTable.appendStringWithSpace(buffer, globalPartition.getValueList());
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
            if (globalPartition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev9i)globalPartition.getSegment(), false, prettyPrint, globalPartition.getTableSpace(), globalPartition.getLogging());
                continue;
            }
            if (globalPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition.getTableSpace()));
            }
            if (!this.storageDesign.isOpen() || !this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(globalPartition.getLogging())) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTable.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(globalPartition.getLogging())) continue;
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateTable.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendPartitionList(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        PartitionListOraclev9i partitionList = (PartitionListOraclev9i)tableProxy.getPartitionList();
        if (partitionList != null) {
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOracle)tableProxy.getStorageDesign();
            }
            String partitionType = partitionList.getPartitionType();
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateTable.appendStringWithSpace(buffer, "RANGE");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, false, prettyPrint);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(partitionType)) {
                CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateTable.appendStringWithSpace(buffer, "RANGE");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITION");
                CSSBCreateTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateTable.appendStringWithSpace(buffer, "HASH");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                if ("NO".equals(partitionList.getUseSubpartStorageTemplate())) {
                    if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        this.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                        if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTable.appendStringWithSpace(buffer, "STORE IN");
                            CSSBCreateTable.appendStringWithSpace(buffer, '(');
                            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                            CSSBCreateTable.appendStringWithSpace(buffer, ')');
                        }
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        CSSBCreateTable.appendStringWithSpace(buffer, "1");
                    }
                } else {
                    this.appendHashSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                }
                this.appendPartitions(buffer, partitionList, true, prettyPrint);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateTable.appendStringWithSpace(buffer, "RANGE");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITION");
                CSSBCreateTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateTable.appendStringWithSpace(buffer, "LIST");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                this.appendListSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                this.appendPartitions(buffer, partitionList, true, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateTable.appendStringWithSpace(buffer, "HASH");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "PARTITIONS");
                this.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                if (!"".equals(partitionList.getHashPTableSpaces())) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateTable.appendStringWithSpace(buffer, '(');
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                    CSSBCreateTable.appendStringWithSpace(buffer, ')');
                }
                if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, "OVERFLOW");
                    CSSBCreateTable.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateTable.appendStringWithSpace(buffer, '(');
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                    CSSBCreateTable.appendStringWithSpace(buffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateTable.appendStringWithSpace(buffer, "HASH");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                this.appendHashPartitions(buffer, tableProxy, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateTable.appendStringWithSpace(buffer, "LIST");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                this.appendListPartitions(buffer, tableProxy, prettyPrint);
            }
        }
    }

    private void appendListSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        StorageObjectCollection templates = tableProxy.getListStorageTemplates();
        if (templates.size() > 0) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateTable.appendStringWithSpace(buffer, "TEMPLATE");
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < templates.size(); ++i) {
                ListStorageTemplatePartitionOraclev9i temp = (ListStorageTemplatePartitionOraclev9i)templates.getElement(i);
                if (i > 0) {
                    CSSBCreateTable.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!temp.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(temp));
                }
                CSSBCreateTable.appendStringWithSpace(buffer, "VALUES");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                if (!"".equalsIgnoreCase(temp.getValueList())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, temp.getValueList());
                } else {
                    CSSBCreateTable.appendStringWithSpace(buffer, "DEFAULT");
                }
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, temp, prettyPrint);
            }
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        if (tableProxy.getListStorageTemplates().size() > 0) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateTable.appendStringWithSpace(buffer, "TEMPLATE");
            Iterator setIt = tableProxy.getListStorageTemplates().iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                HashPartitionOraclev9i partition = (HashPartitionOraclev9i)setIt.next();
                if (first) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateTable.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                this.appendPartStorage(buffer, partition, prettyPrint);
            }
            if (!first) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendPartStorage(StringBuffer buffer, AbstractStorageObjectOracle template, boolean prettyPrint) {
        TableSpaceOracle tableSpace = null;
        TableSpaceOracle overflowTableSpace = null;
        StorageObjectCollection lobs = null;
        if (template instanceof HashPartitionOraclev9i) {
            tableSpace = ((HashPartitionOraclev9i)template).getTableSpace();
            overflowTableSpace = ((HashPartitionOraclev9i)template).getIotOverflowTablespace();
            lobs = ((HashPartitionOraclev9i)template).getLobs();
        } else if (template instanceof ListStorageTemplatePartitionOraclev9i) {
            tableSpace = ((ListStorageTemplatePartitionOraclev9i)template).getTablespace();
            lobs = ((ListStorageTemplatePartitionOraclev9i)template).getLobs();
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            if (tableSpace != null) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (overflowTableSpace != null) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTable.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
            }
        }
        if (lobs != null) {
            Iterator it = lobs.iterator();
            while (it.hasNext()) {
                HashPartitionLobItemOraclev9i lobItem;
                Object storageObject = it.next();
                if (storageObject instanceof LobStorageOraclev9i) {
                    LobStorageOraclev9i lobStorage = (LobStorageOraclev9i)storageObject;
                    if (lobStorage.getTableSpace() == null && lobStorage.getLobSegmentName().trim().equals("")) continue;
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    this.appendLobPartitioningStorage(buffer, lobStorage, lobStorage.getColumn(), lobStorage.getLobSegmentName(), lobStorage.getTableSpace(), prettyPrint);
                    continue;
                }
                if (!(storageObject instanceof HashPartitionLobItemOraclev9i) || (lobItem = (HashPartitionLobItemOraclev9i)storageObject).getTableSpace() == null) continue;
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                this.appendLobPartitioningStorage(buffer, lobItem, lobItem.getLobColumn(), "", lobItem.getTableSpace(), prettyPrint);
            }
        }
    }

    private void appendListPartitions(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        Iterator it = tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Table table;
            ListPartitionOraclev9i partition = (ListPartitionOraclev9i)it.next();
            if (first) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBCreateTable.appendStringWithSpace(buffer, ',');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            CSSBCreateTable.appendStringWithSpace(buffer, "VALUES");
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            if (!"".equalsIgnoreCase(partition.getColumns())) {
                CSSBCreateTable.appendStringWithSpace(buffer, partition.getColumns());
            } else {
                CSSBCreateTable.appendStringWithSpace(buffer, "DEFAULT");
            }
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
            if (partition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev9i)partition.getSegment(), true, prettyPrint, partition.getTablespace(), partition.getLogging());
            }
            if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (partition.getSegment() == null) {
                if (partition.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTablespace()));
                }
                if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if (partition.getLogging().equalsIgnoreCase("YES")) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, "LOGGING");
                    } else if (partition.getLogging().equalsIgnoreCase("NO")) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            if ((table = (Table)this.tableObj.getObject()).isSpatialTable()) continue;
            Iterator lobs = partition.getLobStorages().iterator();
            while (lobs.hasNext()) {
                LobStorageOracle lob = (LobStorageOracle)lobs.next();
                this.appendLobStorage(buffer, (LobStorageOraclev9i)lob, prettyPrint);
            }
        }
        if (!first) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, boolean composite, boolean prettyPrint) {
        PartitionSetOracle partitionSet = ((StorageDesignOraclev9i)partitionList.getStorageDesign()).getPartitionSet();
        Object[] partitionsList = partitionSet.toArray();
        Arrays.sort(partitionsList, new PossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < partitionsList.length; ++i) {
            sortedList.add(partitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            PartitionOracle partition = (PartitionOracle)setIt.next();
            if (partition.getPartitionList() == null || partition.getPartitionList() != partitionList) continue;
            if (first) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBCreateTable.appendStringWithSpace(buffer, ',');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            CSSBCreateTable.appendStringWithSpace(buffer, "VALUES LESS THAN");
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            CSSBCreateTable.appendStringWithSpace(buffer, partition.getValueList());
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
            if (partition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev9i)partition.getSegment(), true, prettyPrint, partition.getTableSpace(), partition.getLogging());
            } else if (partition.getIOTOverflowSegment() != null) {
                CSSBCreateTable.appendStringWithSpace(buffer, "OVERFLOW");
                this.appendSegment(buffer, (SegmentOraclev9i)partition.getIOTOverflowSegment(), true, prettyPrint, partition.getTableSpace(), partition.getLogging());
            } else {
                if (partition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTableSpace()));
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if (partition.getLogging().equalsIgnoreCase("NO")) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTable.appendStringWithSpace(buffer, "NOLOGGING");
                    } else if (partition.getLogging().equalsIgnoreCase("YES")) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTable.appendStringWithSpace(buffer, "LOGGING");
                    }
                }
            }
            Table table = (Table)this.tableObj.getObject();
            if (!table.isSpatialTable()) {
                Iterator lobs = partition.getLobs().iterator();
                while (lobs.hasNext()) {
                    LobStorageOracle lob = (LobStorageOracle)lobs.next();
                    this.appendLobStorage(buffer, (LobStorageOraclev9i)lob, prettyPrint);
                }
            }
            if (!composite || this.appendHashSubPartitions(buffer, (PartitionOraclev9i)partition, partitionList, prettyPrint)) continue;
            if (partition.getSubPartitionsQuantity() > 0) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITIONS");
                this.appendStringWithSpace(buffer, partition.getSubPartitionsQuantity());
                if ("".equalsIgnoreCase(partition.getSubPartitionsTableSpaces())) continue;
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "STORE IN");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partition.getSubPartitionsTableSpaces()));
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                continue;
            }
            if (partition.getListPartitions().size() <= 0) continue;
            boolean firstListPart = true;
            Iterator listPartitions = partition.getListPartitions().iterator();
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            while (listPartitions.hasNext()) {
                ListStorageTemplatePartitionOraclev9i listPartition = (ListStorageTemplatePartitionOraclev9i)listPartitions.next();
                if (!firstListPart) {
                    CSSBCreateTable.appendStringWithSpace(buffer, ',');
                } else {
                    firstListPart = false;
                }
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!listPartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(listPartition));
                }
                CSSBCreateTable.appendStringWithSpace(buffer, "VALUES");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, listPartition.getValueList());
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, listPartition, prettyPrint);
            }
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        }
        if (!first) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        }
    }

    private boolean appendHashSubPartitions(StringBuffer buffer, PartitionOraclev9i partition, PartitionListOraclev9i partitionList, boolean prettyPrint) {
        boolean result = false;
        if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
            HashPartitionSetOracle hashPartitionSet = ((StorageDesignOracle)partition.getStorageDesign()).getHashPartitionSet();
            Iterator setIt = hashPartitionSet.iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                HashPartitionOraclev9i hashPartition = (HashPartitionOraclev9i)setIt.next();
                if (hashPartition.getSubPartitionOf() != partition) continue;
                if (first) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, '(');
                    first = false;
                    result = true;
                } else {
                    CSSBCreateTable.appendStringWithSpace(buffer, ',');
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                }
                CSSBCreateTable.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
                }
                this.appendPartStorage(buffer, hashPartition, prettyPrint);
            }
            if (!first) {
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
            }
        }
        return result;
    }

    private boolean appendHashPartitions(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        boolean result = false;
        Iterator it = tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            HashPartitionOraclev9i hashPartition = (HashPartitionOraclev9i)it.next();
            if (first) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                CSSBCreateTable.appendStringWithSpace(buffer, ',');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateTable.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, HashPartitionOraclev9i hashPartition, boolean prettyPrint) {
        HashPartitionLobItemSetOraclev9i hashPLobItemSet = (HashPartitionLobItemSetOraclev9i)((StorageDesignOraclev9i)hashPartition.getStorageDesign()).getHashPartitionLobItemSet();
        Iterator setIt = hashPLobItemSet.iterator();
        while (setIt.hasNext()) {
            HashPartitionLobItemOraclev9i hashPLobItem = (HashPartitionLobItemOraclev9i)setIt.next();
            if (hashPLobItem.getHashPartition() == null || !hashPLobItem.getHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, Object column, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        CSSBCreateTable.appendStringWithSpace(buffer, "LOB");
        CSSBCreateTable.appendStringWithSpace(buffer, '(');
        if (column instanceof ColumnProxy) {
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((ColumnProxy)column));
        } else {
            String columnName = "";
            if (column != null) {
                columnName = column.toString();
            }
            if (columnName.length() > 0) {
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnName));
            } else {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("--  ERROR: Lob ");
                buffer.append(lobObject.getName());
                buffer.append(" has no Column specified");
                CDDLFileMaker.incrementErrors();
            }
        }
        CSSBCreateTable.appendStringWithSpace(buffer, ')');
        CSSBCreateTable.appendStringWithSpace(buffer, "STORE AS");
        if (!lobSegName.equalsIgnoreCase("")) {
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendLobStorage(StringBuffer buffer, LobStorageOraclev9i lobStorage, boolean prettyPrint) {
        if (lobStorage != null) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "LOB");
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getColumn()));
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
            CSSBCreateTable.appendStringWithSpace(buffer, "STORE AS");
            if (!lobStorage.getLobSegmentName().equalsIgnoreCase("")) {
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getLobSegmentName()));
            }
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateTable.appendStringWithSpace(buffer, '(');
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
            if (lobStorage.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                CSSBCreateTable.appendStringWithSpace(buffer, "STORAGE");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (lobStorage.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, lobStorage.getSCInitialExtent());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (lobStorage.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, lobStorage.getSCNextExtent());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, lobStorage.getSCPctIncrease());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCMinExtents());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBCreateTable.appendStringWithSpace(buffer, lobStorage.getSCMaxExtents());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCFreeLists());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && lobStorage.getSCFreelistGroups() > 1) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 3);
                    CSSBCreateTable.appendStringWithSpace(buffer, "FREELIST");
                    CSSBCreateTable.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCFreelistGroups());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 3);
                    CSSBCreateTable.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBCreateTable.appendStringWithSpace(buffer, lobStorage.getSCBufferPool());
                    props = true;
                }
                if (props) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTable.appendStringWithSpace(buffer, ')');
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
            if (lobStorage.getChunk() > 0) {
                CSSBCreateTable.appendStringWithSpace(buffer, "CHUNK");
                this.appendStringWithSpace(buffer, lobStorage.getChunk());
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getOldVersions().equalsIgnoreCase("RETENTION")) {
                CSSBCreateTable.appendStringWithSpace(buffer, "RETENTION");
            } else {
                CSSBCreateTable.appendStringWithSpace(buffer, "PCTVERSION");
                this.appendStringWithSpace(buffer, lobStorage.getPCTVersion());
            }
            if (lobStorage.getFreepools() > 0 && lobStorage.getSCFreelistGroups() <= 1) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTable.appendStringWithSpace(buffer, "FREEPOOLS");
                this.appendStringWithSpace(buffer, lobStorage.getFreepools());
            }
            this.appendStorageInRow(buffer, lobStorage.getTable(), lobStorage.getStorageInRow(), prettyPrint);
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateTable.appendStringWithSpace(buffer, lobStorage.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorage.getCache()) && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(lobStorage.getLogging())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorage.getLogging())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOraclev9i segment, boolean pctUsed, boolean prettyPrint, TableSpaceOracle tableSpace, String logging) {
        if (segment != null) {
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTable.appendStringWithSpace(buffer, "PCTFREE");
                    this.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (pctUsed && this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTable.appendStringWithSpace(buffer, "PCTUSED");
                    this.appendStringWithSpace(buffer, segment.getPCTUsed());
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                    if (segment.getInitrans() > 1) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTable.appendStringWithSpace(buffer, "INITRANS");
                        this.appendStringWithSpace(buffer, segment.getInitrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTable.appendStringWithSpace(buffer, "INITRANS");
                        CSSBCreateTable.appendStringWithSpace(buffer, "1");
                    }
                    if (segment.getMaxTrans() > 1) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTable.appendStringWithSpace(buffer, "MAXTRANS");
                        this.appendStringWithSpace(buffer, segment.getMaxTrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTable.appendStringWithSpace(buffer, "MAXTRANS");
                        CSSBCreateTable.appendStringWithSpace(buffer, "255");
                    }
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (tableSpace != null) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
                } else if (segment.getTableSpace() != null) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(segment.getTableSpace()));
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && !"".equals(logging)) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                if (logging.equalsIgnoreCase("NO")) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "NOLOGGING");
                } else {
                    CSSBCreateTable.appendStringWithSpace(buffer, "LOGGING");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTable.appendStringWithSpace(buffer, "STORAGE");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                boolean props = false;
                if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, segment.getSCNextExtent());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, segment.getSCMinExtents());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBCreateTable.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, segment.getSCFreeLists());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "FREELIST");
                    CSSBCreateTable.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBCreateTable.appendStringWithSpace(buffer, segment.getSCBufferPool());
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    props = true;
                }
                if (props) {
                    CSSBCreateTable.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
        }
    }

    private void appendTableSpace(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        TableSpaceOracle tableSpace;
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL() && (tableSpace = tableProxy.getTableSpace()) != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName())) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
        }
    }

    private void appendOrganization(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        boolean indexOrg = "INDEX".equalsIgnoreCase(tableProxy.getOrganization());
        if (indexOrg) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "ORGANIZATION");
            CSSBCreateTable.appendStringWithSpace(buffer, "INDEX");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL() && !((Table)tableProxy.getObject()).isBST()) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "ORGANIZATION");
            CSSBCreateTable.appendStringWithSpace(buffer, "HEAP");
        }
        if (tableProxy.getSegment() == null) {
            this.appendTableSpace(buffer, tableProxy, prettyPrint);
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(tableProxy.getLogging())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(tableProxy.getLogging())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
        } else {
            this.appendSegment(buffer, (SegmentOraclev9i)tableProxy.getSegment(), !indexOrg, prettyPrint, tableProxy.getTableSpace(), tableProxy.getLogging());
        }
        if (indexOrg) {
            if (tableProxy.getIOTMappingTable().equalsIgnoreCase("YES")) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "MAPPING TABLE");
            }
            if (tableProxy.getIotPctThreshold() > 0) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                this.appendStringWithSpace(buffer, tableProxy.getIotPctThreshold());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                CSSBCreateTable.appendStringWithSpace(buffer, "50");
            }
            if (tableProxy.getIotCompress() > 0) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "COMPRESS");
                this.appendStringWithSpace(buffer, tableProxy.getIotCompress());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            TableSpaceOracle overflowTableSpace = tableProxy.getIotOverflowTablespace();
            String overflowLogging = tableProxy.getIotOverflowLogging();
            SegmentOraclev9i overflowSegment = (SegmentOraclev9i)tableProxy.getIotOverflowSegment();
            ColumnProxy includingColumn = tableProxy.getIotIncluding();
            if (overflowTableSpace != null || !overflowLogging.equals("") || overflowSegment != null || includingColumn != null) {
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                if (includingColumn != null) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "INCLUDING");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(includingColumn));
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                }
                CSSBCreateTable.appendStringWithSpace(buffer, "OVERFLOW");
                if (overflowTableSpace == null) {
                    overflowTableSpace = tableProxy.getTableSpace();
                }
                if (overflowLogging.equals("")) {
                    overflowLogging = tableProxy.getLogging();
                }
                if (overflowSegment != null) {
                    this.appendSegment(buffer, overflowSegment, true, prettyPrint, overflowTableSpace, overflowLogging);
                } else {
                    if (overflowTableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTable.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("NO".equalsIgnoreCase(overflowLogging)) {
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTable.appendStringWithSpace(buffer, "NOLOGGING");
                        } else if ("YES".equalsIgnoreCase(overflowLogging)) {
                            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTable.appendStringWithSpace(buffer, "LOGGING");
                        }
                    }
                }
            }
        } else if (tableProxy.getDataSegmentCompression().equalsIgnoreCase("YES")) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "COMPRESS");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if ("YES".equalsIgnoreCase(tableProxy.getPartitioned())) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            if ("ENABLE".equalsIgnoreCase(tableProxy.getParttitionedRowMovement())) {
                CSSBCreateTable.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBCreateTable.appendStringWithSpace(buffer, "DISABLE");
            }
            CSSBCreateTable.appendStringWithSpace(buffer, "ROW MOVEMENT");
        }
    }

    private void appendCluster(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        ClusterOraclev9i cluster = (ClusterOraclev9i)tableProxy.getCluster();
        if (cluster != null) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "CLUSTER");
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            if (!"".equalsIgnoreCase(tableProxy.getClusterColumns())) {
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getClusterColumns()));
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
            }
        } else {
            this.appendOrganization(buffer, tableProxy, prettyPrint);
            Table table = (Table)this.tableObj.getObject();
            if (!table.isSpatialTable()) {
                for (int i = 0; i < tableProxy.getLobStorages().size(); ++i) {
                    this.appendLobStorage(buffer, (LobStorageOraclev9i)tableProxy.getLobStorages().getElement(i), prettyPrint);
                }
            }
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComments = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)tableProxy.getStorageDesign()).getPermissionsSet();
        Iterator it = permissionsSet.iterator();
        while (it.hasNext()) {
            ModelIDObject column;
            List columns;
            String colName;
            int i;
            PermissionsOraclev9i permissions = (PermissionsOraclev9i)it.next();
            if (permissions.getTable() != null && permissions.getTable().equals(tableProxy)) {
                if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                    CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    CSSBCreateTable.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivileges(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                }
                if (!permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                    CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    CSSBCreateTable.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivilegesWithGrantOption(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions);
                    this.appendGrantOption(buffer, permissions);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                }
            }
            if (permissions.getColumnsTable() == null || !permissions.getColumnsTable().equals(tableProxy)) continue;
            ArrayList cols = permissions.getColumns();
            block1: for (i = 0; i < cols.size(); ++i) {
                colName = (String)cols.get(i);
                columns = this.tableObj.getChildObjects(0);
                for (CompareObjectSelection columnSel : columns) {
                    column = columnSel.getObject();
                    if (column == null || !column.getName().equals(colName)) continue;
                    if (columnSel.canBeCreate() && !columnSel.isSelected()) continue block1;
                    CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    CSSBCreateTable.appendStringWithSpace(buffer, "GRANT");
                    CSSBCreateTable.appendStringWithSpace(buffer, permissions.getPrivs(colName));
                    CSSBCreateTable.appendStringWithSpace(buffer, '(');
                    CSSBCreateTable.appendStringWithSpace(buffer, CSSBCreateTable.getFormattedSelectedName(columnSel, this.storageDesign));
                    CSSBCreateTable.appendStringWithSpace(buffer, ')');
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    continue block1;
                }
            }
            cols = permissions.getColumnsWithGrantOption();
            block3: for (i = 0; i < cols.size(); ++i) {
                colName = (String)cols.get(i);
                columns = this.tableObj.getChildObjects(0);
                for (CompareObjectSelection columnSel : columns) {
                    column = columnSel.getObject();
                    if (column == null || !column.getName().equals(colName)) continue;
                    if (columnSel.canBeCreate() && !columnSel.isSelected()) continue block3;
                    CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    CSSBCreateTable.appendStringWithSpace(buffer, "GRANT");
                    CSSBCreateTable.appendStringWithSpace(buffer, permissions.getPrivsWithGrantOption(colName));
                    CSSBCreateTable.appendStringWithSpace(buffer, '(');
                    CSSBCreateTable.appendStringWithSpace(buffer, CSSBCreateTable.getFormattedSelectedName(columnSel, this.storageDesign));
                    CSSBCreateTable.appendStringWithSpace(buffer, ')');
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions);
                    this.appendGrantOption(buffer, permissions);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    continue block3;
                }
            }
        }
    }

    private String getPermissionsTO(PermissionsOraclev9i permissions) {
        if (permissions.getUser() != null) {
            return permissions.getUser().getName();
        }
        if (permissions.getRole() != null) {
            return permissions.getRole().getName();
        }
        return "";
    }

    private String getPermissionsON(PermissionsOraclev9i permissions) {
        if (permissions.getTable() != null) {
            return permissions.getTable().getLongNameDDL();
        }
        if (permissions.getColumnsTable() != null) {
            return permissions.getColumnsTable().getLongNameDDL();
        }
        return "";
    }

    private void appendPrivileges(StringBuffer buffer, PermissionsOraclev9i permissions) {
        buffer.append(permissions.getPrivileges());
    }

    private void appendPrivilegesWithGrantOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        buffer.append(permissions.getPrivilegesWithGrantOption());
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev9i permissions, boolean prettyPrint) {
        TableProxyOracle tableProxy = permissions.getTable();
        if (tableProxy == null) {
            tableProxy = permissions.getColumnsTable();
        }
        if (tableProxy != null) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "ON");
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        }
    }

    private void appendTo(StringBuffer buffer, PermissionsOraclev9i permissions) {
        CSSBCreateTable.appendStringWithSpace(buffer, "TO");
        if ("YES".equalsIgnoreCase(permissions.getPublic())) {
            CSSBCreateTable.appendStringWithSpace(buffer, "PUBLIC");
        } else {
            AbstractStorageObjectOracle userOrRole = permissions.getUser();
            if (userOrRole == null) {
                userOrRole = permissions.getRole();
            }
            if (userOrRole != null) {
                if (userOrRole.getName().equals("PUBLIC")) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "PUBLIC");
                } else {
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(userOrRole));
                }
            }
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if (permissions.getRole() == null) {
            CSSBCreateTable.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev9i permissions, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    private void appendIndexes(StringBuffer oldbuffer, TableProxyOracle tableProxy, CompareObjectSelection engObject, boolean prettyPrint) {
        this.appendIndexes(oldbuffer, engObject, tableProxy, prettyPrint);
        this.appendPKAndUK(oldbuffer, engObject, prettyPrint);
    }

    public boolean isRenamed() {
        return false;
    }

    private void appendIndexes(StringBuffer oldbuffer, CompareObjectSelection table, TableProxyOracle tableProxy, boolean prettyPrint) {
        List chIndexes = table.getChildObjects(1);
        for (CompareObjectSelection index : chIndexes) {
            Index theIndex;
            if (index.canBeCreate() && !index.isSelected() || (theIndex = (Index)index.getObject()) == null) continue;
            StringBuffer columnList = this.getColumnsForRestore(table, theIndex, prettyPrint, true);
            this.cssbIndex.setRenamed(this.isRenamed());
            this.cssbIndex.setRestoredColumns(columnList);
            this.cssbIndex.setRestoredExpression(theIndex.getIndexExpression());
            this.cssbIndex.setTableName(this.storageDesign.getFormatedLongNameDDL(tableProxy));
            this.cssbIndex.doAppend(oldbuffer, theIndex, prettyPrint);
        }
    }

    private void appendPKAndUK(StringBuffer oldbuffer, CompareObjectSelection table, boolean prettyPrint) {
        TableComparator comp = (TableComparator)table.getPropertiesComparator();
        TableProxyOraclev9i sourceTableProxy = (TableProxyOraclev9i)comp.getSourceTableProxy();
        List chIndexes = table.getChildObjects(2);
        for (CompareObjectSelection index : chIndexes) {
            StringBuffer columnList;
            if (index.canBeCreate() && !index.isSelected() || ((Index)index.getObject()).isOidKey()) continue;
            if (((Index)index.getObject()).isPK() && index.isSelected()) {
                columnList = this.getColumnsForRestore(table, (Index)index.getObject(), prettyPrint, false);
                if (this.isNotEmpty(columnList.toString())) {
                    this.appendPKDefinition(oldbuffer, sourceTableProxy, (Index)index.getObject(), columnList, prettyPrint);
                } else {
                    this.appendError(oldbuffer, prettyPrint, "Index " + index.getObject().toString() + " without columns");
                }
            }
            if (!((Index)index.getObject()).isUnique() || !index.isSelected()) continue;
            columnList = this.getColumnsForRestore(table, (Index)index.getObject(), prettyPrint, false);
            if (this.isNotEmpty(columnList.toString())) {
                UniqueOraclev9i unique = (UniqueOraclev9i)sourceTableProxy.getUniqueKeys().getObjectByID(index.getObject().getObjectID());
                this.appendUniqueDefinition(oldbuffer, sourceTableProxy, unique, prettyPrint, columnList);
                continue;
            }
            this.appendError(oldbuffer, prettyPrint, "Index " + index.getObject().toString() + " without columns");
        }
    }

    private void appendError(StringBuffer oldbuffer, boolean prettyPrint, String errorMsg) {
        CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateTable.appendStringWithSpace(oldbuffer, "--  ERROR: ");
        CSSBCreateTable.appendString(oldbuffer, errorMsg);
        CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CDDLFileMaker.incrementErrors();
    }

    private void appendTableLevelCheckConstraints(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = tableProxy.getTableCheckConstraints().iterator();
        while (it.hasNext()) {
            TableCheckConstraintOracle constraint = (TableCheckConstraintOracle)it.next();
            TableLevelConstraint tlc = constraint.getTableConstraint();
            if (!tlc.shouldBeMerge()) continue;
            String rule = tlc.getRule();
            String cname = constraint.getName().toUpperCase();
            if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                cname = "";
            }
            if ("".equals(cname) || "".equals(rule) || !tlc.isGenerateInDDL()) continue;
            CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
            if (cname.length() > tableProxy.getMaxNameLength()) {
                CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateTable.appendStringWithSpace(oldbuffer, "--  ERROR: Table constraint name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementErrors();
            }
            String formatedConstraintName = this.storageDesign.getFormatedName(constraint);
            String formattedLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
            CSSBCreateTable.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateTable.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateTable.appendStringWithSpace(buffer, formattedLongName);
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "ADD");
            if (!"".equals(cname)) {
                CSSBCreateTable.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTable.appendStringWithSpace(buffer, formatedConstraintName);
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateTable.appendStringWithSpace(buffer, "CHECK");
            CSSBCreateTable.appendString(buffer, '(');
            CSSBCreateTable.appendString(buffer, rule);
            CSSBCreateTable.appendString(buffer, ')');
            this.appendTableConstraintState(buffer, constraint, prettyPrint);
            String advancedComments = "Alter Table " + formattedLongName + " Add Constraint " + formatedConstraintName;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            CDDLFileMaker.incrementAlterTable();
        }
    }

    private StringBuffer getColumnsForRestore(CompareObjectSelection engObject, Index index, boolean prettyPrint, boolean getColumnSortOrder) {
        StringBuffer columnList = new StringBuffer();
        boolean notFirst = false;
        List sourceColumns = engObject.getChildObjects(0);
        block0: for (Column indexCol : index.getElementsCollection()) {
            for (CompareObjectSelection tableCol : sourceColumns) {
                ModelIDObject column = tableCol.getObject();
                if (column == null || !column.equals(indexCol)) continue;
                if (tableCol.canBeCreate() && !tableCol.isSelected() || tableCol.canBeDrop() && tableCol.getCorrespondentNode().isSelected()) continue block0;
                if (notFirst) {
                    columnList.append(',');
                    CSSBCreateTable.appendNewLine(columnList, prettyPrint, 1);
                    columnList.append(' ');
                }
                String formattedColumnName = tableCol.isSelected() ? CSSBCreateTable.getFormattedSelectedName(tableCol, this.storageDesign) : this.storageDesign.getFormatedName(tableCol.getCorrespondentNode().getObject());
                CSSBCreateTable.appendStringWithSpace(columnList, formattedColumnName);
                if (getColumnSortOrder) {
                    CSSBCreateTable.appendStringWithSpace(columnList, index.getColumnSortOrder(tableCol.getObject()));
                }
                notFirst = true;
                continue block0;
            }
        }
        return columnList;
    }

    private void appendPKDefinition(StringBuffer oldbuffer, TableProxyOraclev9i tableProxy, Index index, StringBuffer columnList, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (tableProxy != null) {
            Index pkInd;
            this.pk = this.getPKProxy(tableProxy);
            if (this.pk != null && this.pk.getObject() == index && ((pkInd = this.pk.getIndex()).shouldBeMerge() || this.isRenamed()) && !this.hasNoMergeColumns(pkInd.getElements()) && !"".equalsIgnoreCase(this.pk.getColumns())) {
                CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                if (this.pk.isCommentChanged() && !"".equalsIgnoreCase(this.pk.getComment())) {
                    this.appendComment(oldbuffer, this.pk);
                } else if (!"".equalsIgnoreCase(this.pk.getObject().getComment())) {
                    this.appendComment(oldbuffer, this.pk.getObject());
                }
                String pkName = this.pk.getName();
                if (pkName.length() > tableProxy.getMaxNameLength()) {
                    CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateTable.appendStringWithSpace(oldbuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                    CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    CDDLFileMaker.incrementErrors();
                }
                CSSBCreateTable.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateTable.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTable.appendStringWithSpace(buffer, "ADD");
                CSSBCreateTable.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(this.pk));
                advancedComment = buffer.toString();
                CSSBCreateTable.appendStringWithSpace(buffer, "PRIMARY KEY");
                CSSBCreateTable.appendStringWithSpace(buffer, '(');
                if (!"".equals(pkInd.getIndexExpression())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, pkInd.getIndexExpression());
                } else {
                    this.appendStringWithSpace(buffer, columnList);
                }
                CSSBCreateTable.appendStringWithSpace(buffer, ')');
                if (!"NO".equalsIgnoreCase(this.pk.getDeferrable())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(this.pk.getInitially())) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "INITIALLY");
                        CSSBCreateTable.appendStringWithSpace(buffer, "DEFERRED");
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "INITIALLY");
                        CSSBCreateTable.appendStringWithSpace(buffer, "IMMEDIATE");
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "NOT");
                    CSSBCreateTable.appendStringWithSpace(buffer, "DEFERRABLE");
                }
                if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                    this.appendUsingIndex(buffer, this.pk, prettyPrint);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if ("YES".equalsIgnoreCase(this.pk.getEnable())) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "ENABLE");
                    } else {
                        CSSBCreateTable.appendStringWithSpace(buffer, "DISABLE");
                    }
                    if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "VALIDATE");
                    } else {
                        CSSBCreateTable.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                } else {
                    if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "DISABLE");
                        if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                            CSSBCreateTable.appendStringWithSpace(buffer, "VALIDATE");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                        CSSBCreateTable.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
                if (this.pk.getRely().equals("YES")) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "ALTER");
                    CSSBCreateTable.appendStringWithSpace(buffer, "TABLE");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, "MODIFY");
                    CSSBCreateTable.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(this.pk));
                    advancedComment = buffer.toString();
                    CSSBCreateTable.appendStringWithSpace(buffer, "RELY");
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CDDLFileMaker.incrementAlterTable();
                }
                if (this.pk.getExceptionsTable() != null && "YES".equalsIgnoreCase(this.pk.getEnable())) {
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, "ALTER");
                    CSSBCreateTable.appendStringWithSpace(buffer, "TABLE");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                    advancedComment = buffer.toString();
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTable.appendStringWithSpace(buffer, "MODIFY");
                    CSSBCreateTable.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(this.pk));
                    CSSBCreateTable.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
                    CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(this.pk.getExceptionsTable()));
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CDDLFileMaker.incrementAlterTable();
                }
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer oldbuffer, TableProxyOracle tableProxy, UniqueOraclev9i unique, boolean prettyPrint, StringBuffer columnList) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
        if (unique.isCommentChanged() && !"".equalsIgnoreCase(unique.getComment())) {
            this.appendComment(oldbuffer, unique);
        } else if (!"".equalsIgnoreCase(unique.getObject().getComment())) {
            this.appendComment(oldbuffer, unique.getObject());
        }
        String uniqueName = unique.getName();
        if (uniqueName.length() > tableProxy.getMaxNameLength()) {
            CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateTable.appendStringWithSpace(oldbuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
            CSSBCreateTable.appendNewLine(oldbuffer, prettyPrint, 0);
            CDDLFileMaker.incrementErrors();
        }
        CSSBCreateTable.appendStringWithSpace(buffer, "ALTER");
        CSSBCreateTable.appendStringWithSpace(buffer, "TABLE");
        CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateTable.appendStringWithSpace(buffer, "ADD");
        CSSBCreateTable.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
        CSSBCreateTable.appendStringWithSpace(buffer, "UNIQUE");
        advancedComment = buffer.toString();
        CSSBCreateTable.appendStringWithSpace(buffer, '(');
        this.appendString(buffer, columnList);
        CSSBCreateTable.appendStringWithSpace(buffer, ')');
        if (!"NO".equalsIgnoreCase(unique.getDeferrable())) {
            CSSBCreateTable.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(unique.getInitially())) {
                CSSBCreateTable.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateTable.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTable.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateTable.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateTable.appendStringWithSpace(buffer, "NOT");
            CSSBCreateTable.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (!"NO".equalsIgnoreCase(unique.getUsingIndex())) {
            this.appendUniqueUsingIndex(buffer, unique, prettyPrint);
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(unique.getEnable())) {
                CSSBCreateTable.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBCreateTable.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(unique.getValidate())) {
                CSSBCreateTable.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBCreateTable.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(unique.getEnable())) {
                CSSBCreateTable.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(unique.getValidate())) {
                    CSSBCreateTable.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(unique.getValidate())) {
                CSSBCreateTable.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CDDLFileMaker.incrementAlterTable();
        if (unique.getRely().equals("YES")) {
            CSSBCreateTable.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateTable.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "MODIFY");
            CSSBCreateTable.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
            advancedComment = buffer.toString();
            CSSBCreateTable.appendStringWithSpace(buffer, "RELY");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
        }
        if (unique.getExceptionsTable() != null && "YES".equalsIgnoreCase(unique.getEnable())) {
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateTable.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            advancedComment = buffer.toString();
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTable.appendStringWithSpace(buffer, "MODIFY");
            CSSBCreateTable.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
            CSSBCreateTable.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
            CSSBCreateTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExceptionsTable()));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateTable.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
        }
    }

    private void appendBitmapJoinIndexes(StringBuffer oldbuffer, TableProxyOraclev9i sourceProxy, boolean prettyPrint) {
        Iterator it = sourceProxy.getBjIndexes().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (this.ssbBJIndex == null) {
                this.ssbBJIndex = new SSBCreateBitmapJoinIndexOraclev9i();
            }
            if (!this.ssbBJIndex.canHandle(object)) continue;
            this.ssbBJIndex.doAppendBJIndex(oldbuffer, object, prettyPrint);
        }
    }

    private void appendAutoIncTriggers(StringBuffer oldbuffer, TableProxyOraclev9i sourceProxy, boolean prettyPrint) {
        Table table = (Table)sourceProxy.getObject();
        for (Column column : table.getElementsCollection()) {
            if (!column.isAutoIncrementColumn()) continue;
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(oldbuffer, column, prettyPrint);
        }
    }

    private void appendTriggers(StringBuffer oldbuffer, TableProxyOraclev9i sourceProxy, boolean prettyPrint) {
        Iterator it = sourceProxy.getTriggers().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (this.ssbTriggers == null) {
                this.ssbTriggers = new SSBTriggerOraclev9i();
            }
            if (!this.ssbTriggers.canHandle(object)) continue;
            this.ssbTriggers.doAppendTrigger(oldbuffer, object, prettyPrint);
        }
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOraclev9i)one).getPosition() > ((PartitionOraclev9i)two).getPosition()) {
                return 1;
            }
            if (((PartitionOraclev9i)one).getPosition() < ((PartitionOraclev9i)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    static class GlobalPossitionComparator
    implements Comparator {
        GlobalPossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((IndexGlobalPartitionOraclev9i)one).getPosition() > ((IndexGlobalPartitionOraclev9i)two).getPosition()) {
                return 1;
            }
            if (((IndexGlobalPartitionOraclev9i)one).getPosition() < ((IndexGlobalPartitionOraclev9i)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

