/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBDropIndex
extends AbstractCSSBOracle {
    private Map fkMap;

    public CSSBDropIndex(Map fkMap) {
        this.fkMap = fkMap;
    }

    @Override
    public void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object == null) {
            return;
        }
        KeyObject mdObject = (KeyObject)((CompareObjectSelection)object).getCorrespondentNode().getObject();
        if (mdObject != null && !this.fkMap.containsKey(mdObject.getObjectID())) {
            StringBuffer buffer = new StringBuffer();
            String advancedComment = "";
            Table table = (Table)mdObject.getContainerObject();
            Design design = table.getDesign();
            RDBMSSite site = table.getSelectedRDBMSSite();
            StorageDesignOracle storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
            if (mdObject.isPK() || mdObject.isUnique()) {
                CSSBDropIndex.appendStringWithSpace(buffer, "ALTER");
                CSSBDropIndex.appendStringWithSpace(buffer, "TABLE");
                CSSBDropIndex.appendStringWithSpace(buffer, this.getTableName((CompareObjectSelection)object, storageDesign));
                CSSBDropIndex.appendStringWithSpace(buffer, "DROP");
                CSSBDropIndex.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBDropIndex.appendStringWithSpace(buffer, storageDesign.getFormatedName(mdObject));
                advancedComment = buffer.toString();
                CSSBDropIndex.appendStringWithSpace(buffer, "CASCADE");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBDropIndex.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
            } else {
                this.appendDrop(buffer);
                CSSBDropIndex.appendStringWithSpace(buffer, "INDEX");
                IndexProxyOracle indexProxy = (IndexProxyOracle)storageDesign.getIndexProxySet().getProxy(mdObject.getObjectID());
                CSSBDropIndex.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(indexProxy));
                advancedComment = buffer.toString();
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBDropIndex.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementDropIndex();
            }
            this.fkMap.put(mdObject.getObjectID(), mdObject);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof Index;
    }

    private String getTableName(CompareObjectSelection index, StorageDesignOracle storageDesign) {
        CompareObjectSelection table = index.getTableNode();
        if (table != null) {
            return this.getFormattedTableName(table, storageDesign);
        }
        return "";
    }
}

