/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.AbstractCSSBOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class CSSBAlterColumnOraclev10g
extends AbstractCSSBOraclev10g {
    private Column sourceColumn;
    private Table sourceTable;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection obj = (CompareObjectSelection)object;
        CompareObjectSelection tobj = obj.getCorrespondentNode();
        this.sourceColumn = (Column)obj.getObject();
        this.sourceTable = (Table)this.sourceColumn.getContainer();
        if (this.sourceTable != null) {
            Design design = this.sourceTable.getDesign();
            RDBMSSite site = this.sourceTable.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, this.sourceTable);
            if (obj.canBeCreate()) {
                this.appendAddColumn(oldbuffer, obj, this.sourceColumn, this.sourceTable, prettyPrint);
            } else {
                this.appendModifyColumn(oldbuffer, obj, tobj, prettyPrint);
            }
        }
    }

    public static boolean isNotSkipColumnFromObjectTable(TableProxy tp, Map propMap) {
        Table table = (Table)tp.getObject();
        if (table.isBST()) {
            int count = 0;
            if (propMap.containsKey(PropertiesComparator.NAME)) {
                ++count;
            }
            if (propMap.containsKey(PropertiesComparator.DATA_TYPE)) {
                ++count;
            }
            if (propMap.containsKey(PropertiesComparator.COMPUTED)) {
                ++count;
            }
            if (propMap.containsKey(PropertiesComparator.FORMULA_DESC)) {
                ++count;
            }
            if (propMap.size() > count) {
                return false;
            }
        }
        return true;
    }

    private void appendModifyColumn(StringBuffer oldbuffer, CompareObjectSelection obj, CompareObjectSelection tobj, boolean prettyPrint) {
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(this.sourceTable.getObjectID());
        Map propMap = this.getPropertiesMap(obj);
        if (tableProxy != null && !propMap.isEmpty() && CSSBAlterColumnOraclev10g.isNotSkipColumnFromObjectTable(tableProxy, propMap)) {
            boolean updateVirtualColDef;
            Table table = (Table)tableProxy.getObject();
            String tableName = this.getTableName(obj);
            StringBuffer buffer = new StringBuffer();
            ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(this.sourceColumn.getObjectID());
            Column scolumn = columnProxy.getColumn();
            Column targetColumn = (Column)tobj.getObject();
            if (propMap.containsKey(PropertiesComparator.NAME) && !table.isBST()) {
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                this.appendRenameColumn(oldbuffer, obj, tobj, prettyPrint);
            }
            if (propMap.containsKey(PropertiesComparator.COMMENT_IN_RDBMS) && columnProxy.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOnColumn(oldbuffer, tableName, obj, columnProxy, prettyPrint);
            }
            boolean bl = updateVirtualColDef = columnProxy.isVirtual() && (propMap.containsKey(PropertiesComparator.FORMULA_DESC) || propMap.containsKey(PropertiesComparator.COMPUTED));
            if (updateVirtualColDef || propMap.containsKey(PropertiesComparator.DATA_TYPE) && !table.isBST() || propMap.containsKey(PropertiesComparator.MANDATORY) || propMap.containsKey(PropertiesComparator.NNC_NAME) || propMap.containsKey(PropertiesComparator.DEFAULT_VALUE)) {
                String addvancedComment;
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                if (propMap.get(PropertiesComparator.NNC_NAME) != null && !propMap.containsKey(PropertiesComparator.MANDATORY) && scolumn.isMandatory() && targetColumn.isMandatory()) {
                    String nnc = targetColumn.getNotNullConstraintName();
                    if (nnc != null && !"".equals(nnc)) {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                        addvancedComment = buffer.toString() + "DROP" + ' ' + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(nnc);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DROP");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(nnc));
                        this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        this.appendLineFinisher(buffer, prettyPrint);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                        CDDLFileMaker.incrementAlterTable();
                    } else if (!targetColumn.isPKElement()) {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                        addvancedComment = buffer.toString() + "MODIFY" + ' ' + this.storageDesign.getFormatedName(columnProxy);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NULL");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
                        this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        this.appendLineFinisher(buffer, prettyPrint);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                        CDDLFileMaker.incrementAlterTable();
                    }
                }
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                addvancedComment = buffer.toString() + "MODIFY" + ' ' + this.storageDesign.getFormatedName(columnProxy);
                CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                if (updateVirtualColDef) {
                    this.appendVirtualColumnDefinition(buffer, tableProxy, (ColumnProxyOraclev11g)columnProxy, prettyPrint);
                } else {
                    if (propMap.get(PropertiesComparator.DATA_TYPE) != null && !table.isBST()) {
                        this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.DATA_TYPE));
                    }
                    if (propMap.get(PropertiesComparator.DEFAULT_VALUE) != null) {
                        this.appendWithDefaultDefinition(buffer, columnProxy);
                    }
                }
                if (propMap.get(PropertiesComparator.MANDATORY) != null) {
                    if (!scolumn.getNullsAllowed()) {
                        this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
                    } else {
                        this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.MANDATORY));
                    }
                } else if (propMap.get(PropertiesComparator.NNC_NAME) != null) {
                    if (scolumn.isMandatory()) {
                        this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
                    } else {
                        this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.MANDATORY));
                    }
                }
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                CDDLFileMaker.incrementAlterTable();
            }
            this.appendColumnConstraint(oldbuffer, this.sourceColumn, targetColumn, tableName, columnProxy, obj, prettyPrint);
        }
    }

    private void appendCommentOnColumn(StringBuffer oldbuffer, String formattedTableName, CompareObjectSelection columnObj, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        String commentOn = columnProxy.isCommentInRDBMSChanged() ? columnProxy.getCommentInRDBMS() : columnObj.getChoosedPropertyValue(PropertiesComparator.COMMENT_IN_RDBMS);
        if (commentOn.trim().length() > 0) {
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "COMMENT ON");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "COLUMN");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, formattedTableName + '.' + CSSBAlterColumnOraclev10g.getFormattedSelectedName(columnObj, this.storageDesign));
            String advancedComment = buffer.toString();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IS");
            CSSBAlterColumnOraclev10g.appendString(buffer, '\'');
            CSSBAlterColumnOraclev10g.appendString(buffer, this.replaceSingleQuote(commentOn));
            CSSBAlterColumnOraclev10g.appendString(buffer, '\'');
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendColumnConstraint(StringBuffer oldbuffer, Column sourceColumn, Column targetColumn, String tableName, ColumnProxyOracle columnProxy, CompareObjectSelection obj, boolean prettyPrint) {
        boolean add = CSSBCreateRenameTableOraclev10g.isApplyColumnConstraint(obj);
        if (add && sourceColumn.isGenerateConstraintInDDL()) {
            if (!"".equals(targetColumn.getConstraintName())) {
                String constr = this.storageDesign.getFormatedName(targetColumn.getConstraintName());
                StringBuffer buffer = new StringBuffer();
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constr);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementAlterTable();
            }
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ADD ");
            int len = buffer.length();
            CSSBCreateRenameTableOraclev10g.appendColumnConstraints(buffer, sourceColumn, columnProxy, prettyPrint, obj);
            if (len < buffer.length()) {
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    private Map getPropertiesMap(CompareObjectSelection obj) {
        TreeMap<String, String> propMap = new TreeMap<String, String>();
        for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
            if (!ph.isSelected()) continue;
            if (ph.getName().equals(PropertiesComparator.NAME)) {
                propMap.put(PropertiesComparator.NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.DATA_TYPE)) {
                propMap.put(PropertiesComparator.DATA_TYPE, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.MANDATORY)) {
                if (!Boolean.parseBoolean(ph.getLeftValue())) {
                    propMap.put(PropertiesComparator.MANDATORY, "NULL");
                    continue;
                }
                propMap.put(PropertiesComparator.MANDATORY, "NOT NULL");
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.NNC_NAME)) {
                propMap.put(PropertiesComparator.NNC_NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.DEFAULT_VALUE)) {
                String def = ph.getLeftValue();
                if ("".equals(def.trim())) {
                    propMap.put(PropertiesComparator.DEFAULT_VALUE, "NULL");
                    continue;
                }
                propMap.put(PropertiesComparator.DEFAULT_VALUE, def);
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.COMMENT_IN_RDBMS)) {
                propMap.put(PropertiesComparator.COMMENT_IN_RDBMS, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                propMap.put(EngPropertiesComparator.CHECK_CONSTRAINT_NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.CHECK_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.RANGE_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.RANGE_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.LOV_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.LOV_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.COMPUTED)) {
                propMap.put(PropertiesComparator.COMPUTED, ph.getLeftValue());
                continue;
            }
            if (!ph.getName().equals(PropertiesComparator.FORMULA_DESC)) continue;
            propMap.put(PropertiesComparator.FORMULA_DESC, ph.getLeftValue());
        }
        return propMap;
    }

    private void appendRenameColumn(StringBuffer oldbuffer, CompareObjectSelection sobj, CompareObjectSelection tobj, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.getTableName(sobj));
        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "RENAME");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "COLUMN");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tobj.getObject()));
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TO");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sobj.getObject()));
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CDDLFileMaker.incrementAlterTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAddColumn(StringBuffer oldbuffer, CompareObjectSelection obj, Column column, Table table, boolean prettyPrint) {
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null) {
            RelationalObjectProxy proxy;
            ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
            if (column.isAutoIncrementColumn()) {
                this.appendAutoIncrementSequence(oldbuffer, column, prettyPrint);
            }
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
            String formattedTableName = this.getTableName(obj);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, formattedTableName);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ADD");
            String advancedComment = buffer.toString() + this.storageDesign.getFormatedName(columnProxy);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendSpace(buffer);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            String datatypeString = "";
            Datatype datatype = column.getDataType();
            if ((datatype instanceof StructuredType || datatype instanceof CollectionType) && (proxy = this.storageDesign.getProxy(datatype)) != null) {
                datatypeString = this.storageDesign.getFormatedLongNameDDL(proxy);
                if (column.isReference() && datatype instanceof StructuredType) {
                    datatypeString = "REF " + datatypeString;
                }
            }
            if (datatypeString.equals("")) {
                datatypeString = column.getDatatypeString("Oracle Database 10g");
                if ((datatypeString.equals("CHAR") || datatypeString.equals("NCHAR")) && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    datatypeString = datatypeString + " (1)";
                } else if (datatypeString.equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    datatypeString = datatypeString + " (4000)";
                }
            }
            this.appendDatatype(buffer, datatypeString, columnProxy, prettyPrint);
            if (tableProxy != null) {
                this.appendColumnOptions(buffer, tableProxy, column, columnProxy, prettyPrint);
                this.appendInlineRefConstraint(buffer, column, columnProxy, prettyPrint);
                CSSBCreateTableOraclev10g.appendColumnConstraints(buffer, column, columnProxy, true, prettyPrint);
            }
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(buffer, columnProxy, prettyPrint);
            } else if (datatype instanceof CollectionType) {
                CollectionType cdatatype = (CollectionType)datatype;
                if (cdatatype.isArrayType()) {
                    this.appendVarrayColumnProp(buffer, columnProxy, prettyPrint);
                } else {
                    this.appendNestedTableColumnProp(buffer, columnProxy, prettyPrint);
                }
            } else if (datatype instanceof StructuredType) {
                this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, true);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
            if (columnProxy.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOnColumn(oldbuffer, formattedTableName, obj, columnProxy, prettyPrint);
            }
            if (column.isAutoIncrementColumn()) {
                DDLAdvancedGenerator oldg = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    if (this.ssbAutoIncCol == null) {
                        this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
                    }
                    this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(oldbuffer, column, prettyPrint);
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator(oldg);
                }
            }
        }
    }

    protected void appendVirtualColumnDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, ColumnProxyOraclev11g columnProxy, boolean prettyPrint) {
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Column;
    }

    public String getTableName(CompareObjectSelection column) {
        CompareObjectSelection table = column.getTableNode();
        if (table != null) {
            return this.getFormattedTableName(table, this.storageDesign);
        }
        return "";
    }
}

