/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBFKIndexOraclev10g
extends AbstractCSSBOracle {
    private Map fkMap;
    private StorageDesignOraclev10g storageDesign;
    private boolean isRenamedTable = true;
    private List pkColumns;
    private List fkColumns;

    public CSSBFKIndexOraclev10g(Map fkMap) {
        this.fkMap = fkMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection obj = (CompareObjectSelection)object;
        CompareObjectSelection tobj = obj.getCorrespondentNode();
        FKIndexAssociation fkObj = (FKIndexAssociation)tobj.getObject();
        Table table = null;
        if (fkObj != null && this.fkMap.get(fkObj.getObjectID()) != null) {
            this.isRenamedTable = true;
            table = fkObj.getTable();
            if (!obj.isSelected() || !tobj.canBeDrop()) {
                this.appendRenameFK(oldbuffer, prettyPrint, fkObj, table, tobj);
            }
        } else if (obj.getObject() != null) {
            this.isRenamedTable = false;
            fkObj = (FKIndexAssociation)obj.getObject();
            table = fkObj.getTable();
            if (this.fkMap.get(fkObj.getRemoteIndex().getObjectID()) != null) {
                this.appendFK(oldbuffer, prettyPrint, fkObj, table, obj);
            } else if (fkObj.shouldBeMerge() && table.shouldBeMerge() && obj.isModified()) {
                Design design = table.getDesign();
                RDBMSSite site = table.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
                if (!obj.canBeCreate()) {
                    boolean dropAndRecreate = false;
                    String formattedNewName = null;
                    String formattedOldName = null;
                    for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
                        if (!ph.isSelected()) continue;
                        String propertyName = ph.getName();
                        if (propertyName.equals(PropertiesComparator.NAME)) {
                            formattedNewName = this.storageDesign.getFormatedName(obj.getObject());
                            formattedOldName = this.storageDesign.getFormatedName(obj.getCorrespondentNode().getObject());
                            continue;
                        }
                        if (propertyName.equals(PropertiesComparator.COLUMN_ASSOCIATION)) {
                            CompareObjectSelection sourcePkIndObject = this.getPKObjectSelection(obj, fkObj.getKeyObject());
                            if (sourcePkIndObject != null && sourcePkIndObject.isModified() && !sourcePkIndObject.isSelected()) continue;
                            dropAndRecreate = true;
                            continue;
                        }
                        if (!propertyName.equals(PropertiesComparator.PRIMARY_KEY) && !propertyName.equals(PropertiesComparator.DELETE_RULE) && !propertyName.equals(PropertiesComparator.TRANSFERABLE) && !propertyName.equals(PropertiesComparator.IN_ARC)) continue;
                        dropAndRecreate = true;
                    }
                    if (dropAndRecreate) {
                        this.appendDropFK(oldbuffer, fkObj, obj, prettyPrint);
                    } else {
                        if (formattedNewName != null) {
                            this.renameConstraint(oldbuffer, formattedOldName, formattedNewName, obj, prettyPrint);
                        }
                        return;
                    }
                }
                this.appendFK(oldbuffer, prettyPrint, fkObj, table, obj);
            }
        } else if (fkObj != null && obj.isSelected() && this.fkMap.get(fkObj.getRemoteIndex().getObjectID()) == null) {
            this.appendDropFK(oldbuffer, fkObj, obj, prettyPrint);
        }
    }

    private void renameConstraint(StringBuffer oldbuffer, String formattedOldName, String formattedNewName, CompareObjectSelection obj, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
        String advancedComment = buffer.toString() + "RENAME" + ' ' + "CONSTRAINT" + ' ' + formattedOldName;
        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "RENAME");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, formattedOldName);
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TO");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, formattedNewName);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendLineFinisher(buffer, prettyPrint);
        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendDropFK(StringBuffer oldbuffer, FKIndexAssociation fkObj, CompareObjectSelection obj, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        Table table = fkObj.getTable();
        FKIndexAssociation fkModObj = (FKIndexAssociation)obj.getCorrespondentNode().getObject();
        this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DROP");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkModObj));
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CDDLFileMaker.incrementAlterTable();
        this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
    }

    private void appendFK(StringBuffer oldbuffer, boolean prettyPrint, FKIndexAssociation fkObj, Table table, CompareObjectSelection obj) {
        this.pkColumns = null;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        FKProxyOraclev10g fk = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(fkObj.getLocalFKIndex().getObjectID());
        if (fk != null) {
            this.appendComment(oldbuffer, fk);
            CSSBFKIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            CompareObjectSelection tableSelection = (CompareObjectSelection)((CompareObjectSelection)obj.getParent()).getParent();
            CompareObjectSelection sourcePkIndObject = this.getPKObjectSelection(obj, fkObj.getKeyObject());
            if (sourcePkIndObject == null) {
                this.initFKandRefColumns(fkObj, tableSelection);
            } else if (sourcePkIndObject.isSelected() || !sourcePkIndObject.isModified()) {
                this.initFKandRefColumns(sourcePkIndObject, fkObj, tableSelection);
            }
            if (this.pkColumns != null && !this.pkColumns.isEmpty()) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
                advancedComment = buffer.toString() + "ADD" + ' ' + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(fk);
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ADD");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                this.appendColumnsSelection(buffer, this.fkColumns);
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendReferences(buffer, fk, prettyPrint);
                this.appendOnDelete(buffer, obj, prettyPrint);
                if (this.isRenamedTable) {
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                } else {
                    this.appendConstraintState(buffer, fk, prettyPrint);
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
                if ((fk.getRely().equals("YES") || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) && fk.getValidate().equals("NO")) {
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
                    advancedComment = buffer.toString();
                    if (fk.getRely().equals("YES")) {
                        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "RELY");
                    } else {
                        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NORELY");
                    }
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "RELY");
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CDDLFileMaker.incrementAlterTable();
                }
                this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
            }
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxyOraclev10g fk, boolean prettyPrint) {
        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
        Table refTable = fk.getFKTable();
        ModelIDObject refTableObj = fk.getStorageDesign().getTableProxySet().getProxy(refTable.getObjectID());
        if (refTableObj == null) {
            refTableObj = refTable;
        }
        CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObj));
        boolean refStructType = false;
        if (refTable.isBST()) {
            ColumnProxy[] columnProxies = fk.getColumnProxies();
            for (int i = 0; i < columnProxies.length; ++i) {
                Column column = columnProxies[i].getColumn();
                if (!column.isReference() || column.getUse() != 3) continue;
                refStructType = true;
            }
        }
        if (!refStructType) {
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            this.appendColumns(buffer, this.pkColumns);
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendOnDelete(StringBuffer buffer, CompareObjectSelection obj, boolean prettyPrint) {
        String onDelete = obj.getChoosedPropertyValue(PropertiesComparator.DELETE_RULE);
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            String mandatory = obj.getChoosedPropertyValue(PropertiesComparator.MANDATORY);
            boolean isMandatory = Boolean.parseBoolean(mandatory);
            onDelete = isMandatory ? "RESTRICT" : "SET NULL";
        }
        if (!onDelete.equalsIgnoreCase("RESTRICT") && !onDelete.equalsIgnoreCase("NO ACTION")) {
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ON");
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DELETE");
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, onDelete);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            // empty if block
        }
    }

    private void appendConstraintState(StringBuffer buffer, FKProxyOraclev10g fk, boolean prettyPrint) {
        CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if ("NO".equalsIgnoreCase(fk.getDeferrable())) {
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NOT");
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        } else {
            CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(fk.getInitially())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(fk.getEnable())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(fk.getValidate())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(fk.getEnable())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(fk.getValidate())) {
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(fk.getValidate())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (fk.getExceptionsTable() != null) {
            CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            buffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof FKIndexAssociation || ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof FKIndexAssociation;
    }

    private CompareObjectSelection getPKObjectSelection(CompareObjectSelection object, KeyObject pkIndex) {
        Table table = (Table)pkIndex.getContainerWithKeyObject();
        CompareObjectSelection fkParent = (CompareObjectSelection)object.getParent();
        CompareObjectSelection rootTables = (CompareObjectSelection)((CompareObjectSelection)fkParent.getParent()).getParent();
        CompareObjectSelection tableObj = rootTables.getChild(table);
        if (tableObj == null) {
            return null;
        }
        CompareObjectSelection pkIndexes = (CompareObjectSelection)tableObj.getChild(2);
        if (pkIndexes == null) {
            return null;
        }
        CompareObjectSelection pkIndexObj = pkIndexes.getChild(pkIndex);
        return pkIndexObj;
    }

    private void initFKandRefColumns(CompareObjectSelection pkObject, FKIndexAssociation fkIndAss, CompareObjectSelection tableSelection) {
        this.pkColumns = this.getColumnsForRestore(pkObject);
        this.fkColumns = new ArrayList();
        Table fkTable = (Table)fkIndAss.getContainerWithKeyObject();
        for (Column pkColumn : this.pkColumns) {
            Column fkColumn = fkTable.getFKColumn(fkIndAss, pkColumn);
            if (fkColumn != null) {
                CompareObjectSelection cs = tableSelection.getChildNested(fkColumn, 2);
                if (cs == null) continue;
                this.fkColumns.add(cs);
                continue;
            }
            System.out.println(fkIndAss.toString());
        }
    }

    private void initFKandRefColumns(CompareObjectSelection pkObject, FKIndexAssociation fkIndAss) {
        this.pkColumns = this.getColumnsForRestore(pkObject);
        this.fkColumns = new ArrayList();
        Table fkTable = (Table)fkIndAss.getContainerWithKeyObject();
        for (Column pkColumn : this.pkColumns) {
            Column fkColumn = fkTable.getFKColumn(fkIndAss, pkColumn);
            if (fkColumn != null) {
                this.fkColumns.add(fkColumn);
                continue;
            }
            System.out.println(fkIndAss.toString());
        }
    }

    private void initFKandRefColumns(FKIndexAssociation fkIndAss, CompareObjectSelection tableSelection) {
        this.pkColumns = new ArrayList();
        this.fkColumns = new ArrayList();
        if (fkIndAss.getRemoteIndex() != null) {
            this.pkColumns.addAll(fkIndAss.getRemoteIndex().getElementsCollection());
            Table fkTable = (Table)fkIndAss.getContainerWithKeyObject();
            for (Column pkColumn : this.pkColumns) {
                Column fkColumn = fkTable.getFKColumn(fkIndAss, pkColumn);
                if (fkColumn != null) {
                    CompareObjectSelection cs = tableSelection.getChildNested(fkColumn, 2);
                    if (cs == null) continue;
                    this.fkColumns.add(cs);
                    continue;
                }
                System.out.println(fkIndAss.toString());
            }
        }
    }

    private List getColumnsForRestore(CompareObjectSelection object) {
        CompareObjectSelection pkIndexes;
        CompareObjectSelection tableObj;
        ArrayList<Column> list = new ArrayList<Column>();
        KeyObject pkIndex = (KeyObject)object.getObject();
        if (pkIndex != null && (tableObj = (CompareObjectSelection)(pkIndexes = (CompareObjectSelection)object.getParent()).getParent()) != null) {
            List sourceColumns = tableObj.getChildObjects(0);
            for (Column pkCol : pkIndex.getElementsCollection()) {
                for (CompareObjectSelection obj : sourceColumns) {
                    if (pkCol != obj.getObject() || obj.canBeCreate() && !obj.isSelected() || obj.canBeDrop() && obj.getCorrespondentNode().isSelected()) continue;
                    list.add(pkCol);
                }
            }
        }
        return list;
    }

    private void appendColumns(StringBuffer buffer, List fkColumns) {
        Iterator it = fkColumns.iterator();
        boolean first = true;
        while (it.hasNext()) {
            Column col = (Column)it.next();
            if (!first) {
                CSSBFKIndexOraclev10g.appendString(buffer, ',');
                CSSBFKIndexOraclev10g.appendNewLine(buffer, true, 1);
            }
            CSSBFKIndexOraclev10g.appendString(buffer, ' ');
            if (col != null) {
                CSSBFKIndexOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(col));
            }
            first = false;
        }
    }

    private void appendColumnsSelection(StringBuffer buffer, List fkColSele) {
        Iterator it = this.fkColumns.iterator();
        boolean first = true;
        while (it.hasNext()) {
            CompareObjectSelection col = (CompareObjectSelection)it.next();
            if (!first) {
                CSSBFKIndexOraclev10g.appendString(buffer, ',');
                CSSBFKIndexOraclev10g.appendNewLine(buffer, true, 1);
            }
            CSSBFKIndexOraclev10g.appendString(buffer, ' ');
            if (col != null) {
                CSSBFKIndexOraclev10g.appendString(buffer, CSSBFKIndexOraclev10g.getFormattedSelectedName(col, this.storageDesign));
            }
            first = false;
        }
    }

    private void appendRenameFK(StringBuffer oldbuffer, boolean prettyPrint, FKIndexAssociation fkObj, Table table, CompareObjectSelection obj) {
        this.pkColumns = null;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
        FKProxyOraclev10g fk = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(fkObj.getLocalFKIndex().getObjectID());
        if (fk != null) {
            ModelIDObject sFKInd;
            CompareObjectSelection sourcePKIndObj;
            this.appendComment(oldbuffer, fk);
            CSSBFKIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            CompareObjectSelection targetPkIndObject = this.getPKObjectSelection(obj, fkObj.getKeyObject());
            if (targetPkIndObject != null && ((sourcePKIndObj = targetPkIndObject.getCorrespondentNode()).isSelected() || !sourcePKIndObj.isModified()) && (sFKInd = obj.getCorrespondentNode().getObject()) != null) {
                this.initFKandRefColumns(sourcePKIndObj, (FKIndexAssociation)sFKInd);
            }
            if (this.pkColumns != null && this.pkColumns.size() > 0) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, this.getTableName(obj));
                String fkName = obj.getCorrespondentNode().isSelected() ? CSSBFKIndexOraclev10g.getFormattedSelectedName(obj, this.storageDesign) : this.storageDesign.getFormatedName(fk);
                advancedComment = buffer.toString() + "ADD" + ' ' + "CONSTRAINT" + ' ' + fkName;
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "ADD");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, fkName);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                this.appendColumns(buffer, this.fkColumns);
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendReferences(buffer, fk, prettyPrint);
                this.appendOnDelete(buffer, obj, prettyPrint);
                TableProxyOracle targetProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(fk.getFKTable().getObjectID());
                if (this.isRenamedTable && (targetProxy.getBackupOption().equals(TableProxy.NONE) || targetProxy.getRestoreOption().equals(TableProxy.NONE))) {
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                    CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                } else {
                    this.appendConstraintState(buffer, fk, prettyPrint);
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBFKIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
                this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
            }
        }
    }

    private String getTableName(CompareObjectSelection index) {
        CompareObjectSelection table = index.getTableNode();
        if (table != null) {
            return this.getFormattedTableName(table, this.storageDesign);
        }
        return "";
    }
}

