/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBSnapshotOraclev10g
extends AbstractCSSBOracle {
    protected StorageDesignOraclev10g storageDesign;
    private CSSBCreateTableOraclev10g cssbCreateTableOraclev10g;

    public CSSBSnapshotOraclev10g(CSSBCreateTableOraclev10g cssbCreateTableOraclev10g) {
        this.cssbCreateTableOraclev10g = cssbCreateTableOraclev10g;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        SnapshotOraclev10g snapshot = (SnapshotOraclev10g)((CompareObjectSelection)object).getObject();
        this.storageDesign = (StorageDesignOraclev10g)snapshot.getStorageDesign();
        this.appendComment(oldbuffer, snapshot);
        if (!((CompareObjectSelection)object).canBeCreate()) {
            StringBuffer dropbuffer = new StringBuffer();
            CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "DROP");
            CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "MATERIALIZED");
            CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "VIEW");
            CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, this.storageDesign.getFormatedLongNameDDL(snapshot));
            this.appendToBuffer(oldbuffer, dropbuffer, dropbuffer.toString());
            CSSBSnapshotOraclev10g.appendNewLine(dropbuffer, prettyPrint, 0);
            this.appendLineFinisher(dropbuffer, prettyPrint);
            this.appendToBuffer(oldbuffer, dropbuffer, dropbuffer.toString());
        }
        this.appendCreateSnapshot(buffer, snapshot);
        advancedComment = buffer.toString();
        if (snapshot.getImplementedTable() != null || snapshot.getOnPrebuildTable() == null) {
            if (snapshot.getCluster() != null) {
                this.appendCreateCluster(oldbuffer, snapshot, prettyPrint);
                this.appendCluster(buffer, snapshot, prettyPrint);
            } else {
                this.appendSegment(buffer, snapshot, prettyPrint);
            }
            TableProxyOracle tableProxy = snapshot.getImplementedTable();
            if (tableProxy != null && this.cssbCreateTableOraclev10g != null) {
                this.cssbCreateTableOraclev10g.appendPartitionList(buffer, (TableProxyOraclev10g)tableProxy, prettyPrint);
            } else {
                this.appendPartitioning(buffer, snapshot, prettyPrint);
            }
            this.appendParallelClause(buffer, snapshot, prettyPrint);
            if (!snapshot.getBuild().equals("IMMEDIATE")) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BUILD");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, snapshot.getBuild());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BUILD");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else {
            this.appendPrebuild(buffer, snapshot, prettyPrint);
        }
        this.appendUsingIndex(buffer, snapshot, prettyPrint);
        this.appendRefreshClause(buffer, snapshot, prettyPrint);
        this.appendForUpdate(buffer, snapshot, prettyPrint);
        this.appendQueryRewrite(buffer, snapshot, prettyPrint);
        this.appendSubquery(buffer, snapshot, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CDDLFileMaker.incrementCreateSnapshot();
        CSSBSnapshotOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        if (snapshot.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(oldbuffer, snapshot, prettyPrint);
        }
        this.appendPermissions(oldbuffer, snapshot, prettyPrint);
    }

    private void appendCreateSnapshot(StringBuffer buffer, SnapshotOraclev10g snapshot) {
        this.appendCreate(buffer);
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "MATERIALIZED");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "VIEW");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(snapshot));
    }

    private void appendSegment(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        SegmentOracle segment = snapshot.getSegment();
        if (segment == null && snapshot.getImplementedTable() != null) {
            segment = snapshot.getImplementedTable().getSegment();
        }
        this.appendPhysicalAttributes(buffer, segment, false, prettyPrint);
        this.appendTableSpace(buffer, snapshot, prettyPrint);
        Iterator lobsIt = snapshot.getLobsCollection().iterator();
        while (lobsIt.hasNext()) {
            LobStorageOracle lob = (LobStorageOracle)lobsIt.next();
            this.appendLobStorage(buffer, lob, prettyPrint);
        }
        this.appendAttributes(buffer, snapshot, prettyPrint);
    }

    private void appendParallelClause(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(snapshot.getParalelClause())) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
            if (snapshot.getDegree() > 0) {
                this.appendStringWithSpace(buffer, snapshot.getDegree());
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    private void appendPrebuild(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        if (snapshot.getImplementedTable() != null || snapshot.getOnPrebuildTable() == null) {
            if (!snapshot.getBuild().equals("IMMEDIATE")) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BUILD");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, snapshot.getBuild());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BUILD");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "ON");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PREBUILT");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLE");
            if ("YES".equalsIgnoreCase(snapshot.getReducedPrecision())) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "WITH REDUCED PRECISION");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "WITHOUT REDUCED PRECISION");
            }
        }
    }

    private void appendUsingIndex(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        if (snapshot.getUseIndex().equals("YES")) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "USING");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "INDEX");
            if (snapshot.getIndexTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(snapshot.getIndexTablespace()));
            }
            if (snapshot.getIndexSegment() != null) {
                this.appendPhysicalAttributes(buffer, snapshot.getIndexSegment(), true, prettyPrint);
            }
        } else if (snapshot.getUseIndex().equals("NO")) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "USING");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NO");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "INDEX");
        }
    }

    private void appendRefreshClause(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        if ("NEVER".equalsIgnoreCase(snapshot.getRefresh())) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NEVER");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "REFRESH");
        } else if ("YES".equals(snapshot.getRefresh())) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "REFRESH");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, snapshot.getRefreshType());
            if (!"".equalsIgnoreCase(snapshot.getAction())) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, snapshot.getAction());
            } else if (!"".equalsIgnoreCase(snapshot.getStartDate()) || !"".equalsIgnoreCase(snapshot.getNextDate())) {
                if (!"".equalsIgnoreCase(snapshot.getStartDate())) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "START WITH");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, snapshot.getStartDate());
                }
                if (!"".equalsIgnoreCase(snapshot.getNextDate())) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, snapshot.getNextDate());
                }
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "ON DEMAND");
            }
            if (!snapshot.getWith().equalsIgnoreCase("")) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "WITH");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, snapshot.getWith());
            }
            if (snapshot.getUsingConstraint().equalsIgnoreCase("TRUSTED")) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, true, 2);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "USING");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TRUSTED");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "CONSTRAINTS");
            } else if ("YES".equalsIgnoreCase(snapshot.getDefaultSegment())) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, true, 2);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "USING");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                if (!"LOCAL".equalsIgnoreCase(snapshot.getSegmentType())) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, snapshot.getSegmentType());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "LOCAL");
                }
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "ROLLBACK");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SEGMENT");
            } else if (snapshot.getRollbackSegment() != null) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, true, 2);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "USING");
                if (!"LOCAL".equalsIgnoreCase(snapshot.getSegmentType())) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, snapshot.getSegmentType());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "LOCAL");
                }
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "ROLLBACK");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SEGMENT");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(snapshot.getRollbackSegment()));
            }
        }
    }

    private void appendForUpdate(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(snapshot.getForUpdate())) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "FOR");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "UPDATE");
        }
    }

    private void appendQueryRewrite(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        if ("ENABLE".equalsIgnoreCase(snapshot.getQueryRewrite())) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "QUERY REWRITE");
        }
    }

    private void appendSubquery(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "AS");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, snapshot.getSubquery());
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof SnapshotOraclev10g;
    }

    private void appendLobStorage(StringBuffer buffer, LobStorageOracle lobStorage, boolean prettyPrint) {
        if (lobStorage != null) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "LOB");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getColumn()));
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "STORE AS");
            if (lobStorage instanceof LobStorageOraclev11g) {
                if (((LobStorageOraclev11g)lobStorage).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                } else if (((LobStorageOraclev11g)lobStorage).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                }
            }
            if (!lobStorage.getLobSegmentName().equalsIgnoreCase("")) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getLobSegmentName()));
            }
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (lobStorage.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (lobStorage.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, lobStorage.getSCInitialExtent());
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (lobStorage.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, lobStorage.getSCNextExtent());
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, lobStorage.getSCPctIncrease());
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCMinExtents());
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCMaxExtents());
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCFreeLists());
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && lobStorage.getSCFreelistGroups() > 1) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCFreelistGroups());
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCBufferPool());
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (props) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getChunk() > 0) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "CHUNK");
                this.appendStringWithSpace(buffer, lobStorage.getChunk());
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getOldVersions().equalsIgnoreCase("RETENTION")) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "RETENTION");
            } else {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PCTVERSION");
                this.appendStringWithSpace(buffer, lobStorage.getPCTVersion());
            }
            if (lobStorage.getFreepools() > 0 && lobStorage.getSCFreelistGroups() <= 1) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                this.appendStringWithSpace(buffer, lobStorage.getFreepools());
            }
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if ("ENABLE".equalsIgnoreCase(lobStorage.getStorageInRow())) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "STORAGE IN ROW");
            if (this.isSecureFile(lobStorage.getLobStorageType())) {
                if (lobStorage.getCompression().equalsIgnoreCase("YES")) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, lobStorage.getCompressionType());
                }
                if (lobStorage.getDuplication().equalsIgnoreCase("DEDUPLICATE")) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "DEDUPLICATE");
                }
            }
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, lobStorage.getCache());
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && (!"CACHE".equalsIgnoreCase(lobStorage.getCache()) || this.storageDesign instanceof StorageDesignOraclev12c)) {
                String logging = lobStorage.getLogging();
                if (logging.equalsIgnoreCase("YES")) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                } else if (logging.equalsIgnoreCase("NO")) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else if (logging.equalsIgnoreCase("FILESYSTEM_LIKE_LOGGING") && this.isSecureFile(lobStorage.getLobStorageType())) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "FILESYSTEM_LIKE_LOGGING");
                }
            }
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private boolean isSecureFile(String lobStorageType) {
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            return !lobStorageType.equalsIgnoreCase("BASICFILE");
        }
        return lobStorageType.equalsIgnoreCase("SECUREFILE");
    }

    private void appendTableSpace(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        TableSpaceOracle tableSpace;
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL() && (tableSpace = snapshot.getTablespace()) != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName())) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
        }
    }

    private void appendAttributes(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            if ("YES".equalsIgnoreCase(snapshot.getLogging())) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(snapshot.getLogging())) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
            }
        }
        if ("YES".equalsIgnoreCase(snapshot.getCache())) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "CACHE");
        } else if ("NO".equalsIgnoreCase(snapshot.getCache()) || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
        }
    }

    private void appendCluster(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        ClusterOracle cluster = snapshot.getCluster();
        if (cluster != null) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "CLUSTER");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            if (!"".equalsIgnoreCase(snapshot.getClusterColumns())) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getClusterColumns()));
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendCreateCluster(StringBuffer oldbuffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        ClusterOracle cluster = snapshot.getCluster();
        if (cluster != null) {
            TableSpaceOracle tableSpace;
            StringBuffer buffer = new StringBuffer();
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "CREATE");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "CLUSTER");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            this.appendPhysicalAttributes(buffer, cluster.getSegment(), false, prettyPrint);
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL() && (tableSpace = cluster.getTableSpace()) != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName())) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        }
    }

    private void appendPhysicalAttributes(StringBuffer buffer, SegmentOracle segment, boolean usingIndex, boolean prettyPrint) {
        if (segment != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (!usingIndex) {
                if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PCTFREE");
                    this.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PCTUSED");
                    this.appendStringWithSpace(buffer, segment.getPCTUsed());
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 1) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    this.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "1");
                }
            }
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "STORAGE");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
            boolean props = false;
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                this.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, segment.getSCNextExtent());
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                this.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                this.appendStringWithSpace(buffer, segment.getSCMinExtents());
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                this.appendStringWithSpace(buffer, segment.getSCFreeLists());
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                this.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    protected void appendPartitioning(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        PartitionListOraclev10g partitionList = (PartitionListOraclev10g)snapshot.getPartitionList();
        if (partitionList != null) {
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType) || "COMPOSITE BY HASH".equalsIgnoreCase(partitionType) || "COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "RANGE");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                if (subpartitionType.equalsIgnoreCase("HASH")) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BY");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "HASH");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                    if ("NO".equals(partitionList.getUseSubpartStorageTemplate())) {
                        if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                            this.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                            if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                            }
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "1");
                        }
                    }
                } else if (subpartitionType.equalsIgnoreCase("LIST")) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BY");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "LIST");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                }
                boolean composite = !subpartitionType.equalsIgnoreCase("");
                this.appendPartitions(buffer, partitionList, true, composite, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "HASH");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
                this.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                if (!"".equals(partitionList.getHashPTableSpaces())) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "HASH");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendHashPartitions(buffer, partitionList, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "LIST");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendListPartitions(buffer, snapshot, partitionList, prettyPrint);
            }
        }
    }

    protected void appendPartStorage(StringBuffer buffer, AbstractStorageObjectOracle template, boolean prettyPrint) {
        TableSpaceOracle tableSpace = null;
        TableSpaceOracle overflowTableSpace = null;
        String dataSegmentCompression = "";
        StorageObjectCollection lobs = null;
        if (template instanceof PartitionOraclev10g) {
            tableSpace = ((PartitionOraclev10g)template).getTableSpace();
            dataSegmentCompression = ((PartitionOraclev10g)template).getDataSegmentCompression();
            lobs = ((PartitionOraclev10g)template).getLobs();
        } else if (template instanceof HashPartitionOraclev10g) {
            tableSpace = ((HashPartitionOraclev10g)template).getTableSpace();
            overflowTableSpace = ((HashPartitionOraclev10g)template).getIotOverflowTablespace();
            lobs = ((HashPartitionOraclev10g)template).getLobs();
        } else if (template instanceof ListStorageTemplatePartitionOraclev10g) {
            tableSpace = ((ListStorageTemplatePartitionOraclev10g)template).getTablespace();
            dataSegmentCompression = ((ListStorageTemplatePartitionOraclev10g)template).getDataSegmentCompression();
            lobs = ((ListStorageTemplatePartitionOraclev10g)template).getLobs();
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            if (tableSpace != null) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (overflowTableSpace != null) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
            }
        }
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            if (dataSegmentCompression.equalsIgnoreCase("NO")) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (dataSegmentCompression.equalsIgnoreCase("YES")) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
        }
        if (lobs != null) {
            Iterator it = lobs.iterator();
            while (it.hasNext()) {
                HashPartitionLobItemOraclev10g lobItem;
                Object storageObject = it.next();
                if (storageObject instanceof LobStorageOraclev10g) {
                    LobStorageOraclev10g lobStorage = (LobStorageOraclev10g)storageObject;
                    if (lobStorage.getTableSpace() == null && lobStorage.getLobSegmentName().trim().equals("")) continue;
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    this.appendLobPartitioningStorage(buffer, lobStorage, lobStorage.getColumn(), lobStorage.getLobSegmentName(), lobStorage.getTableSpace(), prettyPrint);
                    continue;
                }
                if (!(storageObject instanceof HashPartitionLobItemOraclev10g) || (lobItem = (HashPartitionLobItemOraclev10g)storageObject).getTableSpace() == null) continue;
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                this.appendLobPartitioningStorage(buffer, lobItem, lobItem.getLobColumn(), "", lobItem.getTableSpace(), prettyPrint);
            }
        }
    }

    protected void appendListPartitions(StringBuffer buffer, SnapshotOraclev10g snapshot, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        Iterator it = snapshot.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            ListPartitionOraclev10g partition = (ListPartitionOraclev10g)it.next();
            if (first) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "VALUES");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
            if (!"".equalsIgnoreCase(partition.getColumns())) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, partition.getColumns());
            } else {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            }
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
            if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (partition.getSegment() == null) {
                if (partition.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTablespace()));
                }
                if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if (partition.getLogging().equalsIgnoreCase("YES")) {
                        CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                    } else if (partition.getLogging().equalsIgnoreCase("NO")) {
                        CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            Iterator lobs = partition.getLobStorages().iterator();
            while (lobs.hasNext()) {
                LobStorageOracle lob = (LobStorageOracle)lobs.next();
                this.appendLobStorage(buffer, lob, prettyPrint);
            }
            if (partitionList.getSubpartitionType().length() <= 0) continue;
            this.appendSubPartitions(buffer, partition, partitionList, prettyPrint);
        }
        if (!first) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, boolean appendValueList, boolean composite, boolean prettyPrint) {
        StorageObjectCollection partitions = partitionList.getSnapshot().getPartitionsCollection();
        if (partitions.size() > 0) {
            Object[] partitionsList = partitions.toArray();
            Arrays.sort(partitionsList, new PossitionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < partitionsList.length; ++i) {
                sortedList.add(partitionsList[i]);
            }
            Iterator setIt = sortedList.iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                Object partitionObj = setIt.next();
                if (!(partitionObj instanceof PartitionOracle)) continue;
                PartitionOracle partition = (PartitionOracle)partitionObj;
                if (first) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                if (appendValueList) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, partition.getValueList());
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                }
                this.appendPhysicalAttributes(buffer, partition.getSegment(), false, prettyPrint);
                Iterator lobs = partition.getLobs().iterator();
                while (lobs.hasNext()) {
                    LobStorageOracle lob = (LobStorageOracle)lobs.next();
                    this.appendLobStorage(buffer, lob, prettyPrint);
                }
                if (!composite) continue;
                this.appendSubPartitions(buffer, partition, partitionList, prettyPrint);
            }
            if (!first) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendSubPartitions(StringBuffer buffer, AbstractStorageObjectOracle partition, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        if (partitionList.getSubpartitionType().equalsIgnoreCase("HASH")) {
            PartitionOraclev10g rangePartition;
            if (partition instanceof PartitionOraclev10g && !this.appendHashSubPartitions(buffer, (rangePartition = (PartitionOraclev10g)partition).getPartitions(), partitionList, prettyPrint) && rangePartition.getSubPartitionsQuantity() > 0) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                this.appendStringWithSpace(buffer, rangePartition.getSubPartitionsQuantity());
                if (!"".equalsIgnoreCase(rangePartition.getSubPartitionsTableSpaces())) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(rangePartition.getSubPartitionsTableSpaces()));
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                }
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("LIST") && partition instanceof PartitionOraclev10g) {
            this.appendListSubPartitions(buffer, ((PartitionOraclev10g)partition).getListPartitions(), prettyPrint);
        }
    }

    protected void appendListSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, boolean prettyPrint) {
        if (subpartitions.size() > 0) {
            boolean firstListPart = true;
            Iterator listSubpartitions = subpartitions.iterator();
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
            while (listSubpartitions.hasNext()) {
                ListStorageTemplatePartitionOraclev10g listSubpartition = (ListStorageTemplatePartitionOraclev10g)listSubpartitions.next();
                if (!firstListPart) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ',');
                } else {
                    firstListPart = false;
                }
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!listSubpartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(listSubpartition));
                }
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "VALUES");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, listSubpartition.getValueList());
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, listSubpartition, prettyPrint);
            }
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected boolean appendHashSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        boolean result = false;
        if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
            Iterator it = subpartitions.iterator();
            boolean first = true;
            while (it.hasNext()) {
                HashPartitionOracle hashPartition = (HashPartitionOracle)it.next();
                if (first) {
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                    result = true;
                } else {
                    this.appendComma(buffer);
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
                }
                if (hashPartition.getTableSpace() == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
                Iterator lobs = hashPartition.getLobItems().iterator();
                while (lobs.hasNext()) {
                    HashPartitionLobItemOracle lobStorage = (HashPartitionLobItemOracle)lobs.next();
                    CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "LOB");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                    this.appendStringWithSpace(buffer, lobStorage);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                    if (lobStorage.getTableSpace() == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "STORE AS");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                    CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
                }
            }
            if (!first) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
        return result;
    }

    protected boolean appendHashPartitions(StringBuffer buffer, PartitionListOracle partitionList, boolean prettyPrint) {
        boolean result = false;
        SnapshotOracle snapshot = partitionList.getSnapshot();
        Iterator it = snapshot.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            HashPartitionOracle hashPartition = (HashPartitionOracle)it.next();
            if (first) {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                this.appendComma(buffer);
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, HashPartitionOracle hashPartition, boolean prettyPrint) {
        HashPartitionLobItemSetOracle hashPLobItemSet = ((StorageDesignOracle)hashPartition.getStorageDesign()).getHashPartitionLobItemSet();
        Iterator setIt = hashPLobItemSet.iterator();
        while (setIt.hasNext()) {
            HashPartitionLobItemOracle hashPLobItem = (HashPartitionLobItemOracle)setIt.next();
            if (hashPLobItem.getHashPartition() == null || !hashPLobItem.getHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, Object column, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "LOB");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
        if (column instanceof ColumnProxy) {
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((ColumnProxy)column));
        } else {
            String columnName = "";
            if (column != null) {
                columnName = column.toString();
            }
            if (columnName.length() > 0) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnName));
            } else {
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("--  ERROR: Lob ");
                buffer.append(lobObject.getName());
                buffer.append(" has no Column specified");
                CDDLFileMaker.incrementErrors();
            }
        }
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "STORE AS");
        if (lobObject instanceof LobStorageOraclev11g) {
            String lobStorageType = ((LobStorageOraclev11g)lobObject).getLobStorageType();
            if (lobStorageType.equalsIgnoreCase("SECUREFILE")) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
            } else if (lobStorageType.equalsIgnoreCase("BASICFILE")) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
            }
        }
        if (!lobSegName.equalsIgnoreCase("")) {
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)snapshot.getStorageDesign()).getPermissionsSet();
        Iterator it = permissionsSet.iterator();
        while (it.hasNext()) {
            PermissionsOraclev10g permissions = (PermissionsOraclev10g)it.next();
            if (permissions.getSnapshot() == null || !permissions.getSnapshot().equals(snapshot)) continue;
            if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                CSSBSnapshotOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBSnapshotOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "GRANT");
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions, prettyPrint);
                this.appendTo(buffer, permissions);
                advancedComment = buffer.toString();
                this.appendHierrarchyOption(buffer, permissions);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            CSSBSnapshotOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBSnapshotOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendComment(oldbuffer, permissions);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "GRANT");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions, prettyPrint);
            this.appendTo(buffer, permissions);
            advancedComment = buffer.toString();
            this.appendHierrarchyOption(buffer, permissions);
            this.appendGrantOption(buffer, permissions);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        if (permissions.getSnapshot() != null) {
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "ON");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getSnapshot()));
        }
    }

    private void appendTo(StringBuffer buffer, PermissionsOraclev10g privileges) {
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TO");
        if ("YES".equalsIgnoreCase(privileges.getPublic())) {
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "PUBLIC");
        } else {
            if (privileges.getUser() != null) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(privileges.getUser()));
            }
            if (privileges.getRole() != null) {
                CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(privileges.getRole()));
            }
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if (permissions.getRole() == null) {
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            buffer.append(NEWLINE);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOracle)one).getPosition() > ((PartitionOracle)two).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)one).getPosition() < ((PartitionOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

