/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBSnapshotOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBCreateTableOraclev11g;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;

public class CSSBSnapshotOraclev11g
extends CSSBSnapshotOraclev10g {
    public CSSBSnapshotOraclev11g(CSSBCreateTableOraclev11g cssbCreateTableOraclev11g) {
        super(cssbCreateTableOraclev11g);
    }

    @Override
    protected void appendPartitioning(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        PartitionListOraclev11g partitionList = (PartitionListOraclev11g)snapshot.getPartitionList();
        if (partitionList != null) {
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "RANGE");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                String intervalExpression = partitionList.getIntervalExpression().trim();
                if (intervalExpression.length() > 0) {
                    CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "INTERVAL");
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, intervalExpression);
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                    if (partitionList.getIntervalTablespaces().length() > 0) {
                        CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIntervalTablespaces()));
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                }
                this.appendSubPartitionDefinition(buffer, snapshot, partitionList, prettyPrint);
                boolean composite = !subpartitionType.equalsIgnoreCase("");
                this.appendPartitions(buffer, partitionList, true, composite, prettyPrint);
            } else if (partitionType.startsWith("HASH")) {
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "HASH");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendSubPartitionDefinition(buffer, snapshot, partitionList, prettyPrint);
                if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                    CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITIONS");
                    this.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                    if (!"".equals(partitionList.getHashPTableSpaces())) {
                        CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                    if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                        CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "OVERFLOW");
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                } else {
                    this.appendHashPartitions(buffer, partitionList, prettyPrint);
                }
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "LIST");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendSubPartitionDefinition(buffer, snapshot, partitionList, prettyPrint);
                this.appendListPartitions(buffer, snapshot, partitionList, prettyPrint);
            } else if ("REFERENCE".equalsIgnoreCase(partitionType)) {
                Table remoteTable;
                FKProxyOracle refConstraint = partitionList.getRefConstraint();
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "REFERENCE");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                Table table = remoteTable = refConstraint == null ? null : refConstraint.getFKTable();
                if (remoteTable != null) {
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(refConstraint));
                }
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, false, false, prettyPrint);
            } else if ("SYSTEM".equalsIgnoreCase(partitionType)) {
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SYSTEM");
                int systemPartitions = partitionList.getSystemPartitions();
                if (systemPartitions > 1) {
                    CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITIONS");
                    this.appendStringWithSpace(buffer, systemPartitions);
                } else {
                    this.appendPartitions(buffer, partitionList, false, false, prettyPrint);
                }
            }
        }
    }

    private void appendSubPartitionDefinition(StringBuffer buffer, SnapshotOraclev10g snapshot, PartitionListOraclev11g partitionList, boolean prettyPrint) {
        String subpartitionType = partitionList.getSubpartitionType();
        if (subpartitionType.equalsIgnoreCase("HASH")) {
            CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "HASH");
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
            if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
                if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                    CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    this.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                    if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                        CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "1");
                }
            }
        } else if (subpartitionType.equalsIgnoreCase("LIST")) {
            CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "LIST");
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
        } else if (subpartitionType.equalsIgnoreCase("RANGE")) {
            CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "RANGE");
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    protected void appendSubPartitions(StringBuffer buffer, AbstractStorageObjectOracle partition, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        if (partitionList.getSubpartitionType().equalsIgnoreCase("HASH")) {
            StorageObjectCollection subpartitions = null;
            int subPartitionsQuantity = 0;
            String subPartitionsTableSpaceIDs = "";
            if (partition instanceof PartitionOraclev11g) {
                PartitionOraclev11g rangePartition = (PartitionOraclev11g)partition;
                subpartitions = rangePartition.getPartitions();
                subPartitionsQuantity = rangePartition.getSubPartitionsQuantity();
                subPartitionsTableSpaceIDs = rangePartition.getSubPartitionsTableSpaces();
            } else if (partition instanceof ListPartitionOraclev11g) {
                ListPartitionOraclev11g listPartition = (ListPartitionOraclev11g)partition;
                subpartitions = listPartition.getHashSubpartitions();
                subPartitionsQuantity = listPartition.getSubPartitionsQuantity();
                subPartitionsTableSpaceIDs = listPartition.getSubPartitionsTableSpaces();
            }
            if (!this.appendHashSubPartitions(buffer, subpartitions, partitionList, prettyPrint) && subPartitionsQuantity > 0) {
                CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                this.appendStringWithSpace(buffer, subPartitionsQuantity);
                if (!"".equalsIgnoreCase(subPartitionsTableSpaceIDs)) {
                    CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionsTableSpaceIDs));
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                }
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("LIST")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendListSubPartitions(buffer, ((PartitionOraclev11g)partition).getListPartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendListSubPartitions(buffer, ((ListPartitionOraclev11g)partition).getListSubpartitions(), prettyPrint);
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("RANGE")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, ((PartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, ((ListPartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            }
        }
    }

    private void appendRangeSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, boolean prettyPrint) {
        if (subpartitions.size() > 0) {
            Object[] subpartitionsList = subpartitions.toArray();
            Arrays.sort(subpartitionsList, new PositionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < subpartitionsList.length; ++i) {
                sortedList.add(subpartitionsList[i]);
            }
            Iterator rangeSubpartitions = sortedList.iterator();
            boolean firstPart = true;
            CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
            while (rangeSubpartitions.hasNext()) {
                PartitionOraclev11g rangeSubpartition = (PartitionOraclev11g)rangeSubpartitions.next();
                if (!firstPart) {
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ',');
                } else {
                    firstPart = false;
                }
                CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!rangeSubpartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(rangeSubpartition));
                }
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, rangeSubpartition.getValueList());
                CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, rangeSubpartition, prettyPrint);
            }
            CSSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }

    static class PositionComparator
    implements Comparator {
        PositionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOracle)one).getPosition() > ((PartitionOracle)two).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)one).getPosition() < ((PartitionOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

