/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage;

import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageObject;

public abstract class StoragePropertiesComparator
extends PropertiesComparator {
    private StorageObject left_so;
    private StorageObject right_so;

    public StoragePropertiesComparator(StorageObject left_so, StorageObject right_so) {
        super(null, null);
        this.left_so = left_so;
        this.right_so = right_so;
    }

    @Override
    public String getLeftName() {
        if (this.left_so != null) {
            return this.left_so.getName();
        }
        return "";
    }

    @Override
    public String getRightName() {
        if (this.right_so != null) {
            return this.right_so.getName();
        }
        return "";
    }

    @Override
    protected void initNameProperty() {
        PropertyHolder ph = new PropertyHolder(NAME);
        ph.setLeftValue(this.left_so != null ? this.left_so.getName() : "");
        ph.setRightValue(this.right_so != null ? this.right_so.getName() : "");
        if (this.isExcludedFromComparison(NAME) || this.isExcludeNamesFromComparison(ph)) {
            ph.setExcluded(true);
        } else if (this.left_so != null && this.right_so != null) {
            if (this.caseSensitive) {
                if (!this.left_so.getName().equals(this.right_so.getName())) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            } else if (!this.left_so.getName().equalsIgnoreCase(this.right_so.getName())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        }
        this.propertiesList.add(ph);
    }

    @Override
    protected void initCommentsAndNotes() {
        PropertyHolder ph = new PropertyHolder(COMMENT);
        ph.setLeftValue(this.left_so != null ? this.left_so.getComment() : "");
        ph.setRightValue(this.right_so != null ? this.right_so.getComment() : "");
        if (this.isExcludedFromComparison(COMMENT)) {
            ph.setExcluded(true);
        } else if (this.left_so != null && this.right_so != null && !this.left_so.getComment().equals(this.right_so.getComment())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COMMENT_IN_RDBMS);
        ph.setLeftValue(this.left_so != null ? this.left_so.getCommentInRDBMS() : "");
        ph.setRightValue(this.right_so != null ? this.right_so.getCommentInRDBMS() : "");
        if (this.isExcludedFromComparison(COMMENT_IN_RDBMS)) {
            ph.setExcluded(true);
        } else if (this.left_so != null && this.right_so != null && !this.left_so.getCommentInRDBMS().equals(this.right_so.getCommentInRDBMS())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(NOTES);
        ph.setLeftValue(this.left_so != null ? this.left_so.getNotes() : "");
        ph.setRightValue(this.right_so != null ? this.right_so.getNotes() : "");
        if (this.isExcludedFromComparison(NOTES)) {
            ph.setExcluded(true);
        } else if (this.left_so != null && this.right_so != null && !this.left_so.getNotes().equals(this.right_so.getNotes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_so != null && this.right_so != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(NAME)) {
                    this.right_so.setName(this.left_so.getName());
                    continue;
                }
                if (ph.getName().equals(COMMENT)) {
                    this.right_so.setComment(this.left_so.getComment());
                    continue;
                }
                if (ph.getName().equals(COMMENT_IN_RDBMS)) {
                    this.right_so.setCommentInRDBMS(this.left_so.getCommentInRDBMS());
                    continue;
                }
                if (!ph.getName().equals(NOTES)) continue;
                this.right_so.setNotes(this.left_so.getNotes());
            }
            this.right_so.setDirty(this.isDirty());
        }
    }

    @Override
    public String getID() {
        if (this.left_so != null && this.right_so != null) {
            return this.left_so.getObjectID() + this.right_so.getObjectID();
        }
        if (this.left_so != null) {
            return this.left_so.getObjectID();
        }
        if (this.right_so != null) {
            return this.right_so.getObjectID();
        }
        return "null";
    }

    @Override
    protected boolean hasToBeDrop() {
        return this.left_so == null && this.right_so != null;
    }

    public void setDroped(boolean isDrop) {
        this.isDroped = isDrop;
    }

    public boolean isDroped() {
        return this.isDroped;
    }

    @Override
    public String getChoosedPropertyValue(String propertyName) {
        for (EngPropertyHolder st_ph : this.propertiesList) {
            if (!st_ph.getName().equals(propertyName)) continue;
            if (this.left_so == null) {
                return st_ph.getRightValue();
            }
            if (this.right_so == null) {
                return st_ph.getLeftValue();
            }
            if (st_ph.isSelected()) {
                return st_ph.getLeftValue();
            }
            return st_ph.getRightValue();
        }
        return "";
    }

    @Override
    public boolean isTargetSelected(String propertyName) {
        for (EngPropertyHolder st_ph : this.propertiesList) {
            if (!st_ph.getName().equals(propertyName)) continue;
            if (this.left_so == null) {
                return true;
            }
            if (this.right_so == null) {
                return false;
            }
            return !st_ph.isSelected();
        }
        return true;
    }
}

