/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;

public class SequenceComparator
extends StoragePropertiesComparator {
    private SequenceOracle sourceSequence;
    private SequenceOracle targetSequence;
    protected static List propertiesFilterList = new ArrayList();

    public SequenceComparator(StorageObject sourceSequence, StorageObject targetSequence) {
        super(sourceSequence, targetSequence);
        this.sourceSequence = (SequenceOracle)sourceSequence;
        this.targetSequence = (SequenceOracle)targetSequence;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(USER_NAME);
        String su_name = "";
        String tu_name = "";
        if (this.sourceSequence != null && this.sourceSequence.getUser() != null) {
            su_name = this.sourceSequence.getUser().getName();
        }
        if (this.targetSequence != null && this.targetSequence.getUser() != null) {
            tu_name = this.targetSequence.getUser().getName();
        }
        ph.setLeftValue(su_name);
        ph.setRightValue(tu_name);
        if (this.isExcludedFromComparison(USER_NAME)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !su_name.equalsIgnoreCase(tu_name)) {
            ph.setModified(true);
            if (this.useSchema) {
                ph.setSelected(true);
            } else {
                ph.setFiltered(true);
            }
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(START_WITH);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getStartWith() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getStartWith() : "");
        if (this.isExcludedFromComparison(START_WITH)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getStartWith().equals(this.targetSequence.getStartWith())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(INCREMENT_BY);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getIncrementBy() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getIncrementBy() : "");
        if (this.isExcludedFromComparison(INCREMENT_BY)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getIncrementBy().equals(this.targetSequence.getIncrementBy())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MAX_VALUE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getMaxValue() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getMaxValue() : "");
        if (this.isExcludedFromComparison(MAX_VALUE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getMaxValue().equals(this.targetSequence.getMaxValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MIN_VALUE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getMinValue() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getMinValue() : "");
        if (this.isExcludedFromComparison(MIN_VALUE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getMinValue().equals(this.targetSequence.getMinValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(CYCLE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getCycle() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getCycle() : "");
        if (this.isExcludedFromComparison(CYCLE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getCycle().equals(this.targetSequence.getCycle())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(NOCACHE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getNoCache() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getNoCache() : "");
        if (this.isExcludedFromComparison(NOCACHE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getNoCache().equals(this.targetSequence.getNoCache())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(CACHE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getCache() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getCache() : "");
        if (this.isExcludedFromComparison(CACHE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getCache().equals(this.targetSequence.getCache())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(ORDER);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getOrder() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getOrder() : "");
        if (this.isExcludedFromComparison(ORDER)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getOrder().equals(this.targetSequence.getOrder())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (this.getStorageDesign() instanceof StorageDesignOraclev12c) {
            ph = new PropertyHolder(SESSION);
            ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getSession() : "");
            ph.setRightValue(this.targetSequence != null ? this.targetSequence.getSession() : "");
            if (this.isExcludedFromComparison(SESSION)) {
                ph.setExcluded(true);
            } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getSession().equals(this.targetSequence.getSession())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    private StorageDesignOracle getStorageDesign() {
        if (this.sourceSequence != null) {
            return this.sourceSequence.getStorageDesignOracle();
        }
        if (this.targetSequence != null) {
            return this.targetSequence.getStorageDesignOracle();
        }
        return null;
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromSequenceToSequence();
    }

    private void copyPropertiesFromSequenceToSequence() {
        if (this.sourceSequence != null && this.targetSequence != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(USER_NAME)) {
                    this.targetSequence.setUser(this.sourceSequence.getUser());
                    continue;
                }
                if (ph.getName().equals(START_WITH)) {
                    this.targetSequence.setStartWith(this.sourceSequence.getStartWith());
                    continue;
                }
                if (ph.getName().equals(INCREMENT_BY)) {
                    this.targetSequence.setIncrementBy(this.sourceSequence.getIncrementBy());
                    continue;
                }
                if (ph.getName().equals(MAX_VALUE)) {
                    this.targetSequence.setMaxValue(this.sourceSequence.getMaxValue());
                    continue;
                }
                if (ph.getName().equals(MIN_VALUE)) {
                    this.targetSequence.setMinValue(this.sourceSequence.getMinValue());
                    continue;
                }
                if (ph.getName().equals(CYCLE)) {
                    this.targetSequence.setCycle(this.sourceSequence.getCycle());
                    continue;
                }
                if (ph.getName().equals(NOCACHE)) {
                    this.targetSequence.setNoCache(this.sourceSequence.getNoCache());
                    continue;
                }
                if (ph.getName().equals(CACHE)) {
                    this.targetSequence.setCache(this.sourceSequence.getCache());
                    continue;
                }
                if (ph.getName().equals(ORDER)) {
                    this.targetSequence.setOrder(this.sourceSequence.getOrder());
                    continue;
                }
                if (!ph.getName().equals(SESSION)) continue;
                this.targetSequence.setSession(this.sourceSequence.getSession());
            }
        }
    }

    public SequenceOracle getSequenceForProperty(String propertyName) {
        if (this.isTargetSelected(propertyName)) {
            return this.targetSequence;
        }
        return this.sourceSequence;
    }
}

