/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.PropertyFilter;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StorageTemplateComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;

public class SnapshotComparator
extends StoragePropertiesComparator {
    private SnapshotOracle sourceSnapshot;
    private SnapshotOracle targetSnapshot;
    protected static List propertiesFilterList = new ArrayList();
    protected static List storagePropertiesFilterList = new ArrayList();
    private Map objectsMap;

    public SnapshotComparator(StorageObject sourceSnapshot, StorageObject targetSnapshot, Map objectsMap) {
        super(sourceSnapshot, targetSnapshot);
        this.sourceSnapshot = (SnapshotOracle)sourceSnapshot;
        this.targetSnapshot = (SnapshotOracle)targetSnapshot;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initStoragePropertiesList();
        this.initPropertiesFilterList();
        this.initStoragePropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(BODY);
        ph.setLeftValue(this.sourceSnapshot != null ? this.sourceSnapshot.getSubquery() : "");
        ph.setRightValue(this.targetSnapshot != null ? this.targetSnapshot.getSubquery() : "");
        if (this.isExcludedFromComparison(BODY)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(ON_PREBUILT_TABLE);
        String left = "";
        if (this.sourceSnapshot != null && this.sourceSnapshot.getOnPrebuildTable() != null) {
            left = String.valueOf(this.sourceSnapshot.getOnPrebuildTable());
        }
        ph.setLeftValue(left);
        String right = "";
        if (this.targetSnapshot != null && this.targetSnapshot.getOnPrebuildTable() != null) {
            right = String.valueOf(this.targetSnapshot.getOnPrebuildTable());
        }
        ph.setRightValue(right);
        if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(IMPLEMENTS_TABLE);
        left = "";
        if (this.sourceSnapshot != null && this.sourceSnapshot.getImplementedTable() != null) {
            left = String.valueOf(this.sourceSnapshot.getImplementedTable());
        }
        ph.setLeftValue(left);
        right = "";
        if (this.targetSnapshot != null && this.targetSnapshot.getImplementedTable() != null) {
            right = String.valueOf(this.targetSnapshot.getImplementedTable());
        }
        ph.setRightValue(right);
        if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    @Override
    protected void initStoragePropertiesList() {
        SegmentOracle sourceSegment = null;
        SegmentOracle targetSegment = null;
        TableSpaceOracle sourceTableSpace = null;
        TableSpaceOracle targetTableSpace = null;
        if (this.sourceSnapshot != null) {
            sourceSegment = this.sourceSnapshot.getSegment();
            sourceTableSpace = this.sourceSnapshot.getTablespace();
        }
        if (this.targetSnapshot != null) {
            targetSegment = this.targetSnapshot.getSegment();
            targetTableSpace = this.targetSnapshot.getTablespace();
        }
        StorageTemplateComparator st_comp = new StorageTemplateComparator(sourceSegment, targetSegment, sourceTableSpace, targetTableSpace);
        st_comp.loadStoragePropertiesList(this.storagePropertiesList, storagePropertiesFilterList);
        this.storagePropertiesListActive = true;
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    public static List getStaticStoragePropertiesFilterList() {
        return storagePropertiesFilterList;
    }

    public List getStoragePropertiesFilterList() {
        return storagePropertiesFilterList;
    }

    protected void initStoragePropertiesFilterList() {
        if (this.getStoragePropertiesFilterList().size() != this.storagePropertiesList.size()) {
            TreeMap<String, Boolean> fm = new TreeMap<String, Boolean>();
            for (int i = 0; i < this.getStoragePropertiesFilterList().size(); ++i) {
                PropertyFilter fe = (PropertyFilter)this.getStoragePropertiesFilterList().get(i);
                fm.put(fe.getName(), fe.isSelected());
            }
            this.getStoragePropertiesFilterList().clear();
            for (int j = 0; j < this.storagePropertiesList.size(); ++j) {
                EngPropertyHolder ph = (EngPropertyHolder)this.storagePropertiesList.get(j);
                PropertyFilter pf = new PropertyFilter(ph.getName());
                if (fm.containsKey(pf.getName())) {
                    pf.setSelected((Boolean)fm.get(pf.getName()));
                }
                this.getStoragePropertiesFilterList().add(pf);
            }
        }
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromSnapshotToSnapshot();
    }

    private void copyPropertiesFromSnapshotToSnapshot() {
        if (this.sourceSnapshot != null && this.targetSnapshot != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                TableProxyOracle tpr;
                ModelIDObject t_tp;
                TableProxyOracle tp;
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(BODY)) {
                    this.targetSnapshot.setSubquery(this.sourceSnapshot.getSubquery());
                    continue;
                }
                if (ph.getName().equals(ON_PREBUILT_TABLE)) {
                    tp = this.sourceSnapshot.getOnPrebuildTable();
                    if (tp != null) {
                        t_tp = (ModelIDObject)this.objectsMap.get(tp.getObjectID());
                        if (t_tp == null || (tpr = (TableProxyOracle)this.targetSnapshot.getStorageDesign().getStorageObject(t_tp.getObjectID())) == null) continue;
                        this.targetSnapshot.setOnPrebuildTable(tpr);
                        continue;
                    }
                    this.targetSnapshot.setOnPrebuildTable(null);
                    continue;
                }
                if (!ph.getName().equals(IMPLEMENTS_TABLE)) continue;
                tp = this.sourceSnapshot.getImplementedTable();
                if (tp != null) {
                    t_tp = (ModelIDObject)this.objectsMap.get(tp.getObjectID());
                    if (t_tp == null || (tpr = (TableProxyOracle)this.targetSnapshot.getStorageDesign().getStorageObject(t_tp.getObjectID())) == null) continue;
                    tpr.setSnapshot(this.targetSnapshot);
                    continue;
                }
                TableProxyOracle tpr2 = this.targetSnapshot.getImplementedTable();
                if (tpr2 == null) continue;
                tpr2.setSnapshot(null);
            }
        }
    }
}

