/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.compare.PropertyFilter;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;

public class StorageTemplateComparator
extends StoragePropertiesComparator {
    private SegmentOracle sourceStorageTemplate;
    private SegmentOracle targetStorageTemplate;
    private TableSpaceOracle sourceTableSpace;
    private TableSpaceOracle targetTableSpace;
    protected static List propertiesFilterList = new ArrayList();

    public StorageTemplateComparator(StorageObject sourceStorageTemplate, StorageObject targetStorageTemplate) {
        super(sourceStorageTemplate, targetStorageTemplate);
        this.sourceStorageTemplate = (SegmentOracle)sourceStorageTemplate;
        this.targetStorageTemplate = (SegmentOracle)targetStorageTemplate;
        this.sourceTableSpace = null;
        this.targetTableSpace = null;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    public StorageTemplateComparator(StorageObject sourceStorageTemplate, StorageObject targetStorageTemplate, TableSpaceOracle sourceTableSpace, TableSpaceOracle targetTableSpace) {
        super(sourceStorageTemplate, targetStorageTemplate);
        this.sourceStorageTemplate = (SegmentOracle)sourceStorageTemplate;
        this.targetStorageTemplate = (SegmentOracle)targetStorageTemplate;
        this.sourceTableSpace = sourceTableSpace;
        this.targetTableSpace = targetTableSpace;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(TABLESPACE);
        String sourceTS = "";
        String targetTS = "";
        if (this.sourceTableSpace != null) {
            sourceTS = this.sourceTableSpace.getName();
        } else if (this.sourceStorageTemplate != null && this.sourceStorageTemplate.getTableSpace() != null) {
            sourceTS = this.sourceStorageTemplate.getTableSpace().getName();
        }
        if (this.targetTableSpace != null) {
            targetTS = this.targetTableSpace.getName();
        } else if (this.targetStorageTemplate != null && this.targetStorageTemplate.getTableSpace() != null) {
            targetTS = this.targetStorageTemplate.getTableSpace().getName();
        }
        ph.setLeftValue(sourceTS);
        ph.setRightValue(targetTS);
        if (this.isExcludedFromComparison(TABLESPACE)) {
            ph.setExcluded(true);
        } else if (!(this.sourceStorageTemplate == null && this.sourceTableSpace == null || this.targetStorageTemplate == null && this.targetTableSpace == null || sourceTS.equalsIgnoreCase(targetTS))) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(PCT_FREE);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getPCTFree()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getPCTFree()) : "");
        if (this.isExcludedFromComparison(PCT_FREE)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && this.sourceStorageTemplate.getPCTFree() != this.targetStorageTemplate.getPCTFree()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(PCT_USED);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getPCTUsed()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getPCTUsed()) : "");
        if (this.isExcludedFromComparison(PCT_USED)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && this.sourceStorageTemplate.getPCTUsed() != this.targetStorageTemplate.getPCTUsed()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(INIT_TRANS);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getInitrans()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getInitrans()) : "");
        if (this.isExcludedFromComparison(INIT_TRANS)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && this.sourceStorageTemplate.getInitrans() != this.targetStorageTemplate.getInitrans()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (this.sourceStorageTemplate != null && this.sourceStorageTemplate instanceof SegmentOraclev9i || this.targetStorageTemplate != null && this.targetStorageTemplate instanceof SegmentOraclev9i) {
            ph = new PropertyHolder(MAX_TRANS);
            ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getMaxTrans()) : "");
            ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getMaxTrans()) : "");
            if (this.isExcludedFromComparison(MAX_TRANS)) {
                ph.setExcluded(true);
            } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && this.sourceStorageTemplate.getMaxTrans() != this.targetStorageTemplate.getMaxTrans()) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(SC_INITIAL_EXTENT);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCInitialExtent()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCInitialExtent()) : "");
        if (this.isExcludedFromComparison(SC_INITIAL_EXTENT)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && this.sourceStorageTemplate.getSCInitialExtent() != this.targetStorageTemplate.getSCInitialExtent()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_NEXT_EXTENT);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCNextExtent()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCNextExtent()) : "");
        if (this.isExcludedFromComparison(SC_NEXT_EXTENT)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && this.sourceStorageTemplate.getSCNextExtent() != this.targetStorageTemplate.getSCNextExtent()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_MIN_EXTENTS);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCMinExtents()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCMinExtents()) : "");
        if (this.isExcludedFromComparison(SC_MIN_EXTENTS)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && this.sourceStorageTemplate.getSCMinExtents() != this.targetStorageTemplate.getSCMinExtents()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_MAX_EXTENTS);
        ph.setLeftValue(this.sourceStorageTemplate != null ? this.sourceStorageTemplate.getSCMaxExtents() : "");
        ph.setRightValue(this.targetStorageTemplate != null ? this.targetStorageTemplate.getSCMaxExtents() : "");
        if (this.isExcludedFromComparison(SC_MAX_EXTENTS)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && !this.sourceStorageTemplate.getSCMaxExtents().equalsIgnoreCase(this.targetStorageTemplate.getSCMaxExtents())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_PCT_INCREASE);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCPctIncrease()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCPctIncrease()) : "");
        if (this.isExcludedFromComparison(SC_PCT_INCREASE)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && this.sourceStorageTemplate.getSCPctIncrease() != this.targetStorageTemplate.getSCPctIncrease()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_BUFFER_POOL);
        ph.setLeftValue(this.sourceStorageTemplate != null ? this.sourceStorageTemplate.getSCBufferPool() : "");
        ph.setRightValue(this.targetStorageTemplate != null ? this.targetStorageTemplate.getSCBufferPool() : "");
        if (this.isExcludedFromComparison(SC_BUFFER_POOL)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && !this.sourceStorageTemplate.getSCBufferPool().equalsIgnoreCase(this.targetStorageTemplate.getSCBufferPool())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_FREE_LISTS);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCFreeLists()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCFreeLists()) : "");
        if (this.isExcludedFromComparison(SC_FREE_LISTS)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && this.sourceStorageTemplate.getSCFreeLists() != this.targetStorageTemplate.getSCFreeLists()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_FREE_LISTS_GRPS);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCFreelistGroups()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCFreelistGroups()) : "");
        if (this.isExcludedFromComparison(SC_FREE_LISTS_GRPS)) {
            ph.setExcluded(true);
        } else if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null && this.sourceStorageTemplate.getSCFreelistGroups() != this.targetStorageTemplate.getSCFreelistGroups()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    public void loadStoragePropertiesList(List propList, List filterList) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            EngPropertyHolder ph = (EngPropertyHolder)this.propertiesList.get(i);
            if (ph.getName().equalsIgnoreCase(NAME)) continue;
            if (this.isExcludedFromStorageComparison(ph.getName(), filterList)) {
                ph.setExcluded(true);
                ph.setModified(false);
                ph.setSelected(false);
            }
            propList.add(ph);
        }
    }

    private boolean isExcludedFromStorageComparison(String propertyName, List filterList) {
        for (int j = 0; j < filterList.size(); ++j) {
            PropertyFilter st_pf = (PropertyFilter)filterList.get(j);
            if (!propertyName.equalsIgnoreCase(st_pf.getName())) continue;
            return !st_pf.isSelected();
        }
        return false;
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropsFromStoTemToStoTem();
    }

    private void copyPropsFromStoTemToStoTem() {
        if (this.sourceStorageTemplate != null && this.targetStorageTemplate != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
            }
        }
    }
}

