/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.constraint;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;

public class ConstraintEnumeration
extends AbstractConstraint {
    private static final String PROPERTY_PREFIX = "element.";
    private Map valuesDescriptionMap = new TreeMap();

    public void add(Object object) {
        this.add(object, "");
    }

    public void add(Object object, String description) {
        if (!((String)object).trim().equalsIgnoreCase("")) {
            this.valuesDescriptionMap.put(object, description);
        }
    }

    public Object remove(Object object) {
        this.valuesDescriptionMap.remove(object);
        return object;
    }

    public Set getValues() {
        return this.valuesDescriptionMap.keySet();
    }

    public Map getValuesDescriptionMap() {
        return this.valuesDescriptionMap;
    }

    public boolean isEmpty() {
        return this.getValues().isEmpty();
    }

    protected List getValuesAsList() {
        return Arrays.asList(this.getValues().toArray());
    }

    protected Set createValueSet() {
        return new HashSet();
    }

    @Override
    public String getTypename() {
        return "String value list";
    }

    @Override
    public String getType() {
        return "enumerated String";
    }

    @Override
    public boolean isType(String typeConstant) {
        return "enumerated String".equals(typeConstant);
    }

    @Override
    public Iterator values() {
        return this.getValues().iterator();
    }

    @Override
    public String getProperty(String key) {
        String value = (String)this.valuesDescriptionMap.get(key);
        if (value != null) {
            return value;
        }
        value = this.getSimulatedProperty(key);
        if (value != null) {
            return value;
        }
        return super.getProperty(key);
    }

    @Override
    public void setProperty(String key, String value) {
        if (!key.startsWith(PROPERTY_PREFIX)) {
            this.add(key, value);
        } else {
            super.setProperty(key, value);
        }
    }

    @Override
    public Iterator getPropertyNames() {
        return this.valuesDescriptionMap.keySet().iterator();
    }

    @Override
    public boolean hasProperty(String key, String value) {
        String mvalue = (String)this.valuesDescriptionMap.get(key);
        if (mvalue != null) {
            return mvalue.equals(value);
        }
        return this.getSimulatedProperty(key) != value || super.hasProperty(key, value);
    }

    @Override
    public boolean hasProperty(String key) {
        String value = (String)this.valuesDescriptionMap.get(key);
        if (value != null) {
            return true;
        }
        return this.getSimulatedProperty(key) != null || this.hasProperty(key);
    }

    protected String getSimulatedProperty(String key) {
        if (key.startsWith(PROPERTY_PREFIX)) {
            try {
                String s = key.substring(PROPERTY_PREFIX.length());
                int index = Integer.parseInt(s.trim());
                if (index < this.getValues().size()) {
                    List list = this.getValuesAsList();
                    return String.valueOf(list.get(index));
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    protected boolean attemptSetSimulatedProperty(String key, Object value) {
        if (key.startsWith(PROPERTY_PREFIX)) {
            this.add(value);
            return true;
        }
        return false;
    }

    public String getValuesAsString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.values();
        while (it.hasNext()) {
            String value = (String)it.next();
            sb.append(value.trim()).append(",").append("\n ");
        }
        int i = sb.lastIndexOf(",");
        if (i > 0) {
            return sb.substring(0, i).trim();
        }
        return sb.toString().trim();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.values();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)this.getValuesDescriptionMap().get(key);
            sb.append(key).append("\n description - ").append(value).append("\n ");
        }
        return sb.toString();
    }

    @Override
    public void copyTo(Constraint constraint) {
        ((ConstraintEnumeration)constraint).getValuesDescriptionMap().clear();
        Iterator it = this.values();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = this.getValuesDescriptionMap().get(key);
            ((ConstraintEnumeration)constraint).getValuesDescriptionMap().put(key, value);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ConstraintEnumeration)) {
            return false;
        }
        ConstraintEnumeration constr = (ConstraintEnumeration)obj;
        Iterator it = this.values();
        while (it.hasNext()) {
            String key1 = (String)it.next();
            String value2 = (String)constr.getValuesDescriptionMap().get(key1);
            if (value2 == null) {
                return false;
            }
            String value1 = (String)this.getValuesDescriptionMap().get(key1);
            if (value2.equalsIgnoreCase(value1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearProperties() {
        this.valuesDescriptionMap.clear();
        super.clearProperties();
    }
}

