/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.constraint;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.util.logging.Logger;

public class ConstraintSet
extends ModelObjectSet {
    private static final Object[] PROTO_ARRAY = new Constraint[0];
    private static final ConstraintTypeDescriptor[] CONSTRAINT_TYPES = new ConstraintTypeDescriptor[]{new ConstraintTypeDescriptor("Value List", 0), new ConstraintTypeDescriptor("Check Constraint", 1)};
    private static final Logger LOGGER = new Logger(ConstraintSet.class);

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "Constraint";
    }

    public static Object[] getConstraintTypes() {
        return CONSTRAINT_TYPES;
    }

    public ModelIDObject createElement(String id) {
        LOGGER.error("ConstraintSet can not use createElement(String) because it needs a ConstraintTypeDescriptor to determine what to instantiate.");
        return null;
    }

    public Constraint createConstraint(Object constraintType) {
        if (constraintType instanceof ConstraintTypeDescriptor) {
            ConstraintTypeDescriptor ctd = (ConstraintTypeDescriptor)constraintType;
            AbstractConstraint constraint = null;
            switch (ctd.getId()) {
                case 0: {
                    ConstraintEnumeration econstraint = new ConstraintEnumeration();
                    constraint = econstraint;
                    break;
                }
                case 1: {
                    constraint = new CheckConstraint();
                    break;
                }
                default: {
                    return null;
                }
            }
            constraint.setDesign(this.getDesign());
            this.add(constraint);
            return constraint;
        }
        return null;
    }

    public Constraint createConstraint(String type) {
        int id = -1;
        if ("check constraint".equals(type)) {
            id = 1;
        } else if ("enumerated String".equals(type)) {
            id = 0;
        } else {
            return null;
        }
        return this.createConstraint(ConstraintSet.getConstraintTypes()[id]);
    }

    private static class ConstraintTypeDescriptor {
        private String description;
        private int id;

        private ConstraintTypeDescriptor(String description, int id) {
            this.description = description;
            this.id = id;
        }

        int getId() {
            return this.id;
        }

        public String toString() {
            return this.description;
        }
    }
}

