/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.constraint;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.Table;

public class TableLevelConstraint
extends DesignObject {
    private String EMPTY;
    private String rule;
    private String generateInDDL;
    private Table table;
    public static final String TYPE_NAME = "Constraint";

    public TableLevelConstraint(DesignPart designPart) {
        super(designPart);
        this.rule = this.EMPTY = "";
        this.generateInDDL = "YES";
        this.table = null;
        this.getDesign().addDesignObject(this);
    }

    public TableLevelConstraint(DesignPart designPart, String name, String rule) {
        super(designPart);
        this.rule = this.EMPTY = "";
        this.generateInDDL = "YES";
        this.table = null;
        this.getDesign().addDesignObject(this);
        super.setName(name);
        this.rule = rule;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("chkconstr id prefix");
    }

    public String getRule() {
        if (this.rule == null) {
            return this.EMPTY;
        }
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getGenerateInDDL() {
        return this.generateInDDL;
    }

    public void setGenerateInDDL(String generateInDDL) {
        if (generateInDDL.equalsIgnoreCase("YES") || generateInDDL.equalsIgnoreCase("NO")) {
            this.generateInDDL = generateInDDL;
        }
    }

    public boolean isGenerateInDDL() {
        return this.generateInDDL.equalsIgnoreCase("YES");
    }

    public void setGenerateInDDL(boolean generateInDDL) {
        this.generateInDDL = generateInDDL ? "YES" : "NO";
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getID() {
        return this.getObjectID();
    }

    public void setID(String id) {
        this.setObjectID(id);
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public void remove() {
        if (this.table != null) {
            this.table.removeCheckConstraint(this);
        }
        this.getDesign().removeDesignObject(this);
        super.remove();
    }
}

