/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.AbstractDTTV;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class DTRelation
extends AbstractDTObject
implements ConnectionInterface {
    public static final Object[] CONNECTION_PROTO_ARRAY = new Connection[0];
    public static final int SOURCE = 0;
    public static final int DESTINATION = 1;
    private final AbstractDTObject[] DT_OBJECTS = new AbstractDTObject[2];
    private final Connection[] CONNECTIONS = new Connection[]{new SourceConnection(), new DestinationConnection()};
    private AbstractDTObject source;
    private AbstractDTObject destination;
    private Collection dpvCol = new ArrayList();

    public DTRelation(DesignPart designPart) {
        super(designPart);
    }

    public void setDTObject(int endPoint, AbstractDTObject dtObject) {
        if (this.DT_OBJECTS[endPoint] == dtObject) {
            return;
        }
        if (this.DT_OBJECTS[endPoint] != null) {
            if (this.DT_OBJECTS[0] != this.DT_OBJECTS[1]) {
                // empty if block
            }
            this.DT_OBJECTS[endPoint].remove(this.CONNECTIONS[endPoint]);
        }
        if (dtObject != null) {
            dtObject.add(this.CONNECTIONS[endPoint]);
        }
        this.DT_OBJECTS[endPoint] = dtObject;
        if (dtObject != null) {
            // empty if block
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
    }

    public AbstractDTObject getDTObject(int endPoint) {
        return this.DT_OBJECTS[endPoint];
    }

    public AbstractDTObject getTargetDTObject() {
        return this.getDTObject(1);
    }

    public void setTargetDTObject(AbstractDTObject dtObject) {
        if (this.getTargetDTObject() != dtObject) {
            AbstractDTObject old = this.getTargetDTObject();
            this.setDTObject(1, dtObject);
            if (old != null && old != dtObject) {
                this.clearTargetTV();
            }
            this.addToAllDPVs();
        }
    }

    public void addToAllDPVs() {
        DesignPartView dpv;
        if (this.getTargetDTObject() == null || this.getSourceDTObject() == null) {
            return;
        }
        Collection targetDPVs = this.getTargetDTObject().getAffectedDPVs();
        Collection sourceDPVs = this.getSourceDTObject().getAffectedDPVs();
        Iterator tit = targetDPVs.iterator();
        Iterator sit = sourceDPVs.iterator();
        while (tit.hasNext()) {
            dpv = (DesignPartView)tit.next();
            this.getTargetTV(dpv);
        }
        while (sit.hasNext()) {
            dpv = (DesignPartView)sit.next();
            this.getSourceTV(dpv);
        }
    }

    public AbstractDTObject getSourceDTObject() {
        return this.getDTObject(0);
    }

    public AbstractDTObject getOtherDTObject(AbstractDTObject dtObject) {
        if (dtObject == this.getSourceDTObject()) {
            return this.getTargetDTObject();
        }
        return this.getSourceDTObject();
    }

    public void setSourceDTObject(AbstractDTObject dtObject) {
        if (this.getSourceDTObject() != dtObject) {
            AbstractDTObject old = this.getSourceDTObject();
            this.setDTObject(0, dtObject);
            if (old != null && old != dtObject) {
                this.clearSourceTV();
            }
            this.addToAllDPVs();
        }
    }

    public void clearSourceTV() {
        for (DpvInfo dpi : this.dpvCol) {
            dpi.sourceTV = null;
            if (dpi.tv == null) continue;
            ((TVDTRelation)dpi.tv).removeConnection();
            if (dpi.dpv != null) {
                dpi.dpv.unregisterFromTreemodel(dpi.tv);
            }
            dpi.tv = null;
        }
    }

    public void clearTargetTV() {
        for (DpvInfo dpi : this.dpvCol) {
            dpi.targetTV = null;
            if (dpi.tv == null) continue;
            ((TVDTRelation)dpi.tv).removeConnection();
            if (dpi.dpv != null) {
                dpi.dpv.unregisterFromTreemodel(dpi.tv);
            }
            dpi.tv = null;
        }
    }

    public DpvInfo getDPVInfoFor(DesignPartView dpv) {
        DpvInfo dpi2;
        for (DpvInfo dpi2 : this.dpvCol) {
            if (dpi2.dpv != dpv) continue;
            return dpi2;
        }
        dpi2 = new DpvInfo();
        dpi2.dpv = dpv;
        this.dpvCol.add(dpi2);
        return dpi2;
    }

    @Override
    public TopView getViewFor(DesignPartView dpv) {
        DpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.tv;
    }

    public AbstractDTTV getSourceTV(DesignPartView dpv) {
        Collection c;
        DpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV == null && this.getSourceDTObject() != null && !(c = this.getSourceDTObject().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.sourceTV = (AbstractDTTV)it.next();
            dpi.sourceTV.addTopViewListener(this);
            this.addTVDTRelation(dpi);
        }
        return dpi.sourceTV;
    }

    public AbstractDTTV getTargetTV(DesignPartView dpv) {
        Collection c;
        DpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV == null && this.getTargetDTObject() != null && !(c = this.getTargetDTObject().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.targetTV = (AbstractDTTV)it.next();
            dpi.targetTV.addTopViewListener(this);
            this.addTVDTRelation(dpi);
        }
        return dpi.targetTV;
    }

    public void addTVDTRelation(DpvInfo dpi) {
        if (dpi.tv == null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            TopView tv = ((DPVDataTypes)dpi.dpv).createViewSynonim(this);
            tv.setSize(new Dimension(100, 100));
            this.addObjectListener(tv);
        } else if (dpi.tv != null && ((TVConnector)dpi.tv).getEdge() == null && dpi.dpv.isVisible() && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            DefaultEdge edge = ((TVDTRelation)dpi.tv).addConnection();
            dpi.tv.getDesignPartView().getWorkSpace().addPoints(edge, ((TVDTRelation)dpi.tv).getEdgePoints(), true);
            edge.getCellView().update();
        }
    }

    public void setSourceTV(AbstractDTTV source) {
        DesignPartView dpv = source.getDesignPartView();
        DpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV != source) {
            if (dpi.sourceTV != null) {
                if (dpi.tv != null) {
                    ((TVDTRelation)dpi.tv).removeConnection();
                    if (dpi.dpv != null) {
                        dpi.dpv.unregisterFromTreemodel(dpi.tv);
                    }
                    dpi.tv = null;
                }
                dpi.sourceTV.removeTopViewListener(this);
            }
            dpi.sourceTV = source;
            dpi.sourceTV.addTopViewListener(this);
            this.addTVDTRelation(dpi);
        }
    }

    public void setTargetTV(AbstractDTTV target) {
        DesignPartView dpv = target.getDesignPartView();
        DpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV != target) {
            if (dpi.targetTV != null) {
                if (dpi.tv != null) {
                    ((TVDTRelation)dpi.tv).removeConnection();
                    if (dpi.dpv != null) {
                        dpi.dpv.unregisterFromTreemodel(dpi.tv);
                    }
                    dpi.tv = null;
                }
                dpi.targetTV.removeTopViewListener(this);
            }
            dpi.targetTV = target;
            dpi.targetTV.addTopViewListener(this);
            this.addTVDTRelation(dpi);
        }
    }

    public void callRemoveListeners() {
        ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
        event.setAffected(this);
        this.fireChange(event);
        event.setAffected(null);
    }

    public boolean isValid() {
        return this.getDTObject(0) != null && this.getDTObject(1) != null;
    }

    public Connection getConnection(int endPoint) {
        return this.CONNECTIONS[endPoint];
    }

    public Connection getSourceConnection() {
        return this.getConnection(0);
    }

    public Connection getTargetConnection() {
        return this.getConnection(1);
    }

    @Override
    public void setTopView(TopView view) {
        this.addTopView(view);
    }

    @Override
    public TopView getTopView() {
        for (DpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            return dpi.tv;
        }
        return null;
    }

    @Override
    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        DpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv != null) {
            throw new RuntimeException(Messages.getString("DTRelation.AssociationAlreadyExists"));
        }
        inf.tv = view;
    }

    @Override
    public void removeTopView(TopView view) {
        if (view != null) {
            DesignPartView dpv = view.getDesignPartView();
            DpvInfo inf = this.getDPVInfoFor(dpv);
            ((TVDTRelation)view).removeConnection();
            if (inf.dpv != null) {
                inf.dpv.unregisterFromTreemodel(view);
            }
            if (inf.tv == null) {
                return;
            }
            this.dpvCol.remove(inf);
            this.removeObjectListener(view);
        }
    }

    public void removeViewFor(DesignPartView dpv) {
        if (dpv != null) {
            DpvInfo inf = this.getDPVInfoFor(dpv);
            if (inf.tv != null) {
                ((TVDTRelation)inf.tv).removeConnection();
                if (inf.dpv != null) {
                    inf.dpv.unregisterFromTreemodel(inf.tv);
                }
                this.dpvCol.remove(inf);
            }
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public AbstractDTObject getSource() {
        return this.source;
    }

    public void setSource(AbstractDTObject source) {
        this.source = source;
    }

    public AbstractDTObject getDestination() {
        return this.destination;
    }

    public void setDestination(AbstractDTObject destination) {
        this.destination = destination;
    }

    @Override
    public String getObjectTypeName() {
        return "DTRelation";
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "DTRelation";
    }

    @Override
    public void changed(TopView tv, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView dpv = tv.getDesignPartView();
            dpv.removeViewFor(this);
            DpvInfo dpi = this.getDPVInfoFor(dpv);
            dpi.tv = null;
            if (dpi.sourceTV == tv) {
                dpi.sourceTV = null;
            }
            if (dpi.targetTV == tv) {
                dpi.targetTV = null;
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.setDTObject(1, null);
        this.setDTObject(0, null);
        int a = 0;
        ++a;
    }

    @Override
    public void setSourceTopView(TopView source) {
        this.setSourceTV((AbstractDTTV)source);
    }

    @Override
    public void setTargetTopView(TopView target) {
        this.setTargetTV((AbstractDTTV)target);
    }

    @Override
    public TopView getSourceTopView(DesignPartView dpv) {
        return this.getSourceTV(dpv);
    }

    @Override
    public TopView getTargetTopView(DesignPartView dpv) {
        return this.getTargetTV(dpv);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        return this.getViewFor(dpv);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getSourceDTObject();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getTargetDTObject();
    }

    @Override
    public List getAllViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (DpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            col.add(dpi.tv);
        }
        return col;
    }

    @Override
    public void restoreTopView(TopView tv, TopView sourceTV, TopView targetTV) {
        tv.getDesignPartView().restoreTopview(tv, this);
        DpvInfo dpi = this.getDPVInfoFor(tv.getDesignPartView());
        if (dpi.tv == tv) {
            this.addObjectListener(tv);
            dpi.targetTV = (AbstractDTTV)targetTV;
            dpi.targetTV.addTopViewListener(this);
            dpi.sourceTV = (AbstractDTTV)sourceTV;
            dpi.sourceTV.addTopViewListener(this);
        }
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    public class DestinationConnection
    extends Connection {
        @Override
        public AbstractDTObject getDTObject() {
            return DTRelation.this.getDTObject(1);
        }

        @Override
        public String getDescriptor() {
            return "Destination";
        }

        @Override
        public boolean isSource() {
            return false;
        }
    }

    public class SourceConnection
    extends Connection {
        @Override
        public AbstractDTObject getDTObject() {
            return DTRelation.this.getDTObject(0);
        }

        @Override
        public String getDescriptor() {
            return "Source";
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    public abstract class Connection {
        private Boolean optionality = Boolean.TRUE;
        private String nameOn = null;

        public DTRelation getDTRelation() {
            return DTRelation.this;
        }

        public abstract AbstractDTObject getDTObject();

        public abstract String getDescriptor();

        public abstract boolean isSource();

        public String toString() {
            return DTRelation.this.getName() + this.getDescriptor();
        }

        public boolean isOptional() {
            return this.optionality;
        }

        public void setOptional(boolean value) {
            this.optionality = value ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean getOptionality() {
            return this.optionality;
        }

        public void setOptionality(Boolean value) {
            this.optionality = value == null ? Boolean.FALSE : value;
        }

        public void setNameOn(String name) {
            this.nameOn = name;
        }

        public TopView getTopView() {
            return DTRelation.this.getTopView();
        }

        public String getNameOn() {
            return this.nameOn;
        }
    }

    public class DpvInfo {
        public AbstractDTTV sourceTV;
        public AbstractDTTV targetTV;
        public TopView tv;
        public DesignPartView dpv;

        DpvInfo() {
        }
    }
}

