/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.CollectionTypeSet;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTInheritanceSet;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTReferenceSet;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.DistinctTypeSet;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParamSet;
import oracle.dbtools.crest.model.design.datatypes.MethodSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.datatypes.TypeElementSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypesSubView;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.editor.datatypes.DataTypesModelPropertiesDialog;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;

public class DataTypesDesign
extends DesignPart
implements ObjectListener {
    public static final String OBJECT_TYPE_NAME = "Data Types";
    public static final String SDO_GEOMETRY = "SDO_GEOMETRY";
    public static final String XMLTYPE = "XMLTYPE";
    public static final String DISTINCT_TYPE_SET_NAME = "Distinct Types";
    public static final String COLLECTION_TYPE_SET_NAME = "Collection Types";
    public static final String STRUCTURED_TYPE_SET_NAME = "Structured Types";
    public static final String NOTE_SET_NAME = "Notes";
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    public static final String SDO_GEOMETRY_ID = "47E390DE-0671-C4B1-8428-0F45CBEE18F8";
    public static final String XMLTYPE_ID = "F72C39E0-D1CA-8821-2AD7-A1E95A37D3D1";
    DistinctTypeSet dtSet;
    StructuredTypeSet stSet;
    CollectionTypeSet ctSet;
    private NoteSet noteSet;
    private TypeElementSet teSet;
    private MethodSet methodSet;
    private DTInheritanceSet dtiSet;
    private DTReferenceSet dtrSet;
    private MethodParamSet mpSet;
    private String referencePrefix = "ref_";
    private String collectionPrefix = "array_";
    private String embeddedStructuredTypePrefix = "inst_";
    private String collectionOfRefsPrefix = "array_ref_";
    private String defaultCollectionType_Kind = CollectionType.TYPE_ARRAY;
    private int defaultArrayLimit = 10;
    private String defaultCollectionType_Suffix = "_Array";
    private boolean useRoleInAssociationEndAsName = true;
    private DesignObjectCollection predefinedStCollection;
    private DesignObjectCollection stCollection;
    private DesignObjectCollection ctCollection;
    private DesignObjectCollection predefinedCtCollection;
    public static final String OBJECT_NAME = "DataTypes";

    public DataTypesDesign() {
        this.setVisible(false);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getStructuredTypeSet().addAllElementsTo(collection);
        this.getDTInheritanceSet().addAllElementsTo(collection);
        this.getDTReferenceSet().addAllElementsTo(collection);
        this.getNoteSet().addAllElementsTo(collection);
        this.getDiagramViewSet().addAllElementsTo(collection);
        return collection;
    }

    @Override
    public String getName() {
        return OBJECT_NAME;
    }

    @Override
    public String toString() {
        return Messages.getString("Design.DataTypes");
    }

    @Override
    public void clearAll() {
        this.getStructuredTypeSet().removeAll();
        this.getStructureTypeCollection().removeAll();
        this.getDistinctTypeSet().removeAll();
        this.getCollectionTypeSet().removeAll();
        this.getTypeElementSet().removeAll();
        this.getMethodSet().removeAll();
        this.getMethodParamSet().removeAll();
        this.getDTInheritanceSet().removeAll();
        this.getDTReferenceSet().removeAll();
        this.getNoteSet().removeAll();
        this.getDiagramViewSet().removeAll();
        this.clearDocuments();
        this.clearResponsibleParties();
        this.setComment("");
        this.setNotes("");
        if (this.predefinedStCollection != null) {
            this.predefinedStCollection.removeAll();
        }
        this.predefinedStCollection = null;
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public void sortCollections() {
        this.getStructuredTypeSet().sort();
        this.getDistinctTypeSet().sort();
        this.getCollectionTypeSet().sort();
        this.getTypeElementSet().sort();
        this.getMethodSet().sort();
        this.getDTInheritanceSet().sort();
        this.getDTReferenceSet().sort();
        this.getPredefinedCtCollection().sort();
        this.getPredefinedStCollection().sort();
        this.getDataTypesDesignSubViews().sort();
        Iterator it = this.getDataTypesDesignSubViews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvHolder = (DesignPartViewPlaceHolder)it.next();
            DesignPartView subView = dpvHolder.getDesignPartView();
            subView.sortCollections();
        }
    }

    private void addStructureType() {
        String id = SDO_GEOMETRY_ID;
        DesignObject type2 = this.getStructuredTypeSet().getObjectByID(id);
        if (type2 == null) {
            type2 = this.getStructuredTypeSet().getByName(SDO_GEOMETRY);
        }
        if (type2 == null) {
            StructuredType type = this.getStructuredTypeSet().createStructuredType(id, false);
            type.setName(SDO_GEOMETRY);
            type.setPredefined(true);
            type.setIsNullInstance(true);
            String oldId = type.getObjectID();
            this.getDesign().updateDesignObjectId(oldId, type.getObjectID());
            this.getStructuredTypeSet().resetCounter();
            type.setDirty(false);
            this.listOfObjectsChanged = false;
        }
        id = XMLTYPE_ID;
        DesignObject xmltype = this.getStructuredTypeSet().getObjectByID(id);
        if (xmltype == null) {
            xmltype = this.getStructuredTypeSet().getByName(XMLTYPE);
        }
        if (xmltype == null) {
            StructuredType type = this.getStructuredTypeSet().createStructuredType(id, false);
            type.setName(XMLTYPE);
            type.setPredefined(true);
            type.setIsNullInstance(true);
            String oldId = type.getObjectID();
            this.getDesign().updateDesignObjectId(oldId, type.getObjectID());
            this.getStructuredTypeSet().resetCounter();
            type.setDirty(false);
            this.listOfObjectsChanged = false;
        }
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        DPVDataTypesSubView dpv = new DPVDataTypesSubView(this.getDesign().getAppView(), this);
        name = this.getNameVersion(this.subViews, name);
        dpv.setName(name);
        DesignPartViewPlaceHolder dpvPH = new DesignPartViewPlaceHolder((DesignPart)this, dpv);
        dpvPH.setParent(this.subViews);
        this.subViews.add(dpvPH);
        return dpv;
    }

    public SubViewObjectSet getDataTypesDesignSubViews() {
        return this.subViews;
    }

    @Override
    public void doBeforeLoad() {
        this.getPredefinedStCollection().removeAll();
        this.getStructuredTypeSet().removeAll();
        this.addStructureType();
    }

    @Override
    public void doAfterLoad() {
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        this.getPredefinedStCollection().removeAll();
        this.getStructuredTypeSet().removeAll();
        this.addStructureType();
        XMLPersistenceManager pm = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader reader = pm.getDesignPartReader(this);
        if (reader != null) {
            reader.recreateDesign(this.getName(), (DesignPart)this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVDataTypes(this.getDesign().getAppView(), this);
            this.mainView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public boolean isEmpty() {
        return this.getDistinctTypeSet().size() <= 0 && this.getStructuredTypeSet().size() <= 0 && this.getCollectionTypeSet().size() <= 0;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DT";
    }

    public DistinctTypeSet getDistinctTypeSet() {
        if (this.dtSet == null) {
            this.dtSet = new DistinctTypeSet(this);
            this.dtSet.setDesign(this.getDesign());
            this.dtSet.setName(Messages.getString("DataTypesDesign.DistinctTypes"));
            this.dtSet.setParent(this);
            this.dtSet.addSetListener(this);
        }
        return this.dtSet;
    }

    public StructuredTypeSet getStructuredTypeSet() {
        if (this.stSet == null) {
            this.stSet = new StructuredTypeSet(this);
            this.stSet.setDesign(this.getDesign());
            this.stSet.setName(Messages.getString("DataTypesDesign.StructuredTypes"));
            this.stSet.setParent(this);
            this.stSet.addSetListener(this);
            this.getPredefinedStCollection();
        }
        return this.stSet;
    }

    public CollectionTypeSet getCollectionTypeSet() {
        if (this.ctSet == null) {
            this.ctSet = new CollectionTypeSet(this);
            this.ctSet.setDesign(this.getDesign());
            this.ctSet.setName(Messages.getString("DataTypesDesign.CollectionTypes"));
            this.ctSet.setParent(this);
            this.ctSet.addSetListener(this);
        }
        return this.ctSet;
    }

    public TypeElementSet getTypeElementSet() {
        if (this.teSet == null) {
            this.teSet = new TypeElementSet(this);
            this.teSet.setDesign(this.getDesign());
            this.teSet.setName("TypeElements");
            this.teSet.setParent(this);
            this.teSet.addSetListener(this);
        }
        return this.teSet;
    }

    public MethodSet getMethodSet() {
        if (this.methodSet == null) {
            this.methodSet = new MethodSet(this);
            this.methodSet.setDesign(this.getDesign());
            this.methodSet.setName("Methods");
            this.methodSet.setParent(this);
            this.methodSet.addSetListener(this);
        }
        return this.methodSet;
    }

    public MethodParamSet getMethodParamSet() {
        if (this.mpSet == null) {
            this.mpSet = new MethodParamSet(this);
            this.mpSet.setDesign(this.getDesign());
            this.mpSet.setName("Method Parameters");
            this.mpSet.setParent(this);
            this.mpSet.addSetListener(this);
        }
        return this.mpSet;
    }

    public DTInheritanceSet getDTInheritanceSet() {
        if (this.dtiSet == null) {
            this.dtiSet = new DTInheritanceSet(this);
            this.dtiSet.setDesign(this.getDesign());
            this.dtiSet.setName("Inheritances");
            this.dtiSet.setParent(this);
            this.dtiSet.addSetListener(this);
        }
        return this.dtiSet;
    }

    public DTReferenceSet getDTReferenceSet() {
        if (this.dtrSet == null) {
            this.dtrSet = new DTReferenceSet(this);
            this.dtrSet.setDesign(this.getDesign());
            this.dtrSet.setName("References");
            this.dtrSet.setParent(this);
            this.dtrSet.addSetListener(this);
        }
        return this.dtrSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(NOTE_SET_NAME);
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public DistinctType createDistinctType() {
        return this.getDistinctTypeSet().createDistinctType(null);
    }

    public StructuredType createStructuredType() {
        return this.getStructuredTypeSet().createStructuredType(null, true);
    }

    public CollectionType createCollectionType() {
        return this.getCollectionTypeSet().createCollectionType(null);
    }

    public DTInheritance createDTInheritance() {
        return this.getDTInheritanceSet().createInheritance(null);
    }

    public DTReference createDTReference() {
        return this.getDTReferenceSet().createReference(null);
    }

    @Override
    public Note createNote() {
        return this.getNoteSet().createNote(null);
    }

    @Override
    public Note recreateNote(String id) {
        return this.getNoteSet().createNote(id);
    }

    @Override
    public int getNumberOfChildren() {
        if (this.getMainView().canCreateDisplays()) {
            return 7;
        }
        return 6;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.getDistinctTypeSet();
            }
            case 1: {
                return this.getStructureTypeCollection();
            }
            case 2: {
                return this.getCtCollection();
            }
            case 3: {
                return this.getPredefinedStCollection();
            }
            case 4: {
                return this.getPredefinedCtCollection();
            }
            case 5: {
                return this.subViews;
            }
            case 6: {
                return this.getMainView().getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.getDistinctTypeSet()) {
            return 0;
        }
        if (child == this.getStructureTypeCollection()) {
            return 1;
        }
        if (child == this.getCtCollection()) {
            return 2;
        }
        if (child == this.getPredefinedStCollection()) {
            return 3;
        }
        if (child == this.getPredefinedCtCollection()) {
            return 4;
        }
        if (child == this.subViews) {
            return 5;
        }
        if (child == this.getMainView().getDisplays()) {
            return 6;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (event == SetEvent.OBJECT_ADDED) {
            AbstractDTObject st;
            if (set instanceof StructuredTypeSet) {
                st = (StructuredType)event.getAffected();
                if (st.isPredefined()) {
                    if (!this.getPredefinedStCollection().contains(st)) {
                        st.setParent(this.getPredefinedStCollection());
                        this.getPredefinedStCollection().add(st);
                        this.getStructureTypeCollection().remove(st);
                        ((TVStructuredType)st.getTopView()).remove(false);
                    }
                } else if (!this.getStructureTypeCollection().contains(st)) {
                    st.setParent(this.getStructureTypeCollection());
                    this.getStructureTypeCollection().add(st);
                    this.getPredefinedStCollection().remove(st);
                }
            }
            if (set instanceof CollectionTypeSet) {
                st = (CollectionType)event.getAffected();
                if (st.isPredefined()) {
                    if (!this.getPredefinedCtCollection().contains(st)) {
                        st.setParent(this.getPredefinedCtCollection());
                        this.getPredefinedCtCollection().add(st);
                        this.getCtCollection().remove(st);
                    }
                } else if (!this.getCtCollection().contains(st)) {
                    st.setParent(this.getCtCollection());
                    this.getCtCollection().add(st);
                    this.getPredefinedCtCollection().remove(st);
                }
            }
            this.fireAdded(event.getAffected());
        } else if (event == SetEvent.OBJECT_REMOVED) {
            if (set instanceof StructuredTypeSet && event.getAffected() instanceof StructuredType) {
                StructuredType st = (StructuredType)event.getAffected();
                if (st.isPredefined()) {
                    this.getPredefinedStCollection().remove(st);
                } else {
                    this.getStructureTypeCollection().remove(st);
                }
                st.removeObjectListener(this);
            } else if (set instanceof CollectionTypeSet) {
                CollectionType ct = (CollectionType)event.getAffected();
                if (ct.isPredefined()) {
                    this.getPredefinedCtCollection().remove(ct);
                } else {
                    this.getCtCollection().remove(ct);
                }
                ct.removeObjectListener(this);
            }
            this.fireRemoved(event.getAffected());
        }
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        list.add(this.getDistinctTypeSet());
        list.add(this.getStructuredTypeSet());
        list.add(this.getNoteSet());
        list.add(this.getCollectionTypeSet());
        return list;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataTypesModelPropertiesDialog dialog = new DataTypesModelPropertiesDialog(this.getDesign().getAppView(), this, true);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public void updateInheritances() {
        Iterator it = this.getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            st.updateInheritance();
        }
    }

    public void rearrangeTypes() {
        int left = 20;
        int top = 20;
        int width = 35;
        int height = 25;
        int count = 0;
        StructuredTypeSet typeSet = this.getDesign().getDataTypesDesign().getStructuredTypeSet();
        if (typeSet.size() > 0) {
            Iterator it = typeSet.iterator();
            float square = (float)Math.sqrt(typeSet.size());
            long maxTypePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTypePerRow;
            }
            ++maxTypePerRow;
            while (it.hasNext()) {
                StructuredType type = (StructuredType)it.next();
                TopView topView = type.getTopView();
                if (topView == null) continue;
                ++count;
                Dimension dim = this.getTypeSize(type);
                width = dim.width;
                height = Math.max(dim.height, height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(left, top), dim));
                } else {
                    topView.setBounds(new Rectangle(new Point(left, top), dim));
                }
                left = left + width + 50;
                if ((long)count != maxTypePerRow) continue;
                count = 0;
                left = 20;
                top = top + height + 50;
                height = 25;
            }
        }
    }

    public void rearrangeTypes(List views, Point p) {
        int left = p.x;
        int top = p.y;
        int width = 35;
        int height = 25;
        int count = 0;
        if (views.size() > 0) {
            Iterator it = views.iterator();
            float square = (float)Math.sqrt(views.size());
            long maxTypePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTypePerRow;
            }
            ++maxTypePerRow;
            while (it.hasNext()) {
                StructuredType type = (StructuredType)it.next();
                TopView topView = type.getTopView();
                if (topView == null) continue;
                ++count;
                if (topView.getCellView() != null) {
                    Dimension dim = this.getTypeSize(type);
                    width = dim.width;
                    height = Math.max(dim.height, height);
                    topView.getCellView().setNewBounds(new Rectangle(new Point(left, top), dim));
                }
                left = left + width + 50;
                if ((long)count != maxTypePerRow) continue;
                count = 0;
                left = 20;
                top = top + height + 150;
                height = 25;
            }
        }
    }

    public Dimension getTypeSize(StructuredType type) {
        int w = 35;
        int h = 25;
        int colCount = type.getElements().length + type.getMethods().length + 1;
        h += colCount * 14;
        int colLength = type.getName().length() * 6;
        int dtLength = 1;
        for (int i = 0; i < type.getElements().length; ++i) {
            TypeElement element = type.getElements()[i];
            int cl = element.getName().length() * 7;
            int dtl = element.getDataType().toString().length() * 7 + 10;
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = type.getName().length() * 7;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    public String getCollectionPrefix() {
        return this.collectionPrefix;
    }

    public void setCollectionPrefix(String collectionPrefix) {
        this.collectionPrefix = collectionPrefix;
    }

    public String getEmbeddedStructuredTypePrefix() {
        return this.embeddedStructuredTypePrefix;
    }

    public void setEmbeddedStructuredTypePrefix(String embeddedStructuredTypePrefix) {
        this.embeddedStructuredTypePrefix = embeddedStructuredTypePrefix;
    }

    public String getReferencePrefix() {
        return this.referencePrefix;
    }

    public void setReferencePrefix(String referencePrefix) {
        this.referencePrefix = referencePrefix;
    }

    public CollectionType getOrCreateCollectionFor(StructuredType st, boolean isRef) {
        TypeElement te;
        CollectionType ct = null;
        Iterator it = this.getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            ct = (CollectionType)it.next();
            te = ct.getElementType();
            if (isRef != te.isReference() || te.getType() != st) continue;
            return ct;
        }
        ct = this.createCollectionType();
        te = ct.getElementType();
        te.setType(st);
        te.setReference(isRef);
        te.setSize("");
        te.setPrecision(0);
        te.setScale(0);
        ct.setName(st.getName() + this.getDefaultCollectionType_Suffix());
        ct.setType(this.getDefaultCollectionType_Kind());
        if (CollectionType.TYPE_ARRAY.equals(this.getDefaultCollectionType_Kind())) {
            ct.setMaxElement(this.getDefaultArrayLimit());
        }
        return ct;
    }

    public String getCollectionOfRefsPrefix() {
        return this.collectionOfRefsPrefix;
    }

    public void setCollectionOfRefsPrefix(String collectionOfRefsPrefix) {
        this.collectionOfRefsPrefix = collectionOfRefsPrefix;
    }

    public int getDefaultArrayLimit() {
        return this.defaultArrayLimit;
    }

    public void setDefaultArrayLimit(int defaultArrayLimit) {
        this.defaultArrayLimit = defaultArrayLimit;
    }

    public String getDefaultCollectionType_Kind() {
        return this.defaultCollectionType_Kind;
    }

    public void setDefaultCollectionType_Kind(String defaultCollectionType_Kind) {
        this.defaultCollectionType_Kind = defaultCollectionType_Kind;
    }

    public String getDefaultCollectionType_Suffix() {
        return this.defaultCollectionType_Suffix;
    }

    public void setDefaultCollectionType_Suffix(String defaultCollectionType_Suffix) {
        this.defaultCollectionType_Suffix = defaultCollectionType_Suffix;
    }

    public boolean isUseRoleInAssociationEndAsName() {
        return this.useRoleInAssociationEndAsName;
    }

    public void setUseRoleInAssociationEndAsName(boolean useRoleInAssociationEndAsName) {
        this.useRoleInAssociationEndAsName = useRoleInAssociationEndAsName;
    }

    @Override
    public boolean canCreateDPSubview() {
        return true;
    }

    public DesignObjectCollection getStructureTypeCollection() {
        if (this.stCollection == null) {
            this.stCollection = new DesignObjectCollection();
            this.stCollection.setDesign(this.getDesign());
            this.stCollection.setParent(this);
            this.stCollection.setName(Messages.getString("DataTypesDesign.StructuredTypes"));
            this.stCollection.setElementDescriptor(StructuredType.class);
        }
        return this.stCollection;
    }

    public DesignObjectCollection getPredefinedStCollection() {
        if (this.predefinedStCollection == null) {
            this.predefinedStCollection = new DesignObjectCollection();
            this.predefinedStCollection.setDesign(this.getDesign());
            this.predefinedStCollection.setParent(this);
            this.predefinedStCollection.setName(Messages.getString("DataTypesDesign.PredefinedStructuredTypes"));
            this.predefinedStCollection.setElementDescriptor(StructuredType.class);
            this.addStructureType();
            this.setDirty(false);
            this.getMainView().setDirty(false);
        }
        return this.predefinedStCollection;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.PREDEFINED_STATUS_CHANGED)) {
            AbstractDTObject st;
            if (object instanceof StructuredType) {
                st = (StructuredType)object;
                if (st.isPredefined()) {
                    if (!this.getPredefinedStCollection().contains(st)) {
                        st.setParent(this.getPredefinedStCollection());
                        this.getPredefinedStCollection().add(st);
                        this.getStructureTypeCollection().remove(st);
                    }
                } else if (!this.getStructureTypeCollection().contains(st)) {
                    st.setParent(this.getStructureTypeCollection());
                    this.getStructureTypeCollection().add(st);
                    this.getPredefinedStCollection().remove(st);
                }
            }
            if (object instanceof CollectionType) {
                st = (CollectionType)object;
                if (st.isPredefined()) {
                    if (!this.getPredefinedCtCollection().contains(st)) {
                        st.setParent(this.getPredefinedCtCollection());
                        this.getPredefinedCtCollection().add(st);
                        this.getCtCollection().remove(st);
                    }
                } else if (!this.getCtCollection().contains(st)) {
                    st.setParent(this.getCtCollection());
                    this.getCtCollection().add(st);
                    this.getPredefinedCtCollection().remove(st);
                }
            }
        }
    }

    public DesignObjectCollection getCtCollection() {
        if (this.ctCollection == null) {
            this.ctCollection = new DesignObjectCollection();
            this.ctCollection.setDesign(this.getDesign());
            this.ctCollection.setParent(this);
            this.ctCollection.setCanCreateElement(true);
            this.ctCollection.setName(Messages.getString("DataTypesDesign.CollectionTypes"));
            this.ctCollection.setElementDescriptor(CollectionType.class);
        }
        return this.ctCollection;
    }

    public DesignObjectCollection getPredefinedCtCollection() {
        if (this.predefinedCtCollection == null) {
            this.predefinedCtCollection = new DesignObjectCollection();
            this.predefinedCtCollection.setDesign(this.getDesign());
            this.predefinedCtCollection.setParent(this);
            this.predefinedCtCollection.setName(Messages.getString("DataTypesDesign.PredefinedCollectionTypes"));
            this.predefinedCtCollection.setElementDescriptor(CollectionType.class);
        }
        return this.predefinedCtCollection;
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("DistinctType");
        list.add("CollectionType");
        list.add("StructuredType");
        list.add("Note");
        list.add("MainView");
        list.add("SubView");
        return list;
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "datatypes").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "datatypes/" + this.getName() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean setName(String name) {
        return true;
    }

    @Override
    public StorableObject createObject(String objectType, String objectID, String name) {
        DesignObject object = null;
        if ("DistinctType".equalsIgnoreCase(objectType)) {
            object = this.getDistinctTypeSet().createDistinctType(objectID);
        } else if ("CollectionType".equalsIgnoreCase(objectType)) {
            object = this.getCollectionTypeSet().createCollectionType(objectID);
        } else if ("StructuredType".equalsIgnoreCase(objectType)) {
            object = this.getStructuredTypeSet().createStructuredType(objectID, false);
        } else if ("Note".equalsIgnoreCase(objectType)) {
            object = this.getNoteSet().createNote(objectID);
        }
        if (object != null && name != null && name.length() > 0) {
            object.setName(name);
        }
        return object;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("distincttype", "DistinctType");
            this.f2tMap.put("collectiontype", "CollectionType");
            this.f2tMap.put("structuredtype", "StructuredType");
            this.f2tMap.put("note", "Note");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, String path, StorableObjectStatusHelper sosHelper, String storableObjectID) {
        sosHelper.treePath.add(new TreePathHelper(OBJECT_NAME, new File(design.getDataTypesDesign().getStorageName()), DataTypesDesign.class));
        if ("distincttype".equalsIgnoreCase(path)) {
            sosHelper.objectClass = DistinctType.class;
            sosHelper.objectType = "DistinctType";
            sosHelper.treePath.add(new TreePathHelper(DISTINCT_TYPE_SET_NAME, file.getParentFile(), DistinctTypeSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((DataTypesDesign)sosHelper.designPart).getDistinctTypeSet();
                sosHelper.storableObject = ((DataTypesDesign)sosHelper.designPart).getDistinctTypeSet().getObjectByID(storableObjectID);
            }
        } else if ("collectiontype".equalsIgnoreCase(path)) {
            sosHelper.objectClass = CollectionType.class;
            sosHelper.objectType = "CollectionType";
            sosHelper.treePath.add(new TreePathHelper(COLLECTION_TYPE_SET_NAME, file.getParentFile(), CollectionTypeSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((DataTypesDesign)sosHelper.designPart).getCollectionTypeSet();
                sosHelper.storableObject = ((DataTypesDesign)sosHelper.designPart).getCollectionTypeSet().getObjectByID(storableObjectID);
            }
        } else if ("structuredtype".equalsIgnoreCase(path)) {
            sosHelper.objectClass = StructuredType.class;
            sosHelper.objectType = "StructuredType";
            sosHelper.treePath.add(new TreePathHelper(STRUCTURED_TYPE_SET_NAME, file.getParentFile(), StructuredTypeSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((DataTypesDesign)sosHelper.designPart).getStructuredTypeSet();
                sosHelper.storableObject = ((DataTypesDesign)sosHelper.designPart).getStructuredTypeSet().getObjectByID(storableObjectID);
            }
        } else if ("note".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Note.class;
            sosHelper.objectType = "Note";
            sosHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file.getParentFile(), NoteSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((DataTypesDesign)sosHelper.designPart).getNoteSet();
                sosHelper.storableObject = ((DataTypesDesign)sosHelper.designPart).getNoteSet().getObjectByID(storableObjectID);
            }
        } else if ("subviews".equalsIgnoreCase(path)) {
            sosHelper.objectClass = DPVDataTypesSubView.class;
            sosHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file.getParentFile(), DPVDataTypesSubView.class));
            if (sosHelper.designPart != null) {
                DataTypesDesign model = (DataTypesDesign)sosHelper.designPart;
                sosHelper.storableObject = model.getMainView().getDPVId().equals(storableObjectID) ? model.getMainView() : model.getSubViewByID(storableObjectID);
            }
        }
    }

    public List<StorableObject> getNotMarkedGenerateObjects() {
        ArrayList<StorableObject> notMarkedGenerateObjects = new ArrayList<StorableObject>();
        this.addMarkedGenerateStructuredTypes(notMarkedGenerateObjects, false);
        this.addMarkedGenerateCollectionTypes(notMarkedGenerateObjects, false);
        return notMarkedGenerateObjects;
    }

    public List<StorableObject> getMarkedGenerateObjects() {
        ArrayList<StorableObject> markedGenerateObjects = new ArrayList<StorableObject>();
        this.addMarkedGenerateStructuredTypes(markedGenerateObjects, true);
        this.addMarkedGenerateStructuredTypes(markedGenerateObjects, false);
        this.addMarkedGenerateCollectionTypes(markedGenerateObjects, true);
        this.addMarkedGenerateCollectionTypes(markedGenerateObjects, false);
        return markedGenerateObjects;
    }

    private void addMarkedGenerateStructuredTypes(List<StorableObject> markedGenerateObjects, boolean objectMarkedGenerate) {
        Iterator structuredTypesIterator = this.getStructuredTypeSet().iterator();
        while (structuredTypesIterator.hasNext()) {
            StructuredType structuredType = (StructuredType)structuredTypesIterator.next();
            if (structuredType.isMarkedGenerate() != objectMarkedGenerate) continue;
            markedGenerateObjects.add(structuredType);
        }
    }

    private void addMarkedGenerateCollectionTypes(List<StorableObject> markedGenerateObjects, boolean objectMarkedGenerate) {
        Iterator collectionTypesIterator = this.getCollectionTypeSet().iterator();
        while (collectionTypesIterator.hasNext()) {
            CollectionType collectionType = (CollectionType)collectionTypesIterator.next();
            if (collectionType.isMarkedGenerate() != objectMarkedGenerate) continue;
            markedGenerateObjects.add(collectionType);
        }
    }

    public List<StructuredType> getStructuredTypesOrderedByParent() {
        ArrayList<StructuredType> list = new ArrayList<StructuredType>();
        Iterator it = this.getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            this.addST(list, st);
        }
        return list;
    }

    private void addST(List<StructuredType> list, StructuredType st) {
        if (!list.contains(st)) {
            StructuredType parent = st.getParentType();
            if (parent != null) {
                this.addST(list, parent);
                if (!list.contains(st)) {
                    list.add(st);
                }
            } else {
                list.add(st);
            }
        }
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.sortCollections();
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        ArrayList<Object> objects = new ArrayList<Object>();
        Iterator it = this.getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType distinctType = (DistinctType)it.next();
            if (distinctType.getMeasurements().size() <= 0) continue;
            objects.add(distinctType);
        }
        it = this.getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType collectionType = (CollectionType)it.next();
            if (collectionType.getMeasurements().size() <= 0) continue;
            objects.add(collectionType);
        }
        it = this.getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType structuredType = (StructuredType)it.next();
            if (structuredType.getMeasurements().size() > 0) {
                objects.add(structuredType);
            }
            for (TypeElement te : Arrays.asList(structuredType.getElements())) {
                if (te.getMeasurements().size() <= 0) continue;
                objects.add(te);
            }
        }
        it = this.getMethodSet().iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            if (method.getMeasurements().size() <= 0) continue;
            objects.add(method);
        }
        it = this.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note = (Note)it.next();
            if (note.getMeasurements().size() <= 0) continue;
            objects.add(note);
        }
        it = this.getDTInheritanceSet().iterator();
        while (it.hasNext()) {
            DTInheritance dtInheritance = (DTInheritance)it.next();
            if (dtInheritance.getMeasurements().size() <= 0) continue;
            objects.add(dtInheritance);
        }
        it = this.getDTReferenceSet().iterator();
        while (it.hasNext()) {
            DTReference dtReference = (DTReference)it.next();
            if (dtReference.getMeasurements().size() <= 0) continue;
            objects.add(dtReference);
        }
        return objects;
    }

    @Override
    public ArrayList<SearchDockable> getAllSearchDockables() {
        if (this.allSearchDockables == null) {
            this.allSearchDockables = new ArrayList();
        }
        return this.allSearchDockables;
    }

    @Override
    public void addSearchDockable(SearchDockable sd) {
        this.getAllSearchDockables().add(sd);
    }

    @Override
    public SearchDockable getLastNonPinnedSearchDockable() {
        SearchDockable lastOne = null;
        int currentSeq = 0;
        for (SearchDockable sd : this.getAllSearchDockables()) {
            if (((SearchPanel)sd.getGUI()).isPinned() || sd.getViewSequence() < currentSeq) continue;
            lastOne = sd;
        }
        return lastOne;
    }

    @Override
    public int getSearchDockableIdSequence() {
        int currentSeq = 0;
        for (SearchDockable sd : this.getAllSearchDockables()) {
            if (sd.getViewSequence() <= currentSeq) continue;
            currentSeq = sd.getViewSequence();
        }
        return currentSeq + 1;
    }

    @Override
    public void closeAllSearchDockables() {
        for (SearchDockable sd : this.getAllSearchDockables()) {
            sd.closeView(sd);
        }
        this.getAllSearchDockables().clear();
    }

    @Override
    public List getSearchableSets() {
        return this.getSearchableSets(false);
    }

    public List getSearchableSets(boolean global) {
        ArrayList<SearchSet> sets = new ArrayList<SearchSet>();
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(StructuredType.class), StructuredType.class, this, this.getStructuredTypeSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(CollectionType.class), CollectionType.class, this, this.getCollectionTypeSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(DistinctType.class), DistinctType.class, this, this.getDistinctTypeSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(TypeElement.class), TypeElement.class, this, this.getTypeElementSet()));
        if (!global) {
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(Domain.class), Domain.class, this, this.getDesign().getDomainSet()));
        }
        return sets;
    }
}

