/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.io.File;
import java.io.IOException;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.swingui.editor.datatypes.DistinctTypePropertiesDialogEx;

public class DistinctType
extends AbstractDTObject
implements Datatype {
    private LogicalDatatype logicalDataType;
    private String size;
    private int scale;
    private int precision;
    public static final String TYPE_NAME = "DistinctType";

    public DistinctType(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public LogicalDatatype getLogicalDataType() {
        if (this.logicalDataType == null) {
            this.logicalDataType = this.getDesign().getLogicalDatatypeSet().getDefaultType();
        }
        return this.logicalDataType;
    }

    public void setLogicalDataType(LogicalDatatype logicalDataType) {
        this.logicalDataType = logicalDataType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public int getByteSize() {
        return 0;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DistinctTypePropertiesDialogEx dialog = new DistinctTypePropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getDataTypeString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getLogicalDataType().getName());
        if (this.size != null && !"".equalsIgnoreCase(this.size)) {
            buffer.append(" (");
            buffer.append(this.size);
            buffer.append(")");
        } else if (this.precision > 0) {
            buffer.append(" (");
            buffer.append(this.precision);
            if (this.scale > 0) {
                buffer.append(", ");
                buffer.append(this.scale);
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "distincttype/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        DesignObject object = null;
        object = this.getDesign().getDesignObject(id);
        if (object != null) {
            return object;
        }
        if ("logicalDataType".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getLogicalDatatypeSet().getObjectByID(id);
        }
        if (object != null) {
            return object;
        }
        return super.translateIdToObject(propertyName, id);
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }

    public void copyLogicalTypeAndParamsTo(ContainedObjectWithDomain co) {
        if (this.getLogicalDataType() != null) {
            int dtScale;
            int dtPrecision;
            co.setLogicalDatatype(this.getLogicalDataType());
            String dtSize = this.getSize();
            if (dtSize != null && dtSize.length() > 0 && !dtSize.equals("0")) {
                co.setDataTypeSize(dtSize);
            }
            if ((dtPrecision = this.getPrecision()) != 0) {
                co.setDataTypePrecision(String.valueOf(dtPrecision));
            }
            if ((dtScale = this.getScale()) != 0) {
                co.setDataTypePrecision(String.valueOf(dtScale));
            }
        }
    }
}

