/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.MethodParamSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.editor.datatypes.MethodPropertiesDialogEx;
import oracle.dbtools.crest.util.logging.Logger;

public class Method
extends DesignObject
implements ObjectListener {
    public static final String TYPE_NAME = "Method";
    private StructuredType structuredType;
    private boolean isConstructor = false;
    private boolean isOverriding = false;
    private Method overridedMethod;
    private List params = new ArrayList();
    private MethodParam returnValue;
    private String body = "";
    private IDGenerator localIDGenerator;
    private Map localIDs = new TreeMap();
    protected ObjectChangeEvent sharedEvent = new ObjectChangeEvent("ChangeEvent");
    private int number;
    private static final Logger LOGGER = new Logger(Method.class);

    public Method(DesignPart designPart, StructuredType structuredType) {
        super(designPart);
        this.structuredType = structuredType;
    }

    protected void assignLocalID(ModelIDObject object) {
        String id = object.getObjectID();
        if (id == null) {
            while (this.localIDs.containsKey(id = this.getLocalIDGenerator().createNewID())) {
            }
            this.localIDs.put(id, object);
            object.setObjectID(id);
        } else {
            this.localIDs.put(id, object);
        }
    }

    public IDGenerator getLocalIDGenerator() {
        if (this.localIDGenerator == null) {
            this.localIDGenerator = new IDGenerator();
            this.localIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.localIDGenerator;
    }

    public StructuredType getStructuredType() {
        return this.structuredType;
    }

    public void setStructuredType(StructuredType structuredType) {
        this.structuredType = structuredType;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void remove() {
        this.structuredType.removeMethod(this);
        super.remove();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MethodPropertiesDialogEx dialog = new MethodPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void setConstructor(boolean isConstructor) {
        this.isConstructor = isConstructor;
    }

    public boolean isOverriding() {
        return this.isOverriding;
    }

    public void setOverriding(boolean isOverriding) {
        this.isOverriding = isOverriding;
    }

    public Method getOverridedMethod() {
        return this.overridedMethod;
    }

    public void setOverridedMethod(Method overridedMethod) {
        this.overridedMethod = overridedMethod;
    }

    public List getParameters() {
        return this.params;
    }

    public void setParameters(List params) {
        this.params = params;
    }

    public MethodParam createParameter() {
        return this.createParameter(null);
    }

    public MethodParam createParameter(String parameterName) {
        MethodParam param = new MethodParam(this.getDesignPart());
        if (parameterName != null) {
            param.setName(parameterName);
        }
        param.setDesign(this.getDesign());
        this.addParameter(param);
        return param;
    }

    public void addParameter(int index, MethodParam param) {
        if (param == null || this.isReadOnly()) {
            return;
        }
        if (this.contains(param)) {
            this.params.remove(param);
            this.params.add(index, param);
            return;
        }
        if (!this.getParamClass().isAssignableFrom(param.getClass())) {
            LOGGER.error("Class: " + param.getClass());
            LOGGER.error("Expected: " + this.getParamClass());
            throw new RuntimeException("Wrong class added to method.");
        }
        this.assignLocalID(param);
        param.setParent(this);
        param.setMethod(this);
        this.params.add(index, param);
        this.getParamSet().add(param);
        param.getName();
        this.sharedEvent.setAffected(param);
        this.fireChange(this.sharedEvent);
    }

    public void addParameter(MethodParam param) {
        if (param == null || this.isReadOnly()) {
            return;
        }
        if (this.contains(param)) {
            return;
        }
        if (!this.getParamClass().isAssignableFrom(param.getClass())) {
            LOGGER.error("Class: " + param.getClass());
            LOGGER.error("Expected: " + this.getParamClass());
            throw new RuntimeException("Wrong class added to method.");
        }
        this.assignLocalID(param);
        param.setParent(this);
        param.setMethod(this);
        this.params.add(param);
        this.getParamSet().add(param);
        param.getName();
        this.sharedEvent.setAffected(param);
        this.fireChange(this.sharedEvent);
    }

    public MethodParamSet getParamSet() {
        return ((DataTypesDesign)this.getDesignPart()).getMethodParamSet();
    }

    public boolean contains(MethodParam param) {
        return this.params.contains(param);
    }

    public Class getParamClass() {
        return MethodParam.class;
    }

    public void removeParameter(MethodParam param) {
        if (param != null && this.isWriteable()) {
            this.getParamSet().remove(param);
            this.params.remove(param);
            this.localIDs.remove(param.getObjectID());
            param.removeObjectListener(this);
            param.setParent(null);
            this.sharedEvent.setAffected(param);
            this.fireChange(this.sharedEvent);
        }
    }

    public MethodParam getReturnValue() {
        return this.returnValue;
    }

    public String getReturnDataType() {
        if (this.returnValue != null) {
            RDBMSType dbtype = this.getDesign().getSelectedRDBMSType();
            if (dbtype == null) {
                dbtype = StorageDesignOraclev12c.RDBMS_TYPE;
            }
            return this.returnValue.getDataType(dbtype.getName());
        }
        return "";
    }

    public void setReturnValue(MethodParam returnValue) {
        if (returnValue != null && (returnValue.getObjectID() == null || returnValue.getObjectID().equals("null"))) {
            this.assignLocalID(returnValue);
        }
        this.returnValue = returnValue;
    }

    public MethodParam createReturnValue() {
        MethodParam param = new MethodParam(this.getDesignPart());
        param.setDesign(this.getDesign());
        this.setReturnValue(param);
        return param;
    }

    public void clearReturnValue() {
        this.returnValue = null;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (event == ObjectChangeEvent.OBJECT_REMOVED) {
            if (event.getAffected() instanceof MethodParam) {
                this.removeParameter((MethodParam)event.getAffected());
            }
        } else {
            this.fireChange(event);
        }
    }

    public void clearParams() {
        if (this.params.size() > 0) {
            Object[] list = this.params.toArray();
            for (int i = list.length - 1; i >= 0; --i) {
                MethodParam param = (MethodParam)list[i];
                this.removeParameter(param);
            }
        }
    }

    @Override
    public String getLongName() {
        return this.structuredType.getName().concat(".").concat(this.getName());
    }

    @Override
    public boolean setName(String name) {
        if (this.isWriteable()) {
            if (name != null && name.equals(this.name)) {
                return true;
            }
            this.name = name;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
            return true;
        }
        return false;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getMethodParamsAndDatatypesAsString() {
        if (this.getParameters().size() > 0) {
            String res = null;
            for (MethodParam mp : this.getParameters()) {
                if (res == null) {
                    res = mp.getName() + "/" + mp.getDataType();
                    continue;
                }
                res = res + "\n" + mp.getName() + "/" + mp.getDataType();
            }
            return res;
        }
        return "";
    }
}

