/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public abstract class EngPropertiesComparator
extends PropertyNames
implements GeneralPropertiesComparator {
    private DesignObject left_do;
    private DesignObject right_do;
    private boolean readOnly = false;
    protected String translated_name = "";
    protected List propertiesList = new ArrayList();

    public EngPropertiesComparator(DesignObject left_do, DesignObject right_do) {
        this.left_do = left_do;
        this.right_do = right_do;
    }

    @Override
    public List getPropertiesList() {
        return this.propertiesList;
    }

    @Override
    public abstract void copySelectedProperties();

    @Override
    public String getLeftName() {
        if (this.left_do != null) {
            return this.left_do.getName();
        }
        return "";
    }

    @Override
    public String getRightName() {
        if (this.right_do != null) {
            return this.right_do.getName();
        }
        return "";
    }

    protected void initNameProperty() {
        EngPropertyHolder ph = new EngPropertyHolder(NAME);
        ph.setLeftValue(this.left_do != null ? this.left_do.getName() : "");
        ph.setRightValue(this.right_do != null ? this.right_do.getName() : "");
        if (this.left_do != null && this.right_do != null && !this.left_do.getName().equals(this.right_do.getName())) {
            if (this.getDesign().isApplyNameStandardization()) {
                String tr_name = "";
                if (this.left_do.getDesignPart() instanceof LogicalDesign) {
                    if (this.right_do != null && this.right_do instanceof Index) {
                        Index ind = (Index)this.right_do;
                        tr_name = this.getDesign().transformNameFromLogicalToRelational(this.left_do, this.right_do, ind.getTable());
                    } else {
                        tr_name = this.getDesign().transformNameFromLogicalToRelational(this.left_do, this.right_do, null);
                    }
                } else {
                    tr_name = this.getDesign().transformNameFromRelationalToLogical(this.left_do);
                }
                if (!tr_name.equals(this.right_do.getName())) {
                    this.translated_name = tr_name;
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            } else {
                NamingStandardRule namingRule = this.getDesign().getNamingStandardRule();
                char logSep = namingRule.getLogicalSeparatorChar();
                char relSep = namingRule.getRelationalSeparatorChar();
                String tr_name = AbstractEngineering.transformSeparatorFromLogical(this.left_do.getName(), logSep, relSep);
                if (!tr_name.equals(this.right_do.getName())) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            }
        }
        this.propertiesList.add(ph);
    }

    protected void initNameTranslationProperty() {
        EngPropertyHolder name_ph;
        if (this.left_do == null || this.right_do == null) {
            return;
        }
        EngPropertyHolder ph = new EngPropertyHolder(NAME_TRANSLATION);
        String tr_name = "";
        String abbr = "";
        boolean pref_abbr = false;
        if (this.left_do != null) {
            if (this.isFromLogicalToRelational()) {
                if (this.right_do != null && this.right_do instanceof Index) {
                    Index ind = (Index)this.right_do;
                    tr_name = this.getDesign().transformNameFromLogicalToRelational(this.left_do, this.right_do, ind.getTable());
                } else {
                    tr_name = this.getDesign().transformNameFromLogicalToRelational(this.left_do, this.right_do, null);
                }
                if (this.left_do instanceof Attribute) {
                    abbr = ((Attribute)this.left_do).getPreferredAbbreviation();
                } else if (this.left_do instanceof Entity) {
                    abbr = ((Entity)this.left_do).getPreferredAbbreviation();
                }
                if (!"".equals(abbr) && this.getDesign().isUsePreferredAbbreviation()) {
                    ph.setLeftValue("(Pr.Abbr.)" + abbr);
                    if (this.right_do != null && !tr_name.equals(this.right_do.getName()) && (name_ph = this.getPropertyHolderByName(NAME)) != null) {
                        name_ph.setModified(true);
                        name_ph.setSelected(true);
                    }
                    if (tr_name.equalsIgnoreCase(abbr)) {
                        pref_abbr = true;
                    }
                } else {
                    ph.setLeftValue(tr_name);
                }
            } else {
                tr_name = this.getDesign().transformNameFromRelationalToLogical(this.left_do);
                String left_name = this.left_do.getName().trim();
                if (this.right_do != null) {
                    if (this.right_do instanceof Attribute) {
                        abbr = ((Attribute)this.right_do).getPreferredAbbreviation();
                    } else if (this.right_do instanceof Entity) {
                        abbr = ((Entity)this.right_do).getPreferredAbbreviation();
                    }
                    if (!"".equals(abbr) && this.getDesign().isUsePreferredAbbreviation()) {
                        ph.setRightValue("(Pr.Abbr.)" + abbr);
                        if (left_name.equalsIgnoreCase(abbr)) {
                            pref_abbr = true;
                        }
                    } else {
                        ph.setLeftValue(tr_name);
                    }
                }
                ph.setLeftValue(tr_name);
            }
        }
        if (this.left_do != null && this.right_do != null && !pref_abbr && !tr_name.equals(this.right_do.getName())) {
            this.translated_name = tr_name;
            name_ph = this.getPropertyHolderByName(NAME);
            if (name_ph != null) {
                name_ph.setModified(true);
                name_ph.setSelected(true);
            }
        }
        ph.setModified(false);
        ph.setSelected(false);
        this.propertiesList.add(ph);
    }

    protected void initCommentsAndNotes() {
        EngPropertyHolder ph = new EngPropertyHolder(COMMENT);
        ph.setLeftValue(this.left_do != null ? this.left_do.getComment() : "");
        ph.setRightValue(this.right_do != null ? this.right_do.getComment() : "");
        if (this.left_do != null && this.right_do != null && !this.left_do.getComment().equals(this.right_do.getComment())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(COMMENT_IN_RDBMS);
        ph.setLeftValue(this.left_do != null ? this.left_do.getCommentInRDBMS() : "");
        ph.setRightValue(this.right_do != null ? this.right_do.getCommentInRDBMS() : "");
        if (this.left_do != null && this.right_do != null && !this.left_do.getCommentInRDBMS().equals(this.right_do.getCommentInRDBMS())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(NOTES);
        ph.setLeftValue(this.left_do != null ? this.left_do.getNotes() : "");
        ph.setRightValue(this.right_do != null ? this.right_do.getNotes() : "");
        if (this.left_do != null && this.right_do != null && !this.left_do.getNotes().equals(this.right_do.getNotes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    protected void initDeprecated() {
        EngPropertyHolder ph = new EngPropertyHolder(DEPRECATED);
        ph.setLeftValue(this.left_do != null ? (this.left_do.isDeprecated() ? YES : NO) : "");
        ph.setRightValue(this.right_do != null ? (this.right_do.isDeprecated() ? YES : NO) : "");
        if (this.left_do != null && this.right_do != null && this.left_do.isDeprecated() != this.right_do.isDeprecated()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    protected void copyPropertiesFromLeftToRight() {
        if (this.left_do != null && this.right_do != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(NAME)) {
                    if (this.shouldApplyNametranslation()) {
                        if (!"".equals(this.translated_name)) {
                            this.right_do.setName(this.translated_name);
                            continue;
                        }
                        if (this.isFromLogicalToRelational()) {
                            this.right_do.setName(this.getDesign().transformNameFromLogicalToRelational(this.left_do));
                            continue;
                        }
                        this.right_do.setName(this.getDesign().transformNameFromRelationalToLogical(this.left_do));
                        continue;
                    }
                    this.right_do.setName(this.left_do.getName());
                    continue;
                }
                if (ph.getName().equals(COMMENT)) {
                    this.right_do.setComment(this.left_do.getComment());
                    continue;
                }
                if (ph.getName().equals(COMMENT_IN_RDBMS)) {
                    this.right_do.setCommentInRDBMS(this.left_do.getCommentInRDBMS());
                    continue;
                }
                if (ph.getName().equals(NOTES)) {
                    this.right_do.setNotes(this.left_do.getNotes());
                    continue;
                }
                if (!ph.getName().equals(DEPRECATED)) continue;
                this.right_do.setDeprecated(this.left_do.isDeprecated());
            }
        }
        if (this.isDirty()) {
            this.right_do.setDirty(true);
        }
    }

    @Override
    public boolean isModified() {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.getName().equals(NAME) && ph.isModified() && !ph.isFiltered()) {
                return true;
            }
            if (!ph.getName().equals(NAME) || !ph.isModified() || ph.isFiltered() || !ph.isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getID() {
        if (this.left_do != null && this.right_do != null) {
            return this.left_do.getObjectID() + this.right_do.getObjectID();
        }
        if (this.left_do != null) {
            return this.left_do.getObjectID();
        }
        if (this.right_do != null) {
            return this.right_do.getObjectID();
        }
        return "null";
    }

    protected boolean isDirty() {
        for (EngPropertyHolder ph : this.propertiesList) {
            if (!ph.isModified() || !ph.isSelected()) continue;
            return true;
        }
        return false;
    }

    public EngPropertyHolder getPropertyHolderByName(String name) {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.getName().equals(name)) continue;
            return ph;
        }
        return null;
    }

    private boolean isFromLogicalToRelational() {
        return this.left_do.getDesignPart() instanceof LogicalDesign;
    }

    public Design getDesign() {
        return this.left_do.getDesign();
    }

    protected boolean shouldApplyNametranslation() {
        return true;
    }

    protected boolean hasToBeRename() {
        return false;
    }

    protected boolean hasToBeDrop() {
        return false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void applyCompareFilter(List list, boolean showSelectedOnly) {
        ArrayList<EngPropertyHolder> selectedPH = new ArrayList<EngPropertyHolder>();
        ArrayList<EngPropertyHolder> noneSelectedPH = new ArrayList<EngPropertyHolder>();
        for (EngPropertyHolder ph : this.propertiesList) {
            if (this.isHolderselected(ph.getName(), list)) {
                selectedPH.add(ph);
                ph.setFiltered(false);
                continue;
            }
            noneSelectedPH.add(ph);
            ph.setFiltered(true);
            ph.setEditable(false);
        }
        this.propertiesList.clear();
        this.propertiesList.addAll(selectedPH);
        if (!showSelectedOnly) {
            this.propertiesList.addAll(noneSelectedPH);
        }
    }

    protected boolean isHolderselected(String name, List holders) {
        for (EngPropertyHolder ph : holders) {
            if (!ph.getName().equalsIgnoreCase(name)) continue;
            return ph.isSelected();
        }
        return true;
    }
}

