/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class EntityTableComparator
extends EngPropertiesComparator {
    private final Entity entity;
    private final Table table;

    public EntityTableComparator(Entity entity, Table table) {
        super(entity, table);
        this.entity = entity;
        this.table = table;
        this.initPropertiesList();
    }

    public EntityTableComparator(Entity entity, Table table, List filters) {
        this(entity, table);
        this.applyCompareFilter(filters, entity.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromEntityToTable();
        }
    }

    @Override
    protected void initNameProperty() {
        EngPropertyHolder ph = new EngPropertyHolder(NAME);
        ph.setLeftValue(this.entity != null ? this.entity.getName() : "");
        ph.setRightValue(this.table != null ? this.table.getName() : "");
        if (this.entity != null && this.table != null && !this.entity.getName().equals(this.table.getName())) {
            boolean change = false;
            if (this.getDesign().isApplyNameStandardization()) {
                String tr_name = this.getDesign().transformNameFromLogicalToRelational(this.entity);
                if (!tr_name.equals(this.table.getName())) {
                    change = true;
                }
            } else {
                change = true;
            }
            if (change) {
                if (this.entity.getFwdEngineeringStrategyName().equals("Single Table") && !this.entity.isHierarchicalRoot()) {
                    change = false;
                }
                if (this.entity.getFwdEngineeringStrategyName().equals("Table per child") && this.entity.getHierarchicalChildrenCount() > 0) {
                    change = false;
                }
                if (change) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            }
        }
        this.propertiesList.add(ph);
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        if (this.getDesign().isApplyNameStandardization() && !this.getDesign().isLoading()) {
            this.initNameTranslationProperty();
        }
        EngPropertyHolder ph = new EngPropertyHolder(SHORT_NAME_ABBR);
        ph.setLeftValue(this.entity != null ? this.entity.getShortName() : "");
        ph.setRightValue(this.table != null ? this.table.getAbbreviation() : "");
        if (this.entity != null && this.table != null && !this.entity.getShortName().equals(this.table.getAbbreviation())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        this.initDeprecated();
        this.initCommentsAndNotes();
        ph = new EngPropertyHolder(TEMP_TABLE_SCOPE);
        ph.setLeftValue(this.entity != null ? this.entity.getScope() : "");
        ph.setRightValue(this.table != null ? this.table.getScope() : "");
        if (this.entity != null && this.table != null && !this.entity.getScope().equals(this.table.getScope())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(TABLE_TYPE);
        ph.setLeftValue(this.entity != null ? this.entity.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.entity.getTypeID()) : "");
        ph.setRightValue(this.table != null ? this.table.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.table.getTypeID()) : "");
        if (this.entity != null && this.table != null && !this.entity.getTypeID().equals(this.table.getTypeID())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(STRUCTURED_TYPE);
        if (this.entity != null && this.entity.getBasedOnStructuredType() != null) {
            ph.setLeftValue(this.entity.getBasedOnStructuredType().getName());
        } else {
            ph.setLeftValue("");
        }
        if (this.table != null && this.table.getBasedOnStructuredType() != null) {
            ph.setRightValue(this.table.getBasedOnStructuredType().getName());
        } else {
            ph.setRightValue("");
        }
        if (this.entity != null && this.table != null && this.entity.getBasedOnStructuredType() != this.table.getBasedOnStructuredType()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ENT_TABLE_TYPE_SUBSTITUTION);
        ph.setRightValue(this.table != null && this.table.getTypeSubstitution() != null ? String.valueOf(this.table.getTypeSubstitution().getParentContainerObject().getName()) : "");
        ph.setLeftValue(this.entity != null && this.entity.getTypeSubstitution() != null ? String.valueOf(this.entity.getTypeSubstitution().getParentContainerObject().getName()) : "");
        if (this.table != null && this.entity != null) {
            if (this.entity.getTypeSubstitution() != null) {
                Entity ent = (Entity)this.entity.getTypeSubstitution().getParentContainerObject();
                Table tab = null;
                if (this.table.getTypeSubstitution() != null) {
                    tab = (Table)this.table.getTypeSubstitution().getParentContainerObject();
                }
                if (ent.getEngTable((RelationalDesign)this.table.getDesignPart()) != tab) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            } else if (this.table.getTypeSubstitution() != null) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        } else if (this.entity != null && this.entity.getTypeSubstitution() != null) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ALLOW_TYPE_SUBSTITUTION);
        ph.setLeftValue(this.entity != null ? String.valueOf(this.entity.isAllowTypeSubstitution()) : "");
        ph.setRightValue(this.table != null ? String.valueOf(this.table.isAllowTypeSubstitution()) : "");
        if (this.table != null && this.entity != null && this.table.isAllowTypeSubstitution() != this.entity.isAllowTypeSubstitution()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(MIN_VOLUMES);
        ph.setLeftValue(this.entity != null ? this.entity.getMinVolumes() : "");
        ph.setRightValue(this.table != null ? this.table.getMinVolumes() : "");
        if (this.entity != null && this.table != null && !this.entity.getMinVolumes().equals(this.table.getMinVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(EXPECTED_VOLUMES);
        ph.setLeftValue(this.entity != null ? this.entity.getExpectedVolumes() : "");
        ph.setRightValue(this.table != null ? this.table.getExpectedVolumes() : "");
        if (this.entity != null && this.table != null && !this.entity.getExpectedVolumes().equals(this.table.getExpectedVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(MAX_VOLUMES);
        ph.setLeftValue(this.entity != null ? this.entity.getMaxVolumes() : "");
        ph.setRightValue(this.table != null ? this.table.getMaxVolumes() : "");
        if (this.entity != null && this.table != null && !this.entity.getMaxVolumes().equals(this.table.getMaxVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(GROWTH_PERCENT);
        ph.setLeftValue(this.entity != null ? this.entity.getGrowthPercent() : "");
        ph.setRightValue(this.table != null ? this.table.getGrowthPercent() : "");
        if (this.entity != null && this.table != null && !this.entity.getGrowthPercent().equals(this.table.getGrowthPercent())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(GROWTH_TYPE);
        ph.setLeftValue(this.entity != null ? this.entity.getGrowthType() : "");
        ph.setRightValue(this.table != null ? this.table.getGrowthType() : "");
        if (this.entity != null && this.table != null && !this.entity.getGrowthType().equals(this.table.getGrowthType())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(NORMAL_FORM);
        ph.setLeftValue(this.entity != null ? this.entity.getNormalForm() : "");
        ph.setRightValue(this.table != null ? this.table.getNormalForm() : "");
        if (this.entity != null && this.table != null && !this.entity.getNormalForm().equals(this.table.getNormalForm())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ADEQUATELY_NORMALIZED);
        ph.setLeftValue(this.entity != null ? this.entity.getAdequatelyNormalized() : "");
        ph.setRightValue(this.table != null ? this.table.getAdequatelyNormalized() : "");
        if (this.entity != null && this.table != null && !this.entity.getAdequatelyNormalized().equals(this.table.getAdequatelyNormalized())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    private void copyPropertiesFromEntityToTable() {
        if (this.entity != null && this.table != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(TEMP_TABLE_SCOPE)) {
                    this.table.setScope(this.entity.getScope());
                    continue;
                }
                if (ph.getName().equals(TABLE_TYPE)) {
                    this.table.setTypeID(this.entity.getTypeID());
                    continue;
                }
                if (ph.getName().equals(SHORT_NAME_ABBR)) {
                    this.table.setAbbreviation(this.entity.getShortName());
                    continue;
                }
                if (ph.getName().equals(STRUCTURED_TYPE)) {
                    this.table.setBasedOnStructuredType(this.entity.getBasedOnStructuredType());
                    continue;
                }
                if (ph.getName().equals(MIN_VOLUMES)) {
                    this.table.setMinVolumes(this.entity.getMinVolumes());
                    continue;
                }
                if (ph.getName().equals(EXPECTED_VOLUMES)) {
                    this.table.setExpectedVolumes(this.entity.getExpectedVolumes());
                    continue;
                }
                if (ph.getName().equals(MAX_VOLUMES)) {
                    this.table.setMaxVolumes(this.entity.getMaxVolumes());
                    continue;
                }
                if (ph.getName().equals(GROWTH_PERCENT)) {
                    this.table.setGrowthPercent(this.entity.getGrowthPercent());
                    continue;
                }
                if (ph.getName().equals(GROWTH_TYPE)) {
                    this.table.setGrowthType(this.entity.getGrowthType());
                    continue;
                }
                if (ph.getName().equals(NORMAL_FORM)) {
                    this.table.setNormalForm(this.entity.getNormalForm());
                    continue;
                }
                if (ph.getName().equals(ADEQUATELY_NORMALIZED)) {
                    this.table.setAdequatelyNormalized(this.entity.getAdequatelyNormalized());
                    continue;
                }
                if (!ph.getName().equals(ALLOW_TYPE_SUBSTITUTION)) continue;
                this.table.setAllowTypeSubstitution(this.entity.isAllowTypeSubstitution());
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.entity != null ? MessageFormat.format(Messages.getString("EntityTableComparator.Entity"), this.entity.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.table != null ? MessageFormat.format(Messages.getString("EntityTableComparator.Table"), this.table.getName()) : "";
    }
}

