/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;

public class FK_RelationComparator
extends EngPropertiesComparator {
    private Relation rel;
    private FKIndexAssociation fk;
    private boolean mandatoryDefined = false;

    public FK_RelationComparator(FKIndexAssociation fk, Relation rel) {
        super(fk, rel);
        this.rel = rel;
        this.fk = fk;
        this.initPropertiesList();
    }

    public FK_RelationComparator(FKIndexAssociation fk, Relation rel, List filters) {
        this(fk, rel);
        this.applyCompareFilter(filters, fk.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            if (this.isMandatoryDefined() && this.rel != null && this.fk != null) {
                for (EngPropertyHolder ph : this.propertiesList) {
                    if (!ph.isSelected()) continue;
                    if (ph.getName().equals(MANDATORY)) {
                        String leftv = ph.getLeftValue();
                        try {
                            int[] pkends = this.rel.getPKProviderEndPoint();
                            if (pkends.length != 1) continue;
                            int endp = pkends[0];
                            int other = this.rel.getOtherEndPoint(endp);
                            boolean mandatory = Boolean.valueOf(leftv);
                            this.rel.setOptional(other, !mandatory);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (!ph.getName().equals(DELETE_RULE)) continue;
                    this.rel.setDeleteRule(this.fk.getDeleteRule());
                }
            }
        }
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initMandatory();
        this.initDeleteRule();
        this.initCommentsAndNotes();
    }

    private void initMandatory() {
        int[] pkends;
        String leftv = "";
        if (this.fk != null) {
            leftv = String.valueOf(this.fk.isMandatory());
        }
        String rightv = "";
        if (this.rel != null && (pkends = this.rel.getPKProviderEndPoint()).length == 1) {
            int endp = pkends[0];
            int other = this.rel.getOtherEndPoint(endp);
            rightv = String.valueOf(!this.rel.isOptional(other));
            this.mandatoryDefined = true;
        }
        if (this.mandatoryDefined) {
            PropertyHolder ph = new PropertyHolder(MANDATORY);
            ph.setLeftValue(leftv);
            ph.setRightValue(rightv);
            if (!leftv.equalsIgnoreCase(rightv)) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
        }
    }

    public boolean isMandatoryDefined() {
        return this.mandatoryDefined;
    }

    private void initDeleteRule() {
        boolean optional = true;
        String leftv = "";
        if (this.fk != null) {
            leftv = this.fk.getDeleteRule();
        }
        String rightv = "";
        if (this.rel != null) {
            rightv = this.rel.getDeleteRule();
        }
        PropertyHolder ph = new PropertyHolder(DELETE_RULE);
        ph.setLeftValue(leftv);
        ph.setRightValue(rightv);
        if (!leftv.equalsIgnoreCase(rightv)) {
            ph.setModified(optional);
            ph.setSelected(optional);
            ph.setEditable(optional);
        }
        this.propertiesList.add(ph);
    }
}

