/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Table;

public class TableEntityComparator
extends EngPropertiesComparator {
    private final Table table;
    private final Entity entity;

    public TableEntityComparator(Table table, Entity entity) {
        super(table, entity);
        this.table = table;
        this.entity = entity;
        this.initPropertiesList();
    }

    public TableEntityComparator(Table table, Entity entity, List filters) {
        this(table, entity);
        this.applyCompareFilter(filters, table.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromEntityToTable();
        }
    }

    @Override
    protected void initNameProperty() {
        EngPropertyHolder ph = new EngPropertyHolder(NAME);
        ph.setLeftValue(this.table != null ? this.table.getName() : "");
        ph.setRightValue(this.entity != null ? this.entity.getName() : "");
        if (this.table != null && this.entity != null && !this.table.getName().equals(this.entity.getName())) {
            boolean change = false;
            if (this.getDesign().isApplyNameStandardization()) {
                String tr_name = "";
                tr_name = this.getDesign().transformNameFromRelationalToLogical(this.table);
                if (!tr_name.equals(this.entity.getName())) {
                    change = true;
                }
            } else {
                change = true;
            }
            if (change) {
                if (this.entity.getFwdEngineeringStrategyName().equals("Single Table") && !this.entity.isHierarchicalRoot()) {
                    change = false;
                }
                if (this.entity.getFwdEngineeringStrategyName().equals("Table per child") && this.entity.getHierarchicalChildrenCount() > 0) {
                    change = false;
                }
                if (change) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            }
        }
        this.propertiesList.add(ph);
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        if (this.getDesign().isApplyNameStandardization()) {
            this.initNameTranslationProperty();
        }
        EngPropertyHolder ph = new EngPropertyHolder(SHORT_NAME_ABBR);
        ph.setLeftValue(this.table != null ? this.table.getAbbreviation() : "");
        ph.setRightValue(this.entity != null ? this.entity.getShortName() : "");
        if (this.table != null && this.entity != null && !this.table.getAbbreviation().equals(this.entity.getShortName())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        this.initDeprecated();
        this.initCommentsAndNotes();
        ph = new EngPropertyHolder(TEMP_TABLE_SCOPE);
        ph.setLeftValue(this.table != null ? this.table.getScope() : "");
        ph.setRightValue(this.entity != null ? this.entity.getScope() : "");
        if (this.table != null && this.entity != null && !this.table.getScope().equals(this.entity.getScope())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(TABLE_TYPE);
        ph.setLeftValue(this.table != null ? this.table.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.table.getTypeID()) : "");
        ph.setRightValue(this.entity != null ? this.entity.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.entity.getTypeID()) : "");
        if (this.table != null && this.entity != null && !this.table.getTypeID().equals(this.entity.getTypeID())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(STRUCTURED_TYPE);
        if (this.table != null && this.table.getBasedOnStructuredType() != null) {
            ph.setLeftValue(this.table.getBasedOnStructuredType().getName());
        } else {
            ph.setLeftValue("");
        }
        if (this.entity != null && this.entity.getBasedOnStructuredType() != null) {
            ph.setRightValue(this.entity.getBasedOnStructuredType().getName());
        } else {
            ph.setRightValue("");
        }
        if (this.table != null && this.entity != null && this.table.getBasedOnStructuredType() != this.entity.getBasedOnStructuredType()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ENT_TABLE_TYPE_SUBSTITUTION);
        ph.setLeftValue(this.table != null && this.table.getTypeSubstitution() != null ? String.valueOf(this.table.getTypeSubstitution().getParentContainerObject().getName()) : "");
        ph.setRightValue(this.entity != null && this.entity.getTypeSubstitution() != null ? String.valueOf(this.entity.getTypeSubstitution().getParentContainerObject().getName()) : "");
        if (this.table != null && this.entity != null) {
            if (this.table.getTypeSubstitution() != null) {
                Table tab = (Table)this.table.getTypeSubstitution().getParentContainerObject();
                Entity ent = null;
                if (this.entity.getTypeSubstitution() != null) {
                    ent = (Entity)this.entity.getTypeSubstitution().getParentContainerObject();
                }
                if (tab.getEngEntity() != ent) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            } else if (this.entity.getTypeSubstitution() != null) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        } else if (this.table != null && this.table.getTypeSubstitution() != null) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ALLOW_TYPE_SUBSTITUTION);
        ph.setLeftValue(this.table != null ? String.valueOf(this.table.isAllowTypeSubstitution()) : "");
        ph.setRightValue(this.entity != null ? String.valueOf(this.entity.isAllowTypeSubstitution()) : "");
        if (this.table != null && this.entity != null && this.table.isAllowTypeSubstitution() != this.entity.isAllowTypeSubstitution()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(MIN_VOLUMES);
        ph.setLeftValue(this.table != null ? this.table.getMinVolumes() : "");
        ph.setRightValue(this.entity != null ? this.entity.getMinVolumes() : "");
        if (this.table != null && this.entity != null && !this.table.getMinVolumes().equals(this.entity.getMinVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(EXPECTED_VOLUMES);
        ph.setLeftValue(this.table != null ? this.table.getExpectedVolumes() : "");
        ph.setRightValue(this.entity != null ? this.entity.getExpectedVolumes() : "");
        if (this.table != null && this.entity != null && !this.table.getExpectedVolumes().equals(this.entity.getExpectedVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(MAX_VOLUMES);
        ph.setLeftValue(this.table != null ? this.table.getMaxVolumes() : "");
        ph.setRightValue(this.entity != null ? this.entity.getMaxVolumes() : "");
        if (this.table != null && this.entity != null && !this.table.getMaxVolumes().equals(this.entity.getMaxVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(GROWTH_PERCENT);
        ph.setLeftValue(this.table != null ? this.table.getGrowthPercent() : "");
        ph.setRightValue(this.entity != null ? this.entity.getGrowthPercent() : "");
        if (this.table != null && this.entity != null && !this.table.getGrowthPercent().equals(this.entity.getGrowthPercent())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(GROWTH_TYPE);
        ph.setLeftValue(this.table != null ? this.table.getGrowthType() : "");
        ph.setRightValue(this.entity != null ? this.entity.getGrowthType() : "");
        if (this.table != null && this.entity != null && !this.table.getGrowthType().equals(this.entity.getGrowthType())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(NORMAL_FORM);
        ph.setLeftValue(this.table != null ? this.table.getNormalForm() : "");
        ph.setRightValue(this.entity != null ? this.entity.getNormalForm() : "");
        if (this.table != null && this.entity != null && !this.table.getNormalForm().equals(this.entity.getNormalForm())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ADEQUATELY_NORMALIZED);
        ph.setLeftValue(this.table != null ? this.table.getAdequatelyNormalized() : "");
        ph.setRightValue(this.entity != null ? this.entity.getAdequatelyNormalized() : "");
        if (this.table != null && this.entity != null && !this.table.getAdequatelyNormalized().equals(this.entity.getAdequatelyNormalized())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    private void copyPropertiesFromEntityToTable() {
        if (this.table != null && this.entity != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(TEMP_TABLE_SCOPE)) {
                    this.entity.setScope(this.table.getScope());
                    continue;
                }
                if (ph.getName().equals(TABLE_TYPE)) {
                    this.entity.setTypeID(this.table.getTypeID());
                    continue;
                }
                if (ph.getName().equals(SHORT_NAME_ABBR)) {
                    this.entity.setShortName(this.table.getAbbreviation());
                    continue;
                }
                if (ph.getName().equals(STRUCTURED_TYPE)) {
                    this.entity.setBasedOnStructuredType(this.table.getBasedOnStructuredType());
                    continue;
                }
                if (ph.getName().equals(MIN_VOLUMES)) {
                    this.entity.setMinVolumes(this.table.getMinVolumes());
                    continue;
                }
                if (ph.getName().equals(EXPECTED_VOLUMES)) {
                    this.entity.setExpectedVolumes(this.table.getExpectedVolumes());
                    continue;
                }
                if (ph.getName().equals(MAX_VOLUMES)) {
                    this.entity.setMaxVolumes(this.table.getMaxVolumes());
                    continue;
                }
                if (ph.getName().equals(GROWTH_PERCENT)) {
                    this.entity.setGrowthPercent(this.table.getGrowthPercent());
                    continue;
                }
                if (ph.getName().equals(GROWTH_TYPE)) {
                    this.entity.setGrowthType(this.table.getGrowthType());
                    continue;
                }
                if (ph.getName().equals(NORMAL_FORM)) {
                    this.entity.setNormalForm(this.table.getNormalForm());
                    continue;
                }
                if (ph.getName().equals(ADEQUATELY_NORMALIZED)) {
                    this.entity.setAdequatelyNormalized(this.table.getAdequatelyNormalized());
                    continue;
                }
                if (!ph.getName().equals(ALLOW_TYPE_SUBSTITUTION)) continue;
                this.entity.setAllowTypeSubstitution(this.table.isAllowTypeSubstitution());
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.table != null ? MessageFormat.format(Messages.getString("TableEntityComparator.Table"), this.table.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.entity != null ? MessageFormat.format(Messages.getString("TableEntityComparator.Entity"), this.entity.getName()) : "";
    }
}

