/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.glossary;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.engineering.EngEmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.model.design.glossary.GlossaryWordSelection;
import oracle.dbtools.crest.model.design.glossary.WordPropertiesComparator;
import oracle.dbtools.crest.model.design.process.EventSet;

public class GlossaryImportSelection
extends EngFilteredSelection {
    private EngineeringObjectSelection rightRoot;
    private Map comparatorsMap = new TreeMap();
    private List impWords;
    private List existingWords = new ArrayList();

    public GlossaryImportSelection(Glossary left_glossary, Glossary right_glossary, Design design) {
        super(left_glossary.getName());
        this.setDesign(design);
        this.setName(Messages.getString("GlossaryImportSelection.WordsToImport"));
        this.rightRoot = new EngFilteredSelection(right_glossary.getName());
        this.rightRoot.setName(MessageFormat.format(Messages.getString("GlossaryImportSelection.CorrespondingWordsIn"), right_glossary.getName()));
        this.setCorrespondentNode(this.rightRoot);
        this.rightRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.rightRoot);
        left_glossary.sortWords();
        this.impWords = left_glossary.getWords();
        this.existingWords = right_glossary.getWords();
        this.addWords();
    }

    private void setEmptyComparator(EngineeringObjectSelection node) {
        node.setPropertiesComparator(new EngEmptyPropertiesComparator(null, null));
    }

    private GlossaryWord getWordByImportedID(List existingWords, String impID) {
        for (GlossaryWord word : existingWords) {
            String imp_id = word.getImportID();
            if (imp_id == null || !impID.equalsIgnoreCase(imp_id)) continue;
            return word;
        }
        return null;
    }

    private GlossaryWord getWordByID(List existingWords, String id) {
        for (GlossaryWord word : existingWords) {
            if (!id.equalsIgnoreCase(word.getId())) continue;
            return word;
        }
        return null;
    }

    private GlossaryWord getWordByName(List existingWords, String name) {
        for (GlossaryWord word : existingWords) {
            if (!name.equalsIgnoreCase(word.getName())) continue;
            return word;
        }
        return null;
    }

    private void addWord(GlossaryWord word, EngineeringObjectSelection allLeftSel, EngineeringObjectSelection allRightSel, boolean details) {
        GlossaryWordSelection leftSel = new GlossaryWordSelection(word);
        boolean selected = true;
        GlossaryWord rightWord = this.getWordByImportedID(this.existingWords, word.getId());
        if (rightWord == null) {
            rightWord = this.getWordByID(this.existingWords, word.getId());
        }
        if (rightWord == null && word.getImportID() != null && !"".equals(word.getImportID()) && (rightWord = this.getWordByID(this.existingWords, word.getImportID())) == null) {
            rightWord = this.getWordByImportedID(this.existingWords, word.getImportID());
        }
        if (rightWord == null && (rightWord = this.getWordByName(this.existingWords, word.getName())) != null) {
            selected = false;
        }
        leftSel.setSelected(selected);
        EngineeringObjectSelection rightSel = null;
        if (rightWord != null) {
            rightSel = new GlossaryWordSelection(rightWord);
            WordPropertiesComparator comp = new WordPropertiesComparator(word, rightWord);
            leftSel.setPropertiesComparator(comp);
            rightSel.setPropertiesComparator(comp);
            rightSel.setSelected(comp.isModified());
            this.comparatorsMap.put(comp.getID(), comp);
        } else {
            rightSel = new EngineeringObjectSelection(word.getName());
            leftSel.setStatus(ModelIdObjectSelection.STATE_NEW);
            rightSel.setStatus(ModelIdObjectSelection.STATE_NEW);
            WordPropertiesComparator comp = new WordPropertiesComparator(word, null);
            leftSel.setPropertiesComparator(comp);
            rightSel.setPropertiesComparator(comp);
        }
        leftSel.setElementDescriptor(EventSet.class);
        rightSel.setElementDescriptor(EventSet.class);
        rightSel.setCorrespondentNode(leftSel);
        leftSel.setCorrespondentNode(rightSel);
        allLeftSel.addChild(leftSel);
        allRightSel.addChild(rightSel);
    }

    private void addWords() {
        for (GlossaryWord word : this.impWords) {
            this.addWord(word, this, this.rightRoot, true);
        }
    }

    public EngineeringObjectSelection getLeftRoot() {
        return this;
    }

    public EngineeringObjectSelection getRightRoot() {
        return this.rightRoot;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }
}

