/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.impact.ImpA_AttributeView;
import oracle.dbtools.crest.model.design.impact.ImpA_Column;
import oracle.dbtools.crest.model.design.impact.ImpA_KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_Attribute
extends LongNameObjectSelection {
    private Attribute attribute;

    public ImpA_Attribute(Attribute attribute, ModelIdObjectSelection parent, boolean load) {
        super(attribute);
        this.attribute = attribute;
        this.setParent(parent);
        if (load) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addAttributeNodes(this);
        this.addDependentFKAttributes();
        this.addViews();
        this.addProcessModel();
        ImpA_Attribute.addDimensionalModels(this, this.attribute);
        this.loaded = true;
    }

    private void addAttributeNodes(ImpA_Attribute parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.Mappings"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
        parent.addChild(selection);
        if (this.attribute.getObjectID() != null) {
            ModelIdObjectSelection attrNode = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.RelationalModels"));
            attrNode.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
            selection.addChild(attrNode);
            Iterator it = this.attribute.getDesign().getRelationalDesigns().iterator();
            while (it.hasNext()) {
                RelationalDesign relDesign = (RelationalDesign)it.next();
                ModelIdObjectSelection relModels = null;
                if (relDesign.isLoaded()) {
                    relModels = new ModelIdObjectSelection(relDesign.getName());
                    relModels.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
                    attrNode.addChild(relModels);
                } else {
                    relModels = new ModelIdObjectSelection(relDesign.getName() + "(not loaded)");
                    relModels.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
                    attrNode.addChild(relModels);
                }
                List list = relDesign.getDesign().getExtendedMap().getMappingsForDesignPart(this.attribute, relDesign.getObjectID());
                for (XtdMapping mapping : list) {
                    if (relDesign.isLoaded()) {
                        Column column = (Column)mapping.getObjectMappedTo(this.attribute);
                        if (column == null) continue;
                        if (!relModels.hasAsParent(column)) {
                            relModels.addChild(new ImpA_Column(column, relModels, false));
                            continue;
                        }
                        relModels.addChild(new LongNameObjectSelection(column));
                        continue;
                    }
                    String name = mapping.getOtherName(this.attribute.getObjectID());
                    relModels.addChild(new ModelIdObjectSelection(name + "(not loaded)"));
                }
            }
        }
        ModelIdObjectSelection constrSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.PKAndUKConstraints"));
        constrSelection.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        parent.addChild(constrSelection);
        if (this.attribute.isUnique() || this.attribute.isPKElement()) {
            Iterator itk = this.attribute.getContainerWithKeyObject().getKeySet().iterator();
            while (itk.hasNext()) {
                KeyObject key = (KeyObject)itk.next();
                if (!key.getElementsCollection().contains(this.attribute)) continue;
                if (!constrSelection.hasAsParent(key)) {
                    constrSelection.addChild(new ImpA_KeyObject(key, constrSelection, false));
                    continue;
                }
                constrSelection.addChild(new LongNameObjectSelection(key));
            }
        }
    }

    private void addProcessModel() {
        ModelIdObjectSelection psel;
        Process process;
        int i;
        ModelIdObjectSelection sel;
        DFDholder dfdh;
        TreeMap<String, DFDholder> inbound = new TreeMap<String, DFDholder>();
        TreeMap<String, DFDholder> outbound = new TreeMap<String, DFDholder>();
        TreeMap<String, DFDholder> flows = new TreeMap<String, DFDholder>();
        ProcessModel processModel = this.attribute.getDesign().getProcessModel();
        Iterator it = processModel.getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)it.next();
            DataFlowDesign topDFD = dfd.getTopLevelDataFlowDesign();
            Iterator dfdit = dfd.getProcessSet().iterator();
            while (dfdit.hasNext()) {
                Process process2 = (Process)dfdit.next();
                if (process2.getType() != 0) continue;
                for (Process.ProcessedObject po : process2.getProcessedAttributesAndFlows(false, this.attribute)) {
                    DFDholder dfdh2;
                    if (po.getObject() != this.attribute) continue;
                    if (po.isInbound()) {
                        dfdh2 = (DFDholder)inbound.get(topDFD.getName());
                        if (dfdh2 == null) {
                            dfdh2 = new DFDholder();
                            dfdh2.dfd = topDFD;
                            dfdh2.list = new ArrayList();
                            inbound.put(topDFD.getName(), dfdh2);
                        }
                        if (!dfdh2.list.contains(process2)) {
                            dfdh2.list.add(process2);
                        }
                    } else {
                        dfdh2 = (DFDholder)outbound.get(topDFD.getName());
                        if (dfdh2 == null) {
                            dfdh2 = new DFDholder();
                            dfdh2.dfd = topDFD;
                            dfdh2.list = new ArrayList();
                            outbound.put(topDFD.getName(), dfdh2);
                        }
                        if (!dfdh2.list.contains(process2)) {
                            dfdh2.list.add(process2);
                        }
                    }
                    dfdh2 = (DFDholder)flows.get(topDFD.getName());
                    if (dfdh2 == null) {
                        dfdh2 = new DFDholder();
                        dfdh2.dfd = topDFD;
                        dfdh2.list = new ArrayList();
                        flows.put(topDFD.getName(), dfdh2);
                    }
                    if (dfdh2.list.contains(po.getFlow())) continue;
                    dfdh2.list.add(po.getFlow());
                }
            }
        }
        ModelIdObjectSelection pm = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.ProcessModel"));
        pm.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
        this.addChild(pm);
        ModelIdObjectSelection inb = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.InboundProcesses"));
        inb.setIcon(GUIConfiguration.getInstance().getIcon("PROCESS_ICON"));
        pm.addChild(inb);
        ModelIdObjectSelection outb = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.OutboundProcesses"));
        outb.setIcon(GUIConfiguration.getInstance().getIcon("PROCESS_ICON"));
        pm.addChild(outb);
        ModelIdObjectSelection fl = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.Flows"));
        fl.setIcon(GUIConfiguration.getInstance().getIcon("FLOW_ICON"));
        pm.addChild(fl);
        for (String key : inbound.keySet()) {
            dfdh = (DFDholder)inbound.get(key);
            if (dfdh.list.size() <= 0) continue;
            Collections.sort(dfdh.list, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
            sel = new ModelIdObjectSelection(dfdh.dfd);
            inb.addChild(sel);
            for (i = 0; i < dfdh.list.size(); ++i) {
                process = (Process)dfdh.list.get(i);
                psel = new ModelIdObjectSelection(process);
                sel.addChild(psel);
            }
        }
        for (String key : outbound.keySet()) {
            dfdh = (DFDholder)outbound.get(key);
            if (dfdh.list.size() <= 0) continue;
            Collections.sort(dfdh.list, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
            sel = new ModelIdObjectSelection(dfdh.dfd);
            outb.addChild(sel);
            for (i = 0; i < dfdh.list.size(); ++i) {
                process = (Process)dfdh.list.get(i);
                psel = new ModelIdObjectSelection(process);
                sel.addChild(psel);
            }
        }
        for (String key : flows.keySet()) {
            dfdh = (DFDholder)flows.get(key);
            if (dfdh.list.size() <= 0) continue;
            Collections.sort(dfdh.list, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
            sel = new ModelIdObjectSelection(dfdh.dfd);
            fl.addChild(sel);
            for (i = 0; i < dfdh.list.size(); ++i) {
                DesignObject flow = (DesignObject)dfdh.list.get(i);
                psel = new ModelIdObjectSelection(flow);
                sel.addChild(psel);
            }
        }
    }

    private void addDependentFKAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Iterator it = this.attribute.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (attr.getDelegate() != this.attribute) continue;
            list.add(attr);
        }
        if (list.size() > 0) {
            ModelIdObjectSelection depAttr = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.DependentFKAttributes"));
            depAttr.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
            this.addChild(depAttr);
            for (Attribute attr : list) {
                if (!depAttr.hasAsParent(attr)) {
                    depAttr.addChild(new ImpA_Attribute(attr, depAttr, false));
                    continue;
                }
                depAttr.addChild(new LongNameObjectSelection(attr));
            }
        }
    }

    private void addViews() {
        ModelIdObjectSelection viewSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.DependentViewAttributes"));
        viewSelection.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
        this.addChild(viewSelection);
        ArrayList<AttributeView> list = new ArrayList<AttributeView>();
        Iterator it = this.attribute.getDesign().getLogicalDesign().getAttributeViewSet().iterator();
        while (it.hasNext()) {
            AttributeView attrView = (AttributeView)it.next();
            if (attrView.getReferencedAttribute() == null || attrView.getReferencedColumnView() != null || attrView.getReferencedAttribute() != this.attribute) continue;
            list.add(attrView);
        }
        for (AttributeView view : list) {
            if (!viewSelection.hasAsParent(view)) {
                viewSelection.addChild(new ImpA_AttributeView(view, viewSelection));
                continue;
            }
            viewSelection.addChild(new ModelIdObjectSelection(view));
        }
    }

    public static void addDimensionalModels(ModelIdObjectSelection parent, ContainedObject attribute) {
        ModelIdObjectSelection dms = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.DimensionalModels"));
        dms.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        parent.addChild(dms);
        Iterator it = attribute.getDesign().getMultidimensionalDesigns().iterator();
        while (it.hasNext()) {
            MultidimensionalDesign dm = (MultidimensionalDesign)it.next();
            if (dm.getBoundModel() != attribute.getDesignPart()) continue;
            ImpA_Attribute.addDimensionalModel(dm, dms, attribute);
        }
    }

    private static void addDimensionalModel(MultidimensionalDesign dm, ModelIdObjectSelection parent, ContainedObject attribute) {
        ModelIdObjectSelection dms = new ModelIdObjectSelection(dm);
        dms.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
        parent.addChild(dms);
        ModelIdObjectSelection cubes = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.Measures"));
        cubes.setIcon(GUIConfiguration.getInstance().getIcon("MEASURE_ICON"));
        dms.addChild(cubes);
        Iterator it = dm.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            ArrayList<Measure> list = new ArrayList<Measure>();
            for (Measure measure : cube.getMeasures()) {
                if (measure.getMeasureFact() != attribute) continue;
                list.add(measure);
            }
            if (list.size() <= 0) continue;
            ModelIdObjectSelection cubeNode = new ModelIdObjectSelection(cube);
            cubes.addChild(cubeNode);
            for (Measure measure : list) {
                cubeNode.addChild(new LongNameObjectSelection(measure));
            }
        }
        ModelIdObjectSelection levels = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.LevelAttributes"));
        levels.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
        dms.addChild(levels);
        it = dm.getLevelSet().iterator();
        while (it.hasNext()) {
            Level level = (Level)it.next();
            ArrayList attrs = new ArrayList();
            ArrayList list = new ArrayList();
            list.addAll(level.getLevelKey());
            list.addAll(level.getSlowChangingAttributes());
            list.addAll(level.getJoinAttributes());
            for (Object obj : list) {
                if (obj != attribute && (!(obj instanceof SlowChangingAttribute) || attribute != ((SlowChangingAttribute)obj).getAttribute())) continue;
                attrs.add(obj);
            }
            if (attrs.size() <= 0) continue;
            ModelIdObjectSelection levelNode = new ModelIdObjectSelection(level);
            levels.addChild(levelNode);
            for (Object obj : attrs) {
                if (obj instanceof ContainedObject) {
                    levelNode.addChild(new ModelIdObjectSelection(attribute.getName()));
                    continue;
                }
                if (!(obj instanceof SlowChangingAttribute)) continue;
                levelNode.addChild(new ModelIdObjectSelection(((SlowChangingAttribute)obj).getName()));
            }
        }
        ModelIdObjectSelection joins = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.JoinsRollupLinks"));
        joins.setIcon(GUIConfiguration.getInstance().getIcon("LINK_ICON"));
        dms.addChild(joins);
        it = dm.getRollupLinkSet().iterator();
        while (it.hasNext()) {
            RollupLink rlink = (RollupLink)it.next();
            if (rlink == null || !rlink.getChildToParentAttributes().contains(attribute)) continue;
            joins.addChild(new ModelIdObjectSelection(rlink));
        }
    }

    class DFDholder {
        DataFlowDesign dfd;
        List list;

        DFDholder() {
        }
    }
}

