/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.impact.ImpA_EntityView;
import oracle.dbtools.crest.model.design.impact.ImpA_Table;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_Entity
extends ModelIdObjectSelection {
    private Entity entity;

    public ImpA_Entity(Entity entity, ModelIdObjectSelection parent, boolean load) {
        super(entity);
        this.entity = entity;
        this.setParent(parent);
        if (load) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addEntityNodes();
        this.addEntityViews();
        this.addProcessModel();
        ImpA_Entity.addDimensionalModels(this, this.entity);
        this.addSubViews();
        this.loaded = true;
    }

    private void addEntityNodes() {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.Mappings"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        this.addChild(selection);
        ModelIdObjectSelection relModelNode = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.RelationalModels"));
        relModelNode.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        selection.addChild(relModelNode);
        Iterator it = this.entity.getDesign().getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign relDesign = (RelationalDesign)it.next();
            ModelIdObjectSelection relDesignNode = null;
            if (relDesign.isLoaded()) {
                relDesignNode = new ModelIdObjectSelection(relDesign.getName());
                relDesignNode.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
                relModelNode.addChild(relDesignNode);
            } else {
                relDesignNode = new ModelIdObjectSelection(relDesign.getName() + "(not loaded)");
                relDesignNode.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
                relModelNode.addChild(relDesignNode);
            }
            if (this.entity.getObjectID() == null) continue;
            List list = relDesign.getDesign().getExtendedMap().getMappingsForDesignPart(this.entity, relDesign.getObjectID());
            for (XtdMapping mapping : list) {
                if (relDesign.isLoaded()) {
                    Table table = (Table)mapping.getObjectMappedTo(this.entity);
                    if (table == null) continue;
                    if (!relModelNode.hasAsParent(table)) {
                        relDesignNode.addChild(new ImpA_Table(table, relModelNode, false));
                        continue;
                    }
                    relDesignNode.addChild(new ModelIdObjectSelection(table));
                    continue;
                }
                String tname = mapping.getOtherName(this.entity.getObjectID());
                relDesignNode.addChild(new ModelIdObjectSelection(tname + "(not loaded)"));
            }
        }
    }

    private void addEntityViews() {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.DependentViews"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        this.addChild(selection);
        ArrayList<EntityView> list = new ArrayList<EntityView>();
        Iterator it = this.entity.getDesign().getLogicalDesign().getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView entityView = (EntityView)it.next();
            if (entityView.getContainerHolderFor(this.entity) == null) continue;
            list.add(entityView);
        }
        for (EntityView view : list) {
            if (!selection.hasAsParent(view)) {
                selection.addChild(new ImpA_EntityView(view, selection));
                continue;
            }
            selection.addChild(new ModelIdObjectSelection(view));
        }
    }

    private void addProcessModel() {
        ModelIdObjectSelection psel;
        Process process;
        int i;
        ModelIdObjectSelection sel;
        DFDholder dfdh;
        TreeMap<String, DFDholder> inbound = new TreeMap<String, DFDholder>();
        TreeMap<String, DFDholder> outbound = new TreeMap<String, DFDholder>();
        ArrayList<Flow> flows = new ArrayList<Flow>();
        ProcessModel processModel = this.entity.getDesign().getProcessModel();
        Iterator<Object> it = processModel.getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)it.next();
            DataFlowDesign topDFD = dfd.getTopLevelDataFlowDesign();
            Iterator dfdit = dfd.getProcessSet().iterator();
            while (dfdit.hasNext()) {
                Process process2 = (Process)dfdit.next();
                if (process2.getType() != 0) continue;
                for (Process.ProcessedObject po : process2.getProcessedEntitiesAndFlows(false, this.entity)) {
                    if (po.getObject() != this.entity) continue;
                    if (po.isInbound()) {
                        DFDholder dfdh2 = (DFDholder)inbound.get(topDFD.getObjectID());
                        if (dfdh2 == null) {
                            dfdh2 = new DFDholder();
                            dfdh2.dfd = topDFD;
                            dfdh2.list = new ArrayList();
                            inbound.put(topDFD.getObjectID(), dfdh2);
                        }
                        if (!dfdh2.list.contains(process2)) {
                            dfdh2.list.add(process2);
                        }
                    } else {
                        DFDholder dfdh2 = (DFDholder)outbound.get(topDFD.getObjectID());
                        if (dfdh2 == null) {
                            dfdh2 = new DFDholder();
                            dfdh2.dfd = topDFD;
                            dfdh2.list = new ArrayList();
                            outbound.put(topDFD.getObjectID(), dfdh2);
                        }
                        if (!dfdh2.list.contains(process2)) {
                            dfdh2.list.add(process2);
                        }
                    }
                    if (flows.contains(po.getFlow())) continue;
                    flows.add(po.getFlow());
                }
            }
        }
        ModelIdObjectSelection pm = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.ProcessModel"));
        pm.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
        this.addChild(pm);
        ModelIdObjectSelection inb = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.InboundProcesses"));
        inb.setIcon(GUIConfiguration.getInstance().getIcon("PROCESS_ICON"));
        pm.addChild(inb);
        ModelIdObjectSelection outb = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.OutboundProcesses"));
        outb.setIcon(GUIConfiguration.getInstance().getIcon("PROCESS_ICON"));
        pm.addChild(outb);
        ModelIdObjectSelection fl = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.Flows"));
        fl.setIcon(GUIConfiguration.getInstance().getIcon("FLOW_ICON"));
        pm.addChild(fl);
        for (String string : inbound.keySet()) {
            dfdh = (DFDholder)inbound.get(string);
            if (dfdh.list.size() <= 0) continue;
            Collections.sort(dfdh.list, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
            sel = new ModelIdObjectSelection(dfdh.dfd);
            inb.addChild(sel);
            for (i = 0; i < dfdh.list.size(); ++i) {
                process = (Process)dfdh.list.get(i);
                psel = new ModelIdObjectSelection(process);
                sel.addChild(psel);
            }
        }
        for (String string : outbound.keySet()) {
            dfdh = (DFDholder)outbound.get(string);
            if (dfdh.list.size() <= 0) continue;
            Collections.sort(dfdh.list, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
            sel = new ModelIdObjectSelection(dfdh.dfd);
            outb.addChild(sel);
            for (i = 0; i < dfdh.list.size(); ++i) {
                process = (Process)dfdh.list.get(i);
                psel = new ModelIdObjectSelection(process);
                sel.addChild(psel);
            }
        }
        Collections.sort(flows, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
        for (DesignObject designObject : flows) {
            ModelIdObjectSelection sel2 = new ModelIdObjectSelection(designObject);
            fl.addChild(sel2);
        }
    }

    public static void addDimensionalModels(ModelIdObjectSelection parent, ContainerObject entity) {
        ModelIdObjectSelection dms = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.DimensionalModels"));
        dms.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        parent.addChild(dms);
        Iterator it = entity.getDesign().getMultidimensionalDesigns().iterator();
        while (it.hasNext()) {
            MultidimensionalDesign dm = (MultidimensionalDesign)it.next();
            if (entity.getDesignPart() != dm.getBoundModel()) continue;
            ImpA_Entity.addDimensionalModel(dm, dms, entity);
        }
    }

    private static void addDimensionalModel(MultidimensionalDesign dm, ModelIdObjectSelection parent, ContainerObject entity) {
        ModelIdObjectSelection dms = new ModelIdObjectSelection(dm);
        dms.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
        parent.addChild(dms);
        ModelIdObjectSelection cubes = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.Cubes"));
        cubes.setIcon(GUIConfiguration.getInstance().getIcon("CUBE_ICON"));
        dms.addChild(cubes);
        Iterator it = dm.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            if (!cube.getFactEntities().contains(entity)) continue;
            cubes.addChild(new ModelIdObjectSelection(cube));
        }
        ModelIdObjectSelection levels = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.Levels"));
        levels.setIcon(GUIConfiguration.getInstance().getIcon("LEVEL_ICON"));
        dms.addChild(levels);
        it = dm.getLevelSet().iterator();
        while (it.hasNext()) {
            Level level = (Level)it.next();
            if (level.getLevelEntity() != entity) continue;
            levels.addChild(new ModelIdObjectSelection(level));
        }
    }

    private void addSubViews() {
        ModelIdObjectSelection viewSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Table.UsedInSubViews"));
        viewSelection.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
        this.addChild(viewSelection);
        for (DesignPartView dpv : this.entity.getAffectedDPVs()) {
            if (!dpv.isMasterDPV() || dpv.isMainDiagram()) continue;
            PlaceHolder ph = dpv.getPlaceHolder();
            ModelIdObjectSelection sv = new ModelIdObjectSelection(ph);
            sv.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
            viewSelection.addChild(sv);
        }
        viewSelection.sort();
    }

    class DFDholder {
        DataFlowDesign dfd;
        List list;

        DFDholder() {
        }
    }
}

