/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.impact.ImpA_TableView;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_EntityView
extends ModelIdObjectSelection {
    private EntityView view;

    public ImpA_EntityView(EntityView view, ModelIdObjectSelection parent) {
        super(view);
        this.view = view;
        this.setParent(parent);
        this.addViewNodes(this);
        this.addDependentViews();
    }

    private void addViewNodes(ImpA_EntityView parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_EntityView.Mappings"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        parent.addChild(selection);
        Iterator it = this.view.getDesign().getRelationalDesigns().iterator();
        ModelIdObjectSelection relSelection = new ModelIdObjectSelection(Messages.getString("ImpA_EntityView.RelationalModels"));
        relSelection.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        selection.addChild(relSelection);
        while (it.hasNext()) {
            RelationalDesign design = (RelationalDesign)it.next();
            if (this.view.getObjectID() == null) continue;
            Iterator itl = this.view.getDesign().getExtendedMap().getMappingsForDesignPart(this.view, design.getObjectID()).iterator();
            while (itl.hasNext()) {
                ModelIdObjectSelection modelSel = new ModelIdObjectSelection(design.getName());
                modelSel.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
                relSelection.addChild(modelSel);
                XtdMapping mapping = (XtdMapping)itl.next();
                TableView tblView = (TableView)mapping.getObjectMappedTo(this.view);
                if (tblView == null) continue;
                if (!modelSel.hasAsParent(tblView)) {
                    modelSel.addChild(new ImpA_TableView(tblView, modelSel));
                    continue;
                }
                modelSel.addChild(new ModelIdObjectSelection(tblView));
            }
        }
    }

    private void addDependentViews() {
        ModelIdObjectSelection sel = new ModelIdObjectSelection(Messages.getString("ImpA_EntityView.DependentViews"));
        sel.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        this.addChild(sel);
        Iterator it = this.view.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            EntityView entView = (EntityView)it.next();
            if (entView.getContainerHolderFor(this.view) == null) continue;
            if (!sel.hasAsParent(entView)) {
                sel.addChild(new ImpA_EntityView(entView, sel));
                continue;
            }
            sel.addChild(new ModelIdObjectSelection(entView));
        }
    }
}

