/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.impact.ImpA_PK_UK;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_KeyObject
extends LongNameObjectSelection {
    private KeyObject keyObject;

    public ImpA_KeyObject(KeyObject key, ModelIdObjectSelection parent, boolean load) {
        super(key);
        this.keyObject = key;
        this.setParent(parent);
        if (load) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addKeyNodes(this);
        this.loaded = true;
    }

    private void addKeyNodes(ImpA_KeyObject parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_KeyObject.Mappings"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("KEY_ICON"));
        parent.addChild(selection);
        ModelIdObjectSelection attrNode = new ModelIdObjectSelection(Messages.getString("ImpA_KeyObject.RelationalModels"));
        attrNode.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        selection.addChild(attrNode);
        Iterator it = this.keyObject.getDesign().getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign relDesign = (RelationalDesign)it.next();
            if (this.keyObject.getObjectID() == null) continue;
            ModelIdObjectSelection relModels = new ModelIdObjectSelection(relDesign.getName());
            relModels.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
            attrNode.addChild(relModels);
            List list = relDesign.getDesign().getExtendedMap().getMappingsForDesignPart(this.keyObject, relDesign.getObjectID());
            for (XtdMapping mapping : list) {
                Index index = (Index)mapping.getObjectMappedTo(this.keyObject);
                if (index == null) continue;
                if (!relModels.hasAsParent(index)) {
                    relModels.addChild(new ImpA_PK_UK(index, relModels, false));
                    continue;
                }
                relModels.addChild(new LongNameObjectSelection(index));
            }
        }
    }

    @Override
    public String toString() {
        if (this.keyObject.isPK()) {
            return "(PK) " + this.keyObject.getLongName();
        }
        return this.keyObject.getLongName();
    }
}

