/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.impact.ImpA_FKAssociation;
import oracle.dbtools.crest.model.design.impact.ImpA_Table;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_Relation
extends ModelIdObjectSelection {
    private Relation relation;

    public ImpA_Relation(Relation relation, ModelIdObjectSelection parent, boolean load) {
        super(relation);
        this.relation = relation;
        this.setParent(parent);
        if (load) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addRelationNodes(this);
        this.loaded = true;
    }

    private void addRelationNodes(ImpA_Relation parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_Relation.Mappings"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        parent.addChild(selection);
        ModelIdObjectSelection relModel = new ModelIdObjectSelection(Messages.getString("ImpA_Relation.RelationalModels"));
        relModel.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        selection.addChild(relModel);
        Iterator it = this.relation.getDesign().getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign design = (RelationalDesign)it.next();
            if (this.relation.getObjectID() == null) continue;
            List list = this.relation.getDesign().getExtendedMap().getMappingsForDesignPart(this.relation, design.getObjectID());
            ModelIdObjectSelection designNode = new ModelIdObjectSelection(design.getName());
            designNode.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
            relModel.addChild(designNode);
            for (XtdMapping mapping : list) {
                DesignObject designObject = mapping.getObjectMappedTo(this.relation);
                if (designObject == null) continue;
                if (designObject instanceof FKIndexAssociation) {
                    if (!designNode.hasAsParent(designObject)) {
                        designNode.addChild(new ImpA_FKAssociation((FKIndexAssociation)designObject, designNode, false));
                        continue;
                    }
                    designNode.addChild(new ModelIdObjectSelection(designObject));
                    continue;
                }
                if (!designNode.hasAsParent(designObject)) {
                    designNode.addChild(new ImpA_Table((Table)designObject, designNode, false));
                    continue;
                }
                designNode.addChild(new ModelIdObjectSelection(designObject));
            }
        }
    }

    @Override
    public String getLongName() {
        if (this.object != null) {
            return this.object.toString();
        }
        return "";
    }

    @Override
    public String toString() {
        return this.getLongName();
    }
}

