/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;

public class RestoreMappings {
    private Design design;
    private RelationalDesign[] rd_array;
    private ExtendedMap xmap;

    public RestoreMappings(Design design) {
        this.design = design;
        this.rd_array = (RelationalDesign[])design.getRelationalDesigns().toArray();
        this.xmap = design.getExtendedMap();
    }

    public void restore() {
        LogicalDesign ld = this.design.getLogicalDesign();
        Iterator it = ld.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity ent = (Entity)it.next();
            this.processEntity(ent);
            ContainedObject[] attributes = ent.getElements();
            for (int i = 0; i < attributes.length; ++i) {
                Attribute attr = (Attribute)attributes[i];
                this.processAttribute(attr);
            }
            KeyObject[] keys = ent.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                CandidateKey key = (CandidateKey)keys[i];
                this.processCandidateKey(key);
            }
        }
        for (int i = 0; i < this.rd_array.length; ++i) {
            RelationalDesign pd = this.rd_array[i];
            it = pd.getFKIndexAssociationSet().iterator();
            while (it.hasNext()) {
                List list;
                FKIndexAssociation fk = (FKIndexAssociation)it.next();
                Relation dobj = fk.getEngRelation();
                if (dobj == null || (list = this.xmap.getMappingsForDesignPart(fk, ld.getObjectID())).size() != 0) continue;
                this.xmap.createMapping(dobj, fk);
            }
        }
        it = ld.getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView ev = (EntityView)it.next();
            this.processEntityView(ev);
        }
        this.restoreSubviews();
    }

    private void restoreSubviews() {
        Iterator it = this.design.getLogicalDesign().getLogicalDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it.next();
            DesignPartView logDPV = dpvph.getDesignPartView();
            for (int i = 0; i < this.rd_array.length; ++i) {
                RelationalDesign pd = this.rd_array[i];
                DesignPartView physDPV = pd.getSubViewGeneratedByDPV(logDPV.getDPVId());
                if (physDPV == null && logDPV.getGeneratorId() != null && !"".equalsIgnoreCase(logDPV.getGeneratorId())) {
                    physDPV = pd.getSubViewByID(logDPV.getGeneratorId());
                }
                if (physDPV == null) continue;
                this.xmap.createMapping(logDPV.getPlaceHolder(), physDPV.getPlaceHolder());
            }
        }
    }

    private void processEntity(Entity ent) {
        for (int i = 0; i < this.rd_array.length; ++i) {
            Table dobj = ent.getEngTable(this.rd_array[i]);
            this.restoreMapping(ent, dobj);
        }
    }

    private void processAttribute(Attribute attr) {
        for (int i = 0; i < this.rd_array.length; ++i) {
            Column dobj = attr.getEngColumn(this.rd_array[i]);
            this.restoreMapping(attr, dobj);
        }
    }

    private void processCandidateKey(CandidateKey key) {
        for (int i = 0; i < this.rd_array.length; ++i) {
            Index dobj = key.getEngIndex(this.rd_array[i]);
            this.restoreMapping(key, dobj);
        }
    }

    private void processEntityView(EntityView entView) {
        for (int i = 0; i < this.rd_array.length; ++i) {
            TableView dobj = entView.getEngTableView(this.rd_array[i]);
            this.restoreMapping(entView, dobj);
        }
    }

    private XtdMapping restoreMapping(DesignObject source, DesignObject target) {
        RelationalDesign pdes;
        List list;
        if (source != null && target != null && (list = this.xmap.getMappingsForDesignPart(source, (pdes = (RelationalDesign)target.getDesignPart()).getObjectID())).size() == 0) {
            return this.xmap.createMapping(source, target);
        }
        return null;
    }
}

