/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.crest.model.design.multidimensional.CursorPrintWriter;
import oracle.dbtools.crest.model.design.multidimensional.Logger;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.olapi.data.cursor.CompoundCursor;
import oracle.olapi.data.cursor.Cursor;
import oracle.olapi.data.cursor.CursorManager;
import oracle.olapi.data.cursor.ValueCursor;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmHierarchyLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmOrganizationalSchema;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmRootSchema;
import oracle.olapi.session.UserSession;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.TransactionProvider;

public class Context11g {
    private CursorPrintWriter cpw = null;
    private Logger logOutput = null;
    private TransactionProvider tp = null;
    private DataProvider dp = null;
    private oracle.jdbc.OracleConnection conn = null;
    private MdmMetadataProvider mp = null;
    private Properties props = new Properties();
    private Map m_hashMap = null;
    private List m_dimensionList = null;
    private List m_measureList = null;
    private String _server;
    private String _user;

    public Context11g(Properties properties, Logger logger, OracleConnection connection) {
        this.props = properties;
        this.logOutput = logger;
        this.cpw = new CursorPrintWriter(logger.getPrintWriter());
        this.conn = connection;
        this._createProviders();
    }

    public Context11g(Properties properties, Logger logger) {
        this.props = properties;
        this.logOutput = logger;
        this.cpw = new CursorPrintWriter(logger.getPrintWriter());
        this._connect();
    }

    public void close() {
        this._disconnect();
    }

    private void _connect() {
        this.showInfo("Connecting to the database.");
        this.showInfo("Loading the JDBC driver.");
        try {
            Class.forName("oracle.jdbc.OracleDriver");
            this.showInfo("JDBC driver loaded.");
        }
        catch (Exception e) {
            this.showError("Cannot not load the JDBC driver. " + e);
        }
        this.showInfo("Setting up connection properties.");
        String url = this.props.getProperty("url");
        String user = this.props.getProperty("user");
        String password = this.props.getProperty("password");
        String type = this.props.getProperty("OracleConnectionType");
        if ("TNS".equals(type)) {
            try {
                OracleDataSource ods = new OracleDataSource();
                ods.setTNSEntryName(url);
                ods.setDriverType("oci8");
                ods.setUser(this.props.getProperty("user"));
                ods.setPassword(this.props.getProperty("password"));
                this.conn = (oracle.jdbc.OracleConnection)ods.getConnection();
            }
            catch (SQLException e) {
                System.out.println("Connection attempt failed. " + e);
            }
        } else {
            int indexAtSign = url.indexOf("@");
            int indexColonAfterServer = url.indexOf(":", indexAtSign);
            String server = url.substring(indexAtSign + 1, indexColonAfterServer);
            this.setServer(server);
            this.setUser(user);
            try {
                OracleDataSource ods = new OracleDataSource();
                ods.setURL(this.props.getProperty("url"));
                ods.setUser(this.props.getProperty("user"));
                ods.setPassword(this.props.getProperty("password"));
                this.conn = (oracle.jdbc.OracleConnection)ods.getConnection();
            }
            catch (SQLException e) {
                System.out.println("Connection attempt failed. " + e);
            }
        }
        this._createProviders();
    }

    public void _disconnect() {
        if (null != this.dp) {
            this.showInfo("Closing DataProvider");
            this.dp.close();
            this.dp = null;
        }
        this._closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _closeConnection() {
        try {
            if (null != this.conn) {
                this.showInfo("Closing JDBC connection");
                this.conn.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.conn = null;
        }
    }

    private void _createProviders() {
        this.showInfo("Creating a DataProvider.");
        this.dp = new DataProvider();
        try {
            UserSession session = this.dp.createSession(this.conn);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        this.showInfo("Creating a TransactionProvider.");
        this.tp = this.dp.getTransactionProvider();
        this.showInfo("Getting the MDM MetadataProvider.");
        try {
            this.mp = (MdmMetadataProvider)this.dp.getDefaultMetadataProvider();
        }
        catch (Exception e) {
            this.showError("Cannot create the MDM metadata provider." + e);
        }
    }

    public DataProvider getDataProvider() {
        return this.dp;
    }

    public FundamentalMetadataProvider getFundamentalMetadataProvider() {
        return this.dp.getFundamentalMetadataProvider();
    }

    public MdmMetadataProvider getMetadataProvider() {
        return this.mp;
    }

    public TransactionProvider getTransactionProvider() {
        return this.tp;
    }

    private Map loadHashMap() {
        MdmRootSchema mdmRootSchema = (MdmRootSchema)this.mp.getRootSchema();
        MdmDatabaseSchema mdmSchema = mdmRootSchema.getDatabaseSchema(this.getUser());
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isGlobal = false;
        Object mdmSchemaToUse = null;
        if (this.getUser().toUpperCase().equals("GLOBAL")) {
            isGlobal = true;
            List subSchemas = mdmSchema.getSubSchemas();
            for (MdmOrganizationalSchema schemaToUse : subSchemas) {
                if (!mdmSchemaToUse.getName().equals("GLOBAL_AWJ")) continue;
                mdmSchema = mdmSchemaToUse;
                break;
            }
        }
        this.m_dimensionList = mdmSchema.getDimensions();
        Iterator objIter = this.m_dimensionList.iterator();
        MdmPrimaryDimension mdmPDim = null;
        while (objIter.hasNext()) {
            mdmPDim = (MdmPrimaryDimension)objIter.next();
            map.put(mdmPDim.getName().toUpperCase(), mdmPDim);
        }
        if (isGlobal) {
            this.m_measureList = mdmSchema.getMeasures();
        } else {
            MdmMeasureDimension mDim = mdmSchema.getMeasureDimension();
            this.m_measureList = mDim.getMeasures();
        }
        objIter = this.m_measureList.iterator();
        MdmMeasure mdmMeasure = null;
        while (objIter.hasNext()) {
            mdmMeasure = (MdmMeasure)objIter.next();
            map.put(mdmMeasure.getName().toUpperCase(), mdmMeasure);
        }
        return map;
    }

    public MdmMeasure getMdmMeasureByName(String name) {
        if (this.m_hashMap == null) {
            this.m_hashMap = this.loadHashMap();
        }
        MdmMeasure result = null;
        if (this.m_hashMap != null) {
            String val = name.toUpperCase();
            result = (MdmMeasure)this.m_hashMap.get(val);
        }
        return result;
    }

    public MdmMeasure[] getMdmMeasuresByName(String[] names) {
        if (this.m_hashMap == null) {
            this.m_hashMap = this.loadHashMap();
        }
        MdmMeasure[] mdmMeasures = new MdmMeasure[names.length];
        if (this.m_hashMap != null) {
            for (int i = 0; i < names.length; ++i) {
                String val = names[i].toUpperCase();
                mdmMeasures[i] = (MdmMeasure)this.m_hashMap.get(val);
            }
        }
        return mdmMeasures;
    }

    public MdmPrimaryDimension getMdmPrimaryDimensionByName(String name) {
        if (this.m_hashMap == null) {
            this.m_hashMap = this.loadHashMap();
        }
        MdmPrimaryDimension result = null;
        if (this.m_hashMap != null) {
            String val = name.toUpperCase();
            result = (MdmPrimaryDimension)this.m_hashMap.get(val);
        }
        return result;
    }

    public MdmAttribute getAttributeByName(MdmPrimaryDimension mdmPDim, String name) {
        List mdmAttrs = mdmPDim.getAttributes();
        for (MdmAttribute mdmAttr : mdmAttrs) {
            if (!mdmAttr.getName().equals(name)) continue;
            return mdmAttr;
        }
        return null;
    }

    public MdmHierarchy getHierarchyByName(MdmPrimaryDimension mdmPDim, String name) {
        List mdmHiers = mdmPDim.getHierarchies();
        for (MdmHierarchy mdmHier : mdmHiers) {
            if (!mdmHier.getName().equals(name)) continue;
            return mdmHier;
        }
        return null;
    }

    public MdmHierarchyLevel getHierLevelByName(MdmLevelHierarchy mdmLvlHier, String levelName) {
        List hierList = mdmLvlHier.getHierarchyLevels();
        for (MdmHierarchyLevel mdmHier : hierList) {
            List hierLevelList = mdmLvlHier.getHierarchyLevels();
            for (MdmHierarchyLevel mdmHierLevel : hierLevelList) {
                if (!mdmHierLevel.getName().equals(levelName)) continue;
                return mdmHierLevel;
            }
        }
        return null;
    }

    public String getLocalValue(String uniqueValue) {
        return this.cpw.getLocalValue(uniqueValue);
    }

    public void println(String line) {
        this.logOutput.println(line);
    }

    public void printCursor(Cursor rootCursor) {
        this.cpw.printCursor(rootCursor, false);
    }

    public void printAsCrosstab(CompoundCursor rootCursor) {
        this.cpw.printAsCrosstab(rootCursor);
    }

    public void showInfo(String message) {
        this.logOutput.showInfo(message);
    }

    public void showError(String message) {
        this.logOutput.showError(message);
    }

    public void commit() {
        try {
            this.tp.prepareCurrentTransaction();
        }
        catch (NotCommittableException e) {
            this.println("Cannot prepare the current Transaction. " + (Object)((Object)e));
        }
        this.tp.commitCurrentTransaction();
    }

    public void displayResult(Source source) {
        this._displayResult(source, false);
    }

    private void _displayResult(Source source, boolean displayLocVal) {
        CursorManager cursorManager = this.dp.createCursorManager(source);
        Cursor cursor = cursorManager.createCursor();
        this.cpw.printCursor(cursor, displayLocVal);
        cursorManager.close();
    }

    public void displayCursor(Cursor cursor) {
        this._displayCursor(cursor, false);
    }

    public void displayCursor(Cursor cursor, boolean displayLocVal) {
        this._displayCursor(cursor, displayLocVal);
    }

    private void _displayCursor(Cursor cursor, boolean displayLocVal) {
        this.cpw.printCursor(cursor, displayLocVal);
    }

    public void displayTopBottomResult(Source source) {
        CursorManager cursorManager = this.dp.createCursorManager(source);
        ValueCursor valueCursor = (ValueCursor)cursorManager.createCursor();
        this.cpw.printTopBottomResult(valueCursor);
        cursorManager.close();
    }

    public void displayCursorAsCrosstab(CompoundCursor cursor) {
        this.cpw.printAsCrosstab(cursor);
    }

    public void setServer(String server) {
        this._server = server;
    }

    public String getServer() {
        return this._server;
    }

    public void setUser(String user) {
        this._user = user.toUpperCase();
    }

    public String getUser() {
        return this._user;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String key, boolean required) {
        String ret = this.props.getProperty(key);
        if (required && ret == null) {
            throw new IllegalArgumentException("Command-line arguments must be specified in the form -<property_name> <value> with the property name and value separated by whitespace.");
        }
        return ret;
    }

    public String getOptionalProperty(String key) {
        return this.getProperty(key, false);
    }
}

