/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.swingui.editor.multidimensional.DimensionPropertiesDialogEx;
import oracle.dbtools.crest.util.GUID;

public class Dimension
extends AbstractMDObject
implements EditableFonts {
    private boolean timeDimension;
    private boolean useNaturalKeys = true;
    private List levels = new ArrayList();
    private List attributes = new ArrayList();
    private DesignObjectCollection hierarchies = new DesignObjectCollection();
    private List oracleAWAttributes = new ArrayList();
    private List permanentCalcMembers = new ArrayList();
    private List editableFonts = new ArrayList();
    private List summaryLevels = new ArrayList();
    public static final String TYPE_NAME = "Dimension";

    public Dimension(DesignPart designPart) {
        super(designPart);
        this.hierarchies.setName(Messages.getString("Dimension.Hierarchies"));
        this.hierarchies.setParent(this);
        this.hierarchies.setElementDescriptor(Hierarchy.class);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DimensionPropertiesDialogEx dialog = new DimensionPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public boolean isTimeDimension() {
        return this.timeDimension;
    }

    public void setTimeDimension(boolean timeDimension) {
        this.timeDimension = timeDimension;
    }

    public DesignObjectCollection getHierarchies() {
        return this.hierarchies;
    }

    public List getAllHierarchies() {
        ArrayList list = new ArrayList();
        this.getHierarchies().addAllElementsTo(list);
        return list;
    }

    public void addHierarchy(Hierarchy hierarchy) {
        hierarchy.setParent(this.hierarchies);
        this.hierarchies.add(hierarchy);
        hierarchy.setDimension(this);
    }

    public void removeHierarchy(Hierarchy hierarchy) {
        this.hierarchies.remove(hierarchy);
    }

    public List getAllLevels() {
        this.levels.clear();
        ArrayList list = new ArrayList();
        this.getHierarchies().addAllElementsTo(list);
        for (Hierarchy hier : list) {
            for (Level level : hier.getLevels()) {
                if (this.levels.contains(level)) continue;
                this.levels.add(level);
            }
        }
        return this.levels;
    }

    public List getAllAttributes() {
        this.attributes.clear();
        for (Level level : this.getAllLevels()) {
            for (DesignObject dobj : level.getAllAttributes()) {
                if (this.attributes.contains(dobj)) continue;
                this.attributes.add(dobj);
            }
        }
        return this.attributes;
    }

    public List<SlowChangingAttribute> getAllDescriptiveAttributes() {
        ArrayList<SlowChangingAttribute> list = new ArrayList<SlowChangingAttribute>();
        for (Level level : this.getAllLevels()) {
            for (SlowChangingAttribute dobj : level.getSlowChangingAttributes()) {
                if (list.contains(dobj)) continue;
                list.add(dobj);
            }
        }
        return list;
    }

    public List getAllLevelsTopDown() {
        ArrayList<Object> levelsTD = new ArrayList<Object>();
        Object[] levels = this.getLongestHierarchy().getLevels().toArray();
        for (int i = levels.length - 1; i >= 0; --i) {
            levelsTD.add(levels[i]);
        }
        return levelsTD;
    }

    public Hierarchy getLongestHierarchy() {
        Hierarchy temp = null;
        Iterator it = this.getHierarchies().iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            if (temp == null) {
                temp = hier;
            }
            if (temp == hier || temp.getLevels().size() >= hier.getLevels().size()) continue;
            temp = hier;
        }
        return temp;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.hierarchies;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.hierarchies) {
            return 0;
        }
        return -1;
    }

    public ContainerObject getBaseEntity() {
        Iterator it = this.hierarchies.iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            if (hier.getLevels().size() <= 0) continue;
            Level level = (Level)hier.getLevels().get(0);
            return level.getLevelEntity();
        }
        return null;
    }

    public Level getBaseLevel() {
        Iterator it = this.hierarchies.iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            if (hier.getLevels().size() <= 0) continue;
            Level level = (Level)hier.getLevels().get(0);
            return level;
        }
        return null;
    }

    public Hierarchy getHierarchyDefinedByLevels(List list) {
        Iterator it = this.getHierarchies().iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            if (!hier.isEqualToLevelList(list)) continue;
            return hier;
        }
        return null;
    }

    public static void validateAWAttributes(Level.OraAWAttributes awAttr, boolean timeDim) {
        Level level = awAttr.level;
        if (level != null) {
            DesignObject dobj;
            if (awAttr.shortDesc != null && (dobj = level.getAttributeById(awAttr.shortDesc.getObjectID())) == null) {
                awAttr.shortDesc = null;
            }
            if (awAttr.longDesc != null && (dobj = level.getAttributeById(awAttr.longDesc.getObjectID())) == null) {
                awAttr.longDesc = null;
            }
            if (timeDim) {
                if (awAttr.timeEnd != null && (dobj = level.getAttributeById(awAttr.timeEnd.getObjectID())) == null) {
                    awAttr.timeEnd = null;
                }
                if (awAttr.timeSpan != null && (dobj = level.getAttributeById(awAttr.timeSpan.getObjectID())) == null) {
                    awAttr.timeSpan = null;
                }
            }
        } else {
            awAttr.shortDesc = null;
            awAttr.longDesc = null;
            awAttr.timeEnd = null;
            awAttr.timeSpan = null;
        }
    }

    public List getOracleAWAttributes() {
        for (Level level : this.getAllLevels()) {
            Level.OraAWAttributes oa = level.getOraAWAttributes();
            if (oa != null) {
                Dimension.validateAWAttributes(oa, this.isTimeDimension());
            }
            this.oracleAWAttributes.add(oa);
        }
        return this.oracleAWAttributes;
    }

    public boolean isUseNaturalKeys() {
        return this.useNaturalKeys;
    }

    public void setUseNaturalKeys(boolean useNaturalKeys) {
        this.useNaturalKeys = useNaturalKeys;
    }

    public List getPermanentCalcMembers() {
        return this.permanentCalcMembers;
    }

    public String getWhereClauseFor(Level level) {
        return level.getSelectionCriteria().trim();
    }

    public PermanentCalcMember createPermanentCalcMember() {
        return new PermanentCalcMember("");
    }

    public PermanentCalcMember getPermanentCalcMemberByID(String id) {
        for (PermanentCalcMember cm : this.permanentCalcMembers) {
            if (!cm.getId().equals(id)) continue;
            return cm;
        }
        return null;
    }

    @Override
    public String getFCObjectType() {
        return TYPE_NAME;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "dimension/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public List getSummaryLevels() {
        return this.summaryLevels;
    }

    public void applySummarLevels(List levels) {
        List list = this.getAllLevels();
        levels.retainAll(list);
        ArrayList copy = new ArrayList(this.summaryLevels);
        if (this.summaryLevels.size() != levels.size()) {
            this.setDirty(true);
            this.summaryLevels.clear();
            this.summaryLevels.addAll(levels);
            return;
        }
        copy.removeAll(levels);
        if (copy.size() > 0) {
            this.setDirty(true);
            this.summaryLevels.clear();
            this.summaryLevels.addAll(levels);
        }
    }

    public class PermanentCalcMember {
        String name;
        String expression = "";
        String id;

        public PermanentCalcMember(String name, String expression) {
            this(name);
            this.expression = expression;
        }

        public PermanentCalcMember(String name) {
            this.name = name;
            this.id = new GUID().toString();
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

