/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.text.MessageFormat;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;

public class EngineerToOracle {
    private MultidimensionalDesign mdmDesign;
    private RelationalDesign phDes;
    private StorageDesignOracle sdOracle;
    private boolean valid = true;
    private StringBuffer validationSB;

    public EngineerToOracle(MultidimensionalDesign mdmDesign, RelationalDesign phDes, StorageDesignOracle sdOracle) {
        this.mdmDesign = mdmDesign;
        this.phDes = phDes;
        this.sdOracle = sdOracle;
    }

    public void engineer() {
        this.validationSB = new StringBuffer(Messages.getString("EngineerToOracle.ErrorsDuringValidationPhase"));
        this.validate();
        if (this.valid) {
            Iterator it = this.mdmDesign.getDimensionSet().iterator();
            while (it.hasNext()) {
                Dimension dimension = (Dimension)it.next();
                this.processDimension(dimension);
            }
            ApplicationView.log(MessageFormat.format(Messages.getString("EngineerToOracle.EngineerToOracleModel"), this.phDes.getName()));
        } else {
            LogReport lr = new LogReport(this.mdmDesign.getAppView());
            lr.setName(Messages.getString("EngineerToOracle.ValidationLog"));
            lr.setLog(this.validationSB.toString());
            lr.showDialog(new java.awt.Dimension(750, 550));
        }
    }

    private void validate() {
        Iterator it = this.mdmDesign.getLevelSet().iterator();
        while (it.hasNext()) {
            Level level = (Level)it.next();
            this.validateLevel(level);
        }
    }

    private void processDimension(Dimension dimension) {
        DimensionOracle dimOra = (DimensionOracle)this.sdOracle.getDimensionSet().getObjectGeneratedBy(dimension);
        if (dimOra == null) {
            dimOra = (DimensionOracle)this.sdOracle.getDimensionSet().getObjectByID(dimension.getGeneratorID());
        }
        if (dimOra == null) {
            dimOra = this.sdOracle.getDimensionSet().createDimension();
        } else {
            this.clearDimension(dimOra);
        }
        dimOra.setName(dimension.getName());
        dimOra.setGeneratorID(dimension.getObjectID());
        Iterator it = dimension.getHierarchies().iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            HierarchyOracle hora = this.createHierarchy(dimOra, this.sdOracle);
            hora.setName(hier.getName());
            this.processHierarchy(hora, hier, dimOra);
        }
    }

    private void clearDimension(DimensionOracle dimOra) {
        Object[] attribs = dimOra.getAttributeSet();
        for (int i = 0; i < attribs.length - 1; ++i) {
            ((StorageObject)attribs[i]).remove();
        }
        dimOra.clearChildren();
    }

    private void processHierarchy(HierarchyOracle hora, Hierarchy hier, DimensionOracle dimOra) {
        for (Level level : hier.getLevels()) {
            LevelOracle levelOra = this.findOrCreateLevel(level, dimOra, this.sdOracle);
            levelOra.setName(level.getName());
            hora.setLevels(levelOra.getObjectID());
            this.processLevel(level, levelOra);
        }
        this.processJoins(hora, hier);
    }

    private void processLevel(Level level, LevelOracle levelOra) {
        ColumnProxy cp;
        DimensionAttributeOracle dattr = this.findOrCreateAttribute(levelOra, this.sdOracle);
        ContainerObject obj = level.getLevelEntity();
        ContainerObject ent = null;
        if (obj != null && obj instanceof ContainerObject) {
            ent = obj;
        }
        TableProxy tp_attr = null;
        for (ContainedObject attr : level.getLevelKey()) {
            cp = this.getColumnProxy(attr);
            if (cp == null) continue;
            levelOra.setColumns(cp.getObjectID());
            if (tp_attr != null) continue;
            tp_attr = cp.getTableProxyR();
        }
        for (ContainedObject attr : level.getDescriptiveAttributes()) {
            cp = this.getColumnProxy(attr);
            if (cp == null) continue;
            dattr.setColumns(cp.getObjectID());
            if (tp_attr != null) continue;
            tp_attr = cp.getTableProxyR();
        }
        if (tp_attr == null && ent != null) {
            tp_attr = this.getTableProxy(ent);
        }
        if (tp_attr != null) {
            levelOra.setLevelTable(tp_attr);
        }
    }

    private DimensionAttributeOracle findOrCreateAttribute(LevelOracle levelOra, StorageDesignOracle stdes) {
        Iterator it = stdes.getDimensionAttributeSet().iterator();
        while (it.hasNext()) {
            DimensionAttributeOracle dattr = (DimensionAttributeOracle)it.next();
            if (dattr.getLevel() != levelOra) continue;
            return dattr;
        }
        DimensionAttributeOracle attr = stdes.getDimensionAttributeSet().createDimensionAttribute();
        attr.setLevel(levelOra);
        attr.setName(levelOra.getName());
        return attr;
    }

    private void validateLevel(Level level) {
        ColumnProxy cp;
        TableProxy tp;
        ContainerObject obj = level.getLevelEntity();
        Entity ent = null;
        if (obj != null && obj instanceof Entity) {
            ent = (Entity)obj;
        }
        if (ent != null && (tp = this.getTableProxy(ent)) == null) {
            this.valid = false;
            this.validationSB.append(MessageFormat.format(Messages.getString("EngineerToOracle.NoCorrespondingTableForEntity"), ent.getName()));
        }
        for (ContainedObject attr : level.getLevelKey()) {
            cp = this.getColumnProxy(attr);
            if (cp != null) continue;
            this.valid = false;
            this.validationSB.append(MessageFormat.format(Messages.getString("EngineerToOracle.NoCorrespondingColumnForAttribute"), attr.getLongName()));
        }
        for (ContainedObject attr : level.getDescriptiveAttributes()) {
            cp = this.getColumnProxy(attr);
            if (cp != null) continue;
            this.valid = false;
            this.validationSB.append(MessageFormat.format(Messages.getString("EngineerToOracle.NoCorrespondingColumnForAttribute"), attr.getLongName()));
        }
        int lsize = level.getOutgoingLinks().size();
        for (int k = 0; k < lsize; ++k) {
            Link link = (Link)level.getOutgoingLinks().get(k);
            RollupLink rlink = link.getRollupLink();
            if (rlink == null) continue;
            for (ContainedObject attr : rlink.getChildToParentAttributes()) {
                ColumnProxy cp2 = this.getColumnProxy(attr);
                if (cp2 != null) continue;
                this.valid = false;
                this.validationSB.append(MessageFormat.format(Messages.getString("EngineerToOracle.NoCorrespondingColumnForAttribute"), attr.getLongName()));
            }
        }
    }

    private void processJoins(HierarchyOracle hora, Hierarchy hier) {
        for (int i = 0; i < hier.getLevels().size() - 1; ++i) {
            RollupLink rlink;
            Level nextLevel;
            Level level = (Level)hier.getLevels().get(i);
            Link link = level.getFirstLinkToTarget(nextLevel = (Level)hier.getLevels().get(i + 1));
            if (link == null || level.getLevelEntity() == null || nextLevel.getLevelEntity() == null || (rlink = link.getRollupLink()).getChildToParentAttributes().size() <= 0 || level.getLevelEntity() == nextLevel.getLevelEntity()) continue;
            StringBuffer sb = new StringBuffer();
            if (rlink.getChildToParentAttributes().size() > 1) {
                sb.append("JOIN KEY (");
            } else {
                sb.append("JOIN KEY ");
            }
            Iterator it = rlink.getChildToParentAttributes().iterator();
            boolean first = true;
            while (it.hasNext()) {
                ContainedObject attr = (ContainedObject)it.next();
                ColumnProxy cp = this.getColumnProxy(attr);
                if (cp == null) continue;
                if (!first) {
                    sb.append(", ");
                }
                sb.append(cp.getLongName());
            }
            String levelname = nextLevel.getName().indexOf(" ") > 0 ? "\"" + nextLevel.getName() + "\"" : nextLevel.getName();
            if (rlink.getChildToParentAttributes().size() > 1) {
                sb.append(") REFERENCES ").append(levelname);
            } else {
                sb.append(" REFERENCES ").append(levelname);
            }
            hora.setJoins(sb.toString());
        }
    }

    private DimensionAttributeOracle createAttribute(LevelOracle level, StorageDesignOracle stdes) {
        DimensionAttributeOracle attr = stdes.getDimensionAttributeSet().createDimensionAttribute();
        attr.setLevel(level);
        attr.setName(level.getName());
        return attr;
    }

    private LevelOracle findOrCreateLevel(Level level, DimensionOracle dimOra, StorageDesignOracle stdes) {
        LevelOracle levelOra = dimOra.getLevelByName(level.getName());
        if (levelOra == null) {
            levelOra = stdes.getLevelSet().createLevel();
            levelOra.setDimension(dimOra);
        }
        return levelOra;
    }

    private HierarchyOracle createHierarchy(DimensionOracle dimOra, StorageDesignOracle stdes) {
        HierarchyOracle hier = stdes.getHierarchySet().createHierarchy();
        hier.setDimension(dimOra);
        return hier;
    }

    private ColumnProxy getColumnProxy(ContainedObject attribute) {
        if (attribute instanceof Attribute) {
            Column column = ((Attribute)attribute).getEngColumn(this.phDes);
            if (column != null) {
                ColumnProxy cp = (ColumnProxy)this.sdOracle.getColumnProxySet().getProxy(column.getObjectID());
                return cp;
            }
        } else if (attribute instanceof Column) {
            return (ColumnProxy)this.sdOracle.getColumnProxySet().getProxy(attribute.getObjectID());
        }
        return null;
    }

    private TableProxy getTableProxy(ContainerObject entity) {
        if (entity instanceof Entity) {
            Table table = ((Entity)entity).getEngTable(this.phDes);
            if (table != null) {
                TableProxy tp = (TableProxy)this.sdOracle.getTableProxySet().getProxy(table.getObjectID());
                return tp;
            }
        } else if (entity instanceof Table) {
            return (TableProxy)this.sdOracle.getTableProxySet().getProxy(entity.getObjectID());
        }
        return null;
    }
}

