/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.EngineerFromOracle;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;

public class FromOracleModelSelector {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private static final int FIELD_WIDTH = 220;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(220, 20);
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private Design design;
    private RelationalDesign physicalDesign;
    private StorageDesign storageDesign;
    private MultidimensionalDesign mdm;
    private String schema = "";
    private JButton okButton;
    private JSpinner jspinner;
    private boolean useFactTables;
    private JCheckBox chbFactTablesOnly;
    private JComboBox cbSearch;
    private Object[] searchList = new Object[]{EngineerFromOracle.USE_FK, EngineerFromOracle.USE_COLUMN_NAMES};

    public FromOracleModelSelector(MultidimensionalDesign mdm) {
        this.mdm = mdm;
    }

    public boolean showDialog(ApplicationView view) {
        this.result = false;
        this.design = view.getCurrentDesign();
        this.dialog = new JDialog((Frame)view.getFrame(), Messages.getString("FromOracleModelSelector.SelectOracleModel"));
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setModal(true);
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel modelPanel = new JPanel(new GridLayout(0, 1));
        modelPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("FromOracleModelSelector.OracleModel")));
        JPanel searcPanel = new JPanel(new GridLayout(0, 1));
        searcPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("FromOracleModelSelector.CubeDiscoveryOptions")));
        JPanel optionsPanel = new JPanel(new GridLayout(0, 1));
        optionsPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.okButton = new JButton(Messages.getString("FromOracleModelSelector.OK"));
        this.okButton.setEnabled(false);
        JLabel lbRelD = new JLabel(Messages.getString("FromOracleModelSelector.RelationalModel"));
        ArrayList rlist = new ArrayList();
        this.design.getRelationalDesigns().addAllElementsTo(rlist);
        lbRelD.setPreferredSize(this.prefDimension);
        this.cbRelDes = new JComboBox<Object>(rlist.toArray());
        this.cbRelDes.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbRelDes.setPreferredSize(this.prefDimension);
        if (this.mdm.getBoundModel() != null && this.mdm.getBoundModel() instanceof RelationalDesign) {
            this.cbRelDes.setSelectedItem(this.mdm.getBoundModel());
            this.cbRelDes.setEnabled(false);
        }
        this.cbStorage = new JComboBox();
        this.cbStorage.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbStorage.setPreferredSize(this.prefDimension);
        this.cbRelDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object ob = FromOracleModelSelector.this.cbRelDes.getSelectedItem();
                if (ob != null && ob instanceof RelationalDesign) {
                    RelationalDesign phd = (RelationalDesign)ob;
                    ArrayList<StorageDesign> rlist = new ArrayList<StorageDesign>();
                    StorageDesign[] stds = phd.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < stds.length; ++i) {
                        StorageDesign sd = stds[i];
                        if (!(sd instanceof StorageDesignOracle)) continue;
                        rlist.add(sd);
                    }
                    FromOracleModelSelector.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(rlist.toArray()));
                    if (rlist.size() > 0) {
                        FromOracleModelSelector.this.okButton.setEnabled(true);
                    } else {
                        FromOracleModelSelector.this.okButton.setEnabled(false);
                    }
                } else if (ob == null) {
                    FromOracleModelSelector.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                }
            }
        });
        if (rlist.size() > 0) {
            this.cbRelDes.setSelectedItem(rlist.get(0));
        }
        JPanel row = this.newRow(lbRelD, this.cbRelDes);
        modelPanel.add(row);
        JLabel lbStoreD = new JLabel(Messages.getString("FromOracleModelSelector.PhysicalOracleModel"));
        lbStoreD.setPreferredSize(this.prefDimension);
        row = this.newRow(lbStoreD, this.cbStorage);
        modelPanel.add(row);
        JPanel panel = new JPanel();
        panel.setPreferredSize(this.prefDimension);
        modelPanel.add(panel);
        SpinnerNumberModel spmodel = new SpinnerNumberModel(3, 3, 100, 1);
        this.jspinner = new JSpinner(spmodel);
        JLabel lbDimNumber = new JLabel(Messages.getString("FromOracleModelSelector.MinimumDimensions"));
        lbDimNumber.setPreferredSize(this.prefDimension);
        this.jspinner.setPreferredSize(this.prefDimension);
        row = this.newRow(lbDimNumber, this.jspinner);
        searcPanel.add(row);
        JLabel lbSearch = new JLabel(Messages.getString("FromOracleModelSelector.MatchMethod"));
        lbSearch.setPreferredSize(this.prefDimension);
        this.cbSearch = new JComboBox<Object>(this.searchList);
        this.cbSearch.setPreferredSize(this.prefDimension);
        row = this.newRow(lbSearch, this.cbSearch);
        searcPanel.add(row);
        JLabel lbFactTables = new JLabel(Messages.getString("FromOracleModelSelector.UseFactEntitiesOnly"));
        lbFactTables.setPreferredSize(this.prefDimension);
        this.chbFactTablesOnly = new JCheckBox();
        this.chbFactTablesOnly.setPreferredSize(this.prefDimension);
        row = this.newRow(lbFactTables, this.chbFactTablesOnly);
        searcPanel.add(row);
        JPanel bottom = new JPanel();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FromOracleModelSelector.this.result = true;
                FromOracleModelSelector.this.physicalDesign = (RelationalDesign)FromOracleModelSelector.this.cbRelDes.getSelectedItem();
                FromOracleModelSelector.this.storageDesign = (StorageDesign)FromOracleModelSelector.this.cbStorage.getSelectedItem();
                if (FromOracleModelSelector.this.result) {
                    FromOracleModelSelector.this.dialog.dispose();
                }
            }
        });
        bottom.add(this.okButton);
        JButton cancelButton = new JButton(Messages.getString("FromOracleModelSelector.Cancel"));
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FromOracleModelSelector.this.result = false;
                FromOracleModelSelector.this.dialog.dispose();
            }
        });
        optionsPanel.add(modelPanel);
        optionsPanel.add(searcPanel);
        bottom.add(cancelButton);
        this.okButton.setPreferredSize(cancelButton.getPreferredSize());
        jpanel.add((Component)optionsPanel, "Center");
        jpanel.add((Component)bottom, "South");
        this.dialog.getContentPane().add(jpanel);
        this.dialog.pack();
        this.centerOnScreen(this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setVisible(true);
        return this.result;
    }

    private void centerOnScreen(JDialog window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = window.getSize();
        Point newLocation = new Point((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 2);
        window.setLocation(newLocation);
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    private JPanel newRow(JLabel lbName, Component field) {
        JPanel newRow = new JPanel();
        newRow.add(lbName);
        newRow.add(field);
        return newRow;
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public String getSchema() {
        return this.schema;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.mdm;
    }

    public int getMinDimensions() {
        Object obj = this.jspinner.getValue();
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 3;
    }

    public boolean isUseFactTablesOnly() {
        return this.useFactTables;
    }

    public String getSearchMethod() {
        return (String)this.cbSearch.getSelectedItem();
    }
}

