/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.editor.multidimensional.HierarchyPropertiesDialogEx;

public class Hierarchy
extends AbstractMDObject {
    private List levels = new ArrayList();
    private List links = new ArrayList();
    private Dimension dimension;
    private Link linkToDimension;
    private boolean defaultHierarchy;
    public static final String TYPE_NAME = "Hierarchy";

    public Hierarchy(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            HierarchyPropertiesDialogEx dialog = new HierarchyPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public boolean isValueBasedHierarchy() {
        if (this.getLevels().size() == 1) {
            Level level = (Level)this.getLevels().get(0);
            return level.isValueBasedHierarchy();
        }
        return false;
    }

    public List getLevels() {
        return this.levels;
    }

    public void addLevel(Level level) {
        this.levels.add(level);
        this.setDirty(true);
    }

    public void removeLevel(Level level) {
        this.levels.remove(level);
        this.setDirty(true);
    }

    public List getLinks() {
        return this.links;
    }

    public void addLink(RollupLink link) {
        this.setDirty(true);
        this.links.add(link);
    }

    public void removeLink(RollupLink link) {
        this.links.remove(link);
        this.setDirty(true);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public Link getLinkToDimension() {
        return this.linkToDimension;
    }

    public void setLinkToDimension(Link linkToDimension) {
        this.linkToDimension = linkToDimension;
    }

    public void applyLinkToDimension(Link linkToDimension) {
        Dimension dim;
        this.setLinkToDimension(linkToDimension);
        if (linkToDimension != null && (dim = (Dimension)linkToDimension.getSourceMDObject()) != null) {
            dim.addHierarchy(this);
        }
    }

    @Override
    public void remove() {
        this.levels.clear();
        this.links.clear();
        this.linkToDimension = null;
        super.remove();
    }

    public boolean contains(Level level) {
        return this.levels.contains(level);
    }

    public boolean isLast(Level level) {
        return this.levels.indexOf(level) == this.levels.size() - 1;
    }

    public Hierarchy clonePartial(Level lastLevel) {
        if (this.contains(lastLevel)) {
            Hierarchy hier = ((MultidimensionalDesign)this.getDesignPart()).createHierarchy();
            hier.setDimension(this.getDimension());
            hier.setLinkToDimension(this.getLinkToDimension());
            int ind = this.levels.indexOf(lastLevel);
            if (ind > -1) {
                for (int i = 0; i <= ind; ++i) {
                    hier.addLevel((Level)this.levels.get(i));
                    if (i >= ind) continue;
                    hier.addLink((RollupLink)this.links.get(i));
                }
            }
            this.getDimension().addHierarchy(hier);
            return hier;
        }
        return null;
    }

    public boolean contains(RollupLink link) {
        return this.links.contains(link);
    }

    public void removePartFromLink(Link link) {
        RollupLink rl = link.getRollupLink();
        if (this.links.contains(rl)) {
            int i;
            int ind = this.links.indexOf(rl);
            int max = this.links.size();
            for (i = max - 1; i >= ind; --i) {
                this.links.remove(i);
            }
            max = this.levels.size();
            for (i = max - 1; i > ind; --i) {
                this.levels.remove(i);
            }
        }
    }

    public List getPathTo(Level level) {
        ArrayList<Level> list = new ArrayList<Level>();
        if (this.levels.contains(level)) {
            for (int i = 0; i < this.levels.size(); ++i) {
                Level temp = (Level)this.levels.get(i);
                if (temp == level) {
                    return list;
                }
                list.add(temp);
            }
        }
        return list;
    }

    public boolean hasDifferentPathToLevel(Level level, List otherHierarchies) {
        List path = this.getPathTo(level);
        if (otherHierarchies.size() == 0) {
            return true;
        }
        for (int i = 0; i < otherHierarchies.size(); ++i) {
            Hierarchy hier = (Hierarchy)otherHierarchies.get(i);
            if (hier == this || !this.differentPaths(path, hier.getPathTo(level))) continue;
            return true;
        }
        return false;
    }

    private boolean differentPaths(List path1, List path2) {
        if (path1.size() == path2.size()) {
            for (int i = 0; i < path1.size(); ++i) {
                if (path1.get(i) == path2.get(i)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isEqualToLevelList(List list) {
        return !this.differentPaths(this.getLevels(), list);
    }

    public boolean isRaggedHierarchy() {
        for (Level level : this.getLevels()) {
            if (level.getRaggedHLinks().size() <= 0) continue;
            for (RaggedHLink rhl : level.getRaggedHLinks()) {
                if (!this.levels.contains(rhl.getParentLevel())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDefaultHierarchy() {
        if (this.getDimension().getHierarchies().size() == 1) {
            return true;
        }
        return this.defaultHierarchy;
    }

    public void setDefaultHierarchy(boolean defaultHierarchy) {
        this.defaultHierarchy = defaultHierarchy;
        if (defaultHierarchy && this.getDimension() != null) {
            Iterator it = this.getDimension().getHierarchies().iterator();
            while (it.hasNext()) {
                Hierarchy hier = (Hierarchy)it.next();
                if (hier == this) continue;
                hier.setDefaultHierarchy(false);
            }
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "hierarchy/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

