/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.editor.multidimensional.LevelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;
import oracle.dbtools.crest.util.GUID;

public class Level
extends AbstractMDObject
implements EditableFonts {
    public static final String PARENT_IS_BLANK_SELF_OR_MISSING = "ParentIsBlankSelfOrMissing";
    public static final String PARENT_IS_SELF = "ParentIsSelf";
    public static final String PARENT_IS_MISSING = "ParentIsMissing";
    public static final String PARENT_IS_BLANK = "ParentIsBlank";
    public static final String PARENT_HAS_VALUE = "ParentHasValue";
    public static final String[] ROOT_IDENTS = new String[]{"ParentIsBlankSelfOrMissing", "ParentIsSelf", "ParentIsMissing", "ParentIsBlank", "ParentHasValue"};
    private ContainerObject levelEntity;
    private final List levelKey = new ArrayList();
    private final List slowChangingAttributes = new ArrayList();
    private String selectionCriteria = "";
    private String selectionCriteriaDescription = "";
    private boolean valueBasedHierarchy;
    private final List parentKey = new ArrayList();
    private String rootIdentification = ROOT_IDENTS[0];
    private String identificationValue = "";
    private int calcAttrID = 1;
    private final List calcAttributes = new ArrayList();
    private DesignObject defaultAttribute;
    private String oraDimension = "";
    private final List raggedHLinks = new ArrayList();
    private final List inputRaggedHLinks = new ArrayList();
    private final OraAWAttributes oraAWAttributes;
    private ContainedObject nameColumn;
    private ContainedObject valueColumn;
    private List editableFonts = new ArrayList();
    public static final String TYPE_NAME = "Level";

    public Level(DesignPart designPart) {
        super(designPart);
        this.oraAWAttributes = new OraAWAttributes(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LevelPropertiesDialogEx dialog = new LevelPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void showPropertyDialog(Dialog owner) {
        if (!this.isDialogVisible()) {
            LevelPropertiesDialogEx dialog = owner == null ? new LevelPropertiesDialogEx(this.getDesign().getAppView(), this) : new LevelPropertiesDialogEx(owner, this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getIdentificationValue() {
        return this.identificationValue;
    }

    public void setIdentificationValue(String identificationValue) {
        this.identificationValue = identificationValue;
    }

    public ContainerObject getLevelEntity() {
        return this.levelEntity;
    }

    public void setLevelEntity(ContainerObject levelEntity) {
        this.levelEntity = levelEntity;
        if (levelEntity != null && levelEntity instanceof ContainerWithKeyObject) {
            ((ContainerWithKeyObject)levelEntity).setTypeID("2");
        }
    }

    public String getRootIdentification() {
        return this.rootIdentification;
    }

    public void setRootIdentification(String rootIdentification) {
        this.rootIdentification = rootIdentification;
    }

    public String getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public void setSelectionCriteria(String selectionCriteria) {
        this.selectionCriteria = selectionCriteria;
    }

    public String getSelectionCriteriaDescription() {
        return this.selectionCriteriaDescription;
    }

    public void setSelectionCriteriaDescription(String selectionCriteriaDescription) {
        this.selectionCriteriaDescription = selectionCriteriaDescription;
    }

    public boolean isValueBasedHierarchy() {
        return this.valueBasedHierarchy;
    }

    public void setValueBasedHierarchy(boolean valueBasedHierarchy) {
        this.valueBasedHierarchy = valueBasedHierarchy;
    }

    public List getDescriptiveAttributes() {
        ArrayList<ContainedObject> result = new ArrayList<ContainedObject>();
        for (SlowChangingAttribute scha : this.slowChangingAttributes) {
            if (scha.getAttribute() == null) continue;
            result.add(scha.getAttribute());
        }
        return result;
    }

    public SlowChangingAttribute getSlowChangingAttribute(ContainedObject attribute, String scaName) {
        for (SlowChangingAttribute scha : this.slowChangingAttributes) {
            if (scha.getAttribute() != attribute || !scha.getName().equals(scaName)) continue;
            return scha;
        }
        return null;
    }

    public SlowChangingAttribute getSlowChangingAttribute(String attributeID, String scaName) {
        for (SlowChangingAttribute scha : this.slowChangingAttributes) {
            if (scha.getAttribute() == null || !scha.getAttribute().getObjectID().equalsIgnoreCase(attributeID) || !scha.getName().equalsIgnoreCase(scaName)) continue;
            return scha;
        }
        return null;
    }

    public List getSlowChangingAttributes() {
        return this.slowChangingAttributes;
    }

    public List getAllAttributes() {
        ArrayList list = new ArrayList();
        list.addAll(this.getLevelKey());
        list.addAll(this.getDescriptiveAttributes());
        list.addAll(this.getCalculatedAttributes());
        List links = this.getOutgoingLinks();
        for (Link link : links) {
            list.addAll(link.getRollupLink().getChildToParentAttributes());
        }
        return list;
    }

    public List getJoinAttributes() {
        ArrayList list = new ArrayList();
        List links = this.getOutgoingLinks();
        for (Link link : links) {
            list.addAll(link.getRollupLink().getChildToParentAttributes());
        }
        return list;
    }

    public void addDescriptiveAttribute(SlowChangingAttribute attribute) {
        this.slowChangingAttributes.add(attribute);
    }

    public void removeDescriptiveAttribute(SlowChangingAttribute attribute) {
        this.slowChangingAttributes.remove(attribute);
    }

    public SlowChangingAttribute createDescriptiveAttribute() {
        return new SlowChangingAttribute(this, "New_Descr_Attr");
    }

    public SlowChangingAttribute getDescriptiveAttrByID(String id) {
        for (SlowChangingAttribute sca : this.slowChangingAttributes) {
            if (!sca.getObjectID().equals(id)) continue;
            return sca;
        }
        return null;
    }

    public List getLevelKey() {
        return this.levelKey;
    }

    public void addToLevelKey(ContainedObject attribute) {
        this.levelKey.add(attribute);
    }

    public void removeFromLevelKey(ContainedObject attribute) {
        this.levelKey.remove(attribute);
    }

    public List getParentKey() {
        return this.parentKey;
    }

    public void addToParentKey(ContainedObject attribute) {
        this.parentKey.add(attribute);
    }

    public void removeFromParentKey(ContainedObject attribute) {
        this.parentKey.remove(attribute);
    }

    public List getCalculatedAttributes() {
        return this.calcAttributes;
    }

    public boolean hasCalculatedAttribute(String name, String expression) {
        for (CalculatedAttribute calcAttribute : this.calcAttributes) {
            if (!name.trim().equals(calcAttribute.getName().trim()) || !expression.trim().equals(calcAttribute.getFunction())) continue;
            return true;
        }
        return false;
    }

    public void addCalculatedAttribute(CalculatedAttribute ca) {
        this.calcAttributes.add(ca);
        String id = ca.getObjectID();
        int idint = 0;
        try {
            idint = Integer.valueOf(id);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (idint > this.calcAttrID) {
            this.calcAttrID = idint;
        }
    }

    public CalculatedAttribute addCalculatedAttribute(String name, String id) {
        CalculatedAttribute ca = this.createCalculatedAttribute(name, id);
        this.calcAttributes.add(ca);
        return ca;
    }

    public CalculatedAttribute createCalculatedAttribute() {
        String name = CalculatedAttribute.NAMEPREFIX + Integer.toString(this.calcAttrID);
        return this.createCalculatedAttribute(name);
    }

    public void ramoveCalculatedAttribute(CalculatedAttribute ca) {
        this.calcAttributes.remove(ca);
    }

    public CalculatedAttribute createCalculatedAttribute(String name) {
        CalculatedAttribute ca = new CalculatedAttribute(this.getDesignPart());
        ca.setName(name);
        String caid = new GUID().toString();
        ++this.calcAttrID;
        ca.setObjectID(caid);
        ca.setLevel(this);
        return ca;
    }

    public CalculatedAttribute createCalculatedAttribute(String name, String id) {
        CalculatedAttribute ca = this.createCalculatedAttribute(name);
        ca.setObjectID(id);
        return ca;
    }

    public DesignObject getAttributeById(String id) {
        for (DesignObject dobj : this.getAllAttributes()) {
            if (!dobj.getObjectID().equalsIgnoreCase(id)) continue;
            return dobj;
        }
        return null;
    }

    public DesignObject getDefaultAttribute() {
        return this.defaultAttribute;
    }

    public void setDefaultAttribute(DesignObject defaultAttribute) {
        this.defaultAttribute = defaultAttribute;
    }

    public List getDefaultAttributeCandidates() {
        ArrayList result = new ArrayList();
        result.addAll(this.getLevelKey());
        result.addAll(this.getDescriptiveAttributes());
        result.addAll(this.getCalculatedAttributes());
        return result;
    }

    public String getOraDimension() {
        return this.oraDimension;
    }

    public void setOraDimension(String oraDimension) {
        this.oraDimension = oraDimension;
    }

    public List getRaggedHLinks() {
        return this.raggedHLinks;
    }

    @Override
    public void remove() {
        TVRaggedHLink tv;
        RaggedHLink rhl;
        int i;
        Object[] rhlinks = this.raggedHLinks.toArray();
        for (i = 0; i < rhlinks.length; ++i) {
            rhl = (RaggedHLink)rhlinks[i];
            tv = (TVRaggedHLink)rhl.getTopView();
            if (tv == null) continue;
            tv.remove();
        }
        rhlinks = this.inputRaggedHLinks.toArray();
        for (i = 0; i < rhlinks.length; ++i) {
            rhl = (RaggedHLink)rhlinks[i];
            tv = (TVRaggedHLink)rhl.getTopView();
            if (tv == null) continue;
            tv.remove();
        }
        super.remove();
    }

    public List getInputRaggedHLinks() {
        return this.inputRaggedHLinks;
    }

    public RaggedHLink getFirstRaggedHLinkTo(Level level) {
        for (RaggedHLink rhl : this.raggedHLinks) {
            if (rhl.getParentLevel() != level) continue;
            return rhl;
        }
        return null;
    }

    public OraAWAttributes getOraAWAttributes() {
        return this.oraAWAttributes;
    }

    public void validateAWAttributes(OraAWAttributes oraAWAttributes, boolean timeDim) {
        DesignObject dobj;
        if (oraAWAttributes.shortDesc != null && (dobj = this.getAttributeById(oraAWAttributes.shortDesc.getObjectID())) == null) {
            if (this.levelEntity != null) {
                dobj = this.levelEntity.getElementByID(oraAWAttributes.shortDesc.getObjectID());
            }
            if (dobj == null) {
                oraAWAttributes.shortDesc = null;
            }
        }
        if (oraAWAttributes.longDesc != null && (dobj = this.getAttributeById(oraAWAttributes.longDesc.getObjectID())) == null) {
            if (this.levelEntity != null) {
                dobj = this.levelEntity.getElementByID(oraAWAttributes.longDesc.getObjectID());
            }
            if (dobj == null) {
                oraAWAttributes.longDesc = null;
            }
        }
        if (timeDim) {
            if (oraAWAttributes.timeEnd != null && (dobj = this.getAttributeById(oraAWAttributes.timeEnd.getObjectID())) == null) {
                if (this.levelEntity != null) {
                    dobj = this.levelEntity.getElementByID(oraAWAttributes.timeEnd.getObjectID());
                }
                if (dobj == null) {
                    oraAWAttributes.timeEnd = null;
                }
            }
            if (oraAWAttributes.timeSpan != null && (dobj = this.getAttributeById(oraAWAttributes.timeSpan.getObjectID())) == null) {
                if (this.levelEntity != null) {
                    dobj = this.levelEntity.getElementByID(oraAWAttributes.timeSpan.getObjectID());
                }
                if (dobj == null) {
                    oraAWAttributes.timeSpan = null;
                }
            }
        }
    }

    public void attributeIsDeleted(ContainedObject attr) {
        Object obj;
        int i;
        if (this.getDefaultAttribute() == attr) {
            this.setDefaultAttribute(null);
        }
        Object[] attrs = this.getLevelKey().toArray();
        for (i = 0; i < attrs.length; ++i) {
            obj = attrs[i];
            if (obj != attr) continue;
            this.getLevelKey().remove(obj);
        }
        attrs = this.getSlowChangingAttributes().toArray();
        for (i = 0; i < attrs.length; ++i) {
            obj = (SlowChangingAttribute)attrs[i];
            if (((SlowChangingAttribute)obj).getAttribute() != attr) continue;
            ((SlowChangingAttribute)obj).setAttribute(null);
        }
        if (this.oraAWAttributes.shortDesc == attr) {
            this.oraAWAttributes.shortDesc = null;
        }
        if (this.oraAWAttributes.longDesc != null) {
            this.oraAWAttributes.longDesc = null;
        }
        if (this.oraAWAttributes.timeEnd != null) {
            this.oraAWAttributes.timeEnd = null;
        }
        if (this.oraAWAttributes.timeSpan != null) {
            this.oraAWAttributes.timeSpan = null;
        }
    }

    public void entityIsDeleted(ContainerObject ent) {
        if (this.getLevelEntity() == ent) {
            this.setLevelEntity(null);
            this.setDefaultAttribute(null);
            this.getLevelKey().clear();
            this.getSlowChangingAttributes().clear();
            this.getCalculatedAttributes().clear();
            this.oraAWAttributes.shortDesc = null;
            this.oraAWAttributes.longDesc = null;
            this.oraAWAttributes.timeEnd = null;
            this.oraAWAttributes.timeSpan = null;
            for (AbstractMDObject link : this.getOutgoingLinks()) {
                RollupLink rl = ((Link)link).getRollupLink();
                if (rl == null) continue;
                rl.getChildToParentAttributes().clear();
            }
            for (AbstractMDObject link : this.getRaggedHLinks()) {
                ((RaggedHLink)link).getChildToParentAttributes().clear();
            }
        }
    }

    @Override
    public boolean setName(String name) {
        if (!this.name.equals(name)) {
            this.name = name;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
        return true;
    }

    @Override
    public String toString() {
        String result = "";
        if (this.getLevelEntity() != null) {
            result = this.getLevelEntity().getName() + ".";
        }
        result = result + this.getName();
        return result;
    }

    public ContainedObject getNameColumn() {
        return this.nameColumn;
    }

    public void setNameColumn(ContainedObject nameColumn) {
        this.nameColumn = nameColumn;
    }

    public ContainedObject getValueColumn() {
        return this.valueColumn;
    }

    public void setValueColumn(ContainedObject valueColumn) {
        this.valueColumn = valueColumn;
    }

    @Override
    public String getFCObjectType() {
        return TYPE_NAME;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "level/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public List getUsedInHierarchies() {
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
        Iterator it = this.getMultidimensionalDesign().getHierarchySet().iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            if (hier == null || !hier.getLevels().contains(this) || list.contains(hier)) continue;
            list.add(hier);
        }
        return list;
    }

    public List getUsedInDimensions() {
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        Iterator it = this.getMultidimensionalDesign().getHierarchySet().iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            Dimension dim = hier.getDimension();
            if (dim == null || !hier.getLevels().contains(this) || list.contains(dim)) continue;
            list.add(dim);
        }
        return list;
    }

    public class OraAWAttributes
    implements ID_ObjectPropertyTranslator {
        public ContainedObject shortDesc;
        public ContainedObject longDesc;
        public ContainedObject timeSpan;
        public ContainedObject timeEnd;
        public Level level;

        public OraAWAttributes(Level level2) {
            this.level = level2;
        }

        public ContainedObject getShortDesc() {
            return this.shortDesc;
        }

        public void setShortDesc(ContainedObject shortDesc) {
            this.shortDesc = shortDesc;
        }

        public ContainedObject getLongDesc() {
            return this.longDesc;
        }

        public void setLongDesc(ContainedObject longDesc) {
            this.longDesc = longDesc;
        }

        public ContainedObject getTimeSpan() {
            return this.timeSpan;
        }

        public void setTimeSpan(ContainedObject timeSpan) {
            this.timeSpan = timeSpan;
        }

        public ContainedObject getTimeEnd() {
            return this.timeEnd;
        }

        public void setTimeEnd(ContainedObject timeEnd) {
            this.timeEnd = timeEnd;
        }

        @Override
        public Object translateIdToObject(String propertyName, String id) {
            return this.level.translateIdToObject(propertyName, id);
        }

        @Override
        public String translateObjectToID(String propertyName, Object object) {
            return this.level.translateObjectToID(propertyName, object);
        }
    }
}

