/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;

public class Link
extends AbstractMDObject
implements ConnectionInterface {
    public static final Object[] CONNECTION_PROTO_ARRAY = new Connection[0];
    public static final int SOURCE = 0;
    public static final int DESTINATION = 1;
    private final AbstractMDObject[] MD_OBJECTS = new AbstractMDObject[2];
    private final Connection[] CONNECTIONS = new Connection[]{new SourceConnection(), new DestinationConnection()};
    private AbstractMDObject source;
    private AbstractMDObject destination;
    private Collection dpvCol = new ArrayList();
    private RollupLink rollupLink;
    public static final String TYPE_NAME = "Link";

    public Link(DesignPart designPart) {
        super(designPart);
    }

    public void setMDObject(int endPoint, AbstractMDObject mdObject) {
        if (this.MD_OBJECTS[endPoint] == mdObject) {
            return;
        }
        if (this.MD_OBJECTS[endPoint] != null) {
            if (this.MD_OBJECTS[0] != this.MD_OBJECTS[1]) {
                // empty if block
            }
            this.MD_OBJECTS[endPoint].remove(this.CONNECTIONS[endPoint]);
        }
        if (mdObject != null) {
            mdObject.add(this.CONNECTIONS[endPoint]);
        }
        this.MD_OBJECTS[endPoint] = mdObject;
        if (mdObject != null) {
            // empty if block
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
    }

    public AbstractMDObject getMDObject(int endPoint) {
        return this.MD_OBJECTS[endPoint];
    }

    public AbstractMDObject getTargetMDObject() {
        return this.getMDObject(1);
    }

    public void setTargetMDObject(AbstractMDObject mdObject) {
        AbstractMDObject old = this.getTargetMDObject();
        this.setMDObject(1, mdObject);
        this.setDestination(mdObject);
        if (old != mdObject && old != null) {
            this.clearTargetTV();
        }
        if (this.getSourceMDObject() != null && this.getTargetMDObject() != null && !this.getDesign().isLoading()) {
            this.getDesign().getMultidimensionalDesign().processNewLink(this);
        }
    }

    public AbstractMDObject getSourceMDObject() {
        return this.getMDObject(0);
    }

    public void setSourceMDObject(AbstractMDObject mdObject) {
        AbstractMDObject old = this.getSourceMDObject();
        this.setMDObject(0, mdObject);
        this.setSource(mdObject);
        if (old != mdObject && old != null) {
            this.clearSourceTV();
        }
        if (this.getSourceMDObject() != null && this.getTargetMDObject() != null && !this.getDesign().isLoading()) {
            this.getDesign().getMultidimensionalDesign().processNewLink(this);
        }
    }

    @Override
    public void removeAllViews() {
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.dpv == null || dpi.tv == null) continue;
            dpi.dpv.unregisterFromTreemodel(dpi.tv);
            dpi.dpv.getWorkSpace().removeConnection(this);
            dpi.tv = null;
        }
    }

    public void clearSourceTV() {
        for (dpvInfo dpi : this.dpvCol) {
            dpi.sourceTV = null;
        }
    }

    public void clearTargetTV() {
        for (dpvInfo dpi : this.dpvCol) {
            dpi.targetTV = null;
        }
    }

    public dpvInfo getDPVInfoFor(DesignPartView dpv) {
        dpvInfo dpi2;
        for (dpvInfo dpi2 : this.dpvCol) {
            if (dpi2.dpv != dpv) continue;
            return dpi2;
        }
        dpi2 = new dpvInfo();
        dpi2.dpv = dpv;
        this.dpvCol.add(dpi2);
        return dpi2;
    }

    @Override
    public TopView getViewFor(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.tv;
    }

    public AbstractMDTV getSourceTV(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV == null && this.getSourceMDObject() != null) {
            dpi.sourceTV = (AbstractMDTV)this.getSourceMDObject().getFirstViewForDPV(dpv);
            if (dpi.sourceTV != null) {
                dpi.sourceTV.addTopViewListener(this);
                this.addTVLink(dpi);
            }
        }
        return dpi.sourceTV;
    }

    public AbstractMDTV getTargetTV(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV == null && this.getTargetMDObject() != null) {
            dpi.targetTV = (AbstractMDTV)this.getTargetMDObject().getFirstViewForDPV(dpv);
            if (dpi.targetTV != null) {
                dpi.targetTV.addTopViewListener(this);
                this.addTVLink(dpi);
            }
        }
        return dpi.targetTV;
    }

    public void addTVLink(dpvInfo dpi) {
        if (dpi.tv == null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            TVLink tvr = new TVLink(this.getDesign().getAppView(), dpi.dpv);
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpi.dpv.registerForTreemodel(tvr);
            if (!ApplicationView.loading) {
                tvr.addConnection();
            }
        } else if (dpi.tv != null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null && ((TVLink)dpi.tv).getEdge() == null && !ApplicationView.loading) {
            ((TVLink)dpi.tv).addConnection();
        }
    }

    public void setSourceTV(AbstractMDTV source) {
        if (source != null) {
            if (this.getSourceMDObject() == null) {
                this.setSourceMDObject((AbstractMDObject)source.getModel());
            }
            DesignPartView dpv = source.getDesignPartView();
            dpvInfo dpi = this.getDPVInfoFor(dpv);
            if (dpi.sourceTV != null) {
                if (dpi.tv != null) {
                    ((TVLink)dpi.tv).removeConnection();
                }
                dpi.sourceTV.removeTopViewListener(this);
            }
            dpi.sourceTV = source;
            dpi.sourceTV.addTopViewListener(this);
            this.addTVLink(dpi);
        }
    }

    public void setTargetTV(AbstractMDTV target) {
        if (target != null) {
            if (this.getTargetMDObject() == null) {
                this.setTargetMDObject((AbstractMDObject)target.getModel());
            }
            DesignPartView dpv = target.getDesignPartView();
            dpvInfo dpi = this.getDPVInfoFor(dpv);
            if (dpi.targetTV != null) {
                if (dpi.tv != null) {
                    ((TVLink)dpi.tv).removeConnection();
                }
                dpi.targetTV.removeTopViewListener(this);
            }
            dpi.targetTV = target;
            dpi.targetTV.addTopViewListener(this);
            this.addTVLink(dpi);
        }
    }

    public boolean isValid() {
        return this.getMDObject(0) != null && this.getMDObject(1) != null;
    }

    public Connection getConnection(int endPoint) {
        return this.CONNECTIONS[endPoint];
    }

    public Connection getSourceConnection() {
        return this.getConnection(0);
    }

    public Connection getTargetConnection() {
        return this.getConnection(1);
    }

    @Override
    public void setTopView(TopView view) {
        this.addTopView(view);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            return dpi.tv;
        }
        return null;
    }

    @Override
    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv != null) {
            throw new RuntimeException(Messages.getString("Link.AssociationAlreadyExists"));
        }
        inf.tv = view;
    }

    @Override
    public void removeTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv == null) {
            return;
        }
        this.dpvCol.remove(inf);
        this.removeObjectListener(view);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public AbstractMDObject getSource() {
        return this.source;
    }

    public void setSource(AbstractMDObject source) {
        this.source = source;
    }

    public AbstractMDObject getDestination() {
        return this.destination;
    }

    public void setDestination(AbstractMDObject destination) {
        this.destination = destination;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public RollupLink getRollupLink() {
        return this.rollupLink;
    }

    public void setRollupLink(RollupLink rollupLink) {
        this.rollupLink = rollupLink;
    }

    public void addRollupLink() {
        if (this.rollupLink == null && this.getSource() != null) {
            this.rollupLink = this.getDesign().getMultidimensionalDesign().createRollupLink();
            this.rollupLink.setParentLevel(this.getTargetMDObject());
            this.rollupLink.setChildLevel(this.getSourceMDObject());
            this.rollupLink.setLink(this);
        }
    }

    @Override
    public void changed(TopView tv, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView dpv = tv.getDesignPartView();
            dpv.removeViewFor(this);
            dpvInfo dpi = this.getDPVInfoFor(dpv);
            dpi.tv = null;
            if (dpi.sourceTV == tv) {
                dpi.sourceTV = null;
            }
            if (dpi.targetTV == tv) {
                dpi.targetTV = null;
            }
            if (this.getDesignPart() == dpv.getDesignPart()) {
                this.remove();
            }
        }
    }

    @Override
    public void showPropertyDialog() {
        if (this.rollupLink != null) {
            this.rollupLink.showPropertyDialog();
        }
    }

    @Override
    public void remove() {
        RollupLink rollupLink = this.getRollupLink();
        AbstractMDObject targeto = this.getTargetMDObject();
        AbstractMDObject sourceo = this.getSourceMDObject();
        this.getDesign().getMultidimensionalDesign().removeAndUpdateHierarchies(this, sourceo, targeto);
        super.remove();
        this.setMDObject(1, null);
        this.setMDObject(0, null);
        if (rollupLink != null) {
            rollupLink.remove();
        }
    }

    public void attributeIsDeleted(ContainedObject attr) {
        RollupLink rl = this.getRollupLink();
        if (rl != null) {
            rl.getChildToParentAttributes().remove(attr);
        }
    }

    @Override
    public void setSourceTopView(TopView source) {
        this.setSourceTV((AbstractMDTV)source);
    }

    @Override
    public void setTargetTopView(TopView target) {
        this.setTargetTV((AbstractMDTV)target);
    }

    @Override
    public TopView getSourceTopView(DesignPartView dpv) {
        return this.getSourceTV(dpv);
    }

    @Override
    public TopView getTargetTopView(DesignPartView dpv) {
        return this.getTargetTV(dpv);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        return this.getViewFor(dpv);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getSourceMDObject();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getTargetMDObject();
    }

    @Override
    public List getAllViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            col.add(dpi.tv);
        }
        return col;
    }

    @Override
    public void restoreTopView(TopView tv, TopView sourceTV, TopView targetTV) {
        tv.getDesignPartView().restoreTopview(tv, this);
        dpvInfo dpi = this.getDPVInfoFor(tv.getDesignPartView());
        if (dpi.tv == tv) {
            this.addObjectListener(tv);
            dpi.targetTV = (AbstractMDTV)targetTV;
            dpi.targetTV.addTopViewListener(this);
            dpi.sourceTV = (AbstractMDTV)sourceTV;
            dpi.sourceTV.addTopViewListener(this);
        }
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "link/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getName() {
        if (this.rollupLink != null && this.rollupLink.isRolePlaying()) {
            return this.rollupLink.getName();
        }
        return super.getName();
    }

    public class DestinationConnection
    extends Connection {
        @Override
        public AbstractMDObject getMDObject() {
            return Link.this.getMDObject(1);
        }

        @Override
        public String getDescriptor() {
            return "Destination";
        }

        @Override
        public boolean isSource() {
            return false;
        }
    }

    public class SourceConnection
    extends Connection {
        @Override
        public AbstractMDObject getMDObject() {
            return Link.this.getMDObject(0);
        }

        @Override
        public String getDescriptor() {
            return "Source";
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    public abstract class Connection {
        private Boolean optionality = Boolean.TRUE;
        private String nameOn = null;

        public Link getLink() {
            return Link.this;
        }

        public abstract AbstractMDObject getMDObject();

        public abstract String getDescriptor();

        public abstract boolean isSource();

        public String toString() {
            return Link.this.getName() + this.getDescriptor();
        }

        public boolean isOptional() {
            return this.optionality;
        }

        public void setOptional(boolean value) {
            this.optionality = value ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean getOptionality() {
            return this.optionality;
        }

        public void setOptionality(Boolean value) {
            this.optionality = value == null ? Boolean.FALSE : value;
        }

        public void setNameOn(String name) {
            this.nameOn = name;
        }

        public TopView getTopView() {
            return Link.this.getTopView();
        }

        public String getNameOn() {
            return this.nameOn;
        }
    }

    public class dpvInfo {
        public AbstractMDTV sourceTV;
        public AbstractMDTV targetTV;
        public TopView tv;
        public DesignPartView dpv;

        dpvInfo() {
        }
    }
}

