/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.util.GUID;

public class MultidimensionalDesignSet
extends ModelIDObjectSet {
    private static final ModelIDObject[] PROTO_ARRAY = new MultidimensionalDesign[0];
    private Object elDescriptor;
    private Design design;

    public MultidimensionalDesignSet(Design design) {
        this.setDesign(design);
        this.setElementDescriptor(MultidimensionalDesign.class);
    }

    @Override
    public ModelIDObject createElement(String id) {
        MultidimensionalDesign design = new MultidimensionalDesign(this.getDesign());
        design.setDesign(this.getDesign());
        if (id == null || "".equalsIgnoreCase(id)) {
            design.setObjectID(new GUID().toString());
        } else {
            design.setObjectID(id);
        }
        design.setName(this.createName());
        design.setParent(this);
        this.add(design);
        return design;
    }

    @Override
    public boolean canCreateElement() {
        return true;
    }

    @Override
    protected String createName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDefaultNamePrefix());
        buffer.append(this.getSeparator());
        int count = this.size() + 1;
        while (this.getByName(buffer.toString() + String.valueOf(count)) != null) {
            ++count;
        }
        buffer.append(count);
        return buffer.toString();
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "Multidimensional";
    }

    public void setElementDescriptor(Object elementDescriptor) {
        this.elDescriptor = elementDescriptor;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    @Override
    public void setDesign(Design design) {
        this.design = design;
    }

    public MultidimensionalDesign getLoadedMDM_BoundTo(DesignPart rd) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MultidimensionalDesign mdm = (MultidimensionalDesign)it.next();
            if (!mdm.isLoaded() || rd != mdm.getBoundModel()) continue;
            return mdm;
        }
        return null;
    }
}

