/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;

public class OracleModelSelector {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private static final int FIELD_WIDTH = 220;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(220, 20);
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private Design design;
    private RelationalDesign physicalDesign;
    private StorageDesign storageDesign;
    private MultidimensionalDesign mdm;
    private String schema = "";
    JButton okButton;

    public OracleModelSelector(MultidimensionalDesign mdm) {
        this.mdm = mdm;
    }

    public boolean showDialog(ApplicationView view) {
        this.result = false;
        this.design = view.getCurrentDesign();
        this.dialog = new JDialog((Frame)view.getFrame(), Messages.getString("OracleModelSelector.SelectOracleModel"));
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setModal(true);
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel optionsPanel = new JPanel(new GridLayout(0, 1));
        optionsPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.okButton = new JButton(Messages.getString("OracleModelSelector.OK"));
        this.okButton.setEnabled(false);
        JLabel lbRelD = new JLabel(Messages.getString("OracleModelSelector.RelationalModel"));
        ArrayList rlist = new ArrayList();
        this.design.getRelationalDesigns().addAllElementsTo(rlist);
        lbRelD.setPreferredSize(this.prefDimension);
        this.cbRelDes = new JComboBox<Object>(rlist.toArray());
        this.cbRelDes.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbRelDes.setPreferredSize(this.prefDimension);
        this.cbStorage = new JComboBox();
        this.cbStorage.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbStorage.setPreferredSize(this.prefDimension);
        if (this.mdm.getBoundModel() != null && this.mdm.getBoundModel() instanceof RelationalDesign) {
            this.cbRelDes.setSelectedItem(this.mdm.getBoundModel());
            this.cbRelDes.setEnabled(false);
        }
        this.cbRelDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object ob = OracleModelSelector.this.cbRelDes.getSelectedItem();
                if (ob != null && ob instanceof RelationalDesign) {
                    RelationalDesign phd = (RelationalDesign)ob;
                    ArrayList<StorageDesign> rlist = new ArrayList<StorageDesign>();
                    StorageDesign[] stds = phd.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < stds.length; ++i) {
                        StorageDesign sd = stds[i];
                        if (!(sd instanceof StorageDesignOracle)) continue;
                        rlist.add(sd);
                    }
                    OracleModelSelector.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(rlist.toArray()));
                    if (rlist.size() > 0) {
                        OracleModelSelector.this.okButton.setEnabled(true);
                    } else {
                        OracleModelSelector.this.okButton.setEnabled(false);
                    }
                } else if (ob == null) {
                    OracleModelSelector.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                }
            }
        });
        if (rlist.size() > 0) {
            this.cbRelDes.setSelectedItem(rlist.get(0));
        }
        JPanel row = this.newRow(lbRelD, this.cbRelDes);
        optionsPanel.add(row);
        JLabel lbStoreD = new JLabel(Messages.getString("OracleModelSelector.PhysicalOracleModel"));
        lbStoreD.setPreferredSize(this.prefDimension);
        row = this.newRow(lbStoreD, this.cbStorage);
        optionsPanel.add(row);
        JPanel bottom = new JPanel();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OracleModelSelector.this.result = true;
                OracleModelSelector.this.physicalDesign = (RelationalDesign)OracleModelSelector.this.cbRelDes.getSelectedItem();
                OracleModelSelector.this.storageDesign = (StorageDesign)OracleModelSelector.this.cbStorage.getSelectedItem();
                if (OracleModelSelector.this.result) {
                    OracleModelSelector.this.dialog.dispose();
                }
            }
        });
        bottom.add(this.okButton);
        JButton cancelButton = new JButton(Messages.getString("OracleModelSelector.Cancel"));
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OracleModelSelector.this.result = false;
                OracleModelSelector.this.dialog.dispose();
            }
        });
        bottom.add(cancelButton);
        this.okButton.setPreferredSize(cancelButton.getPreferredSize());
        jpanel.add((Component)optionsPanel, "Center");
        jpanel.add((Component)bottom, "South");
        this.dialog.getContentPane().add(jpanel);
        this.dialog.pack();
        this.centerOnScreen(this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setVisible(true);
        return this.result;
    }

    private void centerOnScreen(JDialog window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = window.getSize();
        Point newLocation = new Point((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 2);
        window.setLocation(newLocation);
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    private JPanel newRow(JLabel lbName, Component field) {
        JPanel newRow = new JPanel();
        newRow.add(lbName);
        newRow.add(field);
        return newRow;
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public String getSchema() {
        return this.schema;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.mdm;
    }
}

