/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.swingui.editor.multidimensional.RollupLinkPropertiesDialogEx;

public class RollupLink
extends AbstractMDObject {
    private AbstractMDObject childLevel;
    private AbstractMDObject parentLevel;
    private List childToParentAttributes = new ArrayList();
    private ContainerObject factEntity;
    private boolean rolePlaying;
    private String defaultAggregationOperator = "SUM";
    private boolean sparseDimension = false;
    private Link link;
    public static final String TYPE_NAME = "RollupLink";

    public RollupLink(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RollupLinkPropertiesDialogEx dialog = new RollupLinkPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void showPropertyDialog(Dialog owner) {
        if (!this.isDialogVisible()) {
            RollupLinkPropertiesDialogEx dialog = owner == null ? new RollupLinkPropertiesDialogEx(this.getDesign().getAppView(), this) : new RollupLinkPropertiesDialogEx(owner, this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public AbstractMDObject getChildLevel() {
        return this.childLevel;
    }

    public void setChildLevel(AbstractMDObject childLevel) {
        this.childLevel = childLevel;
    }

    public AbstractMDObject getParentLevel() {
        return this.parentLevel;
    }

    public void setParentLevel(AbstractMDObject parentLevel) {
        this.parentLevel = parentLevel;
    }

    public List getChildToParentAttributes() {
        return this.childToParentAttributes;
    }

    public void addChildToParentAttribute(ContainedObject attribute) {
        if (!this.childToParentAttributes.contains(attribute)) {
            this.childToParentAttributes.add(attribute);
        }
    }

    public void removeChildToParentAttribute(ContainedObject attribute) {
        this.childToParentAttributes.remove(attribute);
    }

    public ContainerObject getFactEntity() {
        if (this.childLevel == null || !(this.childLevel instanceof Cube)) {
            return null;
        }
        if (this.factEntity != null) {
            return this.factEntity;
        }
        if (this.childToParentAttributes.size() > 0) {
            ContainedObject attr = (ContainedObject)this.childToParentAttributes.get(0);
            this.factEntity = attr.getContainer();
            return this.factEntity;
        }
        Cube cube = (Cube)this.childLevel;
        if (cube.getFactEntities().size() == 1) {
            this.factEntity = (ContainerObject)cube.getFactEntities().get(0);
            return this.factEntity;
        }
        return null;
    }

    public void setFactEntity(ContainerObject factEntity) {
        this.factEntity = factEntity;
    }

    public boolean isRolePlaying() {
        return this.rolePlaying;
    }

    public void setRolePlaying(boolean rolePlaying) {
        this.rolePlaying = rolePlaying;
    }

    public String getDefaultAggregationOperator() {
        return this.defaultAggregationOperator;
    }

    public void setDefaultAggregationOperator(String defaultAggregationOperator) {
        if (this.defaultAggregationOperator != null && !this.defaultAggregationOperator.equalsIgnoreCase(defaultAggregationOperator)) {
            this.setDirty(true);
        }
        this.defaultAggregationOperator = defaultAggregationOperator;
    }

    public boolean isSparseDimension() {
        return this.sparseDimension;
    }

    public void setSparseDimension(boolean sparseDimension) {
        if (this.sparseDimension != sparseDimension) {
            this.setDirty(true);
        }
        this.sparseDimension = sparseDimension;
    }

    public Link getLink() {
        if (this.link == null) {
            Iterator it = ((MultidimensionalDesign)this.getDesignPart()).getLinkSet().iterator();
            while (it.hasNext()) {
                Link clink = (Link)it.next();
                if (clink.getRollupLink() != this) continue;
                this.link = clink;
            }
        }
        return this.link;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "rolluplink/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setLink(Link link) {
        this.link = link;
    }

    public Link getOrCreateLink() {
        if (this.link == null) {
            this.link = this.getMultidimensionalDesign().getLinkSet().createLink(null, this);
        }
        return this.link;
    }

    @Override
    public void remove() {
        super.remove();
    }

    public boolean isDimensionUsage() {
        return this.getChildLevel() instanceof Cube && this.getParentLevel() instanceof Dimension;
    }

    public Cube getCube() {
        AbstractMDObject obj = this.getChildLevel();
        if (obj instanceof Cube) {
            return (Cube)obj;
        }
        return null;
    }

    public Dimension getDimension() {
        AbstractMDObject obj = this.getParentLevel();
        if (obj instanceof Dimension) {
            return (Dimension)obj;
        }
        return null;
    }
}

