/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;

public class SQLAttribute
implements ID_ObjectPropertyTranslator {
    private String type;
    private String name = "";
    public String hierarchyID;
    private Dimension dimension;
    private SlowChangingAttribute slowChangingAttribute;
    private Level level;
    public Hierarchy hierarchy;
    private Measure measure;
    private Slice.MeasureWrapper measureWrapper;
    private boolean nameEditable = false;
    private String dataType = "";
    private Slice slice;
    private Cube cube;
    private int outPosition = 0;
    private SQLAccessToAW sqlAW;
    private ID_ObjectPropertyTranslator idProvider;
    private String mw_MeasureID;
    private String mw_FunctID;
    private String sca_AttributeID;
    private String sca_AttributeName;

    public SQLAttribute(SQLAccessToAW sqlAW) {
        this.sqlAW = sqlAW;
        this.slice = sqlAW.getSlice();
        this.cube = sqlAW.getCube();
    }

    public SQLAttribute(String type, String name, Dimension dimension) {
        this.type = type;
        this.name = name;
        this.dimension = dimension;
        this.nameEditable = true;
    }

    public SQLAttribute(String name, Measure measure, Cube cube) {
        this.type = SQLAccessToAW.ATTR_TYPE_MEASURE;
        this.name = name;
        this.measure = measure;
        this.cube = cube;
        this.nameEditable = true;
    }

    public SQLAttribute(String name, Slice.MeasureWrapper measureWrapper, Slice slice) {
        this.type = SQLAccessToAW.ATTR_TYPE_MEASURE;
        this.name = name;
        this.measureWrapper = measureWrapper;
        this.slice = slice;
        this.nameEditable = true;
    }

    public SQLAttribute(String name, Dimension dimension, Level level, SlowChangingAttribute slowChangingAttribute) {
        this.type = SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR;
        this.name = name;
        this.dimension = dimension;
        this.level = level;
        this.slowChangingAttribute = slowChangingAttribute;
        this.nameEditable = true;
    }

    public SQLAttribute(String name, Dimension dimension, Hierarchy hierarchy, Level level) {
        this.type = SQLAccessToAW.ATTR_TYPE_LEVEL;
        this.name = name;
        this.dimension = dimension;
        this.hierarchy = hierarchy;
        this.level = level;
        this.nameEditable = true;
    }

    public SQLAttribute(String name, Dimension dimension, String hierarchyID, Level level) {
        this.type = SQLAccessToAW.ATTR_TYPE_LEVEL;
        this.name = name;
        this.dimension = dimension;
        this.hierarchyID = hierarchyID;
        this.level = level;
        this.nameEditable = true;
    }

    public String getType() {
        return this.type;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String getName() {
        return this.name;
    }

    public String getLevelName() {
        if (this.level != null) {
            return this.level.getName();
        }
        return "";
    }

    public String getDimensionName() {
        if (this.dimension != null) {
            return this.dimension.getName();
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSQLAWName() {
        String awname = "";
        String dimname = "";
        if (!this.type.equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) {
            dimname = this.dimension.getName().replaceAll(" ", "_");
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_SHORT_DESC)) {
            return dimname + "_" + "short_description";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LONG_DESC)) {
            return dimname + "_" + "long_description";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_END_DATE)) {
            return dimname + "_" + "end_date";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_TIME_SPAN)) {
            return dimname + "_" + "time_span";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LEVEL_NAME)) {
            return dimname + "_" + "levelrel";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_GID)) {
            return dimname + "_" + "gid";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_ID)) {
            return dimname;
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR)) {
            String attrname = this.slowChangingAttribute.getName().replaceAll(" ", "_");
            return dimname + "_" + attrname;
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) {
            String ownername = "";
            String measurename = "";
            if (this.measure != null) {
                ownername = this.cube.getName().replaceAll(" ", "_");
                measurename = this.measure.getName().replaceAll(" ", "_");
            } else if (this.measureWrapper != null) {
                ownername = this.slice.getName().replaceAll(" ", "_");
                measurename = this.measureWrapper.getAggrFunction().measureAlias.replaceAll(" ", "_");
            }
            return ownername + "_" + measurename;
        }
        return awname;
    }

    private String getAttributeDataType() {
        String typename = "varchar2(30)";
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR) && this.getSlowChangingAttribute().getAttribute() != null) {
            ContainedObject cob = this.getSlowChangingAttribute().getAttribute();
            if (cob instanceof AbstractViewElement) {
                typename = ((AbstractViewElement)cob).getDataType();
            } else if (cob instanceof ContainedObjectWithDomain) {
                typename = ((ContainedObjectWithDomain)cob).getDataType().toString();
            }
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) {
            typename = "number";
        }
        return typename;
    }

    public String toString() {
        String awname = "";
        String dimname = this.dimension.getName().replaceAll(" ", "_");
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_SHORT_DESC)) {
            return "Short Description";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LONG_DESC)) {
            return "Long Description";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LEVEL_NAME)) {
            return dimname + "_" + "levelrel";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_GID)) {
            return dimname + "_" + "gid";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_ID)) {
            return dimname + " column";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR)) {
            String attrname = this.slowChangingAttribute.getName();
            return attrname;
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) {
            String measurename = "";
            if (this.measure != null) {
                measurename = this.measure.getName().replaceAll(" ", "_");
            } else if (this.measureWrapper != null) {
                measurename = this.measureWrapper.getAggrFunction().measureAlias.replaceAll(" ", "_");
            }
            return measurename;
        }
        return awname;
    }

    public SlowChangingAttribute getSlowChangingAttribute() {
        return this.slowChangingAttribute;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SQLAttribute)) {
            return false;
        }
        SQLAttribute sattr = (SQLAttribute)object;
        if (!this.type.equals(sattr.getType())) {
            return false;
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) {
            return !(this.measure != null ? this.measure != sattr.getMeasure() : this.measureWrapper != sattr.getMeasureWrapper());
        }
        if (this.dimension != sattr.getDimension()) {
            return false;
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR)) {
            if (this.level != sattr.level) {
                return false;
            }
            if (this.slowChangingAttribute.getAttribute() != sattr.getSlowChangingAttribute().getAttribute()) {
                return false;
            }
        } else if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LEVEL)) {
            if (this.getHierarchy() != sattr.getHierarchy()) {
                return false;
            }
            if (this.level != sattr.level) {
                return false;
            }
        } else if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LEVEL_NAME) && this.level != sattr.level) {
            return false;
        }
        return true;
    }

    public Level getLevel() {
        return this.level;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public Slice.MeasureWrapper getMeasureWrapper() {
        return this.measureWrapper;
    }

    public boolean isNameEditable() {
        return this.nameEditable;
    }

    public void setNameEditable(boolean nameEditable) {
        this.nameEditable = nameEditable;
    }

    public boolean isDataTypePreset() {
        return !"".equals(this.dataType);
    }

    public String getDataType() {
        if (!this.isDataTypePreset()) {
            return this.getAttributeDataType();
        }
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType.trim();
    }

    public Hierarchy getHierarchy() {
        if (this.hierarchy == null && this.hierarchyID != null) {
            this.hierarchy = (Hierarchy)this.getDimension().getMultidimensionalDesign().getHierarchySet().getObjectByID(this.hierarchyID);
        }
        return this.hierarchy;
    }

    public Cube getCube() {
        return this.cube;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public int getOutPosition() {
        return this.outPosition;
    }

    public void setOutPosition(int outPosition) {
        this.outPosition = outPosition;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public void setSlowChangingAttribute(SlowChangingAttribute slowChangingAttribute) {
        this.slowChangingAttribute = slowChangingAttribute;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    public void setSlice(Slice slice) {
        this.slice = slice;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public ID_ObjectPropertyTranslator getIdProvider() {
        if (this.idProvider == null) {
            if (this.sqlAW != null) {
                this.idProvider = this.sqlAW;
            } else if (this.dimension != null) {
                this.idProvider = this.dimension;
            } else if (this.level != null) {
                this.idProvider = this.level;
            } else if (this.hierarchy != null) {
                this.idProvider = this.hierarchy;
            } else if (this.slowChangingAttribute != null) {
                this.idProvider = this.slowChangingAttribute;
            } else if (this.cube != null) {
                this.idProvider = this.cube;
            } else if (this.measure != null) {
                this.idProvider = this.measure;
            } else if (this.slice != null) {
                this.idProvider = this.slice;
            } else if (this.measureWrapper != null) {
                this.idProvider = this.measureWrapper;
            }
        }
        return this.idProvider;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        return this.getIdProvider().translateIdToObject(propertyName, id);
    }

    @Override
    public String translateObjectToID(String propertyName, Object object) {
        return this.getIdProvider().translateObjectToID(propertyName, object);
    }

    public String getMw_MeasureID() {
        if (this.getMeasureWrapper() != null) {
            return this.getMeasureWrapper().getMeasure().getObjectID();
        }
        return this.mw_MeasureID;
    }

    public void setMw_MeasureID(String mwMeasureID) {
        Slice.MeasureWrapper mw;
        this.mw_MeasureID = mwMeasureID;
        if (this.slice != null && this.mw_MeasureID != null && this.mw_FunctID != null && (mw = this.slice.getMeasureWrapper(mwMeasureID, mwMeasureID)) != null) {
            this.measureWrapper = mw;
        }
    }

    public String getMw_FunctID() {
        if (this.getMeasureWrapper() != null) {
            return this.getMeasureWrapper().getAggrFunction().getObjectID();
        }
        return this.mw_FunctID;
    }

    public void setMw_FunctID(String mwFunctID) {
        this.mw_FunctID = mwFunctID;
    }

    public String getSca_AttributeID() {
        if (this.getSlowChangingAttribute() != null && this.getSlowChangingAttribute().getAttribute() != null) {
            return this.getSlowChangingAttribute().getAttribute().getObjectID();
        }
        return this.sca_AttributeID;
    }

    public void setSca_AttributeID(String scaAttributeID) {
        SlowChangingAttribute sca;
        this.sca_AttributeID = scaAttributeID;
        if (this.level != null && this.sca_AttributeID != null && this.sca_AttributeName != null && (sca = this.level.getSlowChangingAttribute(this.sca_AttributeID, this.sca_AttributeName)) != null) {
            this.setSlowChangingAttribute(sca);
        }
    }

    public String getSca_AttributeName() {
        if (this.getSlowChangingAttribute() != null) {
            this.getSlowChangingAttribute().getName();
        }
        return this.sca_AttributeName;
    }

    public void setSca_AttributeName(String scaAttributeName) {
        this.sca_AttributeName = scaAttributeName;
    }

    public void setType(String type) {
        this.type = type;
    }
}

