/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.editor.multidimensional.SlicePropertiesDialogEx;

public class Slice
extends AbstractMDObject {
    private boolean readOnlySlice = true;
    private final List levels = new ArrayList();
    private boolean fullyRealized;
    private ContainerObject entity;
    private final List selectionCriterias = new ArrayList();
    private Cube cube;
    private final List selectedMeasureWrappers = new ArrayList();
    private final List allMeasureWrappers = new ArrayList();
    private final List selectedLevels = new ArrayList();
    private final List sliceMappings = new ArrayList();
    private final List sqlDefinitions = new ArrayList();
    public static final String TYPE_NAME = "Slice";

    public Slice(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SlicePropertiesDialogEx dialog = new SlicePropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public ContainerObject getEntity() {
        return this.entity;
    }

    public void setEntity(ContainerObject entity) {
        this.entity = entity;
        if (entity != null && entity instanceof ContainerWithKeyObject) {
            ((ContainerWithKeyObject)entity).setTypeID("4");
        }
    }

    public boolean isFullyRealized() {
        return this.fullyRealized;
    }

    public void setFullyRealized(boolean fullyRealized) {
        this.fullyRealized = fullyRealized;
    }

    public boolean isReadOnlySlice() {
        return this.readOnlySlice;
    }

    public void setReadOnlySlice(boolean readOnly) {
        this.readOnlySlice = readOnly;
    }

    public List getLevels() {
        return this.levels;
    }

    public void addLevel(Level level) {
        this.levels.add(level);
    }

    public void removeLevel(Level level) {
        this.levels.remove(level);
    }

    public List getSelectionCriterias() {
        return this.selectionCriterias;
    }

    public void addSelectionCriteria(SelectionCriteria selectionCriteria) {
        selectionCriteria.setSlice(this);
        if (!this.selectionCriterias.contains(selectionCriteria)) {
            this.selectionCriterias.add(selectionCriteria);
        }
    }

    public void removeSelectionCriteria(SelectionCriteria selectionCriteria) {
        this.selectionCriterias.remove(selectionCriteria);
    }

    public SelectionCriteria createSelectionCriteria() {
        SelectionCriteria sc = this.getMultidimensionalDesign().createSelectionCriteria();
        this.addSelectionCriteria(sc);
        return sc;
    }

    public Cube getCube() {
        return this.cube;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public void applyMeasureWrappers(List list) {
        MeasureWrapper[] mws = this.selectedMeasureWrappers.toArray(new MeasureWrapper[0]);
        this.selectedMeasureWrappers.clear();
        for (MeasureWrapper newMW : list) {
            MeasureWrapper mw = this.getMeasureWrapperFor(newMW, mws);
            if (mw != null) {
                this.selectedMeasureWrappers.add(mw);
                continue;
            }
            this.selectedMeasureWrappers.add(newMW);
        }
    }

    private MeasureWrapper getMeasureWrapperFor(MeasureWrapper newMW, MeasureWrapper[] mws) {
        for (int i = 0; i < mws.length; ++i) {
            MeasureWrapper mw = mws[i];
            if (mw.measureId == null || !mw.measureId.equals(newMW.measureId)) continue;
            if (mw.aggrFuncId != null && newMW.aggrFuncId != null && mw.aggrFuncId.equals(newMW.aggrFuncId)) {
                return mw;
            }
            if (mw.aggrFuncId != null || newMW.aggrFuncId != null) continue;
            return mw;
        }
        return null;
    }

    public SelectedLevel createSelectedLevel() {
        return new SelectedLevel(this);
    }

    public void applySelectedLevels(List list) {
        this.selectedLevels.clear();
        this.selectedLevels.addAll(list);
    }

    public List getSelectedMeasureWrappers() {
        return this.selectedMeasureWrappers;
    }

    public List getAllMeasureWrappers() {
        return this.allMeasureWrappers;
    }

    public void verifyMeasureWrappers() {
        ArrayList temp = new ArrayList();
        temp.addAll(this.selectedMeasureWrappers);
        this.allMeasureWrappers.clear();
        for (Measure measure : this.cube.getMeasures()) {
            Measure.AggregateFunction af;
            if (measure.getAggregateFunctions().size() == 0) {
                af = measure.createAggregateFunction();
                measure.addAggregateFunction(af);
                measure.setDefaultAggregationFunction(af);
                for (Measure.AggregateFunction afn : measure.getAggregateFunctions()) {
                    MeasureWrapper mw = new MeasureWrapper(measure, afn, this);
                    mw.levels.addAll(af.levels);
                    this.allMeasureWrappers.add(mw);
                }
                continue;
            }
            if (measure.isDefinedAsOracleAWCalculated()) {
                af = (Measure.AggregateFunction)measure.getAggregateFunctions().get(0);
                af.name = "OLAP";
                MeasureWrapper mw = new MeasureWrapper(measure, af, this);
                mw.levels.addAll(af.levels);
                this.allMeasureWrappers.add(mw);
                continue;
            }
            for (Measure.AggregateFunction af2 : measure.getAggregateFunctions()) {
                MeasureWrapper mw = new MeasureWrapper(measure, af2, this);
                mw.levels.addAll(af2.levels);
                this.allMeasureWrappers.add(mw);
            }
        }
        this.selectedMeasureWrappers.clear();
        for (MeasureWrapper mw : this.allMeasureWrappers) {
            MeasureWrapper tmw = this.findMeasureWrapper(temp, mw);
            if (tmw == null || this.findMeasureWrapper(this.selectedMeasureWrappers, tmw) != null) continue;
            this.selectedMeasureWrappers.add(mw);
            mw.levels.clear();
            mw.levels.addAll(tmw.levels);
        }
    }

    private MeasureWrapper findMeasureWrapper(List list, MeasureWrapper inmw) {
        String measureId = inmw.getMeasure().getObjectID();
        if (inmw.getAggrFunction() != null) {
            String aggrFunctionId = inmw.getAggrFunction().getObjectID();
            for (MeasureWrapper mw : list) {
                if (inmw.getMeasure().isDefinedAsOracleAWCalculated() && inmw.getMeasure() == mw.getMeasure()) {
                    return mw;
                }
                if (mw.getAggrFunction() == null || mw.getMeasure() == null || !mw.getMeasure().getObjectID().equalsIgnoreCase(measureId) || !mw.getAggrFunction().getObjectID().equalsIgnoreCase(aggrFunctionId)) continue;
                return mw;
            }
        }
        return null;
    }

    public MeasureWrapper createMeasureWrapper(String measureId, String aggrFuncId) {
        MeasureWrapper mw = new MeasureWrapper(measureId, aggrFuncId, this);
        return mw;
    }

    public MeasureWrapper createMeasureWrapper(Measure measure, Measure.AggregateFunction aggrFunction) {
        MeasureWrapper mw = new MeasureWrapper(measure, aggrFunction, this);
        return mw;
    }

    public MeasureWrapper createMeasureWrapper() {
        MeasureWrapper mw = new MeasureWrapper(this);
        return mw;
    }

    public List getSelectedLevels() {
        if (this.getCube() != null) {
            ArrayList temp = new ArrayList();
            temp.addAll(this.selectedLevels);
            this.selectedLevels.clear();
            List cubedimensions = null;
            if (!this.getDesign().isLoading()) {
                cubedimensions = this.getCube().getDimensions();
            }
            for (SelectedLevel selectedLevel : temp) {
                if (!this.isCorrect(selectedLevel, cubedimensions)) continue;
                this.selectedLevels.add(selectedLevel);
            }
        }
        return this.selectedLevels;
    }

    public List getUsedDimensions() {
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        List cubedimensions = null;
        if (!this.getDesign().isLoading()) {
            cubedimensions = this.getCube().getDimensions();
        }
        for (SelectedLevel selectedLevel : this.selectedLevels) {
            Dimension dim = selectedLevel.getDimension();
            if (cubedimensions != null) {
                if (!cubedimensions.contains(dim)) continue;
                list.add(dim);
                continue;
            }
            list.add(dim);
        }
        return list;
    }

    private boolean isCorrect(SelectedLevel selectedLevel, List cubedimensions) {
        Dimension dimension = (Dimension)((MultidimensionalDesign)this.getDesignPart()).getDimensionSet().getObjectByID(selectedLevel.dimensionId);
        if (dimension == null) {
            return false;
        }
        if (cubedimensions != null && cubedimensions.indexOf(dimension) == -1) {
            return false;
        }
        Hierarchy hierarchy = (Hierarchy)((MultidimensionalDesign)this.getDesignPart()).getHierarchySet().getObjectByID(selectedLevel.hierarchyId);
        if (hierarchy == null) {
            if (dimension.getHierarchies().size() > 0) {
                hierarchy = (Hierarchy)dimension.getHierarchies().getElement(0);
                if (hierarchy.getLevels().size() > 0) {
                    Level level = (Level)hierarchy.getLevels().get(0);
                    selectedLevel.setHierarchy(hierarchy);
                    selectedLevel.setLevel(level);
                    return true;
                }
                return false;
            }
            return false;
        }
        Level level = (Level)((MultidimensionalDesign)this.getDesignPart()).getLevelSet().getObjectByID(selectedLevel.levelId);
        if (level == null) {
            return false;
        }
        if (!hierarchy.getLevels().contains(level)) {
            selectedLevel.setLevel((Level)hierarchy.getLevels().get(0));
        }
        return true;
    }

    public List getSliceMappings() {
        return this.sliceMappings;
    }

    public MeasureWrapper getMeasureWrapper(Measure measure, String funcID) {
        for (MeasureWrapper mw : this.selectedMeasureWrappers) {
            if (mw.getMeasure() != measure || !mw.getAggrFunction().objectId.equals(funcID)) continue;
            return mw;
        }
        return null;
    }

    public MeasureWrapper getMeasureWrapper(String measureID, String funcID) {
        if (measureID == null || funcID == null) {
            return null;
        }
        for (MeasureWrapper mw : this.selectedMeasureWrappers) {
            if (!mw.getMeasure().getObjectID().equalsIgnoreCase(measureID) || !mw.getAggrFunction().objectId.equals(funcID)) continue;
            return mw;
        }
        return null;
    }

    public String getWhereClauseFor(MeasureWrapper mw) {
        String where = "";
        Iterator it = this.selectionCriterias.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String wc;
            SelectionCriteria sc = (SelectionCriteria)it.next();
            if (sc.getMeasureWrapper() != mw || "".equals(wc = sc.getSelectionCriteria().trim())) continue;
            if (first) {
                where = wc;
                first = false;
                continue;
            }
            where = where + " AND " + wc;
        }
        return where.trim();
    }

    public List getSQLDefinitions() {
        return this.sqlDefinitions;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "slice/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public class SliceMapping {
        private final ContainedObject attribute;
        private DesignObject mapping;

        public SliceMapping(SliceMapping sm) {
            this.attribute = sm.getAttribute();
            this.mapping = sm.getMapping();
        }

        public SliceMapping(ContainedObject attribute, DesignObject mapping) {
            this.attribute = attribute;
            this.mapping = mapping;
        }

        public DesignObject getMapping() {
            return this.mapping;
        }

        public void setMapping(DesignObject mapping) {
            this.mapping = mapping;
        }

        public ContainedObject getAttribute() {
            return this.attribute;
        }
    }

    public class SelectedLevel
    implements ID_ObjectPropertyTranslator {
        String dimensionId;
        String hierarchyId;
        String levelId;
        Dimension dimension;
        Hierarchy hierarchy;
        Level level;
        String selAttrIDs;
        public RollupLink rollupLink;
        List selectedAttributes = new ArrayList();
        Slice slice;

        public SelectedLevel(String dimensionId, String hierarchyId, String levelId, Slice slice2) {
            this.slice = slice2;
            this.dimensionId = dimensionId;
            this.hierarchyId = hierarchyId;
            this.levelId = levelId;
        }

        public SelectedLevel(Dimension dimension, Hierarchy hierarchy, Level level, Slice slice2) {
            this.slice = slice2;
            this.dimension = dimension;
            this.hierarchy = hierarchy;
            this.level = level;
            this.dimensionId = dimension.getObjectID();
            this.hierarchyId = hierarchy.getObjectID();
            this.levelId = level.getObjectID();
        }

        public SelectedLevel(Slice slice2) {
            this.slice = slice2;
        }

        public Dimension getDimension() {
            if (this.dimension == null) {
                this.dimension = (Dimension)((MultidimensionalDesign)Slice.this.getDesignPart()).getDimensionSet().getObjectByID(this.dimensionId);
            }
            return this.dimension;
        }

        public void setDimension(Dimension dimension) {
            this.dimension = dimension;
            this.dimensionId = dimension.getObjectID();
        }

        public Hierarchy getHierarchy() {
            if (this.hierarchy == null) {
                this.hierarchy = (Hierarchy)((MultidimensionalDesign)Slice.this.getDesignPart()).getHierarchySet().getObjectByID(this.hierarchyId);
            }
            return this.hierarchy;
        }

        public void setHierarchy(Hierarchy hierarchy) {
            this.hierarchy = hierarchy;
            this.hierarchyId = hierarchy != null ? hierarchy.getObjectID() : null;
        }

        public Level getLevel() {
            if (this.level == null) {
                this.level = (Level)((MultidimensionalDesign)Slice.this.getDesignPart()).getLevelSet().getObjectByID(this.levelId);
            }
            return this.level;
        }

        public void setLevel(Level level) {
            if (this.level != level) {
                this.level = level;
                this.levelId = level.getObjectID();
                this.selectedAttributes.clear();
                this.selAttrIDs = null;
                this.selectedAttributes.addAll(level.getLevelKey());
            }
        }

        public void validateSelectedAttributes() {
            Object[] attrs = this.selectedAttributes.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                DesignObject dobj = this.level.getAttributeById(((DesignObject)attrs[i]).getObjectID());
                if (dobj != null) continue;
                this.selectedAttributes.remove(attrs[i]);
            }
        }

        public String toString() {
            if (this.getDimension() != null) {
                return this.getDimension().getName();
            }
            return "empty";
        }

        public String getSelAttrIDs() {
            this.getSelectedAttributes();
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < this.selectedAttributes.size(); ++i) {
                DesignObject dobj = (DesignObject)this.selectedAttributes.get(i);
                if (!first) {
                    sb.append(",").append(dobj.getObjectID());
                    continue;
                }
                sb.append(dobj.getObjectID());
                first = false;
            }
            return sb.toString();
        }

        public void setSelAttrIDs(String selAttrIDs) {
            this.selAttrIDs = selAttrIDs;
            this.selectedAttributes.clear();
        }

        public List getSelectedAttributes() {
            if (this.selectedAttributes.size() == 0 && this.selAttrIDs != null && !"".equalsIgnoreCase(this.selAttrIDs)) {
                String[] ids = this.selAttrIDs.indexOf(59) > -1 ? this.selAttrIDs.split(";") : this.selAttrIDs.split(",");
                Level level = this.getLevel();
                if (level != null) {
                    for (int i = 0; i < ids.length; ++i) {
                        DesignObject dobj = level.getAttributeById(ids[i]);
                        if (dobj == null) continue;
                        this.selectedAttributes.add(dobj);
                    }
                }
                this.selAttrIDs = null;
            }
            this.validateSelectedAttributes();
            return this.selectedAttributes;
        }

        public RollupLink getRollupLink() {
            return this.rollupLink;
        }

        public void setRollupLink(RollupLink rollupLink) {
            this.rollupLink = rollupLink;
        }

        @Override
        public Object translateIdToObject(String propertyName, String id) {
            if (this.slice != null) {
                return this.slice.translateIdToObject(propertyName, id);
            }
            return null;
        }

        @Override
        public String translateObjectToID(String propertyName, Object object) {
            if (this.slice != null) {
                return this.slice.translateObjectToID(propertyName, object);
            }
            return null;
        }
    }

    public class MeasureWrapper
    implements ID_ObjectPropertyTranslator {
        Measure measure;
        Measure.AggregateFunction aggrFunction;
        String measureId;
        String aggrFuncId;
        public List levels = new ArrayList();
        private Slice slice;

        public MeasureWrapper(Measure measure, Measure.AggregateFunction aggrFunction, Slice slice2) {
            this.measure = measure;
            this.slice = slice2;
            if (measure != null) {
                this.measureId = measure.getObjectID();
            }
            this.aggrFunction = aggrFunction;
            if (aggrFunction != null) {
                this.aggrFuncId = aggrFunction.getObjectID();
            }
        }

        MeasureWrapper(String measureId, String aggrFuncId, Slice slice2) {
            this.slice = slice2;
            this.measureId = measureId;
            this.aggrFuncId = aggrFuncId;
        }

        MeasureWrapper(Slice slice2) {
            this.slice = slice2;
        }

        public String getFunctionName() {
            if (this.getAggrFunction() != null) {
                return this.getAggrFunction().name;
            }
            return "";
        }

        public String getMeasureAlias() {
            if (this.getAggrFunction() != null) {
                return this.getAggrFunction().measureAlias;
            }
            return "";
        }

        public Measure.AggregateFunction getAggrFunction() {
            if (this.aggrFunction == null && this.getMeasure() != null) {
                this.aggrFunction = this.getMeasure().getAggregateFunctionById(this.aggrFuncId);
            }
            return this.aggrFunction;
        }

        public Measure getMeasure() {
            if (this.measure == null) {
                this.measure = (Measure)((MultidimensionalDesign)Slice.this.getDesignPart()).getMeasureSet().getObjectByID(this.measureId);
            }
            return this.measure;
        }

        public String toString() {
            if (this.getMeasure() != null && this.getAggrFunction() != null) {
                return this.getMeasure().getName() + " : " + this.getAggrFunction().name;
            }
            return "empty";
        }

        public List getLevels() {
            return this.levels;
        }

        public String getMeasureId() {
            return this.measureId;
        }

        public void setMeasureId(String measureId) {
            this.measureId = measureId;
        }

        public String getAggrFuncId() {
            return this.aggrFuncId;
        }

        public void setAggrFuncId(String aggrFuncId) {
            this.aggrFuncId = aggrFuncId;
        }

        @Override
        public Object translateIdToObject(String propertyName, String id) {
            return this.slice.translateIdToObject(propertyName, id);
        }

        @Override
        public String translateObjectToID(String propertyName, Object object) {
            return this.slice.translateObjectToID(propertyName, object);
        }
    }
}

