/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesignSet;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalAgentSet;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ExternalDataSet;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.FlowSet;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStoreSet;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.ProcessSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.process.DataFlowModelPropertiesDialog;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.swingui.process.TVProcess;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;

public class DataFlowDesign
extends DesignPart {
    public static final String OBJECT_TYPE_NAME = "Data Flow Diagram";
    public static final String AGENT_SET_NAME = "Agents";
    public static final String FLOW_SET_NAME = "Flows";
    public static final String NOTE_SET_NAME = "Notes";
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    private ProcessModel processModel;
    protected DesignPartView mainView;
    private ProcessSet processSet;
    private FlowSet flowSet;
    private ExternalAgentSet externalAgentSet;
    DesignObjectCollection agents;
    DesignObjectCollection extProcesses;
    DesignObjectCollection stores;
    private NoteSet noteSet;
    private boolean topLevel = true;
    private Process process;
    private List processOrderList = new ArrayList();
    private boolean clean = false;
    private String processOrderString = "";
    private String parentDFD_ID = "";
    private boolean pmDirty = false;

    public DataFlowDesign(ProcessModel processModel) {
        this.setDesign(processModel.getDesign());
        this.processModel = processModel;
        this.processModel.setDirty(true);
        this.clean = false;
    }

    public DataFlowDesign(ProcessModel processModel, boolean topLevel) {
        this.setDesign(processModel.getDesign());
        this.processModel = processModel;
        this.topLevel = topLevel;
        this.processModel.setDirty(true);
        this.clean = false;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getProcessSet().addAllElementsTo(collection);
        this.getExternalAgentSet().addAllElementsTo(collection);
        this.getInfoStoreSet().addAllElementsTo(collection);
        this.getFlowSet().addAllElementsTo(collection);
        this.getNoteSet().addAllElementsTo(collection);
        this.getDiagramViewSet().addAllElementsTo(collection);
        return collection;
    }

    public ExternalAgentSet getExternalAgentSet() {
        if (this.externalAgentSet == null) {
            if (this.process == null) {
                this.externalAgentSet = new ExternalAgentSet(this);
                this.externalAgentSet.setDesign(this.getDesign());
                this.externalAgentSet.setName(Messages.getString("DataFlowDesign.AllExternalAgents"));
                this.externalAgentSet.setParent(this);
            } else {
                this.externalAgentSet = this.getTLExternalAgentSet();
            }
            this.externalAgentSet.addSetListener(this);
        }
        return this.externalAgentSet;
    }

    public ExternalAgentSet getOwnExternalAgentSet() {
        if (this.process == null) {
            return this.getExternalAgentSet();
        }
        return null;
    }

    public FlowSet getFlowSet() {
        if (this.flowSet == null) {
            this.flowSet = new FlowSet(this);
            this.flowSet.setDesign(this.getDesign());
            this.flowSet.setName(Messages.getString("DataFlowDesign.Flows"));
            this.flowSet.setParent(this);
            this.flowSet.addSetListener(this);
        }
        return this.flowSet;
    }

    public InfoStoreSet getInfoStoreSet() {
        return this.getProcessModel().getInfoStoreSet();
    }

    public static final String getProcessSetName() {
        return Messages.getString("DataFlowDesign.Processes");
    }

    public ProcessSet getProcessSet() {
        if (this.processSet == null) {
            this.processSet = new ProcessSet(this);
            this.processSet.setDesign(this.getDesign());
            this.processSet.setName(Messages.getString("DataFlowDesign.Processes"));
            this.processSet.setParent(this);
            this.processSet.addSetListener(this);
        }
        return this.processSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(Messages.getString("DataFlowDesign.Notes"));
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public ExternalDataSet getExternalDataSet() {
        return this.getProcessModel().getExternalDataSet();
    }

    public Process createProcess() {
        Process process = this.getProcessSet().createProcess(null);
        return process;
    }

    public int getProcessNumber(Process process) {
        int ind = this.processOrderList.indexOf(process);
        return ind + 1;
    }

    public Flow createFlow() {
        return this.getFlowSet().createFlow(null);
    }

    public ExternalAgent createExternalAgent() {
        return this.getExternalAgentSet().createExternalAgent(null);
    }

    public InfoStore createInfoStore() {
        return this.getInfoStoreSet().createInfoStore(null);
    }

    @Override
    public Note createNote() {
        Note note = this.getNoteSet().createNote(null);
        return note;
    }

    @Override
    public Note recreateNote(String id) {
        return this.getNoteSet().createNote(id);
    }

    public ExternalData createExternalData() {
        return this.getExternalDataSet().createExternalData(null);
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (dirty) {
            this.processModel.setDirty(dirty);
        }
    }

    @Override
    public void clearAll() {
        for (int i = 0; i < this.getProcessSet().size(); ++i) {
            Process process = (Process)this.getProcessSet().getChild(i);
            process.clearDiagram();
        }
        this.removeGlobals();
        this.getProcessSet().removeAll();
        this.getFlowSet().removeAll();
        this.getNoteSet().removeAll();
        this.getDiagramViewSet().removeAll();
        this.clearDocuments();
        this.clearResponsibleParties();
        this.setComment("");
        this.setNotes("");
        this.clean = true;
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public void sortCollections() {
        this.getProcessSet().sort();
        this.getFlowSet().sort();
        this.getExternalAgentSet().sort();
        this.getInfoStoreSet().sort();
        this.getExternalDataSet().sort();
    }

    private void removeGlobals() {
        ContainerView cv;
        AbstractProcessObject po;
        DesignObjectPlaceHolder dph;
        int i;
        DesignPartView dpv = this.getMainView();
        Object[] dphar = this.getAgents().toArray();
        for (i = 0; i < dphar.length; ++i) {
            dph = (DesignObjectPlaceHolder)dphar[i];
            po = (AbstractProcessObject)dph.getDesignObject();
            cv = (ContainerView)po.getFirstViewForDPV(dpv);
            if (cv == null) continue;
            cv.remove(false);
        }
        dphar = this.getAgents().toArray();
        for (i = 0; i < dphar.length; ++i) {
            dph = (DesignObjectPlaceHolder)dphar[i];
            po = (AbstractProcessObject)dph.getDesignObject();
            cv = (ContainerView)po.getFirstViewForDPV(dpv);
            if (cv == null) continue;
            cv.remove(false);
        }
    }

    @Override
    public int getNumberOfChildren() {
        if (this.isLoaded()) {
            if (this.process != null) {
                return 5;
            }
            return 5;
        }
        return 0;
    }

    @Override
    public ModelObject getChild(int index) {
        if (this.process != null) {
            switch (index) {
                case 0: {
                    return this.getProcessSet();
                }
                case 1: {
                    return this.getExtProcesses();
                }
                case 2: {
                    return this.getStores();
                }
                case 3: {
                    return this.getAgents();
                }
                case 4: {
                    return this.getFlowSet();
                }
            }
            return null;
        }
        switch (index) {
            case 0: {
                return this.getProcessSet();
            }
            case 1: {
                return this.getStores();
            }
            case 2: {
                return this.getAgents();
            }
            case 3: {
                return this.getFlowSet();
            }
            case 4: {
                return this.getExternalAgentSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (this.process != null) {
            if (child == this.getProcessSet()) {
                return 0;
            }
            if (child == this.getExtProcesses()) {
                return 1;
            }
            if (child == this.getStores()) {
                return 2;
            }
            if (child == this.getAgents()) {
                return 3;
            }
            if (child == this.getFlowSet()) {
                return 4;
            }
            return -1;
        }
        if (child == this.getProcessSet()) {
            return 0;
        }
        if (child == this.getStores()) {
            return 1;
        }
        if (child == this.getAgents()) {
            return 2;
        }
        if (child == this.getFlowSet()) {
            return 3;
        }
        if (child == this.getExternalAgentSet()) {
            return 4;
        }
        return -1;
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        return null;
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVProcess(this.getDesign().getAppView(), this);
            this.mainView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DFD";
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (event == SetEvent.OBJECT_ADDED) {
            this.fireAdded(event.getAffected());
        } else if (event == SetEvent.OBJECT_REMOVED) {
            if (this.process != null) {
                DesignObject dobj = event.getAffected();
                if (this.agents != null && dobj instanceof ExternalAgent) {
                    this.agents.removePlaceHolderFor(dobj);
                }
                if (this.stores != null && dobj instanceof InfoStore) {
                    this.stores.removePlaceHolderFor(event.getAffected());
                }
            }
            if (event.getAffected() instanceof Process) {
                this.processOrderList.remove(event.getAffected());
            }
            this.fireRemoved(event.getAffected());
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        if (this.process == null) {
            list.add(this.getExternalAgentSet());
        }
        list.add(this.getProcessSet());
        list.add(this.getFlowSet());
        list.add(this.getNoteSet());
        return list;
    }

    @Override
    public void doBeforeLoad() {
        this.pmDirty = this.getProcessModel().isDirty();
        this.getProcessModel().setDataFlowDesign(this);
    }

    @Override
    public void doAfterLoad() {
        this.presetProcessOrder();
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.getProcessModel().setDirty(this.pmDirty);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        boolean dirty = this.getProcessModel().isDirty();
        this.getProcessModel().setDataFlowDesign(this);
        XMLPersistenceManager pm = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader reader = pm.getDesignPartReader(this);
        if (reader != null) {
            reader.recreateDesign(this.getObjectID(), (DesignPart)this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.getProcessModel().setDirty(dirty);
        this.checkAndSetIDGenerator();
    }

    @Override
    public String getName() {
        if (this.process != null) {
            return MessageFormat.format(Messages.getString("Process.Diagram"), this.process.getName());
        }
        return super.getName();
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
        if (process != null) {
            this.setParent(process);
        }
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
        this.fireDFD_TopLevelChanged(new DesignEvent("DFD top level flag changed"));
    }

    public Collection getFlowsForProcessObject(AbstractProcessObject processObject) {
        ArrayList<Flow> col = new ArrayList<Flow>();
        Iterator it = this.getFlowSet().iterator();
        while (it.hasNext()) {
            Flow flow = (Flow)it.next();
            if (processObject != flow.getSourceProcessObject() && processObject != flow.getTargetProcessObject()) continue;
            col.add(flow);
        }
        return col;
    }

    private ExternalAgentSet getTLExternalAgentSet() {
        if (this.process != null) {
            return ((DataFlowDesign)this.process.getDesignPart()).getExternalAgentSet();
        }
        if (this.externalAgentSet == null) {
            this.externalAgentSet = new ExternalAgentSet(this);
            this.externalAgentSet.setDesign(this.getDesign());
            this.externalAgentSet.setName(Messages.getString("DataFlowDesign.ExternalAgents"));
            this.externalAgentSet.setParent(this);
            this.externalAgentSet.addSetListener(this);
        }
        return this.externalAgentSet;
    }

    public void registerLocalObject(TopView topView) {
        DesignObject object = topView.getModel();
        if (object != null) {
            Process process;
            if (object instanceof ExternalAgent && !this.getAgents().containsPlaceHolderFor(object)) {
                this.getAgents().add(new DesignObjectPlaceHolder((DesignPart)this, object));
            } else if (object instanceof InfoStore && !this.getStores().containsPlaceHolderFor(object)) {
                this.getStores().add(new DesignObjectPlaceHolder((DesignPart)this, object));
            } else if (object instanceof Process && !this.getExtProcesses().containsPlaceHolderFor(object) && (process = (Process)object).getDesignPart() != this) {
                this.getExtProcesses().add(new DesignObjectPlaceHolder((DesignPart)this, object));
            }
        }
    }

    public void unRegisterLocalObject(TopView topView) {
        DesignObject object = topView.getModel();
        if (object != null) {
            if (object instanceof ExternalAgent) {
                this.getAgents().removePlaceHolderFor(object);
            } else if (object instanceof InfoStore) {
                this.getStores().removePlaceHolderFor(object);
            } else if (object instanceof Process) {
                this.getExtProcesses().removePlaceHolderFor(object);
            }
        }
    }

    public DesignObjectCollection getStores() {
        if (this.stores == null) {
            this.stores = new DesignObjectCollection();
            this.stores.setDesign(this.getDesign());
            this.stores.setName(Messages.getString("DataFlowDesign.UsedInformationStores"));
            this.stores.setElementDescriptor(InfoStore.class);
            this.stores.setParent(this);
        }
        return this.stores;
    }

    public DesignObjectCollection getAgents() {
        if (this.agents == null) {
            this.agents = new DesignObjectCollection();
            this.agents.setDesign(this.getDesign());
            this.agents.setName(Messages.getString("DataFlowDesign.UsedExternalAgents"));
            this.agents.setElementDescriptor(ExternalAgent.class);
            this.agents.setParent(this);
        }
        return this.agents;
    }

    public DesignObjectCollection getExtProcesses() {
        if (this.extProcesses == null) {
            this.extProcesses = new DesignObjectCollection();
            this.extProcesses.setDesign(this.getDesign());
            this.extProcesses.setName(Messages.getString("DataFlowDesign.OuterProcesses"));
            this.extProcesses.setParent(this);
        }
        return this.extProcesses;
    }

    public Collection getComponentFlowsFor(Flow flow) {
        ArrayList<Flow> col = new ArrayList<Flow>();
        Iterator it = this.getFlowSet().iterator();
        while (it.hasNext()) {
            Flow fl = (Flow)it.next();
            if (fl.getParentObject() != flow) continue;
            col.add(fl);
        }
        return col;
    }

    public DataFlowDesign getParentDataFlowdesign() {
        if (this.process != null) {
            return (DataFlowDesign)this.process.getDesignPart();
        }
        return null;
    }

    public Flow getFirstFlowBetween(AbstractProcessObject source, AbstractProcessObject target) {
        Iterator it = this.getFlowSet().iterator();
        while (it.hasNext()) {
            Flow flow = (Flow)it.next();
            if (flow.getSourceProcessObject() != source || flow.getTargetProcessObject() != target) continue;
            return flow;
        }
        return null;
    }

    public List getFlowsBetween(AbstractProcessObject source, AbstractProcessObject target) {
        ArrayList<Flow> result = new ArrayList<Flow>();
        Iterator it = this.getFlowSet().iterator();
        while (it.hasNext()) {
            Flow flow = (Flow)it.next();
            if (flow.getSourceProcessObject() != source || flow.getTargetProcessObject() != target) continue;
            result.add(flow);
        }
        return result;
    }

    public Flow createFlowsBetween(AbstractDataFlowTV sourceTV, AbstractDataFlowTV targetTV) {
        DataFlowDesign targetDFD;
        AbstractProcessObject source = (AbstractProcessObject)sourceTV.getModel();
        AbstractProcessObject target = (AbstractProcessObject)targetTV.getModel();
        DataFlowDesign sourceDFD = (DataFlowDesign)sourceTV.getDesignPartView().getDesignPart();
        if (sourceDFD == (targetDFD = (DataFlowDesign)targetTV.getDesignPartView().getDesignPart()) && sourceDFD == this) {
            Flow flow = this.createFlow();
            flow.setSourceTV(sourceTV);
            flow.setTargetTV(targetTV);
            TVFlow tvf = (TVFlow)flow.getViewFor(this.getMainView());
            tvf.addConnection();
            return flow;
        }
        DataFlowDesign commonParentDFD = this.getCommonParentDFD(sourceDFD, targetDFD);
        if (!(source instanceof Process)) {
            this.createSynonyms(source, targetDFD, commonParentDFD);
            Flow flow = targetDFD.createFlow();
            AbstractDataFlowTV tv = (AbstractDataFlowTV)((DPVProcess)targetDFD.getMainView()).createViewSynonim(source);
            flow.setSourceTV(tv);
            flow.setTargetTV(targetTV);
            TVFlow tvf = (TVFlow)flow.getViewFor(targetDFD.getMainView());
            tvf.addConnection();
            return flow;
        }
        if (!(target instanceof Process)) {
            this.createSynonyms(target, sourceDFD, commonParentDFD);
            Flow flow = sourceDFD.createFlow();
            flow.setSourceTV(sourceTV);
            AbstractDataFlowTV tv = (AbstractDataFlowTV)((DPVProcess)sourceDFD.getMainView()).createViewSynonim(target);
            flow.setTargetTV(tv);
            TVFlow tvf = (TVFlow)flow.getViewFor(sourceDFD.getMainView());
            tvf.addConnection();
            return flow;
        }
        return this.createFlowsBetweenLowLevelProcs((Process)source, (Process)target, commonParentDFD);
    }

    private DataFlowDesign getCommonParentDFD(DataFlowDesign dfd1, DataFlowDesign dfd2) {
        if (dfd1 == dfd2) {
            return dfd1;
        }
        for (DataFlowDesign par2 = dfd2.getParentDataFlowdesign(); par2 != null; par2 = par2.getParentDataFlowdesign()) {
            if (dfd1 != par2) continue;
            return dfd1;
        }
        DataFlowDesign par1 = dfd1.getParentDataFlowdesign();
        return this.getCommonParentDFD(par1, dfd2);
    }

    private void createSynonyms(AbstractProcessObject po, DataFlowDesign start, DataFlowDesign parent) {
        DataFlowDesign par;
        if (po instanceof Process) {
            return;
        }
        ((DPVProcess)start.getMainView()).createViewSynonim(po);
        if (start == parent) {
            return;
        }
        for (par = start.getParentDataFlowdesign(); par != null && par != parent; par = par.getParentDataFlowdesign()) {
            ((DPVProcess)par.getMainView()).createViewSynonim(po);
        }
        if (par != null) {
            ((DPVProcess)par.getMainView()).createViewSynonim(po);
        }
    }

    private Flow createFlowsBetweenLowLevelProcs(Process source, Process target, DataFlowDesign commonParentDFD) {
        Process ps = source.getParentProcessInDFD(commonParentDFD);
        if (ps == null) {
            ps = source;
        }
        Flow flow1 = this.createAndPropagateForSource(ps, target, commonParentDFD);
        Process pt = target.getParentProcessInDFD(commonParentDFD);
        if (pt == null) {
            pt = target;
        }
        Flow flow2 = this.createAndPropagateForTarget(source, pt, commonParentDFD);
        return flow1 != null ? flow1 : flow2;
    }

    private Flow createAndPropagateForSource(Process source, Process target, DataFlowDesign dfd) {
        Process tp;
        TVProcess targetTV;
        TVProcess sourceTV = (TVProcess)source.getFirstViewForDPV(dfd.getMainView());
        if (sourceTV == null) {
            sourceTV = (TVProcess)((DPVProcess)dfd.getMainView()).createViewSynonim(source);
        }
        if ((targetTV = (TVProcess)(tp = target.getParentProcessInDFD(dfd)).getFirstViewForDPV(dfd.getMainView())) == null) {
            targetTV = (TVProcess)((DPVProcess)dfd.getMainView()).createViewSynonim(tp);
        }
        Flow flow = dfd.createFlow();
        flow.setSourceTV(sourceTV);
        flow.setTargetTV(targetTV);
        TVFlow tvf = (TVFlow)flow.getViewFor(dfd.getMainView());
        tvf.addConnection();
        if (tp != target && tp.isComposite()) {
            flow = this.createAndPropagateForSource(source, target, tp.getDiagram());
        }
        return flow;
    }

    private Flow createAndPropagateForTarget(Process source, Process target, DataFlowDesign dfd) {
        Process ts;
        TVProcess sourceTV;
        TVProcess targetTV = (TVProcess)target.getFirstViewForDPV(dfd.getMainView());
        if (targetTV == null) {
            targetTV = (TVProcess)((DPVProcess)dfd.getMainView()).createViewSynonim(target);
        }
        if ((sourceTV = (TVProcess)(ts = source.getParentProcessInDFD(dfd)).getFirstViewForDPV(dfd.getMainView())) == null) {
            sourceTV = (TVProcess)((DPVProcess)dfd.getMainView()).createViewSynonim(ts);
        }
        Flow flow = dfd.createFlow();
        flow.setSourceTV(sourceTV);
        flow.setTargetTV(targetTV);
        TVFlow tvf = (TVFlow)flow.getViewFor(dfd.getMainView());
        tvf.addConnection();
        if (ts != source && ts.isComposite()) {
            flow = this.createAndPropagateForTarget(source, target, ts.getDiagram());
        }
        return flow;
    }

    public List getAllProcesses() {
        ArrayList list = new ArrayList();
        this.addAllProcesses(list);
        return list;
    }

    private void addAllProcesses(List list) {
        Iterator it = this.getProcessSet().iterator();
        while (it.hasNext()) {
            Process proc = (Process)it.next();
            list.add(proc);
            if (!proc.isComposite()) continue;
            proc.getDiagram().addAllProcesses(list);
        }
    }

    public List getAllFlows() {
        ArrayList list = new ArrayList();
        this.addAllFlows(list);
        return list;
    }

    private void addAllFlows(List list) {
        this.getFlowSet().addAllElementsTo(list);
        Iterator it = this.getProcessSet().iterator();
        while (it.hasNext()) {
            Process proc = (Process)it.next();
            if (!proc.isComposite()) continue;
            proc.getDiagram().addAllFlows(list);
        }
    }

    public List getAllPrimitiveProcesses() {
        ArrayList list = new ArrayList();
        this.addAllPrimitiveProcesses(list);
        return list;
    }

    public void addAllPrimitiveProcesses(List list) {
        Iterator it = this.getProcessSet().iterator();
        while (it.hasNext()) {
            Process proc = (Process)it.next();
            if (proc.isComposite()) {
                proc.getDiagram().addAllPrimitiveProcesses(list);
                continue;
            }
            list.add(proc);
        }
    }

    public void addAllPrimitiveProcessesConnectedToStore(List list) {
        Iterator it = this.getProcessSet().iterator();
        while (it.hasNext()) {
            Process proc = (Process)it.next();
            if (proc.isComposite()) {
                proc.getDiagram().addAllPrimitiveProcessesConnectedToStore(list);
                continue;
            }
            if (!proc.isConnectedToStore()) continue;
            list.add(proc);
        }
    }

    public DataFlowDesign getTopLevelDataFlowDesign() {
        if (this.isTopLevel()) {
            return this;
        }
        if (this.getParentDataFlowdesign() != null) {
            return this.getParentDataFlowdesign().getTopLevelDataFlowDesign();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        if (this.getProcessSet().size() > 0) {
            return false;
        }
        return this.getNoteSet().size() <= 0;
    }

    public List getProcessOrderList() {
        return this.processOrderList;
    }

    public boolean isClean() {
        return this.clean;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataFlowModelPropertiesDialog dialog = new DataFlowModelPropertiesDialog(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ExtAgent");
        list.add("Process");
        list.add(Flow.TYPE_NAME);
        list.add("Note");
        list.add("MainView");
        list.add("SubView");
        return list;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("agent", "ExtAgent");
            this.f2tMap.put("process", "Process");
            this.f2tMap.put("flow", Flow.TYPE_NAME);
            this.f2tMap.put("note", "Note");
        }
        return this.f2tMap;
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "pm/dflows/" + this.getObjectID()).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "pm/dflows/" + this.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StorableObject createObject(String objectType, String objectID, String name) {
        DesignObject object = null;
        if ("Process".equalsIgnoreCase(objectType)) {
            object = this.getProcessSet().createProcess(objectID);
        } else if ("ExtAgent".equalsIgnoreCase(objectType)) {
            object = this.getExternalAgentSet().createExternalAgent(objectID);
        } else if (Flow.TYPE_NAME.equalsIgnoreCase(objectType)) {
            object = this.getFlowSet().createFlow(objectID);
        } else if ("Note".equalsIgnoreCase(objectType)) {
            object = this.getNoteSet().createNote(objectID);
        }
        if (object != null && name != null && name.length() > 0) {
            ((DesignObject)object).setName(name);
        }
        return object;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        ProcessModel pm;
        DesignObject object = null;
        object = this.getDesign().getDesignObject(id);
        if (object != null) {
            return object;
        }
        if ("processModel".equalsIgnoreCase(propertyName) && (pm = this.getDesign().getProcessModel()).getObjectID().equals(id)) {
            return pm;
        }
        return super.translateIdToObject(propertyName, id);
    }

    public static void initObjectDetails(Design design, File file, String path, StorableObjectStatusHelper sosHelper, String storableObjectID) {
        Class<ModelIDObject> parentClass;
        SVNObjectHelper parentSVNOH;
        SVNObjectHelper svnOH = SVNObjectHelper.getSVNObjectHelperFor(design, storableObjectID);
        if (svnOH != null) {
            parentSVNOH = SVNObjectHelper.getSVNObjectHelperFor(design, svnOH.parentID);
            while (parentSVNOH != null) {
                try {
                    parentClass = Class.forName(parentSVNOH.className);
                    if (parentClass.isAssignableFrom(DataFlowDesign.class)) {
                        sosHelper.treePath.add(0, new TreePathHelper(parentSVNOH.propName, new File(parentSVNOH.fileName), parentClass));
                        sosHelper.treePath.add(0, new TreePathHelper(ProcessModel.getDataFlowDesignSetName(), new File(parentSVNOH.fileName).getParentFile(), parentClass));
                    } else if (parentClass.isAssignableFrom(Process.class)) {
                        sosHelper.treePath.add(0, new TreePathHelper(parentSVNOH.propName, new File(parentSVNOH.fileName), parentClass));
                        sosHelper.treePath.add(0, new TreePathHelper(DataFlowDesign.getProcessSetName(), new File(parentSVNOH.fileName).getParentFile(), parentClass));
                    } else if (parentClass.isAssignableFrom(ProcessModel.class)) {
                        sosHelper.treePath.add(0, new TreePathHelper("Process Model", new File(design.getProcessModel().getStorageName()), parentClass));
                    }
                    if ((parentSVNOH = SVNObjectHelper.getSVNObjectHelperFor(design, parentSVNOH.parentID)) == null || !parentSVNOH.className.endsWith("Process")) continue;
                    sosHelper.treePath.remove(0);
                }
                catch (ClassNotFoundException e) {}
            }
        }
        if ("agent".equalsIgnoreCase(path)) {
            sosHelper.objectClass = ExternalAgent.class;
            sosHelper.objectType = "ExtAgent";
            sosHelper.treePath.add(new TreePathHelper(AGENT_SET_NAME, file.getParentFile(), ExternalAgentSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((DataFlowDesign)sosHelper.designPart).getExternalAgentSet();
                sosHelper.storableObject = ((DataFlowDesign)sosHelper.designPart).getExternalAgentSet().getObjectByID(storableObjectID);
            }
        } else if ("process".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Process.class;
            sosHelper.objectType = "Process";
            sosHelper.treePath.add(new TreePathHelper(DataFlowDesign.getProcessSetName(), file.getParentFile(), ProcessSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((DataFlowDesign)sosHelper.designPart).getProcessSet();
                sosHelper.storableObject = ((DataFlowDesign)sosHelper.designPart).getProcessSet().getObjectByID(storableObjectID);
            }
        } else if ("flow".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Flow.class;
            sosHelper.objectType = Flow.TYPE_NAME;
            sosHelper.treePath.add(new TreePathHelper(FLOW_SET_NAME, file.getParentFile(), FlowSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((DataFlowDesign)sosHelper.designPart).getFlowSet();
                sosHelper.storableObject = ((DataFlowDesign)sosHelper.designPart).getFlowSet().getObjectByID(storableObjectID);
            }
        } else if ("note".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Note.class;
            sosHelper.objectType = "Note";
            sosHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file.getParentFile(), NoteSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((DataFlowDesign)sosHelper.designPart).getNoteSet();
                sosHelper.storableObject = ((DataFlowDesign)sosHelper.designPart).getNoteSet().getObjectByID(storableObjectID);
            }
        } else if ("subviews".equalsIgnoreCase(path)) {
            sosHelper.objectClass = DPVProcess.class;
            if (svnOH != null && (parentSVNOH = SVNObjectHelper.getSVNObjectHelperFor(design, svnOH.parentID)) != null) {
                try {
                    parentClass = Class.forName(parentSVNOH.className);
                    if (parentClass.isAssignableFrom(ProcessModel.class)) {
                        sosHelper.treePath.add(new TreePathHelper(ProcessModel.getDataFlowDesignSetName(), new File(svnOH.fileName).getParentFile(), DataFlowDesignSet.class));
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            sosHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file.getParentFile(), DPVProcess.class));
            if (sosHelper.designPart != null && sosHelper.designPart instanceof DataFlowDesign) {
                DataFlowDesign model = (DataFlowDesign)sosHelper.designPart;
                sosHelper.storableObject = model.getMainView().getDPVId().equals(storableObjectID) ? model.getMainView() : model.getSubViewByID(storableObjectID);
            }
        }
    }

    public String getProcessOrderString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Process process : this.getProcessOrderList()) {
            if (!first) {
                sb.append(",").append(process.getObjectID());
                continue;
            }
            sb.append(process.getObjectID());
            first = false;
        }
        return sb.toString();
    }

    public void setProcessOrderString(String processOrderString) {
        this.processOrderString = processOrderString;
    }

    public void presetProcessOrder() {
        String[] ids;
        if (!"".equals(this.processOrderString) && (ids = this.processOrderString.split(",")).length > 0) {
            List ordList = this.getProcessOrderList();
            ordList.clear();
            for (int i = 0; i < ids.length; ++i) {
                DesignObject obj = this.getProcessSet().getObjectByID(ids[i]);
                if (obj == null) continue;
                ordList.add(obj);
            }
            this.processOrderString = "";
        }
    }

    public String getParentDFD_ID() {
        if (this.getParentDataFlowdesign() != null) {
            return this.getParentDataFlowdesign().getObjectID();
        }
        return this.parentDFD_ID;
    }

    public void setParentDFD_ID(String parentDFDID) {
        this.parentDFD_ID = parentDFDID;
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.sortCollections();
    }

    protected void fireDFD_TopLevelChanged(DesignEvent event) {
        event.setDesignPart(this);
        DesignListener[] listeners = this.designListeners.toArray(new DesignListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            try {
                if (listeners[i] == null) continue;
                listeners[i].designChanged(event);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        ArrayList<Object> objects = new ArrayList<Object>();
        Iterator it = this.getProcessSet().iterator();
        while (it.hasNext()) {
            Process process = (Process)it.next();
            if (process.getMeasurements().size() <= 0) continue;
            objects.add(process);
        }
        it = this.getFlowSet().iterator();
        while (it.hasNext()) {
            Flow flow = (Flow)it.next();
            if (flow.getMeasurements().size() <= 0) continue;
            objects.add(flow);
        }
        it = this.getExternalAgentSet().iterator();
        while (it.hasNext()) {
            ExternalAgent externalAgent = (ExternalAgent)it.next();
            if (externalAgent.getMeasurements().size() <= 0) continue;
            objects.add(externalAgent);
        }
        it = this.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note = (Note)it.next();
            if (note.getMeasurements().size() <= 0) continue;
            objects.add(note);
        }
        return objects;
    }

    public List getSubordinateDataFlowDesigns() {
        ArrayList<DataFlowDesign> list = new ArrayList<DataFlowDesign>();
        Iterator it = this.getProcessModel().getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)it.next();
            if (this != dfd.getParentDataFlowdesign()) continue;
            list.add(dfd);
            list.addAll(dfd.getSubordinateDataFlowDesigns());
        }
        return list;
    }

    public DesignObjectCollection getDataFlowDesigns_AllLevels() {
        DesignObjectCollection col = new DesignObjectCollection();
        col.setDesign(this.getDesign());
        col.setElementDescriptor(InfoStore.class);
        List list = this.getSubordinateDataFlowDesigns();
        list.add(0, this);
        for (DataFlowDesign dfd : list) {
            for (ModelObject dob : dfd.getSubordinateDataFlowDesigns()) {
                col.add(dob);
            }
        }
        return col;
    }

    public DesignObjectCollection getStores_AllLevels() {
        DesignObjectCollection col = new DesignObjectCollection();
        col.setDesign(this.getDesign());
        col.setElementDescriptor(InfoStore.class);
        List list = this.getSubordinateDataFlowDesigns();
        list.add(0, this);
        for (DataFlowDesign dfd : list) {
            Iterator its = dfd.getStores().iterator();
            while (its.hasNext()) {
                DesignObject dob = (DesignObject)its.next();
                col.add(dob);
            }
        }
        return col;
    }

    public DesignObjectCollection getAgents_AllLevels() {
        DesignObjectCollection col = new DesignObjectCollection();
        col.setDesign(this.getDesign());
        col.setElementDescriptor(ExternalAgent.class);
        List list = this.getSubordinateDataFlowDesigns();
        list.add(0, this);
        for (DataFlowDesign dfd : list) {
            Iterator its = dfd.getAgents().iterator();
            while (its.hasNext()) {
                DesignObject dob = (DesignObject)its.next();
                col.add(dob);
            }
        }
        return col;
    }

    public DesignObjectCollection getFlows_AllLevels() {
        DesignObjectCollection col = new DesignObjectCollection();
        col.setDesign(this.getDesign());
        col.setElementDescriptor(Flow.class);
        List list = this.getSubordinateDataFlowDesigns();
        list.add(0, this);
        for (DataFlowDesign dfd : list) {
            Iterator its = dfd.getFlowSet().iterator();
            while (its.hasNext()) {
                DesignObject dob = (DesignObject)its.next();
                col.add(dob);
            }
        }
        return col;
    }

    public DesignObjectCollection getProcesses_AllLevels() {
        DesignObjectCollection col = new DesignObjectCollection();
        col.setDesign(this.getDesign());
        col.setElementDescriptor(Process.class);
        List list = this.getSubordinateDataFlowDesigns();
        list.add(0, this);
        for (DataFlowDesign dfd : list) {
            Iterator its = dfd.getProcessSet().iterator();
            while (its.hasNext()) {
                DesignObject dob = (DesignObject)its.next();
                col.add(dob);
            }
        }
        return col;
    }

    @Override
    public List getSearchableSets() {
        ArrayList<SearchSet> sets = new ArrayList<SearchSet>();
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Process.class), Process.class, this, this.getProcesses_AllLevels()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(ExternalAgent.class), ExternalAgent.class, this, this.getExternalAgentSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Flow.class), Flow.class, this, this.getFlows_AllLevels()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(InfoStore.class), InfoStore.class, this, this.getStores_AllLevels()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(DataFlowDesign.class), DataFlowDesign.class, this, this.getDataFlowDesigns_AllLevels()));
        return sets;
    }
}

