/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.swingui.editor.process.ExternalDataPropertiesDialog;

public class ExternalData
extends AbstractProcessObject {
    private LogicalDatatype type;
    private int startingPos = 0;
    private String description = "";
    private DesignObject mappedDesignObject;
    private boolean structured = false;
    private RecordStructure recStructure;
    private RecordStructure owner;
    public static final String TYPE_NAME = "ExternalData";

    public ExternalData(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "ED";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ExternalDataPropertiesDialog dialog = new ExternalDataPropertiesDialog(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description != null) {
            this.description = description;
        }
    }

    public int getStartingPos() {
        return this.startingPos;
    }

    public void setStartingPos(int startingPos) {
        this.startingPos = startingPos;
    }

    public LogicalDatatype getType() {
        return this.type;
    }

    public void setType(LogicalDatatype type) {
        this.type = type;
    }

    public DesignObject getMappedDesignObject() {
        return this.mappedDesignObject;
    }

    public void setMappedDesignObject(DesignObject mappedDesignObject) {
        if (this.mappedDesignObject != mappedDesignObject) {
            this.mappedDesignObject = mappedDesignObject;
            this.setDirty(true);
        }
    }

    public RecordStructure getRecordStructure() {
        return this.recStructure;
    }

    public void setRecordStructure(RecordStructure recStructure) {
        this.recStructure = recStructure;
    }

    public boolean isStructured() {
        return this.structured;
    }

    public void setStructured(boolean structured) {
        this.structured = structured;
    }

    public RecordStructure getOwner() {
        return this.owner;
    }

    public void setOwner(RecordStructure owner) {
        this.owner = owner;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "extdata/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

