/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.editor.process.FlowPropertiesDialogEx;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.dbtools.crest.swingui.process.TVFlow;

public class Flow
extends AbstractProcessObject
implements ConnectionInterface {
    public static final Object[] CONNECTION_PROTO_ARRAY = new Connection[0];
    public static final int SOURCE = 0;
    public static final int DESTINATION = 1;
    private final AbstractProcessObject[] PROCESS_OBJECTS = new AbstractProcessObject[2];
    private final Connection[] CONNECTIONS = new Connection[]{new SourceConnection(), new DestinationConnection()};
    private AbstractProcessObject source;
    private AbstractProcessObject destination;
    private AbstractProcessObject parent;
    private Event event;
    private String systemObjective = "";
    private boolean logging = false;
    private boolean opCreate;
    private boolean opRead;
    private boolean opUpdate;
    private boolean opDelete;
    private List infoStructures = new ArrayList();
    Collection dpvCol = new ArrayList();
    public static String TYPE_NAME = "Flow";

    public Flow(DesignPart designPart) {
        super(designPart);
    }

    public void setProcessObject(int endPoint, AbstractProcessObject processObject) {
        if (this.PROCESS_OBJECTS[endPoint] == processObject) {
            return;
        }
        if (this.PROCESS_OBJECTS[endPoint] != null) {
            if (this.PROCESS_OBJECTS[0] != this.PROCESS_OBJECTS[1]) {
                // empty if block
            }
            this.PROCESS_OBJECTS[endPoint].remove(this.CONNECTIONS[endPoint]);
        }
        if (processObject != null) {
            processObject.add(this.CONNECTIONS[endPoint]);
        }
        this.PROCESS_OBJECTS[endPoint] = processObject;
        if (processObject != null) {
            // empty if block
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
    }

    public AbstractProcessObject getProcessObject(int endPoint) {
        return this.PROCESS_OBJECTS[endPoint];
    }

    public AbstractProcessObject getTargetProcessObject() {
        return this.getProcessObject(1);
    }

    public void setTargetProcessObject(AbstractProcessObject processObject) {
        AbstractProcessObject old = this.getTargetProcessObject();
        this.setProcessObject(1, processObject);
        this.setDestination(processObject);
        if (old != processObject && old != null) {
            this.clearTargetTV();
        }
        this.addSynonymToCompositeProcDiagram();
        this.createOrSetParentFlow();
        this.addToAllDPVs(null);
    }

    public AbstractProcessObject getSourceProcessObject() {
        return this.getProcessObject(0);
    }

    public void setSourceProcessObject(AbstractProcessObject processObject) {
        AbstractProcessObject old = this.getSourceProcessObject();
        this.setProcessObject(0, processObject);
        this.setSource(processObject);
        if (old != processObject && old != null) {
            this.clearSourceTV();
        }
        if (this.getDesignPart() instanceof DataFlowDesign) {
            this.addSynonymToCompositeProcDiagram();
            this.createOrSetParentFlow();
            this.addToAllDPVs(null);
        }
    }

    public void addToAllDPVs(DesignPartView currentDPV) {
        AbstractProcessObject pos = this.getTargetProcessObject();
        AbstractProcessObject pot = this.getSourceProcessObject();
        if (pot != null && pos != null) {
            Collection targetDPVs = this.getTargetProcessObject().getAffectedDPVs();
            Collection sourceDPVs = this.getSourceProcessObject().getAffectedDPVs();
            for (DesignPartView dpv : targetDPVs) {
                TopView tv;
                if (dpv == currentDPV || (tv = this.getFirstViewForDPV(dpv)) != null || this.getTargetTV(dpv) == null || this.getSourceTV(dpv) == null) continue;
                ((TVFlow)this.getViewFor(dpv)).addConnection();
                sourceDPVs.remove(dpv);
            }
            for (DesignPartView dpv : sourceDPVs) {
                TopView tv;
                if (dpv == currentDPV || (tv = this.getFirstViewForDPV(dpv)) != null || this.getSourceTV(dpv) == null || this.getTargetTV(dpv) == null) continue;
                ((TVFlow)this.getViewFor(dpv)).addConnection();
            }
        }
    }

    @Override
    public void removeAllViews() {
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.dpv == null || dpi.tv == null) continue;
            dpi.dpv.unregisterFromTreemodel(dpi.tv);
            dpi.dpv.getWorkSpace().removeConnection(this);
            dpi.tv = null;
        }
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        return this.getViewFor(dpv);
    }

    public void clearSourceTV() {
        for (dpvInfo dpi : this.dpvCol) {
            dpi.sourceTV = null;
        }
    }

    public void clearTargetTV() {
        for (dpvInfo dpi : this.dpvCol) {
            dpi.targetTV = null;
        }
    }

    public dpvInfo getDPVInfoFor(DesignPartView dpv) {
        dpvInfo dpi2;
        for (dpvInfo dpi2 : this.dpvCol) {
            if (dpi2.dpv != dpv) continue;
            return dpi2;
        }
        dpi2 = new dpvInfo();
        dpi2.dpv = dpv;
        this.dpvCol.add(dpi2);
        return dpi2;
    }

    @Override
    public TopView getViewFor(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.tv;
    }

    public AbstractDataFlowTV getSourceTV(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV == null && this.getSourceProcessObject() != null) {
            dpi.sourceTV = (AbstractDataFlowTV)this.getSourceProcessObject().getFirstViewForDPV(dpv);
            if (dpi.sourceTV != null) {
                dpi.sourceTV.addTopViewListener(this);
                this.addTVFlow(dpi);
            }
        }
        return dpi.sourceTV;
    }

    public AbstractDataFlowTV getTargetTV(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV == null && this.getTargetProcessObject() != null) {
            dpi.targetTV = (AbstractDataFlowTV)this.getTargetProcessObject().getFirstViewForDPV(dpv);
            if (dpi.targetTV != null) {
                dpi.targetTV.addTopViewListener(this);
                this.addTVFlow(dpi);
            }
        }
        return dpi.targetTV;
    }

    public void addTVFlow(dpvInfo dpi) {
        if (dpi.tv == null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            TVFlow tvr = dpi.dpv instanceof DPVProcess ? (TVFlow)((DPVProcess)dpi.dpv).createViewSynonim(this) : (TVFlow)((DPVTransformation)dpi.dpv).createViewSynonim(this);
            dpi.tv = tvr;
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
        }
    }

    public void setSourceTV(AbstractDataFlowTV source) {
        if (source != null) {
            this.setSourceProcessObject((AbstractProcessObject)source.getModel());
            DesignPartView dpv = source.getDesignPartView();
            dpvInfo dpi = this.getDPVInfoFor(dpv);
            boolean reassignConnection = false;
            if (dpi.sourceTV != null) {
                reassignConnection = true;
                if (dpi.tv != null) {
                    ((TVFlow)dpi.tv).removeConnection();
                }
                dpi.sourceTV.removeTopViewListener(this);
            }
            dpi.sourceTV = source;
            dpi.sourceTV.addTopViewListener(this);
            this.addTVFlow(dpi);
            if (reassignConnection && dpi.tv != null) {
                ((TVFlow)dpi.tv).addConnection();
            }
        }
    }

    public void setTargetTV(AbstractDataFlowTV target) {
        if (target != null) {
            this.setTargetProcessObject((AbstractProcessObject)target.getModel());
            DesignPartView dpv = target.getDesignPartView();
            dpvInfo dpi = this.getDPVInfoFor(dpv);
            boolean reassignConnection = false;
            if (dpi.targetTV != null) {
                reassignConnection = true;
                if (dpi.tv != null) {
                    ((TVFlow)dpi.tv).removeConnection();
                }
                dpi.targetTV.removeTopViewListener(this);
            }
            dpi.targetTV = target;
            dpi.targetTV.addTopViewListener(this);
            this.addTVFlow(dpi);
            if (reassignConnection && dpi.tv != null) {
                ((TVFlow)dpi.tv).addConnection();
            }
        }
    }

    public void callRemoveListeners() {
        ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
        event.setAffected(this);
        this.fireChange(event);
        event.setAffected(null);
    }

    public boolean isValid() {
        return this.getProcessObject(0) != null && this.getProcessObject(1) != null;
    }

    public Connection getConnection(int endPoint) {
        return this.CONNECTIONS[endPoint];
    }

    public Connection getSourceConnection() {
        return this.getConnection(0);
    }

    public Connection getTargetConnection() {
        return this.getConnection(1);
    }

    @Override
    public void setTopView(TopView view) {
        this.addTopView(view);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            return dpi.tv;
        }
        return null;
    }

    @Override
    public List getAllViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            col.add(dpi.tv);
        }
        return col;
    }

    @Override
    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv != null) {
            throw new RuntimeException(Messages.getString("Flow.AssociationAlreadyexists"));
        }
        inf.tv = view;
    }

    @Override
    public void removeTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv == null) {
            return;
        }
        this.dpvCol.remove(inf);
        this.removeObjectListener(view);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "FLOW";
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        if (this.event != event) {
            if (this.event != null) {
                this.event.setFlow(null);
            }
            this.event = event;
            if (this.event != null) {
                this.event.setFlow(this);
            }
            if (this.event != null) {
                DefaultEdge edge = ((TVFlow)this.getTopView()).getEdge();
                if (edge != null) {
                    Map edgeAttributes = edge.getAttributes();
                    DiagramConstants.setLineEnd(edgeAttributes, 9);
                    edge.setAttributes(edgeAttributes);
                    EdgeView cv = (EdgeView)edge.getDiagram().getDiagramLayoutCache().getMapping(edge, false);
                    cv.update();
                    cv.getDiagram().repaint();
                }
            } else {
                DefaultEdge edge = ((TVFlow)this.getTopView()).getEdge();
                if (edge != null) {
                    Map edgeAttributes = edge.getAttributes();
                    DiagramConstants.setLineEnd(edgeAttributes, 1);
                    edge.setAttributes(edgeAttributes);
                    EdgeView cv = (EdgeView)edge.getDiagram().getDiagramLayoutCache().getMapping(edge, false);
                    cv.update();
                    cv.getDiagram().repaint();
                }
            }
        }
    }

    public boolean isOpCreate() {
        return this.opCreate;
    }

    public void setOpCreate(boolean opCreate) {
        this.opCreate = opCreate;
    }

    public boolean isOpDelete() {
        return this.opDelete;
    }

    public void setOpDelete(boolean opDelete) {
        this.opDelete = opDelete;
    }

    public boolean isOpRead() {
        return this.opRead || this.getSourceProcessObject() instanceof InfoStore;
    }

    public void setOpRead(boolean opRead) {
        this.opRead = opRead;
    }

    public boolean isOpUpdate() {
        return this.opUpdate;
    }

    public void setOpUpdate(boolean opUpdate) {
        this.opUpdate = opUpdate;
    }

    public String getSystemObjective() {
        return this.systemObjective;
    }

    public void setSystemObjective(String systemObjective) {
        this.systemObjective = systemObjective;
    }

    public List getInfoStructures() {
        ArrayList list = new ArrayList();
        if (this.isConnecedTotCompositeProc()) {
            for (Flow flow : this.getComponentFlows()) {
                list.addAll(flow.getInfoStructures());
            }
            return list;
        }
        return this.infoStructures;
    }

    public void addInfoStructure(InfoStructure infoStructure) {
        this.infoStructures.add(infoStructure);
    }

    public void removeInfoStructure(InfoStructure infoStructure) {
        this.infoStructures.remove(infoStructure);
    }

    public InfoStructure getInfoStructureByID(String id) {
        for (InfoStructure is : this.infoStructures) {
            if (!is.getObjectID().equals(id)) continue;
            return is;
        }
        return null;
    }

    public AbstractProcessObject getDestination() {
        return this.destination;
    }

    public void setDestination(AbstractProcessObject destination) {
        this.destination = destination;
    }

    public AbstractProcessObject getParentObject() {
        return this.parent;
    }

    public void setParentObject(AbstractProcessObject parent) {
        this.parent = parent;
    }

    public AbstractProcessObject getSource() {
        return this.source;
    }

    public void setSource(AbstractProcessObject source) {
        this.source = source;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public List getExternalData() {
        InfoStore store;
        ExternalAgent agent;
        ArrayList list = new ArrayList();
        if (this.getSourceProcessObject() instanceof ExternalAgent) {
            agent = (ExternalAgent)this.getSourceProcessObject();
            list.addAll(agent.getExternalDatas());
        }
        if (this.getTargetProcessObject() instanceof ExternalAgent) {
            agent = (ExternalAgent)this.getTargetProcessObject();
            list.addAll(agent.getExternalDatas());
        }
        if (this.getSourceProcessObject() instanceof InfoStore) {
            store = (InfoStore)this.getSourceProcessObject();
            list.addAll(store.getDatas());
        }
        if (this.getTargetProcessObject() instanceof InfoStore) {
            store = (InfoStore)this.getTargetProcessObject();
            list.addAll(store.getDatas());
        }
        return list;
    }

    public List getComponentFlows() {
        Process proc;
        ArrayList list = new ArrayList();
        if (this.getSourceProcessObject() instanceof Process && (proc = (Process)this.getSourceProcessObject()).isComposite()) {
            list.addAll(proc.getComponentFlowsFor(this));
        }
        if (this.getTargetProcessObject() instanceof Process && (proc = (Process)this.getTargetProcessObject()).isComposite()) {
            list.addAll(proc.getComponentFlowsFor(this));
        }
        return list;
    }

    public boolean isBalanced() {
        Process proc;
        if (this.getSourceProcessObject() instanceof Process && (proc = (Process)this.getSourceProcessObject()).isComposite() && proc.getComponentFlowsFor(this).size() == 0) {
            return false;
        }
        return !(this.getTargetProcessObject() instanceof Process) || !(proc = (Process)this.getTargetProcessObject()).isComposite() || proc.getComponentFlowsFor(this).size() != 0;
    }

    @Override
    public void remove() {
        List compcol;
        ArrayList col = new ArrayList();
        AbstractProcessObject pos = this.getSourceProcessObject();
        AbstractProcessObject pot = this.getTargetProcessObject();
        if (this.getDesignPart() instanceof DataFlowDesign) {
            DataFlowDesign dfd = (DataFlowDesign)this.getDesignPart();
            col.addAll(dfd.getFlowsBetween(pos, pot));
            col.addAll(dfd.getFlowsBetween(pot, pos));
        }
        if (col.size() == 1) {
            AbstractDataFlowTV tv;
            compcol = this.getComponentFlows();
            for (Flow flow : compcol) {
                flow.remove();
            }
            if (pos instanceof Process && ((Process)pos).isComposite() && ((Process)pos).getDiagram() != null && (tv = (AbstractDataFlowTV)pot.getFirstViewForDPV(((Process)pos).getDiagram().getMainView())) != null && !tv.isConnected()) {
                tv.remove(false);
            }
            if (pot instanceof Process && ((Process)pot).isComposite() && ((Process)pot).getDiagram() != null && (tv = (AbstractDataFlowTV)pos.getFirstViewForDPV(((Process)pot).getDiagram().getMainView())) != null && !tv.isConnected()) {
                tv.remove(false);
            }
        } else {
            compcol = this.getComponentFlows();
            for (Flow flow : compcol) {
                flow.remove();
            }
        }
        super.remove();
        this.setProcessObject(1, null);
        this.setProcessObject(0, null);
    }

    @Override
    public void changed(TopView tv, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView dpv = tv.getDesignPartView();
            dpv.removeViewFor(this);
            dpvInfo dpi = this.getDPVInfoFor(dpv);
            dpi.tv = null;
            if (dpi.sourceTV == tv) {
                dpi.sourceTV = null;
            }
            if (dpi.targetTV == tv) {
                dpi.targetTV = null;
            }
            if (this.getDesignPart() == dpv.getDesignPart()) {
                this.remove();
            }
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FlowPropertiesDialogEx dialog = new FlowPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public void addSynonymToCompositeProcDiagram() {
        if (this.getSourceProcessObject() != null && this.getTargetProcessObject() != null) {
            AbstractProcessObject pob1 = this.getSourceProcessObject();
            AbstractProcessObject pob2 = this.getTargetProcessObject();
            if (pob1.getTopView() != null && pob2.getTopView() != null) {
                AbstractDataFlowTV tv;
                DesignPartView dpv;
                DataFlowDesign dfd = null;
                if (pob1 instanceof Process) {
                    dfd = ((Process)pob1).getDiagram();
                }
                if (pob1 instanceof Process && ((Process)pob1).isComposite() && dfd != null) {
                    dpv = dfd.getMainView();
                    if (pob2 != pob1 && !(pob2 instanceof Process) && pob2.getViewsCountForDPV(dpv) == 0) {
                        tv = (AbstractDataFlowTV)pob2.getTopView().createViewSynonim(dpv);
                        tv.addTVFlows();
                    }
                    if (pob2 != pob1 && pob2 instanceof Process && !this.isParentProcessPresentedInDPV((Process)pob2, (DPVProcess)dpv) && pob2.getViewsCountForDPV(dpv) == 0) {
                        tv = (AbstractDataFlowTV)pob2.getTopView().createViewSynonim(dpv);
                        tv.addTVFlows();
                    }
                }
                dfd = null;
                if (pob2 instanceof Process) {
                    dfd = ((Process)pob2).getDiagram();
                }
                if (pob2 instanceof Process && ((Process)pob2).isComposite() && dfd != null) {
                    dpv = dfd.getMainView();
                    if (pob2 != pob1 && !(pob1 instanceof Process) && pob1.getViewsCountForDPV(dpv) == 0) {
                        tv = (AbstractDataFlowTV)pob1.getTopView().createViewSynonim(dpv);
                        tv.addTVFlows();
                    }
                    if (pob2 != pob1 && pob1 instanceof Process && !this.isParentProcessPresentedInDPV((Process)pob1, (DPVProcess)dpv) && pob1.getViewsCountForDPV(dpv) == 0) {
                        tv = (AbstractDataFlowTV)pob1.getTopView().createViewSynonim(dpv);
                        tv.addTVFlows();
                    }
                }
            }
        }
    }

    private boolean isParentProcessPresentedInDPV(Process proc, DPVProcess dpv) {
        if (proc.getViewsCountForDPV(dpv) > 0) {
            return true;
        }
        Process parProc = proc.getParentProcess();
        if (parProc != null) {
            return this.isParentProcessPresentedInDPV(parProc, dpv);
        }
        return false;
    }

    public void createOrSetParentFlow() {
        if (this.getSourceProcessObject() != null && this.getTargetProcessObject() != null) {
            AbstractProcessObject pob1 = this.getSourceProcessObject();
            AbstractProcessObject pob2 = this.getTargetProcessObject();
            if (pob1 instanceof Process && ((Process)pob1).getDesignPart() == this.getDesignPart()) {
                if (pob2 != pob1 && (pob2 instanceof InfoStore || pob2 instanceof ExternalAgent || pob2 instanceof Process && ((Process)pob2).getDesignPart() != this.getDesignPart())) {
                    Process parentProc = ((DataFlowDesign)this.getDesignPart()).getProcess();
                    DataFlowDesign parentDFD = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    if (parentProc != null && parentDFD != null) {
                        Flow parFlow = parentDFD.getFirstFlowBetween(parentProc, pob2);
                        if (parFlow == null) {
                            DesignPartView dpv = parentDFD.getMainView();
                            TopView soutceTV = parentProc.getFirstViewForDPV(dpv);
                            TopView targetTV = pob2.getFirstViewForDPV(dpv);
                            if (soutceTV != null && targetTV != null) {
                                parFlow = parentDFD.createFlow();
                                parFlow.setName(this.getName() + "_" + this.getDesignPart().getName() + "_Par");
                                parFlow.setSourceTV((AbstractDataFlowTV)soutceTV);
                                parFlow.setTargetTV((AbstractDataFlowTV)targetTV);
                                ((TVFlow)parFlow.getTopView()).addConnection();
                                this.setParentObject(parFlow);
                            }
                        } else {
                            this.setParentObject(parFlow);
                        }
                    }
                }
            } else if (pob2 instanceof Process && ((Process)pob2).getDesignPart() == this.getDesignPart()) {
                if (pob2 != pob1 && (pob1 instanceof InfoStore || pob1 instanceof ExternalAgent || pob1 instanceof Process && ((Process)pob1).getDesignPart() != this.getDesignPart())) {
                    Process parentProc = ((DataFlowDesign)this.getDesignPart()).getProcess();
                    DataFlowDesign parentDFD = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    if (parentProc != null && parentDFD != null) {
                        Flow parFlow = parentDFD.getFirstFlowBetween(pob1, parentProc);
                        if (parFlow == null) {
                            DesignPartView dpv = parentDFD.getMainView();
                            TopView soutceTV = pob1.getFirstViewForDPV(dpv);
                            TopView targetTV = parentProc.getFirstViewForDPV(dpv);
                            if (soutceTV != null && targetTV != null) {
                                parFlow = parentDFD.createFlow();
                                parFlow.setName(this.getName() + "_" + this.getDesignPart().getName() + "_Par");
                                parFlow.setSourceTV((AbstractDataFlowTV)soutceTV);
                                parFlow.setTargetTV((AbstractDataFlowTV)targetTV);
                                ((TVFlow)parFlow.getTopView()).addConnection();
                                this.setParentObject(parFlow);
                            }
                        } else {
                            this.setParentObject(parFlow);
                        }
                    }
                }
            } else if (pob1 instanceof Process && ((Process)pob1).getDesignPart() != this.getDesignPart()) {
                if (pob2 != pob1 && pob2 instanceof Process && ((Process)pob2).getDesignPart() == this.getDesignPart()) {
                    Process parentProc = ((DataFlowDesign)this.getDesignPart()).getProcess();
                    DataFlowDesign parentDFD = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    if (parentProc != null && parentDFD != null) {
                        Flow parFlow = parentDFD.getFirstFlowBetween(pob1, parentProc);
                        if (parFlow == null) {
                            DesignPartView dpv = parentDFD.getMainView();
                            TopView soutceTV = pob1.getFirstViewForDPV(dpv);
                            TopView targetTV = parentProc.getFirstViewForDPV(dpv);
                            if (soutceTV != null && targetTV != null) {
                                parFlow = parentDFD.createFlow();
                                parFlow.setName(this.getName() + "_" + this.getDesignPart().getName() + "_Par");
                                parFlow.setSourceTV((AbstractDataFlowTV)soutceTV);
                                parFlow.setTargetTV((AbstractDataFlowTV)targetTV);
                                ((TVFlow)parFlow.getTopView()).addConnection();
                                this.setParentObject(parFlow);
                            }
                        } else {
                            this.setParentObject(parFlow);
                        }
                    }
                } else if (pob2 != pob1 && (pob2 instanceof InfoStore || pob2 instanceof ExternalAgent)) {
                    DataFlowDesign parentDFD = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    DPVProcess currentDPV = (DPVProcess)((DataFlowDesign)this.getDesignPart()).getMainView();
                    TopView tv = pob2.getFirstViewForDPV(currentDPV);
                    if (parentDFD != null) {
                        DPVProcess dpv = (DPVProcess)parentDFD.getMainView();
                        AbstractDataFlowTV targetTV = (AbstractDataFlowTV)pob2.getFirstViewForDPV(dpv);
                        if (targetTV == null) {
                            targetTV = (AbstractDataFlowTV)dpv.createViewSynonim(pob2);
                            if (targetTV.getCellView() != null) {
                                targetTV.getCellView().setNewBounds(new Rectangle(tv.getLocation(), new Dimension(tv.getBounds().width, tv.getBounds().height)));
                            } else {
                                targetTV.setBounds(new Rectangle(tv.getLocation(), new Dimension(tv.getBounds().width, tv.getBounds().height)));
                            }
                        }
                        targetTV.addTVFlows();
                    }
                }
            } else if (pob2 instanceof Process && ((Process)pob2).getDesignPart() != this.getDesignPart()) {
                if (pob2 != pob1 && pob1 instanceof Process && ((Process)pob1).getDesignPart() == this.getDesignPart()) {
                    Process parentProc = ((DataFlowDesign)this.getDesignPart()).getProcess();
                    DataFlowDesign parentDFD = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    if (parentProc != null && parentDFD != null) {
                        Flow parFlow = parentDFD.getFirstFlowBetween(pob1, parentProc);
                        if (parFlow == null) {
                            DesignPartView dpv = parentDFD.getMainView();
                            TopView soutceTV = parentProc.getFirstViewForDPV(dpv);
                            TopView targetTV = pob2.getFirstViewForDPV(dpv);
                            if (soutceTV != null && targetTV != null) {
                                parFlow = parentDFD.createFlow();
                                parFlow.setName(this.getName() + "_" + this.getDesignPart().getName() + "_Par");
                                parFlow.setSourceTV((AbstractDataFlowTV)soutceTV);
                                parFlow.setTargetTV((AbstractDataFlowTV)targetTV);
                                ((TVFlow)parFlow.getTopView()).addConnection();
                                this.setParentObject(parFlow);
                            }
                        } else {
                            this.setParentObject(parFlow);
                        }
                    }
                } else if (pob2 != pob1 && (pob1 instanceof InfoStore || pob1 instanceof ExternalAgent)) {
                    DataFlowDesign parentDFD = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    DPVProcess currentDPV = (DPVProcess)((DataFlowDesign)this.getDesignPart()).getMainView();
                    TopView tv = pob1.getFirstViewForDPV(currentDPV);
                    if (parentDFD != null) {
                        DPVProcess dpv = (DPVProcess)parentDFD.getMainView();
                        AbstractDataFlowTV sourceTV = (AbstractDataFlowTV)pob1.getFirstViewForDPV(dpv);
                        if (sourceTV == null) {
                            sourceTV = (AbstractDataFlowTV)dpv.createViewSynonim(pob1);
                            if (sourceTV.getCellView() != null) {
                                sourceTV.getCellView().setNewBounds(new Rectangle(tv.getLocation(), new Dimension(tv.getBounds().width, tv.getBounds().height)));
                            } else {
                                sourceTV.setBounds(new Rectangle(tv.getLocation(), new Dimension(tv.getBounds().width, tv.getBounds().height)));
                            }
                        }
                        sourceTV.addTVFlows();
                    }
                }
            }
        }
    }

    public List getPossibleParentFlows() {
        DataFlowDesign dfd = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
        if (dfd != null) {
            AbstractProcessObject pos = this.getSourceProcessObject();
            AbstractProcessObject pot = this.getTargetProcessObject();
            if (pos instanceof Process && pos.getDesignPart() == this.getDesignPart()) {
                pos = ((DataFlowDesign)pos.getDesignPart()).getProcess();
            }
            if (pot instanceof Process && pot.getDesignPart() == this.getDesignPart()) {
                pot = ((DataFlowDesign)pot.getDesignPart()).getProcess();
            }
            return dfd.getFlowsBetween(pos, pot);
        }
        return new ArrayList();
    }

    public boolean isConnecedTotCompositeProc() {
        if (this.getSourceProcessObject() instanceof Process && ((Process)this.getSourceProcessObject()).isComposite()) {
            return true;
        }
        return this.getTargetProcessObject() instanceof Process && ((Process)this.getTargetProcessObject()).isComposite();
    }

    public boolean isConnectedToInfoStore() {
        if (this.getSourceProcessObject() instanceof InfoStore) {
            return true;
        }
        return this.getTargetProcessObject() instanceof InfoStore;
    }

    public boolean isConnectedToExternaAgent() {
        if (this.getSourceProcessObject() instanceof ExternalAgent) {
            return true;
        }
        return this.getTargetProcessObject() instanceof ExternalAgent;
    }

    @Override
    public void setSourceTopView(TopView source) {
        this.setSourceTV((AbstractDataFlowTV)source);
    }

    @Override
    public void setTargetTopView(TopView target) {
        this.setTargetTV((AbstractDataFlowTV)target);
    }

    @Override
    public TopView getSourceTopView(DesignPartView dpv) {
        return this.getSourceTV(dpv);
    }

    @Override
    public TopView getTargetTopView(DesignPartView dpv) {
        return this.getTargetTV(dpv);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getSourceProcessObject();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getTargetProcessObject();
    }

    @Override
    public void restoreTopView(TopView tv, TopView sourceTV, TopView targetTV) {
        tv.getDesignPartView().restoreTopview(tv, this);
        dpvInfo dpi = this.getDPVInfoFor(tv.getDesignPartView());
        if (dpi.tv == tv) {
            this.addObjectListener(tv);
            dpi.targetTV = (AbstractDataFlowTV)targetTV;
            dpi.targetTV.addTopViewListener(this);
            dpi.sourceTV = (AbstractDataFlowTV)sourceTV;
            dpi.sourceTV.addTopViewListener(this);
        }
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "flow/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public class DestinationConnection
    extends Connection {
        @Override
        public AbstractProcessObject getProcessObject() {
            return Flow.this.getProcessObject(1);
        }

        @Override
        public String getDescriptor() {
            return "Destination";
        }

        @Override
        public boolean isSource() {
            return false;
        }
    }

    public class SourceConnection
    extends Connection {
        @Override
        public AbstractProcessObject getProcessObject() {
            return Flow.this.getProcessObject(0);
        }

        @Override
        public String getDescriptor() {
            return "Source";
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    public abstract class Connection {
        private Boolean optionality = Boolean.TRUE;
        private String nameOn = null;

        public Flow getFlow() {
            return Flow.this;
        }

        public abstract AbstractProcessObject getProcessObject();

        public abstract String getDescriptor();

        public abstract boolean isSource();

        public String toString() {
            return Flow.this.getName() + this.getDescriptor();
        }

        public boolean isOptional() {
            return this.optionality;
        }

        public void setOptional(boolean value) {
            this.optionality = value ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean getOptionality() {
            return this.optionality;
        }

        public void setOptionality(Boolean value) {
            this.optionality = value == null ? Boolean.FALSE : value;
        }

        public void setNameOn(String name) {
            this.nameOn = name;
        }

        public TopView getTopView() {
            return Flow.this.getTopView();
        }

        public String getNameOn() {
            return this.nameOn;
        }
    }

    public class dpvInfo {
        public AbstractDataFlowTV sourceTV;
        public AbstractDataFlowTV targetTV;
        public TopView tv;
        public DesignPartView dpv;

        dpvInfo() {
        }
    }
}

