/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.editor.process.InOutParamsPropertiesDialogEx;

public class InOutParams
extends AbstractProcessObject
implements EditableFonts {
    public static final String INPUT = "Input";
    public static final String OUTPUT = "Output";
    public static final String SINGLE_RECORD = "Single Record";
    public static final String SET_OF_RECORDS = "Set Of Records";
    public static final String[] MULTIPLICITY_TYPES_INTERNAL = new String[]{"Single Record", "Set Of Records"};
    public static final String[] MULTIPLICITY_TYPES_DISPLAY = new String[]{Messages.getString("InOutParams.SingleRecord"), Messages.getString("InOutParams.SetOfRecords")};
    private String inOutType = "Input";
    private String parametersMultiplicity = "Single Record";
    private String systemObjective = "";
    private TransformationTask task;
    private List editableFonts = new ArrayList();

    public InOutParams(DesignPart designPart, String inOutType) {
        super(designPart);
        this.inOutType = inOutType;
        this.task = (TransformationTask)designPart;
    }

    @Override
    public void setDesign(Design design) {
        super.setDesign(design);
    }

    @Override
    public String getObjectTypeName() {
        return "InOutParams";
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        if (this.inOutType.equalsIgnoreCase(INPUT)) {
            return "INPAR";
        }
        return "OUTPAR";
    }

    public List getAttributes() {
        Iterator is;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator it = this.getIncomingFlows().iterator();
        while (it.hasNext()) {
            is = ((Flow)it.next()).getInfoStructures().iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    if (attributes.contains(attribute)) continue;
                    attributes.add(attribute);
                }
            }
        }
        it = this.getOutgoingFlows().iterator();
        while (it.hasNext()) {
            is = ((Flow)it.next()).getInfoStructures().iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    if (attributes.contains(attribute)) continue;
                    attributes.add(attribute);
                }
            }
        }
        return attributes;
    }

    public List getProcesses() {
        ArrayList<AbstractProcessObject> result = new ArrayList<AbstractProcessObject>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof Process)) continue;
            result.add(flow.getSourceProcessObject());
        }
        return result;
    }

    public String getSystemObjective() {
        return this.systemObjective;
    }

    public void setSystemObjective(String systemObjective) {
        this.systemObjective = systemObjective;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            InOutParamsPropertiesDialogEx dialog = new InOutParamsPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public void addParam(ParameterObject parameter) {
        if (this.inOutType.equalsIgnoreCase(INPUT)) {
            this.task.addInputParam(parameter);
        } else {
            this.task.addOutputParam(parameter);
        }
    }

    public void addParam(String id, String name, String logicalType) {
        if (this.inOutType.equalsIgnoreCase(INPUT)) {
            this.task.addInputParam(id, name, logicalType);
        } else {
            this.task.addOutputParam(id, name, logicalType);
        }
    }

    public List getParams() {
        if (this.inOutType.equalsIgnoreCase(INPUT)) {
            return this.task.getInputParameters();
        }
        return this.task.getOutputParameters();
    }

    public String getInOutType() {
        return this.inOutType;
    }

    public String getParametersMultiplicity() {
        return this.parametersMultiplicity;
    }

    public void setParametersMultiplicity(String parametersMultiplicity) {
        this.parametersMultiplicity = parametersMultiplicity;
    }

    @Override
    public String getName() {
        if (this.inOutType.equalsIgnoreCase(INPUT)) {
            return "Input Parameters";
        }
        return "Output Parameters";
    }

    public DesignObject getElementByID(String localID) {
        if (localID == null) {
            return null;
        }
        Iterator it = this.inOutType.equalsIgnoreCase(INPUT) ? this.task.getInputParameters().iterator() : this.task.getOutputParameters().iterator();
        while (it.hasNext()) {
            DesignObject dobj = (DesignObject)it.next();
            if (!localID.equals(dobj.getObjectID())) continue;
            return dobj;
        }
        return null;
    }

    @Override
    public String getFCObjectType() {
        return "In-Out Parameters";
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    public ParameterObject createParameter() {
        ParameterObject po = new ParameterObject(this.getDesignPart());
        this.addParam(po);
        return po;
    }

    public ParameterObject getParemeterByID(String id) {
        for (ParameterObject po : this.getParams()) {
            if (!po.getObjectID().equals(id)) continue;
            return po;
        }
        return null;
    }
}

